<?php

namespace PHPMaker2026\Reimbursement;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Result;
use Doctrine\DBAL\Query\QueryBuilder;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Event\PreUpdateEventArgs;
use Doctrine\ORM\Event\PostUpdateEventArgs;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Event\OnFlushEventArgs;
use Doctrine\ORM\Event\PostFlushEventArgs;
use Doctrine\ORM\Event\OnClearEventArgs;
use Doctrine\ORM\Event\LoadClassMetadataEventArgs;
use Doctrine\ORM\Events;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\Mapping\ClassMetadata;
use Doctrine\Persistence\Event\LifecycleEventArgs;
use Doctrine\Persistence\ObjectRepository;
use Doctrine\Persistence\ManagerRegistry;
use Doctrine\Bundle\DoctrineBundle\Attribute\AsEntityListener;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\EventStreamResponse;
use Symfony\Component\HttpFoundation\ServerEvent;
use Symfony\Component\HttpFoundation\HeaderBag;
use Symfony\Component\Filesystem\Exception\IOExceptionInterface;
use Symfony\Component\Security\Core\User\UserInterface;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Validator\Validator\ValidatorInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\EventDispatcher\Attribute\AsEventListener;
use Symfony\Contracts\EventDispatcher\EventDispatcherInterface;
use Symfony\Contracts\EventDispatcher\Event;
use Symfony\Contracts\Cache\CacheInterface;
use Symfony\Contracts\Cache\ItemInterface;
use League\Flysystem\DirectoryListing;
use League\Flysystem\FilesystemException;
use ParagonIE\CSPBuilder\CSPBuilder;
use InvalidArgumentException;
use Exception;
use Throwable;
use DateTimeInterface;
use DateTimeImmutable;
use DateInterval;
use DateTime;
use Closure;
use Traversable;
use Symfony\Bundle\SecurityBundleSecurity;
use PHPMaker2026\Reimbursement\Entity as BaseEntity;
use PHPMaker2026\Reimbursement\Db;
use PHPMaker2026\Reimbursement\Db\Entity;

/**
 * Page class
 */
#[AsAlias("TrreimbursementEdit", true)]
class TrreimbursementEdit extends Trreimbursement implements PageInterface
{
    use MessagesTrait;
    use FormTrait;

    // Page result
    public ?Response $Response = null;

    // Headers
    public HeaderBag $Headers;

    // Page ID
    public string $PageID = "edit";

    // Project ID
    public string $ProjectID = PROJECT_ID;

    // View file path
    public ?string $View = null;

    // Title
    public ?string $Title = null; // Title for <title> tag

    // CSS class/style
    public string $CurrentPageName = "TrreimbursementEdit"; // Route action

    // Page headings
    public string $Heading = "";
    public string $Subheading = "";
    public string $PageHeader = "";
    public string $PageFooter = "";

    // Page layout
    public bool $UseLayout = true;

    // Page terminated
    private bool $terminated = false;

    // Properties
    public string $FormClassName = "ew-form ew-edit-form overlay-wrapper";
    public bool $IsModal = false;
    public bool $IsMobileOrModal = false;
    public ?string $HashValue = null; // Hash Value
    public int $DisplayRecords = 1;
    public int $PageNumber = 1;
    public int $StartRecord = 0;
    public int $StopRecord = 0;
    public int $TotalRecords = 0;
    public bool $EditPaging = false; // Allow edit paging
    public ?int $RecordOffset = null; // Record offset (for Edit paging)
    public array $PagerOptions = ["proximity" => 2, "show_dots" => true];
    public int $RecordCount = 0;
    public array $DetailGrids = [];

    // Constructor
    public function __construct(
        Language $language,
        AdvancedSecurity $security,
        CSPBuilder $cspBuilder,
        CacheInterface $cache,
        FieldFactory $fieldFactory,
        EventDispatcherInterface $dispatcher,
    ) {
        parent::__construct($language, $security, $cspBuilder, $cache, $fieldFactory, $dispatcher);
        global $httpContext;
        $this->Headers = new HeaderBag();
        $this->TableVar = 'trreimbursement';
        $this->TableName = 'trreimbursement';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-edit-table d-none";

        // Custom template
        $this->UseCustomTemplate = true;

        // Initialize
        $httpContext["Page"] = $this;

        // Open connection
        $httpContext["Conn"] ??= $this->getConnection();

        // Pager options
        if (IsEmpty($this->PagerOptions)) {
            $this->PagerOptions = Config("PAGER_OPTIONS");
        }
    }

    // Page heading
    public function pageHeading(): string
    {
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading(): string
    {
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return Language()->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName(): string
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl(bool $withArgs = true): string
    {
        if ($withArgs) {
            return CurrentPageUrl();
        } else {
            $route = GetRoute();
            $path = $route?->getPath() ?? "";
            // Remove all placeholders like `{id}`
            $stripped = preg_replace('/\{[^}]+\}/', '', $path);
            // Remove trailing slash unless it's root '/', then replace leading slash with BasePath(true)
            return preg_replace('/^\//', BasePath(true), $stripped !== '/' ? rtrim($stripped, '/') : '/');
        }
    }

    // Get Page Header
    public function getPageHeader(): string
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            $header = '<div id="ew-page-header">' . $header . '</div>';
        }
        return $header;
    }

    // Get Page Footer
    public function getPageFooter(): string
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            $footer = '<div id="ew-page-footer">' . $footer . '</div>';
        }
        return $footer;
    }

    // Set field visibility
    public function setVisibility(): void
    {
        $this->ID->setVisibility();
        $this->MTReimbursementTypeID->setVisibility();
        $this->MTUserRequesterID->Visible = false;
        $this->MTUserApproverID->Visible = false;
        $this->RequestDateTime->Visible = false;
        $this->ApprovedDateTime->Visible = false;
        $this->RejectedDateTime->Visible = false;
        $this->MTUserRejectorID->Visible = false;
        $this->_Title->setVisibility();
        $this->Description->setVisibility();
        $this->Amount->setVisibility();
        $this->Attachment->setVisibility();
        $this->Notes->Visible = false;
        $this->CreatedByUserID->Visible = false;
        $this->CreatedDateTime->Visible = false;
        $this->LastUpdatedByUserID->Visible = false;
        $this->LastUpdatedDateTime->Visible = false;
        $this->_ProjectID->setVisibility();
    }

    // Is lookup
    public function isLookup(): bool
    {
        return SameText(RouteAction(), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill(): bool
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest(): bool
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup(): bool
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated(): bool
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param ?string $url URL for redirection
     * @return void
     */
    public function terminate(?string $url = null): void
    {
        if ($this->terminated) {
            return;
        }
        global $httpContext;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::class);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Return for API
        if (IsApi()) {
            if (!$this->Response) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                $this->Response = new JsonResponse($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (IsJsonResponse($this->Response)) { // Has JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url !== null) {
            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (
                    SameString($pageName, GetPageName($this->getListUrl()))
                    || SameString($pageName, GetPageName($this->getViewUrl()))
                    || SameString($pageName, GetPageName(CurrentMasterTable()?->getViewUrl() ?? ""))
                ) { // List / View / Master View page
                    if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                        $result["caption"] = $this->getModalCaption($pageName);
                        $result["view"] = SameString($pageName, "TrreimbursementView"); // If View page, no primary button
                    } else { // List page
                        $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    }
                } else { // Other pages (add messages and then clear messages)
                    $result = array_merge($this->getMessages(), ["modal" => "1"]);
                    $this->clearMessages();
                }
                $this->Response = new JsonResponse($result);
            } else {
                $this->Response = new RedirectResponse(GetUrl($url), Config("REDIRECT_STATUS_CODE"));
            }
        }
        return; // Return to controller
    }

    // Get row(s) from array of entities
    protected function getRowsFromEntities(array $entities, bool $first = false): array
    {
        $rows = [];
        if (array_is_list($entities)) {
            foreach ($entities as $entity) {
                $row = $this->getRowFromEntity($entity);
                if ($first) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get row from entity
    protected function getRowFromEntity(BaseEntity $entity): array
    {
        $row = [];
        foreach ($entity as $fldname => $val) {
            if ($this->TableName == Config("USER_TABLE_NAME") && $fldname == Config("PASSWORD_FIELD_NAME")) { // Skip user password field
                continue;
            }
            if (isset($this->Fields[$fldname]) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                $fld = $this->Fields[$fldname];
                if ($fld->HtmlTag == "FILE") { // Upload field
                    if (IsEmpty($val)) {
                        $row[$fldname] = null;
                    } else {
                        $key = SessionId() . ServerVar("ENCRYPTION_KEY");
                        if ($fld->DataType == DataType::BLOB) {
                            $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                "/" . $fld->TableVar . "/" . $fld->Param . "/" . $this->getKeyAsString($entity, Config("ROUTE_COMPOSITE_KEY_SEPARATOR"))));
                            $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                        } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                            $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                "/" . $fld->TableVar . "/" . Encrypt($fld->uploadPath() . $val, $key)));
                            $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                        } else { // Multiple files
                            $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                            $ar = [];
                            foreach ($files as $file) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->uploadPath() . $file, $key)));
                                if (!IsEmpty($file)) {
                                    $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                }
                            }
                            $row[$fldname] = $ar;
                        }
                    }
                } else {
                    if ($val instanceof DateTimeInterface) {
                        $val = $val->format(DATE_ATOM);
                    }
                    $row[$fldname] = $val;
                }
            }
        }
        return $row;
    }

    // Hide fields for add/edit
    protected function hideFieldsForAddEdit(): void
    {
    }

    // Lookup data
    public function lookup(array $req = []): array
    {
        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this); // Use settings from current page
    }

    /**
     * Page init
     *
     * @return void
     */
    public function init(): void
    {
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run(): void
    {
        global $httpContext;

        // Is modal
        $this->IsModal = IsModal();
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ParamBool(Config("PAGE_LAYOUT"), true);

        // View
        $this->View = Get(Config("VIEW"));
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::class);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->MTReimbursementTypeID);
        $this->setupLookupOptions($this->MTUserRequesterID);
        $this->setupLookupOptions($this->MTUserApproverID);
        $this->setupLookupOptions($this->_ProjectID);

        // Check modal
        if ($this->IsModal) {
            $httpContext["SkipHeaderFooter"] = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;
        $loaded = $this->CurrentRecord instanceof BaseEntity;
        $postBack = false;

        // Set up current action and primary key
        if (IsApi()) {
            // Load record
            if ($loaded) {
                // Load key values
                if (($keyValue = Route("id") ?? Get("ID")) !== null) {
                    $this->ID->setQueryStringValue($keyValue);
                    $this->ID->setOldValue($this->ID->QueryStringValue);
                } elseif (($keyValue = Post("ID")) !== null) {
                    $this->ID->setFormValue($keyValue);
                    $this->ID->setOldValue($this->ID->FormValue);
                } elseif (($keyValue = Key(0)) !== null) {
                    $this->ID->setQueryStringValue($keyValue);
                    $this->ID->setOldValue($this->ID->QueryStringValue);
                }
                $loaded = $this->loadRow();
            } else {
                $this->setFailureMessage($this->language->phrase("NoRecord")); // Set no record message
                $this->terminate();
                return;
            }
            $this->CurrentAction = "update"; // Update record directly
            $this->OldKey = $this->getKey(true); // Get from CurrentValue
            $postBack = true;
        } else {
            if ($this->CurrentAction = Post("action")) { // Get action code
                if (!$this->isShow()) { // Not reload record, handle as postback
                    $postBack = true;
                }

                // Get key from Form
                $this->setKey($this->getFormOldKey(), $this->isShow());
            } else {
                $this->CurrentAction = "show"; // Default action is display

                // Load key from query string or route value
                $loadByQuery = false;
                if (($keyValue = Route("id") ?? Get("ID")) !== null) {
                    $this->ID->setQueryStringValue($keyValue);
                    $loadByQuery = true;
                } else {
                    $this->ID->CurrentValue = null;
                }
            }

            // Load result set
            if ($this->isShow()) {
                if (!$this->CurrentRecord) { // No record found
                    if (!$this->peekSuccessMessage() && !$this->peekFailureMessage()) {
                        $this->setFailureMessage($this->language->phrase("NoRecord")); // Set no record message
                    }
                    $this->terminate("TrreimbursementList"); // Return to list page
                    return;
                } else { // Load current row
                    $this->loadRow();
                }
                $this->OldKey = $loaded ? $this->getKey(true) : []; // Get from CurrentValue
            }
        }

        // Process form if post back
        if ($postBack) {
            $this->loadFormValues(); // Get form values
        }

        // Validate form if post back
        if ($postBack) {
            if (!$this->validateForm()) {
                $this->EventCancelled = true; // Event cancelled
                if (IsApi()) {
                    $this->Response = new JsonResponse(["success" => false, "version" => PRODUCT_VERSION, "validation" => $this->getValidationErrors()]);
                    $this->terminate();
                    return;
                } else {
                    $this->restoreFormValues();
                    $this->CurrentAction = ""; // Form error, reset action
                }
            }
        }

        // Perform current action
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                if (!$this->IsModal) { // Normal edit page
                    if (!$loaded) {
                        if (!$this->peekSuccessMessage() && !$this->peekFailureMessage()) {
                            $this->setFailureMessage($this->language->phrase("NoRecord")); // Set no record message
                        }
                        $this->terminate("TrreimbursementList"); // Return to list page
                        return;
                    }
                } else { // Modal edit page
                    if (!$loaded) { // Load record based on key
                        if (!$this->peekFailureMessage()) {
                            $this->setFailureMessage($this->language->phrase("NoRecord")); // No record found
                        }
                        $this->terminate("TrreimbursementList"); // No matching record, return to list
                        return;
                    }
                } // End modal checking
                break;
            case "update": // Update
                $returnUrl = $this->getReturnUrl();
                if (GetPageName($returnUrl) == "TrreimbursementList") {
                    $returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
                }
                if ($this->editRow()) { // Update record based on key
                    CleanUploadTempPaths(SessionId());
                    if (!$this->peekSuccessMessage()) {
                        $this->setSuccessMessage($this->language->phrase("UpdateSuccess")); // Update success
                    }

                    // Handle UseAjaxActions with return page
                    if ($this->IsModal && $this->UseAjaxActions) {
                        $this->IsModal = false;
                        if (GetPageName($returnUrl) != "TrreimbursementList") {
                            FlashBag()->add("X-Return-Url", $returnUrl); // Save return URL
                            $returnUrl = "TrreimbursementList"; // Return list page content
                        }
                    }
                    if (IsJsonResponse()) {
                        $this->terminate();
                        return;
                    } else {
                        $this->terminate($returnUrl); // Return to caller
                        return;
                    }
                } elseif (IsApi()) { // API request, return
                    $this->terminate();
                    return;
                } elseif ($this->IsModal && $this->UseAjaxActions) { // Return JSON error message
                    $this->Response = new JsonResponse(["success" => false, "validation" => $this->getValidationErrors(), "error" => $this->getFailureMessage()]);
                    $this->terminate();
                    return;
                } elseif (($this->peekFailureMessage()[0] ?? "") == $this->language->phrase("NoRecord")) {
                    $this->terminate($returnUrl); // Return to caller
                    return;
                } else {
                    $this->EventCancelled = true; // Event cancelled
                    $this->restoreFormValues(); // Restore form values if update failed
                }
        }

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Render row
        $this->renderRow(
            RowType::EDIT
        );

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::class);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get upload files
    protected function getUploadFiles(): void
    {
        $this->Attachment->Upload->Index = $this->FormIndex;
        $this->Attachment->Upload->uploadFile();
    }

    // Load form values
    protected function loadFormValues(): void
    {
        $validate = !Config("SERVER_VALIDATE");

        // ID
        if (!$this->ID->IsDetailKey && $this->hasInputValue($this->ID)) {
            $val = $this->getInputValue($this->ID);
            $this->ID->setFormValue($val);
        }

        // MTReimbursementTypeID
        if (!$this->MTReimbursementTypeID->IsDetailKey && $this->hasInputValue($this->MTReimbursementTypeID)) {
            $val = $this->getInputValue($this->MTReimbursementTypeID);
            $this->MTReimbursementTypeID->setFormValue($val);
        }

        // Title
        if (!$this->_Title->IsDetailKey && $this->hasInputValue($this->_Title)) {
            $val = $this->getInputValue($this->_Title);
            $this->_Title->setFormValue($val);
        }

        // Description
        if (!$this->Description->IsDetailKey && $this->hasInputValue($this->Description)) {
            $val = $this->getInputValue($this->Description);
            $this->Description->setFormValue($val);
        }

        // Amount
        if (!$this->Amount->IsDetailKey && $this->hasInputValue($this->Amount)) {
            $val = $this->getInputValue($this->Amount);
            $this->Amount->setFormValue($val, true, $validate);
        }

        // ProjectID
        if (!$this->_ProjectID->IsDetailKey && $this->hasInputValue($this->_ProjectID)) {
            $val = $this->getInputValue($this->_ProjectID);
            $this->_ProjectID->setFormValue($val);
        }

        // Get upload files
        $this->getUploadFiles();
    }

    // Restore form values
    public function restoreFormValues(): void
    {
        $this->ID->CurrentValue = $this->ID->FormValue;
        $this->MTReimbursementTypeID->CurrentValue = $this->MTReimbursementTypeID->FormValue;
        $this->_Title->CurrentValue = $this->_Title->FormValue;
        $this->Description->CurrentValue = $this->Description->FormValue;
        $this->Amount->CurrentValue = $this->Amount->FormValue;
        $this->_ProjectID->CurrentValue = $this->_ProjectID->FormValue;
    }

    /**
     * Load row based on key values
     *
     * @return bool
     */
    public function loadRow(): bool
    {
        $result = $this->CurrentRecord !== null;
        if ($result) {
            $this->loadRowValues($this->CurrentRecord); // Load row values
        }
        return $result;
    }

    /**
     * Load row values from result set or record
     *
     * @param ?BaseEntity $row Record
     * @return void
     */
    public function loadRowValues(?BaseEntity $row = null): void
    {
        if ($row instanceof BaseEntity) { // Get array from entity
        }
        $row ??= $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->ID->setDbValue($row['ID']);
        $this->MTReimbursementTypeID->setDbValue($row['MTReimbursementTypeID']);
        $this->MTUserRequesterID->setDbValue($row['MTUserRequesterID']);
        $this->MTUserApproverID->setDbValue($row['MTUserApproverID']);
        $this->RequestDateTime->setDbValue($row['RequestDateTime']);
        $this->ApprovedDateTime->setDbValue($row['ApprovedDateTime']);
        $this->RejectedDateTime->setDbValue($row['RejectedDateTime']);
        $this->MTUserRejectorID->setDbValue($row['MTUserRejectorID']);
        $this->_Title->setDbValue($row['Title']);
        $this->Description->setDbValue($row['Description']);
        $this->Amount->setDbValue($row['Amount']);
        $this->Attachment->Upload->DbValue = $row['Attachment'];
        $this->Attachment->setDbValue($this->Attachment->Upload->DbValue);
        $this->Notes->setDbValue($row['Notes']);
        $this->CreatedByUserID->setDbValue($row['CreatedByUserID']);
        $this->CreatedDateTime->setDbValue($row['CreatedDateTime']);
        $this->LastUpdatedByUserID->setDbValue($row['LastUpdatedByUserID']);
        $this->LastUpdatedDateTime->setDbValue($row['LastUpdatedDateTime']);
        $this->_ProjectID->setDbValue($row['ProjectID']);
    }

    /**
     * Return a row with default values
     *
     * @return BaseEntity
     */
    protected function newRow(): BaseEntity
    {
        $row = new $this->EntityClass();
        if (!IsEmpty($this->ID->DefaultValue)) {
            $row['ID'] = intval($this->ID->DefaultValue);
        }
        if (!IsEmpty($this->MTReimbursementTypeID->DefaultValue)) {
            $row['MTReimbursementTypeID'] = intval($this->MTReimbursementTypeID->DefaultValue);
        }
        if (!IsEmpty($this->MTUserRequesterID->DefaultValue)) {
            $row['MTUserRequesterID'] = intval($this->MTUserRequesterID->DefaultValue);
        }
        if (!IsEmpty($this->MTUserApproverID->DefaultValue)) {
            $row['MTUserApproverID'] = intval($this->MTUserApproverID->DefaultValue);
        }
        if (!IsEmpty($this->RequestDateTime->DefaultValue)) {
            $row['RequestDateTime'] = $this->RequestDateTime->DefaultValue instanceof DateTimeInterface ? $this->RequestDateTime->DefaultValue : new DateTimeImmutable($this->RequestDateTime->DefaultValue);
        }
        if (!IsEmpty($this->ApprovedDateTime->DefaultValue)) {
            $row['ApprovedDateTime'] = $this->ApprovedDateTime->DefaultValue instanceof DateTimeInterface ? $this->ApprovedDateTime->DefaultValue : new DateTimeImmutable($this->ApprovedDateTime->DefaultValue);
        }
        if (!IsEmpty($this->RejectedDateTime->DefaultValue)) {
            $row['RejectedDateTime'] = $this->RejectedDateTime->DefaultValue instanceof DateTimeInterface ? $this->RejectedDateTime->DefaultValue : new DateTimeImmutable($this->RejectedDateTime->DefaultValue);
        }
        if (!IsEmpty($this->MTUserRejectorID->DefaultValue)) {
            $row['MTUserRejectorID'] = intval($this->MTUserRejectorID->DefaultValue);
        }
        if (!IsEmpty($this->_Title->DefaultValue)) {
            $row['Title'] = strval($this->_Title->DefaultValue);
        }
        if (!IsEmpty($this->Description->DefaultValue)) {
            $row['Description'] = strval($this->Description->DefaultValue);
        }
        if (!IsEmpty($this->Amount->DefaultValue)) {
            $row['Amount'] = strval($this->Amount->DefaultValue);
        }
        if (!IsEmpty($this->Attachment->DefaultValue)) {
            $row['Attachment'] = strval($this->Attachment->DefaultValue);
        }
        if (!IsEmpty($this->Notes->DefaultValue)) {
            $row['Notes'] = strval($this->Notes->DefaultValue);
        }
        if (!IsEmpty($this->CreatedByUserID->DefaultValue)) {
            $row['CreatedByUserID'] = intval($this->CreatedByUserID->DefaultValue);
        }
        if (!IsEmpty($this->CreatedDateTime->DefaultValue)) {
            $row['CreatedDateTime'] = $this->CreatedDateTime->DefaultValue instanceof DateTimeInterface ? $this->CreatedDateTime->DefaultValue : new DateTimeImmutable($this->CreatedDateTime->DefaultValue);
        }
        if (!IsEmpty($this->LastUpdatedByUserID->DefaultValue)) {
            $row['LastUpdatedByUserID'] = intval($this->LastUpdatedByUserID->DefaultValue);
        }
        if (!IsEmpty($this->LastUpdatedDateTime->DefaultValue)) {
            $row['LastUpdatedDateTime'] = $this->LastUpdatedDateTime->DefaultValue instanceof DateTimeInterface ? $this->LastUpdatedDateTime->DefaultValue : new DateTimeImmutable($this->LastUpdatedDateTime->DefaultValue);
        }
        if (!IsEmpty($this->_ProjectID->DefaultValue)) {
            $row['ProjectID'] = intval($this->_ProjectID->DefaultValue);
        }
        return $row;
    }

    // Load old record
    protected function loadOldRecord(): ?object
    {
        if ($this->CurrentRecord !== null) {
            $this->loadRowValues($this->CurrentRecord);
            return $this->CurrentRecord;
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    /**
     * Render row
     *
     * @param RowType $rowType Row type
     * @param bool $resetAttributes Reset attributes
     * @return void
     */
    public function renderRow(RowType $rowType = RowType::VIEW, bool $resetAttributes = true): void
    {
        global $httpContext;

        // Set up row type
        $this->RowType = $rowType;

        // Reset attributes
        if ($resetAttributes) {
            $this->resetAttributes();
        }

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // ID
        $this->ID->RowCssClass = "row";

        // MTReimbursementTypeID
        $this->MTReimbursementTypeID->RowCssClass = "row";

        // MTUserRequesterID
        $this->MTUserRequesterID->RowCssClass = "row";

        // MTUserApproverID
        $this->MTUserApproverID->RowCssClass = "row";

        // RequestDateTime
        $this->RequestDateTime->RowCssClass = "row";

        // ApprovedDateTime
        $this->ApprovedDateTime->RowCssClass = "row";

        // RejectedDateTime
        $this->RejectedDateTime->RowCssClass = "row";

        // MTUserRejectorID
        $this->MTUserRejectorID->RowCssClass = "row";

        // Title
        $this->_Title->RowCssClass = "row";

        // Description
        $this->Description->RowCssClass = "row";

        // Amount
        $this->Amount->RowCssClass = "row";

        // Attachment
        $this->Attachment->RowCssClass = "row";

        // Notes
        $this->Notes->RowCssClass = "row";

        // CreatedByUserID
        $this->CreatedByUserID->RowCssClass = "row";

        // CreatedDateTime
        $this->CreatedDateTime->RowCssClass = "row";

        // LastUpdatedByUserID
        $this->LastUpdatedByUserID->RowCssClass = "row";

        // LastUpdatedDateTime
        $this->LastUpdatedDateTime->RowCssClass = "row";

        // ProjectID
        $this->_ProjectID->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // ID
            $this->ID->ViewValue = $this->ID->CurrentValue;

            // MTReimbursementTypeID
            $curVal = strval($this->MTReimbursementTypeID->CurrentValue);
            if ($curVal != "") {
                $this->MTReimbursementTypeID->ViewValue = $this->MTReimbursementTypeID->lookupCacheOption($curVal);
                if ($this->MTReimbursementTypeID->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->MTReimbursementTypeID->Lookup->getTable()->Fields["ID"]->searchExpression(), "=", $curVal, $this->MTReimbursementTypeID->Lookup->getTable()->Fields["ID"]->searchDataType(), "DB");
                    $sqlWrk = $this->MTReimbursementTypeID->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = $this->getConnection();
                    $rswrk = $conn->executeQuery($sqlWrk)->fetchAllAssociative();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $rows = [];
                        foreach ($rswrk as $row) {
                            $rows[] = $this->MTReimbursementTypeID->Lookup->renderViewRow($row);
                        }
                        $this->MTReimbursementTypeID->ViewValue = $this->MTReimbursementTypeID->displayValue($rows[0]);
                    } else {
                        $this->MTReimbursementTypeID->ViewValue = FormatNumber($this->MTReimbursementTypeID->CurrentValue, $this->MTReimbursementTypeID->formatPattern());
                    }
                }
            } else {
                $this->MTReimbursementTypeID->ViewValue = null;
            }

            // MTUserRequesterID
            $this->MTUserRequesterID->ViewValue = $this->MTUserRequesterID->CurrentValue;
            $curVal = strval($this->MTUserRequesterID->CurrentValue);
            if ($curVal != "") {
                $this->MTUserRequesterID->ViewValue = $this->MTUserRequesterID->lookupCacheOption($curVal);
                if ($this->MTUserRequesterID->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->MTUserRequesterID->Lookup->getTable()->Fields["ID"]->searchExpression(), "=", $curVal, $this->MTUserRequesterID->Lookup->getTable()->Fields["ID"]->searchDataType(), "DB");
                    $sqlWrk = $this->MTUserRequesterID->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = $this->getConnection();
                    $rswrk = $conn->executeQuery($sqlWrk)->fetchAllAssociative();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $rows = [];
                        foreach ($rswrk as $row) {
                            $rows[] = $this->MTUserRequesterID->Lookup->renderViewRow($row);
                        }
                        $this->MTUserRequesterID->ViewValue = $this->MTUserRequesterID->displayValue($rows[0]);
                    } else {
                        $this->MTUserRequesterID->ViewValue = FormatNumber($this->MTUserRequesterID->CurrentValue, $this->MTUserRequesterID->formatPattern());
                    }
                }
            } else {
                $this->MTUserRequesterID->ViewValue = null;
            }

            // MTUserApproverID
            $this->MTUserApproverID->ViewValue = $this->MTUserApproverID->CurrentValue;
            $curVal = strval($this->MTUserApproverID->CurrentValue);
            if ($curVal != "") {
                $this->MTUserApproverID->ViewValue = $this->MTUserApproverID->lookupCacheOption($curVal);
                if ($this->MTUserApproverID->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->MTUserApproverID->Lookup->getTable()->Fields["ID"]->searchExpression(), "=", $curVal, $this->MTUserApproverID->Lookup->getTable()->Fields["ID"]->searchDataType(), "DB");
                    $sqlWrk = $this->MTUserApproverID->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = $this->getConnection();
                    $rswrk = $conn->executeQuery($sqlWrk)->fetchAllAssociative();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $rows = [];
                        foreach ($rswrk as $row) {
                            $rows[] = $this->MTUserApproverID->Lookup->renderViewRow($row);
                        }
                        $this->MTUserApproverID->ViewValue = $this->MTUserApproverID->displayValue($rows[0]);
                    } else {
                        $this->MTUserApproverID->ViewValue = FormatNumber($this->MTUserApproverID->CurrentValue, $this->MTUserApproverID->formatPattern());
                    }
                }
            } else {
                $this->MTUserApproverID->ViewValue = null;
            }

            // RequestDateTime
            $this->RequestDateTime->ViewValue = $this->RequestDateTime->CurrentValue;
            $this->RequestDateTime->ViewValue = FormatDateTime($this->RequestDateTime->ViewValue, $this->RequestDateTime->formatPattern());

            // ApprovedDateTime
            $this->ApprovedDateTime->ViewValue = $this->ApprovedDateTime->CurrentValue;
            $this->ApprovedDateTime->ViewValue = FormatDateTime($this->ApprovedDateTime->ViewValue, $this->ApprovedDateTime->formatPattern());

            // RejectedDateTime
            $this->RejectedDateTime->ViewValue = $this->RejectedDateTime->CurrentValue;
            $this->RejectedDateTime->ViewValue = FormatDateTime($this->RejectedDateTime->ViewValue, $this->RejectedDateTime->formatPattern());

            // MTUserRejectorID
            $this->MTUserRejectorID->ViewValue = $this->MTUserRejectorID->CurrentValue;
            $this->MTUserRejectorID->ViewValue = FormatNumber($this->MTUserRejectorID->ViewValue, $this->MTUserRejectorID->formatPattern());

            // Title
            $this->_Title->ViewValue = $this->_Title->CurrentValue;

            // Description
            $this->Description->ViewValue = $this->Description->CurrentValue;

            // Amount
            $this->Amount->ViewValue = $this->Amount->CurrentValue;
            $this->Amount->ViewValue = FormatNumber($this->Amount->ViewValue, $this->Amount->formatPattern());

            // Attachment
            if (!IsEmpty($this->Attachment->Upload->DbValue)) {
                $this->Attachment->ImageAlt = $this->Attachment->alt();
                $this->Attachment->ImageCssClass = "ew-image";
                $this->Attachment->ViewValue = $this->Attachment->Upload->DbValue;
            } else {
                $this->Attachment->ViewValue = "";
            }

            // Notes
            $this->Notes->ViewValue = $this->Notes->CurrentValue;

            // CreatedByUserID
            $this->CreatedByUserID->ViewValue = $this->CreatedByUserID->CurrentValue;
            $this->CreatedByUserID->ViewValue = FormatNumber($this->CreatedByUserID->ViewValue, $this->CreatedByUserID->formatPattern());

            // CreatedDateTime
            $this->CreatedDateTime->ViewValue = $this->CreatedDateTime->CurrentValue;
            $this->CreatedDateTime->ViewValue = FormatDateTime($this->CreatedDateTime->ViewValue, $this->CreatedDateTime->formatPattern());

            // LastUpdatedByUserID
            $this->LastUpdatedByUserID->ViewValue = $this->LastUpdatedByUserID->CurrentValue;
            $this->LastUpdatedByUserID->ViewValue = FormatNumber($this->LastUpdatedByUserID->ViewValue, $this->LastUpdatedByUserID->formatPattern());

            // LastUpdatedDateTime
            $this->LastUpdatedDateTime->ViewValue = $this->LastUpdatedDateTime->CurrentValue;
            $this->LastUpdatedDateTime->ViewValue = FormatDateTime($this->LastUpdatedDateTime->ViewValue, $this->LastUpdatedDateTime->formatPattern());

            // ProjectID
            $curVal = strval($this->_ProjectID->CurrentValue);
            if ($curVal != "") {
                $this->_ProjectID->ViewValue = $this->_ProjectID->lookupCacheOption($curVal);
                if ($this->_ProjectID->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchExpression(), "=", $curVal, $this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchDataType(), "DB");
                    $lookupFilter = $this->_ProjectID->getSelectFilter($this); // PHP
                    $sqlWrk = $this->_ProjectID->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = $this->getConnection();
                    $rswrk = $conn->executeQuery($sqlWrk)->fetchAllAssociative();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $rows = [];
                        foreach ($rswrk as $row) {
                            $rows[] = $this->_ProjectID->Lookup->renderViewRow($row);
                        }
                        $this->_ProjectID->ViewValue = $this->_ProjectID->displayValue($rows[0]);
                    } else {
                        $this->_ProjectID->ViewValue = FormatNumber($this->_ProjectID->CurrentValue, $this->_ProjectID->formatPattern());
                    }
                }
            } else {
                $this->_ProjectID->ViewValue = null;
            }

            // ID
            $this->ID->HrefValue = "";

            // MTReimbursementTypeID
            $this->MTReimbursementTypeID->HrefValue = "";

            // Title
            $this->_Title->HrefValue = "";

            // Description
            $this->Description->HrefValue = "";

            // Amount
            $this->Amount->HrefValue = "";

            // Attachment
            if (!IsEmpty($this->Attachment->Upload->DbValue)) {
                $this->Attachment->HrefValue = GetFileUploadUrl($this->Attachment, $this->Attachment->htmlDecode($this->Attachment->Upload->DbValue)); // Add prefix/suffix
                $this->Attachment->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->Attachment->HrefValue = FullUrl($this->Attachment->HrefValue, "href");
                }
            } else {
                $this->Attachment->HrefValue = "";
            }
            $this->Attachment->ExportHrefValue = $this->Attachment->UploadPath . $this->Attachment->Upload->DbValue;

            // ProjectID
            $this->_ProjectID->HrefValue = "";
        } elseif ($this->RowType == RowType::EDIT) {
            // ID
            $this->ID->setupEditAttributes();
            $this->ID->EditValue = $this->ID->CurrentValue;

            // MTReimbursementTypeID
            $this->MTReimbursementTypeID->setupEditAttributes();
            $curVal = trim(strval($this->MTReimbursementTypeID->CurrentValue));
            if ($curVal != "") {
                $this->MTReimbursementTypeID->ViewValue = $this->MTReimbursementTypeID->lookupCacheOption($curVal);
            } else {
                $this->MTReimbursementTypeID->ViewValue = $this->MTReimbursementTypeID->Lookup !== null && is_array($this->MTReimbursementTypeID->lookupOptions()) && count($this->MTReimbursementTypeID->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->MTReimbursementTypeID->ViewValue !== null) { // Load from cache
                $this->MTReimbursementTypeID->EditValue = array_values($this->MTReimbursementTypeID->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->MTReimbursementTypeID->Lookup->getTable()->Fields["ID"]->searchExpression(), "=", $this->MTReimbursementTypeID->CurrentValue, $this->MTReimbursementTypeID->Lookup->getTable()->Fields["ID"]->searchDataType(), "DB");
                }
                $sqlWrk = $this->MTReimbursementTypeID->Lookup->getSql(true, $filterWrk, "", $this, false, true);
                $conn = $this->getConnection();
                $rswrk = $conn->executeQuery($sqlWrk)->fetchAllAssociative();
                $ari = count($rswrk);
                $rows = [];
                if ($ari > 0) { // Lookup values found
                    foreach ($rswrk as $row) {
                        $rows[] = $this->MTReimbursementTypeID->Lookup->renderViewRow($row);
                    }
                } else {
                    $this->MTReimbursementTypeID->ViewValue = $this->language->phrase("PleaseSelect");
                }
                $this->MTReimbursementTypeID->EditValue = $rows;
            }
            $this->MTReimbursementTypeID->PlaceHolder = RemoveHtml($this->MTReimbursementTypeID->caption());

            // Title
            $this->_Title->setupEditAttributes();
            $this->_Title->EditValue = !$this->_Title->Raw ? HtmlDecode($this->_Title->CurrentValue) : $this->_Title->CurrentValue;
            $this->_Title->PlaceHolder = RemoveHtml($this->_Title->caption());

            // Description
            $this->Description->setupEditAttributes();
            $this->Description->EditValue = $this->Description->CurrentValue;
            $this->Description->PlaceHolder = RemoveHtml($this->Description->caption());

            // Amount
            $this->Amount->setupEditAttributes();
            $this->Amount->EditValue = $this->Amount->CurrentValue;
            $this->Amount->PlaceHolder = RemoveHtml($this->Amount->caption());
            if (strval($this->Amount->EditValue) != "" && is_numeric($this->Amount->EditValue)) {
                $this->Amount->EditValue = FormatNumber($this->Amount->EditValue, null);
            }

            // Attachment
            $this->Attachment->setupEditAttributes();
            if (!IsEmpty($this->Attachment->Upload->DbValue)) {
                $this->Attachment->ImageAlt = $this->Attachment->alt();
                $this->Attachment->ImageCssClass = "ew-image";
                $this->Attachment->EditValue = $this->Attachment->Upload->DbValue;
            } else {
                $this->Attachment->EditValue = "";
            }
            if ($this->isShow()) {
                $this->Attachment->Upload->setupTempDirectory();
            }

            // ProjectID
            $this->_ProjectID->setupEditAttributes();
            $curVal = trim(strval($this->_ProjectID->CurrentValue));
            if ($curVal != "") {
                $this->_ProjectID->ViewValue = $this->_ProjectID->lookupCacheOption($curVal);
            } else {
                $this->_ProjectID->ViewValue = $this->_ProjectID->Lookup !== null && is_array($this->_ProjectID->lookupOptions()) && count($this->_ProjectID->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->_ProjectID->ViewValue !== null) { // Load from cache
                $this->_ProjectID->EditValue = array_values($this->_ProjectID->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchExpression(), "=", $this->_ProjectID->CurrentValue, $this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchDataType(), "DB");
                }
                $lookupFilter = $this->_ProjectID->getSelectFilter($this); // PHP
                $sqlWrk = $this->_ProjectID->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = $this->getConnection();
                $rswrk = $conn->executeQuery($sqlWrk)->fetchAllAssociative();
                $ari = count($rswrk);
                $rows = [];
                if ($ari > 0) { // Lookup values found
                    foreach ($rswrk as $row) {
                        $rows[] = $this->_ProjectID->Lookup->renderViewRow($row);
                    }
                } else {
                    $this->_ProjectID->ViewValue = $this->language->phrase("PleaseSelect");
                }
                $this->_ProjectID->EditValue = $rows;
            }
            $this->_ProjectID->PlaceHolder = RemoveHtml($this->_ProjectID->caption());

            // Edit refer script

            // ID
            $this->ID->HrefValue = "";

            // MTReimbursementTypeID
            $this->MTReimbursementTypeID->HrefValue = "";

            // Title
            $this->_Title->HrefValue = "";

            // Description
            $this->Description->HrefValue = "";

            // Amount
            $this->Amount->HrefValue = "";

            // Attachment
            if (!IsEmpty($this->Attachment->Upload->DbValue)) {
                $this->Attachment->HrefValue = GetFileUploadUrl($this->Attachment, $this->Attachment->htmlDecode($this->Attachment->Upload->DbValue)); // Add prefix/suffix
                $this->Attachment->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->Attachment->HrefValue = FullUrl($this->Attachment->HrefValue, "href");
                }
            } else {
                $this->Attachment->HrefValue = "";
            }
            $this->Attachment->ExportHrefValue = $this->Attachment->UploadPath . $this->Attachment->Upload->DbValue;

            // ProjectID
            $this->_ProjectID->HrefValue = "";
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }

        // Save data for Custom Template
        if ($this->RowType == RowType::VIEW || $this->RowType == RowType::EDIT || $this->RowType == RowType::ADD) {
            $this->Rows[] = $this->CurrentRecord;
        }
    }

    // Validate form
    protected function validateForm(): bool
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        $validateForm = true;
        if ($this->ID->Visible) {
            if ($this->ID->Required) {
                if (!$this->ID->IsDetailKey && IsEmpty($this->ID->FormValue)) {
                    $this->ID->addErrorMessage(str_replace("%s", $this->ID->caption(), $this->ID->RequiredErrorMessage));
                }
            }
        }
        if ($this->MTReimbursementTypeID->Visible) {
            if ($this->MTReimbursementTypeID->Required) {
                if (!$this->MTReimbursementTypeID->IsDetailKey && IsEmpty($this->MTReimbursementTypeID->FormValue)) {
                    $this->MTReimbursementTypeID->addErrorMessage(str_replace("%s", $this->MTReimbursementTypeID->caption(), $this->MTReimbursementTypeID->RequiredErrorMessage));
                }
            }
        }
        if ($this->_Title->Visible) {
            if ($this->_Title->Required) {
                if (!$this->_Title->IsDetailKey && IsEmpty($this->_Title->FormValue)) {
                    $this->_Title->addErrorMessage(str_replace("%s", $this->_Title->caption(), $this->_Title->RequiredErrorMessage));
                }
            }
        }
        if ($this->Description->Visible) {
            if ($this->Description->Required) {
                if (!$this->Description->IsDetailKey && IsEmpty($this->Description->FormValue)) {
                    $this->Description->addErrorMessage(str_replace("%s", $this->Description->caption(), $this->Description->RequiredErrorMessage));
                }
            }
        }
        if ($this->Amount->Visible) {
            if ($this->Amount->Required) {
                if (!$this->Amount->IsDetailKey && IsEmpty($this->Amount->FormValue)) {
                    $this->Amount->addErrorMessage(str_replace("%s", $this->Amount->caption(), $this->Amount->RequiredErrorMessage));
                }
            }
            if (!CheckNumber($this->Amount->FormValue)) {
                $this->Amount->addErrorMessage($this->Amount->getErrorMessage(false));
            }
        }
        if ($this->Attachment->Visible) {
            if ($this->Attachment->Required) {
                if ($this->Attachment->Upload->FileName == "" && !$this->Attachment->Upload->KeepFile) {
                    $this->Attachment->addErrorMessage(str_replace("%s", $this->Attachment->caption(), $this->Attachment->RequiredErrorMessage));
                }
            }
        }
        if ($this->_ProjectID->Visible) {
            if ($this->_ProjectID->Required) {
                if (!$this->_ProjectID->IsDetailKey && IsEmpty($this->_ProjectID->FormValue)) {
                    $this->_ProjectID->addErrorMessage(str_replace("%s", $this->_ProjectID->caption(), $this->_ProjectID->RequiredErrorMessage));
                }
            }
        }

        // Return validate result
        $validateForm = $validateForm && !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Update record based on key values
    protected function editRow(): ?bool
    {
        $row = $this->CurrentRecord; // Use current record for update
        if ($row === null) {
            $this->setFailureMessage($this->language->phrase("NoRecord")); // Set no record message
            return false; // Update Failed
        }

        // Clone entity (as old row)
        $oldRow = clone $row;

        // Update entity
        $newRow = $this->getEditRow($row);

        // Validate constraints
        $errors = Validate($newRow);
        if (count($errors) > 0) {
            foreach ($errors as $error) {
                $this->fieldByPropertyName($error->getPropertyPath())?->addErrorMessage($error->getMessage());
            }
            return false;
        }

        // Get Entity Manager
        $em = $this->getEntityManager();
        if ($this->Attachment->Visible && !$this->Attachment->Upload->KeepFile) {
            if (!IsEmpty($this->Attachment->Upload->FileName)) {
                FixUploadFileNames($this->Attachment);
                $newRow->setAttachment($this->Attachment->setDbValueDef($this->Attachment->Upload->FileName, $this->Attachment->ReadOnly));
            }
        }

        // Call Row Updating event
        $update = method_exists($this, "rowUpdating") ? $this->rowUpdating($oldRow, $newRow) : true;
        $oldPk = $oldRow->identifierValues();
        $newPk = $newRow->identifierValues();
        if ($update) {
            try {
                $updateTableRow = null;
                if ($oldPk === $newPk) { // PK unchanged
                    if ($this->UpdateTable && $this->UpdateTable != $this->TableName) { // Use Update Table if set
                        $id = $oldRow->identifierValues();
                        $updateTableRow = $em->find($this->UpdateTableEntityClass, $id);
                        if (!$updateTableRow) {
                            throw new \RuntimeException("Cannot update: related entity not found.");
                        }
                        $updateTableRow->fromArray($newRow->toArray());
                        $em->detach($newRow);
                    }
                } else {
                    $this->handlePrimaryKeyChange($oldRow, $newRow);
                }
                $em->flush();
                $updated = true;
            } catch (Exception $e) {
                $this->dispatcher->dispatch(new RowUpdateFailedEvent($updateTableRow ?? $newRow, $e));
                $this->setFailureMessage($e->getMessage());
                $updated = false;
            }
            if ($updated) {
                if ($this->Attachment->Visible && !$this->Attachment->Upload->KeepFile) {
                    if (!SaveUploadFiles($this->Attachment, $newRow->getAttachment(), false)) {
                        $this->setFailureMessage($this->language->phrase("UploadError7"));
                        return false;
                    }
                }
            }
        } else {
            if ($update === false) {
                if ($this->peekSuccessMessage() || $this->peekFailureMessage()) {
                    // Use the message, do nothing
                } elseif ($this->CancelMessage != "") {
                    $this->setFailureMessage($this->CancelMessage);
                    $this->CancelMessage = "";
                } else {
                    $this->setFailureMessage($this->language->phrase("UpdateCancelled"));
                }
            } elseif ($update === null) { // Skip update record
                $em->detach($newRow);
            }
            $updated = $update;
        }

        // Call Row_Updated event
        if ($updated && method_exists($this, "rowUpdated")) {
            $this->rowUpdated($oldRow, $newRow);
        }

        // Write JSON response
        if (IsJsonResponse() && $updated) {
            $row = $this->getRowsFromEntities([$newRow], true);
            $table = $this->TableVar;
            $this->Response = new JsonResponse(["success" => true, "action" => Config("API_EDIT_ACTION"), $table => $row]);
        }
        return $updated;
    }

    /**
     * Handle primary key change
     *
     * @param BaseEntity $oldRow
     * @param BaseEntity $newRow
     *
     * @return void
     */
    protected function handlePrimaryKeyChange(BaseEntity $oldRow, BaseEntity $newRow): void
    {
        $em = $this->getEntityManager();
        $meta = $newRow->metadata();
        $uow = $em->getUnitOfWork();

        // Recompute changes for lifecycle events
        $uow->recomputeSingleEntityChangeSet($meta, $newRow);
        $changeSet = $uow->getEntityChangeSet($newRow);

        // Replace entity and meta data if UpdateTable is different from current table
        if ($this->UpdateTable && $this->UpdateTable != $this->TableName) {
            $data = $newRow->toArray();
            $em->detach($newRow);
            $newRow = $this->UpdateTableEntityClass::createFromArray($data);
            $meta = $newRow->metadata();
        }

        // Trigger preUpdate if there are changes
        if ($changeSet) {
            $em->getEventManager()->dispatchEvent(
                \Doctrine\ORM\Events::preUpdate,
                new \Doctrine\ORM\Event\PreUpdateEventArgs($newRow, $em, $changeSet)
            );
            //$em->flush(); // Don't flush here
        }

        // Detach entity to avoid affecting UnitOfWork
        $em->detach($newRow);

        // Prepare data for DBAL update
        $data = [];
        foreach ($changeSet as $field => [, $newValue]) {
            if ($meta->hasField($field)) {
                $data[$newRow->columnName($field)] = $newValue;
            }
        }

        // Build criteria using old identifier values (safe for any entity)
        $criteria = [];
        foreach ($meta->getIdentifierValues($oldRow) as $field => $value) {
            $criteria[$oldRow->columnName($field)] = $value;
        }

        // Execute DBAL update
        if ($data) {
            $tableName = $meta->getTableName();
            $table = ServiceLocator($tableName) ?? $this;
            $affected = $table->update($data, $criteria);

            // Trigger postUpdate only if something was actually updated
            if ($affected > 0) {
                $em->getEventManager()->dispatchEvent(
                    \Doctrine\ORM\Events::postUpdate,
                    new \Doctrine\ORM\Event\PostUpdateEventArgs($newRow, $em, $changeSet)
                );
                //$em->flush(); // Don't flush here
            }
        }
    }

    /**
     * Get edit row
     *
     * @return BaseEntity
     */
    protected function getEditRow(BaseEntity $newRow): BaseEntity
    {
        // Load DbValue
        $this->loadDbValues($newRow);

        // MTReimbursementTypeID
        if (!$this->MTReimbursementTypeID->ReadOnly) {
            $newRow->setMtreimbursementTypeId($this->MTReimbursementTypeID->setDbValueDef($this->MTReimbursementTypeID->CurrentValue));
        }

        // Title
        if (!$this->_Title->ReadOnly) {
            $newRow->setTitle($this->_Title->setDbValueDef($this->_Title->CurrentValue));
        }

        // Description
        if (!$this->Description->ReadOnly) {
            $newRow->setDescription($this->Description->setDbValueDef($this->Description->CurrentValue));
        }

        // Amount
        if (!$this->Amount->ReadOnly) {
            $newRow->setAmount($this->Amount->setDbValueDef($this->Amount->CurrentValue));
        }

        // Attachment
        if ($this->Attachment->Visible && !$this->Attachment->ReadOnly && !$this->Attachment->Upload->KeepFile) {
            if ($this->Attachment->Upload->FileName == "") {
                $newRow->setAttachment(null);
            } else {
                FixUploadTempFileNames($this->Attachment);
                $newRow->setAttachment($this->Attachment->Upload->FileName);
            }
        }

        // ProjectID
        if (!$this->_ProjectID->ReadOnly) {
            $newRow->setProjectId($this->_ProjectID->setDbValueDef($this->_ProjectID->CurrentValue));
        }
        $this->Fields->setCurrentValues($newRow);
        return $newRow;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb(): void
    {
        $breadcrumb = Breadcrumb();
        $url = CurrentUrl();
        $breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("TrreimbursementList"), "", $this->TableVar, true);
        $pageId = "edit";
        $breadcrumb->add("edit", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions(DbField $fld): void
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_MTReimbursementTypeID":
                    break;
                case "x_MTUserRequesterID":
                    break;
                case "x_MTUserApproverID":
                    break;
                case "x__ProjectID":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $qb = $fld->Lookup->getSqlBuilder(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $qb != null && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($qb, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }

                // Define a structured and consistent cache key prefix
                $cachePrefix = "lookup.result." . Container($fld->Lookup->LinkTable)->TableVar . ".";

                // Generate a unique cache key using SQL and parameters
                $sqlHash = hash("sha256", $qb->getSQL() . serialize($qb->getParameters()));
                $cacheKey = $cachePrefix . $sqlHash;

                // Fetch rows from cache or database
                $rows = $this->cache->get($cacheKey, fn (ItemInterface $item) => $qb->executeQuery()->fetchAllAssociative());
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row);
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord(): void
    {
        $infiniteScroll = false;

        // Set up StartRecord
        $pagerTable = Get(Config("TABLE_PAGER_TABLE_NAME"));
        if ($pagerTable && $pagerTable != $this->TableVar) { // Skip if not paging for this table
            $this->StartRecord = $this->getStartRecordNumber();
        } else { // Set up from querystring parameter
            $pageNumber = GetInt(Config("TABLE_PAGE_NUMBER"));
            $startRec = GetInt(Config("TABLE_START_REC"));
            $this->PageNumber = $pageNumber ?? $startRec ?? 0; // Record number = page number or start record
            if ($this->PageNumber > 0) {
                $this->StartRecord = $this->PageNumber;
            } else {
                $this->StartRecord = $this->getStartRecordNumber();
            }
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount(): int
    {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad(): void
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload(): void
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(?string &$url): void
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'danger'|'warning'
    public function messageShowing(string &$message, string $type): void
    {
        if ($type == "success") {
            //$message = "your success message";
        } elseif ($type == "danger") {
            //$message = "your failure message";
        } elseif ($type == "warning") {
            //$message = "your warning message";
        } else {
            //$message = "your message";
        }
    }

    // Page Render event
    public function pageRender(): void
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(string &$header): void
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(string &$footer): void
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(bool &$break, string &$content): void
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(string &$customError): bool
    {
        // Return error message in $customError
        return true;
    }
}
