<?php

namespace PHPMaker2026\Reimbursement;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Result;
use Doctrine\DBAL\Query\QueryBuilder;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Event\PreUpdateEventArgs;
use Doctrine\ORM\Event\PostUpdateEventArgs;
use Doctrine\ORM\Event\PreFlushEventArgs;
use Doctrine\ORM\Event\OnFlushEventArgs;
use Doctrine\ORM\Event\PostFlushEventArgs;
use Doctrine\ORM\Event\OnClearEventArgs;
use Doctrine\ORM\Event\LoadClassMetadataEventArgs;
use Doctrine\ORM\Events;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\Mapping\ClassMetadata;
use Doctrine\Persistence\Event\LifecycleEventArgs;
use Doctrine\Persistence\ObjectRepository;
use Doctrine\Persistence\ManagerRegistry;
use Doctrine\Bundle\DoctrineBundle\Attribute\AsEntityListener;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\EventStreamResponse;
use Symfony\Component\HttpFoundation\ServerEvent;
use Symfony\Component\HttpFoundation\HeaderBag;
use Symfony\Component\Filesystem\Exception\IOExceptionInterface;
use Symfony\Component\Security\Core\User\UserInterface;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\Validator\Validator\ValidatorInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\Attribute\AsAlias;
use Symfony\Component\EventDispatcher\Attribute\AsEventListener;
use Symfony\Contracts\EventDispatcher\EventDispatcherInterface;
use Symfony\Contracts\EventDispatcher\Event;
use Symfony\Contracts\Cache\CacheInterface;
use Symfony\Contracts\Cache\ItemInterface;
use League\Flysystem\DirectoryListing;
use League\Flysystem\FilesystemException;
use ParagonIE\CSPBuilder\CSPBuilder;
use InvalidArgumentException;
use Exception;
use Throwable;
use DateTimeInterface;
use DateTimeImmutable;
use DateInterval;
use DateTime;
use Closure;
use Traversable;
use Symfony\Bundle\SecurityBundleSecurity;
use PHPMaker2026\Reimbursement\Entity as BaseEntity;
use PHPMaker2026\Reimbursement\Db;
use PHPMaker2026\Reimbursement\Db\Entity;

/**
 * Page class
 */
#[AsAlias("TrreimbursementView", true)]
class TrreimbursementView extends Trreimbursement implements PageInterface
{
    use MessagesTrait;

    // Page result
    public ?Response $Response = null;

    // Headers
    public HeaderBag $Headers;

    // Page ID
    public string $PageID = "view";

    // Project ID
    public string $ProjectID = PROJECT_ID;

    // View file path
    public ?string $View = null;

    // Title
    public ?string $Title = null; // Title for <title> tag

    // CSS class/style
    public string $CurrentPageName = "TrreimbursementView"; // Route action

    // Page URLs
    public string $AddUrl = "";
    public string $EditUrl = "";
    public string $DeleteUrl = "";
    public string $ViewUrl = "";
    public string $CopyUrl = "";
    public string $ListUrl = "";

    // Update URLs
    public string $InlineAddUrl = "";
    public string $InlineCopyUrl = "";
    public string $InlineEditUrl = "";
    public string $GridAddUrl = "";
    public string $GridEditUrl = "";
    public string $MultiEditUrl = "";
    public string $MultiDeleteUrl = "";
    public string $MultiUpdateUrl = "";

    // Page headings
    public string $Heading = "";
    public string $Subheading = "";
    public string $PageHeader = "";
    public string $PageFooter = "";

    // Page layout
    public bool $UseLayout = true;

    // Page terminated
    private bool $terminated = false;
    public ?ListOptions $ExportOptions = null; // Export options
    public ?ListOptionsCollection $OtherOptions = null; // Other options
    public int $DisplayRecords = 1;
    public int $PageNumber = 1;
    public int $StartRecord = 0;
    public int $StopRecord = 0;
    public int $TotalRecords = 0;
    public bool $ViewPaging = false; // Allow view paging
    public ?int $RecordOffset = null; // Record offset (for View paging)
    public array $PagerOptions = ["proximity" => 2, "show_dots" => true];
    public bool $IsModal = false;
    public array $DetailGrids = [];

    // Constructor
    public function __construct(
        Language $language,
        AdvancedSecurity $security,
        CSPBuilder $cspBuilder,
        CacheInterface $cache,
        FieldFactory $fieldFactory,
        EventDispatcherInterface $dispatcher,
    ) {
        parent::__construct($language, $security, $cspBuilder, $cache, $fieldFactory, $dispatcher);
        global $httpContext;
        $this->Headers = new HeaderBag();
        $this->TableVar = 'trreimbursement';
        $this->TableName = 'trreimbursement';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-view-table";

        // Initialize
        $httpContext["Page"] = $this;

        // Open connection
        $httpContext["Conn"] ??= $this->getConnection();

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Other options
        $this->OtherOptions = new ListOptionsCollection();

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Pager options
        if (IsEmpty($this->PagerOptions)) {
            $this->PagerOptions = Config("PAGER_OPTIONS");
        }
    }

    // Page heading
    public function pageHeading(): string
    {
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading(): string
    {
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return Language()->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName(): string
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl(bool $withArgs = true): string
    {
        if ($withArgs) {
            return CurrentPageUrl();
        } else {
            $route = GetRoute();
            $path = $route?->getPath() ?? "";
            // Remove all placeholders like `{id}`
            $stripped = preg_replace('/\{[^}]+\}/', '', $path);
            // Remove trailing slash unless it's root '/', then replace leading slash with BasePath(true)
            return preg_replace('/^\//', BasePath(true), $stripped !== '/' ? rtrim($stripped, '/') : '/');
        }
    }

    // Get Page Header
    public function getPageHeader(): string
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            $header = '<div id="ew-page-header">' . $header . '</div>';
        }
        return $header;
    }

    // Get Page Footer
    public function getPageFooter(): string
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            $footer = '<div id="ew-page-footer">' . $footer . '</div>';
        }
        return $footer;
    }

    // Set field visibility
    public function setVisibility(): void
    {
        $this->ID->setVisibility();
        $this->MTReimbursementTypeID->setVisibility();
        $this->MTUserRequesterID->setVisibility();
        $this->MTUserApproverID->setVisibility();
        $this->RequestDateTime->setVisibility();
        $this->ApprovedDateTime->setVisibility();
        $this->RejectedDateTime->setVisibility();
        $this->MTUserRejectorID->setVisibility();
        $this->_Title->setVisibility();
        $this->Description->setVisibility();
        $this->Amount->setVisibility();
        $this->Attachment->setVisibility();
        $this->Notes->setVisibility();
        $this->CreatedByUserID->setVisibility();
        $this->CreatedDateTime->setVisibility();
        $this->LastUpdatedByUserID->setVisibility();
        $this->LastUpdatedDateTime->setVisibility();
        $this->_ProjectID->setVisibility();
    }

    // Is lookup
    public function isLookup(): bool
    {
        return SameText(RouteAction(), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill(): bool
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest(): bool
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup(): bool
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated(): bool
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param ?string $url URL for redirection
     * @return void
     */
    public function terminate(?string $url = null): void
    {
        if ($this->terminated) {
            return;
        }
        global $httpContext;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::class);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Return for API
        if (IsApi()) {
            if (!$this->Response) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                $this->Response = new JsonResponse($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (IsJsonResponse($this->Response)) { // Has JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url !== null) {
            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "TrreimbursementView"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                }
                $this->Response = new JsonResponse($result);
            } else {
                $this->Response = new RedirectResponse(GetUrl($url), Config("REDIRECT_STATUS_CODE"));
            }
        }
        return; // Return to controller
    }

    // Get row(s) from array of entities
    protected function getRowsFromEntities(array $entities, bool $first = false): array
    {
        $rows = [];
        if (array_is_list($entities)) {
            foreach ($entities as $entity) {
                $row = $this->getRowFromEntity($entity);
                if ($first) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get row from entity
    protected function getRowFromEntity(BaseEntity $entity): array
    {
        $row = [];
        foreach ($entity as $fldname => $val) {
            if ($this->TableName == Config("USER_TABLE_NAME") && $fldname == Config("PASSWORD_FIELD_NAME")) { // Skip user password field
                continue;
            }
            if (isset($this->Fields[$fldname]) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                $fld = $this->Fields[$fldname];
                if ($fld->HtmlTag == "FILE") { // Upload field
                    if (IsEmpty($val)) {
                        $row[$fldname] = null;
                    } else {
                        $key = SessionId() . ServerVar("ENCRYPTION_KEY");
                        if ($fld->DataType == DataType::BLOB) {
                            $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                "/" . $fld->TableVar . "/" . $fld->Param . "/" . $this->getKeyAsString($entity, Config("ROUTE_COMPOSITE_KEY_SEPARATOR"))));
                            $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                        } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                            $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                "/" . $fld->TableVar . "/" . Encrypt($fld->uploadPath() . $val, $key)));
                            $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                        } else { // Multiple files
                            $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                            $ar = [];
                            foreach ($files as $file) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->uploadPath() . $file, $key)));
                                if (!IsEmpty($file)) {
                                    $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                }
                            }
                            $row[$fldname] = $ar;
                        }
                    }
                } else {
                    if ($val instanceof DateTimeInterface) {
                        $val = $val->format(DATE_ATOM);
                    }
                    $row[$fldname] = $val;
                }
            }
        }
        return $row;
    }

    // Hide fields for add/edit
    protected function hideFieldsForAddEdit(): void
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->ID->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = []): array
    {
        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this); // Use settings from current page
    }

    /**
     * Get view record key
     *
     * @return array
     */
    public function getViewRecordKey(): array
    {
        $recordKeys = $this->getRecordKeys();
        return count($recordKeys) > 0
            ? array_values($recordKeys[0]) // Get values only
            : [];
    }

    /**
     * Page init
     *
     * @return void
     */
    public function init(): void
    {
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run(): void
    {
        global $httpContext;

        // Is modal
        $this->IsModal = IsModal();
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ParamBool(Config("PAGE_LAYOUT"), true);

        // View
        $this->View = Get(Config("VIEW"));
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::class);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->MTReimbursementTypeID);
        $this->setupLookupOptions($this->MTUserRequesterID);
        $this->setupLookupOptions($this->MTUserApproverID);
        $this->setupLookupOptions($this->_ProjectID);

        // Check modal
        if ($this->IsModal) {
            $httpContext["SkipHeaderFooter"] = true;
        }

        // Load pager
        $loadPager = false;
        $returnUrl = "";
        if (($keyValue = Get("ID") ?? Route("id")) !== null) {
            $this->ID->setQueryStringValue($keyValue);
        } elseif (Post("ID") !== null) {
            $this->ID->setFormValue(Post("ID"));
        } elseif (IsApi() && ($keyValue = Key(0)) !== null) {
            $this->ID->setQueryStringValue($keyValue);
        } elseif (!$loadPager) {
            $returnUrl = "TrreimbursementList"; // Return to list
        }

        // Get action
        $this->CurrentAction = "show"; // Display
        switch ($this->CurrentAction) {
            case "show": // Get a record to display
                if (!$this->CurrentRecord) { // No current record
                    if (!$this->peekSuccessMessage() && !$this->peekFailureMessage()) {
                        $this->setFailureMessage($this->language->phrase("NoRecord")); // Set no record message
                    }
                    $this->terminate("TrreimbursementList"); // Return to list page
                    return;
                } else { // Load current row
                    $this->loadRow();
                }
                break;
        }
        if ($returnUrl != "") {
            $this->terminate($returnUrl);
            return;
        }

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Render row
        $this->renderRow(RowType::VIEW);

        // Normal return
        if (IsApi()) {
            if (!$this->isExport()) {
                $row = $this->getRowFromEntity($this->CurrentRecord); // Get current record only
                $this->Response = new JsonResponse(["success" => true, "action" => Config("API_VIEW_ACTION"), $this->TableVar => $row]);
                $this->terminate();
            }
            return;
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::class);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Set up other options
    protected function setupOtherOptions(): void
    {
        // Disable Add/Edit/Copy/Delete for Modal and UseAjaxActions
        /*
        if ($this->IsModal && $this->UseAjaxActions) {
            $this->AddUrl = "";
            $this->EditUrl = "";
            $this->CopyUrl = "";
            $this->DeleteUrl = "";
        }
        */
        $options = $this->OtherOptions;
        $option = $options["action"];

        // Add
        $item = $option->add("add");
        $addcaption = HtmlTitle($this->language->phrase("ViewPageAddLink"));
        if ($this->IsModal) {
            $item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $this->language->phrase("ViewPageAddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $this->language->phrase("ViewPageAddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $this->security->canAdd();

        // Edit
        $item = $option->add("edit");
        $editcaption = HtmlTitle($this->language->phrase("ViewPageEditLink"));
        if ($this->IsModal) {
            $item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $this->language->phrase("ViewPageEditLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $this->language->phrase("ViewPageEditLink") . "</a>";
        }
        $item->Visible = $this->EditUrl != "" && $this->security->canEdit();

        // Copy
        $item = $option->add("copy");
        $copycaption = HtmlTitle($this->language->phrase("ViewPageCopyLink"));
        if ($this->IsModal) {
            $item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $this->language->phrase("ViewPageCopyLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $this->language->phrase("ViewPageCopyLink") . "</a>";
        }
        $item->Visible = $this->CopyUrl != "" && $this->security->canAdd();

        // Delete
        $item = $option->add("delete");
        $url = GetUrl($this->DeleteUrl);
        $item->Body = "<a class=\"ew-action ew-delete\"" .
            ($this->InlineDelete || $this->IsModal ? " data-ew-action=\"inline-delete\"" : "") .
            " title=\"" . HtmlTitle($this->language->phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . HtmlTitle($this->language->phrase("ViewPageDeleteLink")) .
            "\" href=\"" . HtmlEncode($url) . "\">" . $this->language->phrase("ViewPageDeleteLink") . "</a>";
        $item->Visible = $this->DeleteUrl != "" && $this->security->canDelete();

        // Set up action default
        $option = $options["action"];
        $option->DropDownButtonPhrase = $this->language->phrase("ButtonActions");
        $option->UseDropDownButton = !IsJsonResponse() && false;
        $option->UseButtonGroup = true;
        $item = $option->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
    }

    /**
     * Load row based on key values
     *
     * @return bool
     */
    public function loadRow(): bool
    {
        $result = $this->CurrentRecord !== null;
        if ($result) {
            $this->loadRowValues($this->CurrentRecord); // Load row values
        }
        return $result;
    }

    /**
     * Load row values from result set or record
     *
     * @param ?BaseEntity $row Record
     * @return void
     */
    public function loadRowValues(?BaseEntity $row = null): void
    {
        if ($row instanceof BaseEntity) { // Get array from entity
        }
        $row ??= $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->ID->setDbValue($row['ID']);
        $this->MTReimbursementTypeID->setDbValue($row['MTReimbursementTypeID']);
        $this->MTUserRequesterID->setDbValue($row['MTUserRequesterID']);
        $this->MTUserApproverID->setDbValue($row['MTUserApproverID']);
        $this->RequestDateTime->setDbValue($row['RequestDateTime']);
        $this->ApprovedDateTime->setDbValue($row['ApprovedDateTime']);
        $this->RejectedDateTime->setDbValue($row['RejectedDateTime']);
        $this->MTUserRejectorID->setDbValue($row['MTUserRejectorID']);
        $this->_Title->setDbValue($row['Title']);
        $this->Description->setDbValue($row['Description']);
        $this->Amount->setDbValue($row['Amount']);
        $this->Attachment->Upload->DbValue = $row['Attachment'];
        $this->Attachment->setDbValue($this->Attachment->Upload->DbValue);
        $this->Notes->setDbValue($row['Notes']);
        $this->CreatedByUserID->setDbValue($row['CreatedByUserID']);
        $this->CreatedDateTime->setDbValue($row['CreatedDateTime']);
        $this->LastUpdatedByUserID->setDbValue($row['LastUpdatedByUserID']);
        $this->LastUpdatedDateTime->setDbValue($row['LastUpdatedDateTime']);
        $this->_ProjectID->setDbValue($row['ProjectID']);
    }

    /**
     * Return a row with default values
     *
     * @return BaseEntity
     */
    protected function newRow(): BaseEntity
    {
        $row = new $this->EntityClass();
        if (!IsEmpty($this->ID->DefaultValue)) {
            $row['ID'] = intval($this->ID->DefaultValue);
        }
        if (!IsEmpty($this->MTReimbursementTypeID->DefaultValue)) {
            $row['MTReimbursementTypeID'] = intval($this->MTReimbursementTypeID->DefaultValue);
        }
        if (!IsEmpty($this->MTUserRequesterID->DefaultValue)) {
            $row['MTUserRequesterID'] = intval($this->MTUserRequesterID->DefaultValue);
        }
        if (!IsEmpty($this->MTUserApproverID->DefaultValue)) {
            $row['MTUserApproverID'] = intval($this->MTUserApproverID->DefaultValue);
        }
        if (!IsEmpty($this->RequestDateTime->DefaultValue)) {
            $row['RequestDateTime'] = $this->RequestDateTime->DefaultValue instanceof DateTimeInterface ? $this->RequestDateTime->DefaultValue : new DateTimeImmutable($this->RequestDateTime->DefaultValue);
        }
        if (!IsEmpty($this->ApprovedDateTime->DefaultValue)) {
            $row['ApprovedDateTime'] = $this->ApprovedDateTime->DefaultValue instanceof DateTimeInterface ? $this->ApprovedDateTime->DefaultValue : new DateTimeImmutable($this->ApprovedDateTime->DefaultValue);
        }
        if (!IsEmpty($this->RejectedDateTime->DefaultValue)) {
            $row['RejectedDateTime'] = $this->RejectedDateTime->DefaultValue instanceof DateTimeInterface ? $this->RejectedDateTime->DefaultValue : new DateTimeImmutable($this->RejectedDateTime->DefaultValue);
        }
        if (!IsEmpty($this->MTUserRejectorID->DefaultValue)) {
            $row['MTUserRejectorID'] = intval($this->MTUserRejectorID->DefaultValue);
        }
        if (!IsEmpty($this->_Title->DefaultValue)) {
            $row['Title'] = strval($this->_Title->DefaultValue);
        }
        if (!IsEmpty($this->Description->DefaultValue)) {
            $row['Description'] = strval($this->Description->DefaultValue);
        }
        if (!IsEmpty($this->Amount->DefaultValue)) {
            $row['Amount'] = strval($this->Amount->DefaultValue);
        }
        if (!IsEmpty($this->Attachment->DefaultValue)) {
            $row['Attachment'] = strval($this->Attachment->DefaultValue);
        }
        if (!IsEmpty($this->Notes->DefaultValue)) {
            $row['Notes'] = strval($this->Notes->DefaultValue);
        }
        if (!IsEmpty($this->CreatedByUserID->DefaultValue)) {
            $row['CreatedByUserID'] = intval($this->CreatedByUserID->DefaultValue);
        }
        if (!IsEmpty($this->CreatedDateTime->DefaultValue)) {
            $row['CreatedDateTime'] = $this->CreatedDateTime->DefaultValue instanceof DateTimeInterface ? $this->CreatedDateTime->DefaultValue : new DateTimeImmutable($this->CreatedDateTime->DefaultValue);
        }
        if (!IsEmpty($this->LastUpdatedByUserID->DefaultValue)) {
            $row['LastUpdatedByUserID'] = intval($this->LastUpdatedByUserID->DefaultValue);
        }
        if (!IsEmpty($this->LastUpdatedDateTime->DefaultValue)) {
            $row['LastUpdatedDateTime'] = $this->LastUpdatedDateTime->DefaultValue instanceof DateTimeInterface ? $this->LastUpdatedDateTime->DefaultValue : new DateTimeImmutable($this->LastUpdatedDateTime->DefaultValue);
        }
        if (!IsEmpty($this->_ProjectID->DefaultValue)) {
            $row['ProjectID'] = intval($this->_ProjectID->DefaultValue);
        }
        return $row;
    }

    /**
     * Render row
     *
     * @param RowType $rowType Row type
     * @param bool $resetAttributes Reset attributes
     * @return void
     */
    public function renderRow(RowType $rowType = RowType::VIEW, bool $resetAttributes = true): void
    {
        global $httpContext;

        // Set up row type
        $this->RowType = $rowType;

        // Reset attributes
        if ($resetAttributes) {
            $this->resetAttributes();
        }

        // Initialize URLs
        $this->AddUrl = $this->getAddUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();
        $this->ListUrl = $this->getListUrl();
        $this->setupOtherOptions();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // ID

        // MTReimbursementTypeID

        // MTUserRequesterID

        // MTUserApproverID

        // RequestDateTime

        // ApprovedDateTime

        // RejectedDateTime

        // MTUserRejectorID

        // Title

        // Description

        // Amount

        // Attachment

        // Notes

        // CreatedByUserID

        // CreatedDateTime

        // LastUpdatedByUserID

        // LastUpdatedDateTime

        // ProjectID

        // View row
        if ($this->RowType == RowType::VIEW) {
            // ID
            $this->ID->ViewValue = $this->ID->CurrentValue;

            // MTReimbursementTypeID
            $curVal = strval($this->MTReimbursementTypeID->CurrentValue);
            if ($curVal != "") {
                $this->MTReimbursementTypeID->ViewValue = $this->MTReimbursementTypeID->lookupCacheOption($curVal);
                if ($this->MTReimbursementTypeID->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->MTReimbursementTypeID->Lookup->getTable()->Fields["ID"]->searchExpression(), "=", $curVal, $this->MTReimbursementTypeID->Lookup->getTable()->Fields["ID"]->searchDataType(), "DB");
                    $sqlWrk = $this->MTReimbursementTypeID->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = $this->getConnection();
                    $rswrk = $conn->executeQuery($sqlWrk)->fetchAllAssociative();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $rows = [];
                        foreach ($rswrk as $row) {
                            $rows[] = $this->MTReimbursementTypeID->Lookup->renderViewRow($row);
                        }
                        $this->MTReimbursementTypeID->ViewValue = $this->MTReimbursementTypeID->displayValue($rows[0]);
                    } else {
                        $this->MTReimbursementTypeID->ViewValue = FormatNumber($this->MTReimbursementTypeID->CurrentValue, $this->MTReimbursementTypeID->formatPattern());
                    }
                }
            } else {
                $this->MTReimbursementTypeID->ViewValue = null;
            }

            // MTUserRequesterID
            $this->MTUserRequesterID->ViewValue = $this->MTUserRequesterID->CurrentValue;
            $curVal = strval($this->MTUserRequesterID->CurrentValue);
            if ($curVal != "") {
                $this->MTUserRequesterID->ViewValue = $this->MTUserRequesterID->lookupCacheOption($curVal);
                if ($this->MTUserRequesterID->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->MTUserRequesterID->Lookup->getTable()->Fields["ID"]->searchExpression(), "=", $curVal, $this->MTUserRequesterID->Lookup->getTable()->Fields["ID"]->searchDataType(), "DB");
                    $sqlWrk = $this->MTUserRequesterID->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = $this->getConnection();
                    $rswrk = $conn->executeQuery($sqlWrk)->fetchAllAssociative();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $rows = [];
                        foreach ($rswrk as $row) {
                            $rows[] = $this->MTUserRequesterID->Lookup->renderViewRow($row);
                        }
                        $this->MTUserRequesterID->ViewValue = $this->MTUserRequesterID->displayValue($rows[0]);
                    } else {
                        $this->MTUserRequesterID->ViewValue = FormatNumber($this->MTUserRequesterID->CurrentValue, $this->MTUserRequesterID->formatPattern());
                    }
                }
            } else {
                $this->MTUserRequesterID->ViewValue = null;
            }

            // MTUserApproverID
            $this->MTUserApproverID->ViewValue = $this->MTUserApproverID->CurrentValue;
            $curVal = strval($this->MTUserApproverID->CurrentValue);
            if ($curVal != "") {
                $this->MTUserApproverID->ViewValue = $this->MTUserApproverID->lookupCacheOption($curVal);
                if ($this->MTUserApproverID->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->MTUserApproverID->Lookup->getTable()->Fields["ID"]->searchExpression(), "=", $curVal, $this->MTUserApproverID->Lookup->getTable()->Fields["ID"]->searchDataType(), "DB");
                    $sqlWrk = $this->MTUserApproverID->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = $this->getConnection();
                    $rswrk = $conn->executeQuery($sqlWrk)->fetchAllAssociative();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $rows = [];
                        foreach ($rswrk as $row) {
                            $rows[] = $this->MTUserApproverID->Lookup->renderViewRow($row);
                        }
                        $this->MTUserApproverID->ViewValue = $this->MTUserApproverID->displayValue($rows[0]);
                    } else {
                        $this->MTUserApproverID->ViewValue = FormatNumber($this->MTUserApproverID->CurrentValue, $this->MTUserApproverID->formatPattern());
                    }
                }
            } else {
                $this->MTUserApproverID->ViewValue = null;
            }

            // RequestDateTime
            $this->RequestDateTime->ViewValue = $this->RequestDateTime->CurrentValue;
            $this->RequestDateTime->ViewValue = FormatDateTime($this->RequestDateTime->ViewValue, $this->RequestDateTime->formatPattern());

            // ApprovedDateTime
            $this->ApprovedDateTime->ViewValue = $this->ApprovedDateTime->CurrentValue;
            $this->ApprovedDateTime->ViewValue = FormatDateTime($this->ApprovedDateTime->ViewValue, $this->ApprovedDateTime->formatPattern());

            // RejectedDateTime
            $this->RejectedDateTime->ViewValue = $this->RejectedDateTime->CurrentValue;
            $this->RejectedDateTime->ViewValue = FormatDateTime($this->RejectedDateTime->ViewValue, $this->RejectedDateTime->formatPattern());

            // MTUserRejectorID
            $this->MTUserRejectorID->ViewValue = $this->MTUserRejectorID->CurrentValue;
            $this->MTUserRejectorID->ViewValue = FormatNumber($this->MTUserRejectorID->ViewValue, $this->MTUserRejectorID->formatPattern());

            // Title
            $this->_Title->ViewValue = $this->_Title->CurrentValue;

            // Description
            $this->Description->ViewValue = $this->Description->CurrentValue;

            // Amount
            $this->Amount->ViewValue = $this->Amount->CurrentValue;
            $this->Amount->ViewValue = FormatNumber($this->Amount->ViewValue, $this->Amount->formatPattern());

            // Attachment
            if (!IsEmpty($this->Attachment->Upload->DbValue)) {
                $this->Attachment->ImageAlt = $this->Attachment->alt();
                $this->Attachment->ImageCssClass = "ew-image";
                $this->Attachment->ViewValue = $this->Attachment->Upload->DbValue;
            } else {
                $this->Attachment->ViewValue = "";
            }

            // Notes
            $this->Notes->ViewValue = $this->Notes->CurrentValue;

            // CreatedByUserID
            $this->CreatedByUserID->ViewValue = $this->CreatedByUserID->CurrentValue;
            $this->CreatedByUserID->ViewValue = FormatNumber($this->CreatedByUserID->ViewValue, $this->CreatedByUserID->formatPattern());

            // CreatedDateTime
            $this->CreatedDateTime->ViewValue = $this->CreatedDateTime->CurrentValue;
            $this->CreatedDateTime->ViewValue = FormatDateTime($this->CreatedDateTime->ViewValue, $this->CreatedDateTime->formatPattern());

            // LastUpdatedByUserID
            $this->LastUpdatedByUserID->ViewValue = $this->LastUpdatedByUserID->CurrentValue;
            $this->LastUpdatedByUserID->ViewValue = FormatNumber($this->LastUpdatedByUserID->ViewValue, $this->LastUpdatedByUserID->formatPattern());

            // LastUpdatedDateTime
            $this->LastUpdatedDateTime->ViewValue = $this->LastUpdatedDateTime->CurrentValue;
            $this->LastUpdatedDateTime->ViewValue = FormatDateTime($this->LastUpdatedDateTime->ViewValue, $this->LastUpdatedDateTime->formatPattern());

            // ProjectID
            $curVal = strval($this->_ProjectID->CurrentValue);
            if ($curVal != "") {
                $this->_ProjectID->ViewValue = $this->_ProjectID->lookupCacheOption($curVal);
                if ($this->_ProjectID->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchExpression(), "=", $curVal, $this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchDataType(), "DB");
                    $lookupFilter = $this->_ProjectID->getSelectFilter($this); // PHP
                    $sqlWrk = $this->_ProjectID->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = $this->getConnection();
                    $rswrk = $conn->executeQuery($sqlWrk)->fetchAllAssociative();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $rows = [];
                        foreach ($rswrk as $row) {
                            $rows[] = $this->_ProjectID->Lookup->renderViewRow($row);
                        }
                        $this->_ProjectID->ViewValue = $this->_ProjectID->displayValue($rows[0]);
                    } else {
                        $this->_ProjectID->ViewValue = FormatNumber($this->_ProjectID->CurrentValue, $this->_ProjectID->formatPattern());
                    }
                }
            } else {
                $this->_ProjectID->ViewValue = null;
            }

            // ID
            $this->ID->HrefValue = "";
            $this->ID->TooltipValue = "";

            // MTReimbursementTypeID
            $this->MTReimbursementTypeID->HrefValue = "";
            $this->MTReimbursementTypeID->TooltipValue = "";

            // MTUserRequesterID
            $this->MTUserRequesterID->HrefValue = "";
            $this->MTUserRequesterID->TooltipValue = "";

            // MTUserApproverID
            $this->MTUserApproverID->HrefValue = "";
            $this->MTUserApproverID->TooltipValue = "";

            // RequestDateTime
            $this->RequestDateTime->HrefValue = "";
            $this->RequestDateTime->TooltipValue = "";

            // ApprovedDateTime
            $this->ApprovedDateTime->HrefValue = "";
            $this->ApprovedDateTime->TooltipValue = "";

            // RejectedDateTime
            $this->RejectedDateTime->HrefValue = "";
            $this->RejectedDateTime->TooltipValue = "";

            // MTUserRejectorID
            $this->MTUserRejectorID->HrefValue = "";
            $this->MTUserRejectorID->TooltipValue = "";

            // Title
            $this->_Title->HrefValue = "";
            $this->_Title->TooltipValue = "";

            // Description
            $this->Description->HrefValue = "";
            $this->Description->TooltipValue = "";

            // Amount
            $this->Amount->HrefValue = "";
            $this->Amount->TooltipValue = "";

            // Attachment
            if (!IsEmpty($this->Attachment->Upload->DbValue)) {
                $this->Attachment->HrefValue = GetFileUploadUrl($this->Attachment, $this->Attachment->htmlDecode($this->Attachment->Upload->DbValue)); // Add prefix/suffix
                $this->Attachment->LinkAttrs["target"] = "_blank"; // Add target
                if ($this->isExport()) {
                    $this->Attachment->HrefValue = FullUrl($this->Attachment->HrefValue, "href");
                }
            } else {
                $this->Attachment->HrefValue = "";
            }
            $this->Attachment->ExportHrefValue = $this->Attachment->UploadPath . $this->Attachment->Upload->DbValue;
            $this->Attachment->TooltipValue = "";
            if ($this->Attachment->UseColorbox) {
                if (IsEmpty($this->Attachment->TooltipValue)) {
                    $this->Attachment->LinkAttrs["title"] = $this->language->phrase("ViewImageGallery");
                }
                $this->Attachment->LinkAttrs["data-rel"] = "trreimbursement_x_Attachment";
                $this->Attachment->LinkAttrs->appendClass("ew-lightbox");
            }

            // Notes
            $this->Notes->HrefValue = "";
            $this->Notes->TooltipValue = "";

            // CreatedByUserID
            $this->CreatedByUserID->HrefValue = "";
            $this->CreatedByUserID->TooltipValue = "";

            // CreatedDateTime
            $this->CreatedDateTime->HrefValue = "";
            $this->CreatedDateTime->TooltipValue = "";

            // LastUpdatedByUserID
            $this->LastUpdatedByUserID->HrefValue = "";
            $this->LastUpdatedByUserID->TooltipValue = "";

            // LastUpdatedDateTime
            $this->LastUpdatedDateTime->HrefValue = "";
            $this->LastUpdatedDateTime->TooltipValue = "";

            // ProjectID
            $this->_ProjectID->HrefValue = "";
            $this->_ProjectID->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb(): void
    {
        $breadcrumb = Breadcrumb();
        $url = CurrentUrl();
        $breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("TrreimbursementList"), "", $this->TableVar, true);
        $pageId = "view";
        $breadcrumb->add("view", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions(DbField $fld): void
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_MTReimbursementTypeID":
                    break;
                case "x_MTUserRequesterID":
                    break;
                case "x_MTUserApproverID":
                    break;
                case "x__ProjectID":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $qb = $fld->Lookup->getSqlBuilder(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $qb != null && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($qb, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }

                // Define a structured and consistent cache key prefix
                $cachePrefix = "lookup.result." . Container($fld->Lookup->LinkTable)->TableVar . ".";

                // Generate a unique cache key using SQL and parameters
                $sqlHash = hash("sha256", $qb->getSQL() . serialize($qb->getParameters()));
                $cacheKey = $cachePrefix . $sqlHash;

                // Fetch rows from cache or database
                $rows = $this->cache->get($cacheKey, fn (ItemInterface $item) => $qb->executeQuery()->fetchAllAssociative());
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row);
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord(): void
    {
        $infiniteScroll = false;

        // Set up StartRecord
        $pagerTable = Get(Config("TABLE_PAGER_TABLE_NAME"));
        if ($pagerTable && $pagerTable != $this->TableVar) { // Skip if not paging for this table
            $this->StartRecord = $this->getStartRecordNumber();
        } else { // Set up from querystring parameter
            $pageNumber = GetInt(Config("TABLE_PAGE_NUMBER"));
            $startRec = GetInt(Config("TABLE_START_REC"));
            $this->PageNumber = $pageNumber ?? $startRec ?? 0; // Record number = page number or start record
            if ($this->PageNumber > 0) {
                $this->StartRecord = $this->PageNumber;
            } else {
                $this->StartRecord = $this->getStartRecordNumber();
            }
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount(): int
    {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Page Load event
    public function pageLoad(): void
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload(): void
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(?string &$url): void
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'danger'|'warning'
    public function messageShowing(string &$message, string $type): void
    {
        if ($type == "success") {
            //$message = "your success message";
        } elseif ($type == "danger") {
            //$message = "your failure message";
        } elseif ($type == "warning") {
            //$message = "your warning message";
        } else {
            //$message = "your message";
        }
    }

    // Page Render event
    public function pageRender(): void
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(string &$header): void
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(string &$footer): void
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(bool &$break, string &$content): void
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(object &$doc): bool
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport(object $doc, BaseEntity $row): void
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $row["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported(object $doc): void
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }
}
