<?php

namespace PHPMaker2026\Reimbursement;

use Symfony\Component\HttpKernel\Event\RequestEvent;

class BodyParsingListener
{

    public function onKernelRequest(RequestEvent $event): void
    {
        $request = $event->getRequest();

        // Check if the request's Content-Type is application/json
        if ($request->getContentTypeFormat() !== 'json') {
            return;
        }

        // Decode the JSON payload
        $data = $request->toArray();

        // Replace the request parameters with the decoded JSON data
        $request->request->replace(is_array($data) ? $data : []);
    }
}
