<?php

namespace PHPMaker2026\Reimbursement\Db\Entity;

use DateTime;
use DateTimeImmutable;
use DateTimeInterface;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\CustomIdGenerator;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use Symfony\Component\Clock\DatePoint;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use PHPMaker2026\Reimbursement\AdvancedUserInterface;
use PHPMaker2026\Reimbursement\AdvancedSecurity;
use PHPMaker2026\Reimbursement\UserProfile;
use PHPMaker2026\Reimbursement\UserRepository;
use PHPMaker2026\Reimbursement\CustomEntityRepository;
use PHPMaker2026\Reimbursement\DefaultSequenceGenerator;
use PHPMaker2026\Reimbursement\UuidGenerator;
use PHPMaker2026\Reimbursement\Entity as BaseEntity;
use function PHPMaker2026\Reimbursement\Config;
use function PHPMaker2026\Reimbursement\EntityManager;
use function PHPMaker2026\Reimbursement\ConvertToBool;
use function PHPMaker2026\Reimbursement\ConvertToString;
use function PHPMaker2026\Reimbursement\SameDateTime;
use function PHPMaker2026\Reimbursement\RemoveXss;
use function PHPMaker2026\Reimbursement\HtmlDecode;
use function PHPMaker2026\Reimbursement\HashPassword;
use function PHPMaker2026\Reimbursement\PhpEncrypt;
use function PHPMaker2026\Reimbursement\PhpDecrypt;
use function PHPMaker2026\Reimbursement\Security;
use function PHPMaker2026\Reimbursement\IsEmpty;
use InvalidArgumentException;

/**
 * Entity class for 'mtproject' table
 */
#[Entity]
#[Table('mtproject')]
class Mtproject extends BaseEntity
{
    #[Id]
    #[Column(name: 'ProjectID', options: ['param' => '_ProjectID'], type: 'integer', unique: true, insertable: false, updatable: false)]
    #[GeneratedValue]
    private int $projectId;

    #[Column(name: 'ProjectCode', type: 'string', nullable: true)]
    private ?string $projectCode;

    #[Column(name: 'ProjectName', type: 'string')]
    private string $projectName;

    #[Column(name: 'Description', type: 'string', nullable: true)]
    private ?string $description;

    #[Column(name: 'IsActive', type: 'boolean', nullable: true)]
    private ?bool $isActive;

    #[Column(name: 'CreatedByUserID', type: 'integer', nullable: true)]
    private ?int $createdByUserId;

    #[Column(name: 'CreatedDateTime', type: 'datetime', nullable: true)]
    private ?DateTimeInterface $createdDateTime;

    #[Column(name: 'LastUpdatedByUserID', type: 'integer', nullable: true)]
    private ?int $lastUpdatedByUserId;

    #[Column(name: 'LastUpdatedDateTime', type: 'datetime', nullable: true)]
    private ?DateTimeInterface $lastUpdatedDateTime;

    public function getProjectId(): int
    {
        return $this->projectId;
    }

    public function setProjectId(int $value): static
    {
        $this->projectId = $value;
        return $this;
    }

    public function getProjectCode(): ?string
    {
        return HtmlDecode($this->projectCode);
    }

    public function setProjectCode(?string $value): static
    {
        $this->projectCode = RemoveXss($value);
        return $this;
    }

    public function getProjectName(): string
    {
        return HtmlDecode($this->projectName);
    }

    public function setProjectName(string $value): static
    {
        $this->projectName = RemoveXss($value);
        return $this;
    }

    public function getDescription(): ?string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(?string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getIsActive(): ?bool
    {
        return $this->isActive;
    }

    public function setIsActive(?bool $value): static
    {
        $this->isActive = $value;
        return $this;
    }

    public function getCreatedByUserId(): ?int
    {
        return $this->createdByUserId;
    }

    public function setCreatedByUserId(?int $value): static
    {
        $this->createdByUserId = $value;
        return $this;
    }

    public function getCreatedDateTime(): ?DateTimeInterface
    {
        return $this->createdDateTime;
    }

    public function setCreatedDateTime(?DateTimeInterface $value): static
    {
        if (!$this->isInitialized('createdDateTime') || !SameDateTime($this->createdDateTime, $value)) {
            $this->createdDateTime = $value;
        }
        return $this;
    }

    public function getLastUpdatedByUserId(): ?int
    {
        return $this->lastUpdatedByUserId;
    }

    public function setLastUpdatedByUserId(?int $value): static
    {
        $this->lastUpdatedByUserId = $value;
        return $this;
    }

    public function getLastUpdatedDateTime(): ?DateTimeInterface
    {
        return $this->lastUpdatedDateTime;
    }

    public function setLastUpdatedDateTime(?DateTimeInterface $value): static
    {
        if (!$this->isInitialized('lastUpdatedDateTime') || !SameDateTime($this->lastUpdatedDateTime, $value)) {
            $this->lastUpdatedDateTime = $value;
        }
        return $this;
    }
}
