<?php

namespace PHPMaker2026\Reimbursement\Db\Entity;

use DateTime;
use DateTimeImmutable;
use DateTimeInterface;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\CustomIdGenerator;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use Symfony\Component\Clock\DatePoint;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use PHPMaker2026\Reimbursement\AdvancedUserInterface;
use PHPMaker2026\Reimbursement\AdvancedSecurity;
use PHPMaker2026\Reimbursement\UserProfile;
use PHPMaker2026\Reimbursement\UserRepository;
use PHPMaker2026\Reimbursement\CustomEntityRepository;
use PHPMaker2026\Reimbursement\DefaultSequenceGenerator;
use PHPMaker2026\Reimbursement\UuidGenerator;
use PHPMaker2026\Reimbursement\Entity as BaseEntity;
use function PHPMaker2026\Reimbursement\Config;
use function PHPMaker2026\Reimbursement\EntityManager;
use function PHPMaker2026\Reimbursement\ConvertToBool;
use function PHPMaker2026\Reimbursement\ConvertToString;
use function PHPMaker2026\Reimbursement\SameDateTime;
use function PHPMaker2026\Reimbursement\RemoveXss;
use function PHPMaker2026\Reimbursement\HtmlDecode;
use function PHPMaker2026\Reimbursement\HashPassword;
use function PHPMaker2026\Reimbursement\PhpEncrypt;
use function PHPMaker2026\Reimbursement\PhpDecrypt;
use function PHPMaker2026\Reimbursement\Security;
use function PHPMaker2026\Reimbursement\IsEmpty;
use InvalidArgumentException;

/**
 * Entity class for 'mtreimbursementtype' table
 */
#[Entity]
#[Table('mtreimbursementtype')]
class Mtreimbursementtype extends BaseEntity
{
    #[Id]
    #[Column(name: 'ID', type: 'integer', unique: true, insertable: false, updatable: false)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: 'Code', type: 'string')]
    private string $code;

    #[Column(name: 'Description', type: 'string', nullable: true)]
    private ?string $description;

    #[Column(name: 'CreatedByUserID', type: 'integer', nullable: true)]
    private ?int $createdByUserId;

    #[Column(name: 'CreatedDateTime', type: 'datetime', nullable: true)]
    private ?DateTimeInterface $createdDateTime;

    #[Column(name: 'LastUpdatedByUserID', type: 'integer', nullable: true)]
    private ?int $lastUpdatedByUserId;

    #[Column(name: 'LastUpdatedDateTime', type: 'datetime', nullable: true)]
    private ?DateTimeInterface $lastUpdatedDateTime;

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getCode(): string
    {
        return HtmlDecode($this->code);
    }

    public function setCode(string $value): static
    {
        $this->code = RemoveXss($value);
        return $this;
    }

    public function getDescription(): ?string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(?string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getCreatedByUserId(): ?int
    {
        return $this->createdByUserId;
    }

    public function setCreatedByUserId(?int $value): static
    {
        $this->createdByUserId = $value;
        return $this;
    }

    public function getCreatedDateTime(): ?DateTimeInterface
    {
        return $this->createdDateTime;
    }

    public function setCreatedDateTime(?DateTimeInterface $value): static
    {
        if (!$this->isInitialized('createdDateTime') || !SameDateTime($this->createdDateTime, $value)) {
            $this->createdDateTime = $value;
        }
        return $this;
    }

    public function getLastUpdatedByUserId(): ?int
    {
        return $this->lastUpdatedByUserId;
    }

    public function setLastUpdatedByUserId(?int $value): static
    {
        $this->lastUpdatedByUserId = $value;
        return $this;
    }

    public function getLastUpdatedDateTime(): ?DateTimeInterface
    {
        return $this->lastUpdatedDateTime;
    }

    public function setLastUpdatedDateTime(?DateTimeInterface $value): static
    {
        if (!$this->isInitialized('lastUpdatedDateTime') || !SameDateTime($this->lastUpdatedDateTime, $value)) {
            $this->lastUpdatedDateTime = $value;
        }
        return $this;
    }
}
