<?php

namespace PHPMaker2026\Reimbursement\Db\Entity;

use DateTime;
use DateTimeImmutable;
use DateTimeInterface;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\CustomIdGenerator;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use Symfony\Component\Clock\DatePoint;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use PHPMaker2026\Reimbursement\AdvancedUserInterface;
use PHPMaker2026\Reimbursement\AdvancedSecurity;
use PHPMaker2026\Reimbursement\UserProfile;
use PHPMaker2026\Reimbursement\UserRepository;
use PHPMaker2026\Reimbursement\CustomEntityRepository;
use PHPMaker2026\Reimbursement\DefaultSequenceGenerator;
use PHPMaker2026\Reimbursement\UuidGenerator;
use PHPMaker2026\Reimbursement\Entity as BaseEntity;
use function PHPMaker2026\Reimbursement\Config;
use function PHPMaker2026\Reimbursement\EntityManager;
use function PHPMaker2026\Reimbursement\ConvertToBool;
use function PHPMaker2026\Reimbursement\ConvertToString;
use function PHPMaker2026\Reimbursement\SameDateTime;
use function PHPMaker2026\Reimbursement\RemoveXss;
use function PHPMaker2026\Reimbursement\HtmlDecode;
use function PHPMaker2026\Reimbursement\HashPassword;
use function PHPMaker2026\Reimbursement\PhpEncrypt;
use function PHPMaker2026\Reimbursement\PhpDecrypt;
use function PHPMaker2026\Reimbursement\Security;
use function PHPMaker2026\Reimbursement\IsEmpty;
use InvalidArgumentException;

/**
 * Entity class for 'mtuserlevel' table
 */
#[Entity]
#[Table('mtuserlevel')]
class Mtuserlevel extends BaseEntity
{
    #[Id]
    #[Column(name: 'UserLevelID', type: 'integer', unique: true, insertable: false, updatable: false)]
    #[GeneratedValue]
    private int $userLevelId;

    #[Column(name: 'UserLevelName', type: 'string')]
    private string $userLevelName;

    #[Column(name: 'Hierarchy', type: 'string', nullable: true)]
    private ?string $hierarchy;

    public function getUserLevelId(): int
    {
        return $this->userLevelId;
    }

    public function setUserLevelId(int $value): static
    {
        $this->userLevelId = $value;
        return $this;
    }

    public function getUserLevelName(): string
    {
        return HtmlDecode($this->userLevelName);
    }

    public function setUserLevelName(string $value): static
    {
        $this->userLevelName = RemoveXss($value);
        return $this;
    }

    public function getHierarchy(): ?string
    {
        return HtmlDecode($this->hierarchy);
    }

    public function setHierarchy(?string $value): static
    {
        $this->hierarchy = RemoveXss($value);
        return $this;
    }
}
