<?php

namespace PHPMaker2026\Reimbursement\Db\Entity;

use DateTime;
use DateTimeImmutable;
use DateTimeInterface;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\CustomIdGenerator;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use Symfony\Component\Clock\DatePoint;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use PHPMaker2026\Reimbursement\AdvancedUserInterface;
use PHPMaker2026\Reimbursement\AdvancedSecurity;
use PHPMaker2026\Reimbursement\UserProfile;
use PHPMaker2026\Reimbursement\UserRepository;
use PHPMaker2026\Reimbursement\CustomEntityRepository;
use PHPMaker2026\Reimbursement\DefaultSequenceGenerator;
use PHPMaker2026\Reimbursement\UuidGenerator;
use PHPMaker2026\Reimbursement\Entity as BaseEntity;
use function PHPMaker2026\Reimbursement\Config;
use function PHPMaker2026\Reimbursement\EntityManager;
use function PHPMaker2026\Reimbursement\ConvertToBool;
use function PHPMaker2026\Reimbursement\ConvertToString;
use function PHPMaker2026\Reimbursement\SameDateTime;
use function PHPMaker2026\Reimbursement\RemoveXss;
use function PHPMaker2026\Reimbursement\HtmlDecode;
use function PHPMaker2026\Reimbursement\HashPassword;
use function PHPMaker2026\Reimbursement\PhpEncrypt;
use function PHPMaker2026\Reimbursement\PhpDecrypt;
use function PHPMaker2026\Reimbursement\Security;
use function PHPMaker2026\Reimbursement\IsEmpty;
use InvalidArgumentException;

/**
 * Entity class for 'mtuserlevelpermissions' table
 */
#[Entity]
#[Table('mtuserlevelpermissions')]
class Mtuserlevelpermission extends BaseEntity
{
    #[Id]
    #[Column(name: 'UserLevelID', type: 'integer', nullable: true)]
    private ?int $userLevelId;

    #[Id]
    #[Column(name: 'TableName', options: ['param' => '_TableName'], type: 'string', nullable: true)]
    private ?string $tableName;

    #[Column(name: 'Permission', options: ['param' => '_Permission'], type: 'integer')]
    private int $permission;

    public function __construct(?int $userLevelId = null, ?string $tableName = null)
    {
        $this->userLevelId = $userLevelId;
        $this->tableName = $tableName;
    }

    public function getUserLevelId(): ?int
    {
        return $this->userLevelId;
    }

    public function setUserLevelId(?int $value): static
    {
        $this->userLevelId = $value;
        return $this;
    }

    public function getTableName(): ?string
    {
        return $this->tableName;
    }

    public function setTableName(?string $value): static
    {
        $this->tableName = $value;
        return $this;
    }

    public function getPermission(): int
    {
        return $this->permission;
    }

    public function setPermission(int $value): static
    {
        $this->permission = $value;
        return $this;
    }
}
