<?php

namespace PHPMaker2026\Reimbursement\Db\Entity;

use DateTime;
use DateTimeImmutable;
use DateTimeInterface;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\CustomIdGenerator;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use Symfony\Component\Clock\DatePoint;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use PHPMaker2026\Reimbursement\AdvancedUserInterface;
use PHPMaker2026\Reimbursement\AdvancedSecurity;
use PHPMaker2026\Reimbursement\UserProfile;
use PHPMaker2026\Reimbursement\UserRepository;
use PHPMaker2026\Reimbursement\CustomEntityRepository;
use PHPMaker2026\Reimbursement\DefaultSequenceGenerator;
use PHPMaker2026\Reimbursement\UuidGenerator;
use PHPMaker2026\Reimbursement\Entity as BaseEntity;
use function PHPMaker2026\Reimbursement\Config;
use function PHPMaker2026\Reimbursement\EntityManager;
use function PHPMaker2026\Reimbursement\ConvertToBool;
use function PHPMaker2026\Reimbursement\ConvertToString;
use function PHPMaker2026\Reimbursement\SameDateTime;
use function PHPMaker2026\Reimbursement\RemoveXss;
use function PHPMaker2026\Reimbursement\HtmlDecode;
use function PHPMaker2026\Reimbursement\HashPassword;
use function PHPMaker2026\Reimbursement\PhpEncrypt;
use function PHPMaker2026\Reimbursement\PhpDecrypt;
use function PHPMaker2026\Reimbursement\Security;
use function PHPMaker2026\Reimbursement\IsEmpty;
use InvalidArgumentException;

/**
 * Entity class for 'trreimbursement' table
 */
#[Entity]
#[Table('trreimbursement')]
class Trreimbursement extends BaseEntity
{
    #[Id]
    #[Column(name: 'ID', type: 'integer', unique: true, insertable: false, updatable: false)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: 'MTReimbursementTypeID', type: 'integer')]
    private int $mtreimbursementTypeId;

    #[Column(name: 'MTUserRequesterID', type: 'integer')]
    private int $mtuserRequesterId;

    #[Column(name: 'MTUserApproverID', type: 'integer', nullable: true)]
    private ?int $mtuserApproverId;

    #[Column(name: 'RequestDateTime', type: 'datetime', nullable: true)]
    private ?DateTimeInterface $requestDateTime;

    #[Column(name: 'ApprovedDateTime', type: 'datetime', nullable: true)]
    private ?DateTimeInterface $approvedDateTime;

    #[Column(name: 'RejectedDateTime', type: 'datetime', nullable: true)]
    private ?DateTimeInterface $rejectedDateTime;

    #[Column(name: 'MTUserRejectorID', type: 'integer', nullable: true)]
    private ?int $mtuserRejectorId;

    #[Column(name: 'Title', options: ['param' => '_Title'], type: 'string')]
    private string $title;

    #[Column(name: 'Description', type: 'string', nullable: true)]
    private ?string $description;

    #[Column(name: 'Amount', type: 'decimal')]
    private string $amount;

    #[Column(name: 'Attachment', type: 'string', nullable: true)]
    private ?string $attachment;

    #[Column(name: 'Notes', type: 'string', nullable: true)]
    private ?string $notes;

    #[Column(name: 'CreatedByUserID', type: 'integer', nullable: true)]
    private ?int $createdByUserId;

    #[Column(name: 'CreatedDateTime', type: 'datetime', nullable: true)]
    private ?DateTimeInterface $createdDateTime;

    #[Column(name: 'LastUpdatedByUserID', type: 'integer', nullable: true)]
    private ?int $lastUpdatedByUserId;

    #[Column(name: 'LastUpdatedDateTime', type: 'datetime', nullable: true)]
    private ?DateTimeInterface $lastUpdatedDateTime;

    #[Column(name: 'ProjectID', options: ['param' => '_ProjectID'], type: 'integer', nullable: true)]
    private ?int $projectId;

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getMtreimbursementTypeId(): int
    {
        return $this->mtreimbursementTypeId;
    }

    public function setMtreimbursementTypeId(int $value): static
    {
        $this->mtreimbursementTypeId = $value;
        return $this;
    }

    public function getMtuserRequesterId(): int
    {
        return $this->mtuserRequesterId;
    }

    public function setMtuserRequesterId(int $value): static
    {
        $this->mtuserRequesterId = $value;
        return $this;
    }

    public function getMtuserApproverId(): ?int
    {
        return $this->mtuserApproverId;
    }

    public function setMtuserApproverId(?int $value): static
    {
        $this->mtuserApproverId = $value;
        return $this;
    }

    public function getRequestDateTime(): ?DateTimeInterface
    {
        return $this->requestDateTime;
    }

    public function setRequestDateTime(?DateTimeInterface $value): static
    {
        if (!$this->isInitialized('requestDateTime') || !SameDateTime($this->requestDateTime, $value)) {
            $this->requestDateTime = $value;
        }
        return $this;
    }

    public function getApprovedDateTime(): ?DateTimeInterface
    {
        return $this->approvedDateTime;
    }

    public function setApprovedDateTime(?DateTimeInterface $value): static
    {
        if (!$this->isInitialized('approvedDateTime') || !SameDateTime($this->approvedDateTime, $value)) {
            $this->approvedDateTime = $value;
        }
        return $this;
    }

    public function getRejectedDateTime(): ?DateTimeInterface
    {
        return $this->rejectedDateTime;
    }

    public function setRejectedDateTime(?DateTimeInterface $value): static
    {
        if (!$this->isInitialized('rejectedDateTime') || !SameDateTime($this->rejectedDateTime, $value)) {
            $this->rejectedDateTime = $value;
        }
        return $this;
    }

    public function getMtuserRejectorId(): ?int
    {
        return $this->mtuserRejectorId;
    }

    public function setMtuserRejectorId(?int $value): static
    {
        $this->mtuserRejectorId = $value;
        return $this;
    }

    public function getTitle(): string
    {
        return HtmlDecode($this->title);
    }

    public function setTitle(string $value): static
    {
        $this->title = RemoveXss($value);
        return $this;
    }

    public function getDescription(): ?string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(?string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getAmount(): string
    {
        return $this->amount;
    }

    public function setAmount(string $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getAttachment(): ?string
    {
        return HtmlDecode($this->attachment);
    }

    public function setAttachment(?string $value): static
    {
        $this->attachment = RemoveXss($value);
        return $this;
    }

    public function getNotes(): ?string
    {
        return HtmlDecode($this->notes);
    }

    public function setNotes(?string $value): static
    {
        $this->notes = RemoveXss($value);
        return $this;
    }

    public function getCreatedByUserId(): ?int
    {
        return $this->createdByUserId;
    }

    public function setCreatedByUserId(?int $value): static
    {
        $this->createdByUserId = $value;
        return $this;
    }

    public function getCreatedDateTime(): ?DateTimeInterface
    {
        return $this->createdDateTime;
    }

    public function setCreatedDateTime(?DateTimeInterface $value): static
    {
        if (!$this->isInitialized('createdDateTime') || !SameDateTime($this->createdDateTime, $value)) {
            $this->createdDateTime = $value;
        }
        return $this;
    }

    public function getLastUpdatedByUserId(): ?int
    {
        return $this->lastUpdatedByUserId;
    }

    public function setLastUpdatedByUserId(?int $value): static
    {
        $this->lastUpdatedByUserId = $value;
        return $this;
    }

    public function getLastUpdatedDateTime(): ?DateTimeInterface
    {
        return $this->lastUpdatedDateTime;
    }

    public function setLastUpdatedDateTime(?DateTimeInterface $value): static
    {
        if (!$this->isInitialized('lastUpdatedDateTime') || !SameDateTime($this->lastUpdatedDateTime, $value)) {
            $this->lastUpdatedDateTime = $value;
        }
        return $this;
    }

    public function getProjectId(): ?int
    {
        return $this->projectId;
    }

    public function setProjectId(?int $value): static
    {
        $this->projectId = $value;
        return $this;
    }
}
