<?php

namespace PHPMaker2026\Reimbursement;

use Symfony\Bundle\FrameworkBundle\Kernel\MicroKernelTrait;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\HttpKernel\Kernel as BaseKernel;

/**
 * Kernel
 */
class Kernel extends BaseKernel
{
    use MicroKernelTrait;
    private ?HttpContext $httpContext = null;

    /**
     * Check if the kernel is booted.
     */
    public function isBooted(): bool
    {
        return $this->booted;
    }

    /**
     * Get the HttpContext instance.
     */
    public function getHttpContext(): HttpContext
    {
        return $this->httpContext ??= new HttpContext();
    }

    /**
     * Set the HttpContext instance manually.
     */
    public function setHttpContext(HttpContext $httpContext): void
    {
        $this->httpContext = $httpContext;
    }

    /**
     * Boot the kernel and flush early listeners.
     */
    public function boot(): void
    {
        parent::boot();
        $context = $this->getHttpContext();
        $context->setKernel($this);
        $context->flushEventListeners();
    }

    /**
     * Build
     *
     * @param ContainerBuilder $container
     * @return void
     */
    protected function build(ContainerBuilder $container): void
    {
        parent::build($container);
        $container->addCompilerPass(new RegisterModelLocatorPass());
        $container->addCompilerPass(new AliasToClassPass());
    }
}
