<?php declare(strict_types=1);

namespace Pagerfanta\Tests\Adapter;

use Pagerfanta\Adapter\CallbackAdapter;
use Pagerfanta\Exception\NotValidResultCountException;
use PHPUnit\Framework\TestCase;

final class CallbackAdapterTest extends TestCase
{
    public function testAdapterReturnsNumberOfItemsInResultSet(): void
    {
        $expected = 42;

        $adapter = new CallbackAdapter(
            static fn () => $expected,
            static fn (int $offset, int $length) => []
        );

        $this->assertSame($expected, $adapter->getNbResults());
    }

    public function testAdapterRaisesAnErrorIfTheNumberOfResultsCallableReturnsANegativeNumber(): void
    {
        $this->expectException(NotValidResultCountException::class);

        $adapter = new CallbackAdapter(
            static fn () => -10, /** @phpstan-ignore-line argument.type */
            static fn (int $offset, int $length) => []
        );

        $adapter->getNbResults();
    }

    public function testGetSliceShouldReturnTheResultFromTheCallback(): void
    {
        $expected = new \ArrayObject();

        $adapter = new CallbackAdapter(
            static fn () => 0,
            static fn (int $offset, int $length) => $expected
        );

        $this->assertSame($expected, $adapter->getSlice(1, 1));
    }

    public function testGetSliceShouldPassTheOffsetAndLengthToTheGetSliceCallback(): void
    {
        $sliceCallable = function (int $offset, int $length): iterable {
            TestCase::assertSame(10, $offset);
            TestCase::assertSame(18, $length);

            return [];
        };

        $adapter = new CallbackAdapter(
            static fn () => 10,
            $sliceCallable
        );

        $adapter->getSlice(10, 18);
    }
}
