<?php

namespace PHPMaker2026\Reimbursement;
?>
<?= $Page->getHtmlMessage() ?>
<?php
    $reqAction = $_GET['action'] ?? '';
    $reqId     = $_GET['id'] ?? 0;
    $reqNotes  = $_GET['reason'] ?? '';

    $approverId = CurrentUserID();
    if (empty($approverId)) $approverId = 0;

    if ($reqId > 0) {
        if ($reqAction == 'approve') {
            $sqlUpd = "UPDATE trreimbursement SET 
                    ApprovedDateTime = NOW(), 
                    MTUserApproverID = " . AdjustSql($approverId) . ",
                    Notes = '" . AdjustSql($reqNotes) . "'
                    WHERE ID = " . AdjustSql($reqId);
            
            ExecuteStatement($sqlUpd);
            header("Location: DashboardAdmin?status=Pending");
            exit();
        }
        
        if ($reqAction == 'reject') {
            $sqlUpd = "UPDATE trreimbursement SET 
                    RejectedDateTime = NOW(), 
                    MTUserRejectorID = " . AdjustSql($approverId) . ",
                    Notes = '" . AdjustSql($reqNotes) . "' 
                    WHERE ID = " . AdjustSql($reqId);
                    
            ExecuteStatement($sqlUpd);
            header("Location: DashboardAdmin?status=Pending");
            exit();
        }
    }

    $filterStatus = isset($_GET['status']) ? $_GET['status'] : 'Pending';

    $sqlStats = "SELECT 
        SUM(CASE WHEN ApprovedDateTime IS NULL AND RejectedDateTime IS NULL THEN 1 ELSE 0 END) as cnt_pending,
        SUM(CASE WHEN ApprovedDateTime IS NOT NULL THEN 1 ELSE 0 END) as cnt_approved,
        SUM(CASE WHEN RejectedDateTime IS NOT NULL THEN 1 ELSE 0 END) as cnt_rejected,
        SUM(CASE WHEN ApprovedDateTime IS NOT NULL THEN Amount ELSE 0 END) as total_cair
    FROM trreimbursement";
    
    $resStats = ExecuteRows($sqlStats);
    $rowStats = (is_array($resStats) && count($resStats) > 0) ? $resStats[0] : [];
    
    $stats = [
        'pending'  => $rowStats['cnt_pending'] ?? 0,
        'approved' => $rowStats['cnt_approved'] ?? 0,
        'rejected' => $rowStats['cnt_rejected'] ?? 0,
        'total_approved_rp' => number_format((float)($rowStats['total_cair'] ?? 0), 0, ',', '.')
    ];
    $stats['all'] = $stats['pending'] + $stats['approved'] + $stats['rejected'];

    // B. LIST DATA
    $sqlList = "SELECT * FROM trreimbursement WHERE 1=1 ";

    $judulList = "Semua Data";
    
    if ($filterStatus == 'Pending') {
        $sqlList .= " AND ApprovedDateTime IS NULL AND RejectedDateTime IS NULL";
        $judulList = "Pengajuan Menunggu Review";
        
    } elseif ($filterStatus == 'Approved') {
        $sqlList .= " AND ApprovedDateTime IS NOT NULL";
        $judulList = "Pengajuan Disetujui";
        
    } elseif ($filterStatus == 'Rejected') {
        $sqlList .= " AND RejectedDateTime IS NOT NULL";
        $judulList = "Pengajuan Ditolak";
    }

    $sqlList .= " ORDER BY RequestDateTime DESC";
    $rows = ExecuteRows($sqlList);

    if (!function_exists('fmtTgl')) {

        function fmtTgl($d) { return empty($d) ? "-" : date('d M Y', strtotime($d)); }
    }
?>

<style>
    .content-header, .breadcrumb, .content-header .container-fluid { display: none !important; }
    .content-wrapper, .content { background-color: #f4f6f9 !important; }
    .admin-wrapper { max-width: 70%; margin: 0 auto; padding: 30px 20px; font-family: 'Inter', 'Segoe UI', sans-serif; min-height: 100vh; }

    .page-header-custom { display: flex; align-items: center; gap: 15px; margin-bottom: 30px; }
    .header-icon-box { width: 48px; height: 48px; background-color: #2563eb; color: white; border-radius: 12px; display: flex; align-items: center; justify-content: center; font-size: 20px; box-shadow: 0 4px 6px -1px rgba(37, 99, 235, 0.2); }
    .header-text h1 { font-size: 24px; font-weight: 800; margin: 0; color: #111827; letter-spacing: -0.5px; }
    .header-text p { margin: 4px 0 0 0; color: #6b7280; font-size: 14px; }

    .stats-grid { display: grid; gap: 20px; margin-bottom: 30px; grid-template-columns: repeat(4, 1fr); }
    @media (max-width: 992px) { .stats-grid { grid-template-columns: repeat(2, 1fr); } }
    @media (max-width: 576px) { .stats-grid { grid-template-columns: repeat(1, 1fr); } }
    
    .stat-card { background: white; padding: 24px; border-radius: 12px; border: 1px solid #e5e7eb; display: flex; justify-content: space-between; align-items: flex-start; box-shadow: 0 1px 2px rgba(0,0,0,0.05); }
    .stat-label { font-size: 13px; font-weight: 600; color: #6b7280; margin-bottom: 8px; }
    .stat-value { font-size: 24px; font-weight: 800; color: #111827; }
    .icon-circle { width: 40px; height: 40px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 16px; }
    .ic-yellow { background: #fef9c3; color: #ca8a04; } .ic-green { background: #dcfce7; color: #16a34a; } .ic-red { background: #fee2e2; color: #dc2626; } .ic-blue { background: #dbeafe; color: #2563eb; }

    .tabs-container { display: flex; gap: 10px; margin-bottom: 25px; overflow-x: auto; }
    .tab-pill { padding: 8px 16px; border-radius: 99px; font-size: 14px; font-weight: 600; cursor: pointer; display: flex; align-items: center; gap: 6px; border: 1px solid transparent; transition: all 0.2s; text-decoration: none !important; }
    .tab-active { background: white; border-color: #e5e7eb; color: #111827; box-shadow: 0 1px 2px rgba(0,0,0,0.05); }
    .tab-inactive { background: transparent; color: #6b7280; }
    .tab-inactive:hover { background: rgba(0,0,0,0.03); color: #374151; }

    .main-list-card { background: white; border: 1px solid #e5e7eb; border-radius: 16px; padding: 0; box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.02); }
    .list-header { padding: 24px; border-bottom: 1px solid #f3f4f6; }
    .list-header h3 { font-size: 18px; font-weight: 700; margin: 0 0 5px 0; }
    .list-header p { font-size: 14px; color: #6b7280; margin: 0; }

    .list-item { padding: 24px; border-bottom: 1px solid #f3f4f6; display: flex; justify-content: space-between; align-items: flex-start; gap: 20px; }
    .list-item:last-child { border-bottom: none; }
    .item-content { flex: 1; }
    .item-top-row { display: flex; align-items: center; gap: 10px; margin-bottom: 8px; flex-wrap: wrap; }
    .item-title { font-size: 16px; font-weight: 700; color: #111827; }

    .badge-status { padding: 4px 10px; border-radius: 6px; font-size: 12px; font-weight: 600; display: flex; align-items: center; gap: 5px; }
    .bs-pending { background: #fef9c3; color: #a16207; border: 1px solid #fde047; }
    .bs-approved { background: #dcfce7; color: #16a34a; border: 1px solid #bbf7d0; }
    .bs-rejected { background: #fee2e2; color: #dc2626; border: 1px solid #fecaca; }
    .badge-cat { background: #f3f4f6; color: #4b5563; padding: 4px 8px; border-radius: 6px; font-size: 12px; font-weight: 500; }

    .item-desc { font-size: 14px; color: #4b5563; margin-bottom: 12px; line-height: 1.5; }
    .item-meta { font-size: 13px; display: flex; align-items: center; gap: 8px; color: #6b7280; flex-wrap: wrap; }
    .meta-amount { font-weight: 700; color: #111827; font-size: 14px; }
    .meta-sep { width: 3px; height: 3px; background: #d1d5db; border-radius: 50%; }

    .item-actions { display: flex; gap: 10px; }
    .btn-action { padding: 8px 16px; border-radius: 6px; font-size: 13px; font-weight: 600; cursor: pointer; display: flex; align-items: center; gap: 6px; background: white; transition: all 0.2s; text-decoration: none; }
    .btn-approve { border: 1px solid #22c55e; color: #16a34a; }
    .btn-approve:hover { background: #f0fdf4; }
    .btn-reject { border: 1px solid #ef4444; color: #dc2626; }
    .btn-reject:hover { background: #fef2f2; }
    
    .modal-overlay { position: fixed; font-family: 'Inter', 'Segoe UI', sans-serif; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5); z-index: 9999; display: flex; justify-content: center; align-items: center; backdrop-filter: blur(2px); animation: fadeIn 0.2s; }
    .modal-box { background: #fff; width: 100%; max-width: 500px; padding: 25px; border-radius: 12px; box-shadow: 0 10px 25px rgba(0,0,0,0.2); animation: slideUp 0.2s; }
    .modal-info-card { background: #f8f9fa; border-radius: 8px; padding: 15px; margin-bottom: 20px; border: 1px solid #e9ecef; }
    .btn-modal-cancel { background: #fff; border: 1px solid #ddd; padding: 10px 20px; border-radius: 6px; font-weight: 600; cursor: pointer; color: #333; }
    .btn-modal-confirm { padding: 10px 20px; border-radius: 6px; font-weight: 600; cursor: pointer; color: #fff; border: none; display: flex; align-items: center; gap: 8px; }
    .btn-confirm-green { background-color: #10b981; } .btn-confirm-green:hover { background-color: #059669; }
    .btn-confirm-red { background-color: #ef4444; } .btn-confirm-red:hover { background-color: #dc2626; }
    @keyframes fadeIn { from { opacity: 0; } to { opacity: 1; } }
    @keyframes slideUp { from { transform: translateY(20px); opacity: 0; } to { transform: translateY(0); opacity: 1; } }

    .header-actions {
        margin-left: auto; /* Dorong ke kanan mentok */
        display: flex;
        gap: 10px;
    }

    .btn-header {
        background: white;
        border: 1px solid #e5e7eb;
        color: #4b5563;
        padding: 10px 16px;
        border-radius: 10px;
        font-size: 14px;
        font-weight: 600;
        text-decoration: none;
        display: flex;
        align-items: center;
        gap: 8px;
        transition: all 0.2s;
        box-shadow: 0 1px 2px rgba(0,0,0,0.05);
    }

    .btn-header:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.08);
        color: #2563eb; /* Biru saat hover */
        border-color: #bfdbfe;
    }

    .btn-header i { font-size: 16px; }
    
    /* Responsif: Di HP tombol turun ke bawah */
    @media (max-width: 768px) {
        .page-header-custom { flex-wrap: wrap; }
        .header-actions { margin-left: 0; margin-top: 15px; width: 100%; }
        .btn-header { flex: 1; justify-content: center; }
    }
</style>

<div class="admin-wrapper">
    <div class="page-header-custom">
        <a href="DashboardPanel" style="background:#fff; width:40px; height:40px; border-radius:10px; display:flex; align-items:center; justify-content:center; color:#2563eb; box-shadow:0 2px 5px rgba(0,0,0,0.05); text-decoration:none; margin-right:5px; transition:transform 0.2s;">
            <i class="fas fa-arrow-left"></i>
        </a>
        
        <div class="header-icon-box"><i class="fas fa-shield-alt"></i></div>
        <div class="header-text">
            <h1>Admin Dashboard</h1>
            <p>Kelola semua pengajuan reimbursement</p>
        </div>

        <div class="header-actions">
            <a href="ReportReimburse" class="btn-header" style="color: #2563eb; border-color: #bfdbfe; background: #eff6ff;">
                <i class="fas fa-chart-pie"></i> 
                <span>Laporan Bulanan</span>
            </a>
        </div>
    </div>

    <div class="stats-grid">
        <div class="stat-card"><div><div class="stat-label">Menunggu Review</div><div class="stat-value"><?php echo $stats['pending']; ?></div></div><div class="icon-circle ic-yellow"><i class="far fa-clock"></i></div></div>
        <div class="stat-card"><div><div class="stat-label">Disetujui</div><div class="stat-value"><?php echo $stats['approved']; ?></div></div><div class="icon-circle ic-green"><i class="fas fa-check"></i></div></div>
        <div class="stat-card"><div><div class="stat-label">Ditolak</div><div class="stat-value"><?php echo $stats['rejected']; ?></div></div><div class="icon-circle ic-red"><i class="fas fa-times"></i></div></div>
        <div class="stat-card"><div><div class="stat-label">Total Cair</div><div class="stat-value" style="font-size: 20px;">Rp <?php echo $stats['total_approved_rp']; ?></div></div><div class="icon-circle ic-blue"><i class="fas fa-chart-line"></i></div></div>
    </div>

    <div class="tabs-container">
        <a href="?status=Pending" class="tab-pill <?php echo ($filterStatus=='Pending') ? 'tab-active' : 'tab-inactive'; ?>"><i class="far fa-clock"></i> Menunggu</a>
        <a href="?status=Approved" class="tab-pill <?php echo ($filterStatus=='Approved') ? 'tab-active' : 'tab-inactive'; ?>"><i class="fas fa-check-circle"></i> Disetujui</a>
        <a href="?status=Rejected" class="tab-pill <?php echo ($filterStatus=='Rejected') ? 'tab-active' : 'tab-inactive'; ?>"><i class="fas fa-times-circle"></i> Ditolak</a>
        <a href="?status=All" class="tab-pill <?php echo ($filterStatus=='All') ? 'tab-active' : 'tab-inactive'; ?>">Semua</a>
    </div>

    <div class="main-list-card">
        <div class="list-header">
            <h3><?php echo $judulList; ?></h3>
            <p>Daftar pengajuan berdasarkan filter yang dipilih</p>
        </div>

        <?php if (count($rows) > 0): ?>
            <?php foreach($rows as $row): ?>
                <?php 
                    $stClass = 'bs-pending'; $stIcon = '<i class="far fa-clock"></i>'; $stText = 'Pending';
                    
                    if (!empty($row['RejectedDateTime'])) {
                        $stClass = 'bs-rejected'; $stIcon = '<i class="fas fa-times-circle"></i>'; $stText = 'Ditolak';
                    } elseif (!empty($row['ApprovedDateTime'])) {
                        $stClass = 'bs-approved'; $stIcon = '<i class="fas fa-check-circle"></i>'; $stText = 'Disetujui';
                    }

                    $namaUser = "User ID: " . $row['MTUserRequesterID'];
                    $emailUser = "-";
                    if (!empty($row['MTUserRequesterID'])) {
                        $uName = ExecuteScalar("SELECT FullName FROM mtuser WHERE ID = " . $row['MTUserRequesterID']);
                        if ($uName) $namaUser = $uName;
                        $uEmail = ExecuteScalar("SELECT Email FROM mtuser WHERE ID = " . $row['MTUserRequesterID']);
                        if ($uEmail) $emailUser = $uEmail;
                    }

                    $project = "-";
                    if (!empty($row['ProjectID'])) {
                        $uProject = ExecuteScalar("SELECT ProjectName FROM mtproject WHERE ProjectID = " . $row['ProjectID']);
                        if ($uProject) $project = $uProject;
                    }

                    $kodeKategori = "General";
                    if (!empty($row['MTReimbursementTypeID'])) {
                        $kCode = ExecuteScalar("SELECT Code FROM mtreimbursementtype WHERE ID = " . $row['MTReimbursementTypeID']);
                        if ($kCode) $kodeKategori = $kCode;
                    }

                    $linkBukti = "#";
                    $hasBukti = false;
                    if (!empty($row['Attachment'])) {
                        $linkBukti = "files/" . $row['Attachment'];
                        if (function_exists('BaseUrl')) $linkBukti = AppUrl() . "files/" . $row['Attachment'];
                        $hasBukti = true;
                    }
                ?>

                <div class="list-item">
                    <div class="item-content">
                        <div class="item-top-row">
                            <span class="item-title"><?php echo $row['Title']; ?></span>
                            <span class="badge-status <?php echo $stClass; ?>">
                                <?php echo $stIcon . ' ' . $stText; ?>
                            </span>
                            <span class="badge-cat"><?php echo $kodeKategori; ?></span>
                        </div>

                        <div class="item-desc">
                            <?php echo $row['Description']; ?>
                        </div>

                        <div class="item-meta">
                            <span class="meta-amount">Rp <?php echo number_format($row['Amount'], 0, ',', '.'); ?></span>
                            <span class="meta-sep"></span>
                            <span style="font-weight: 600; color: #374151;">
                                <i class="far fa-user me-1"></i> <?php echo $namaUser; ?>
                            </span>
                            <span class="meta-sep"></span>
                            <span style="color: #6b7280;"><?php echo $emailUser; ?></span>
                            <span class="meta-sep"></span>
                            <span style="color: #6b7280;"><?php echo $project; ?></span>
                            <span class="meta-sep"></span>
                            <span><?php echo fmtTgl($row['RequestDateTime']); ?></span>
                        </div>

                        <?php if ($hasBukti): ?>
                            <a href="<?php echo $linkBukti; ?>" target="_blank" style="display: inline-flex; align-items: center; gap: 5px; text-decoration: none; margin-top: 8px; margin-bottom: 8px; color: #2563eb; font-size: 13px; font-weight: 600; transition: color 0.2s;" onmouseover="this.style.color='#1d4ed8'" onmouseout="this.style.color='#2563eb'">
                                Lihat Bukti 
                                <i class="fas fa-external-link-alt" style="font-size: 11px;"></i>
                            </a>
                        <?php endif; ?>

                        <?php if(!empty($row['Notes'])): ?>
                            <div style="margin-top:8px; font-size:12px; color:#666; background:#f9fafb; padding:8px; border-radius:6px; border:1px solid #eee;">
                                <strong>Catatan:</strong> <?php echo $row['Notes']; ?>
                            </div>
                        <?php endif; ?>
                    </div>

                    <?php if (empty($row['ApprovedDateTime']) && empty($row['RejectedDateTime'])): ?>
                    <div class="item-actions">
                        <button type="button" class="btn-action btn-approve"
                            data-id="<?php echo $row['ID']; ?>"
                            data-title="<?php echo htmlspecialchars($row['Title']); ?>"
                            data-desc="<?php echo htmlspecialchars($row['Description']); ?>"
                            data-amount="<?php echo number_format($row['Amount'], 0, ',', '.'); ?>"
                            data-user="<?php echo htmlspecialchars($namaUser); ?>"
                            data-email="<?php echo htmlspecialchars($emailUser); ?>"
                            onclick="openModal(this, 'approve')">
                            <i class="fas fa-check-circle"></i> Setujui
                        </button>

                        <button type="button" class="btn-action btn-reject"
                            data-id="<?php echo $row['ID']; ?>"
                            data-title="<?php echo htmlspecialchars($row['Title']); ?>"
                            data-desc="<?php echo htmlspecialchars($row['Description']); ?>"
                            data-amount="<?php echo number_format($row['Amount'], 0, ',', '.'); ?>"
                            data-user="<?php echo htmlspecialchars($namaUser); ?>"
                            data-email="<?php echo htmlspecialchars($emailUser); ?>"
                            onclick="openModal(this, 'reject')">
                            <i class="fas fa-times-circle"></i> Tolak
                        </button>
                    </div>
                    <?php endif; ?>

                </div>
            <?php endforeach; ?>
        <?php else: ?>
            <div style="padding: 50px; text-align: center; color: #9ca3af;">
                <i class="far fa-folder-open" style="font-size: 32px; margin-bottom: 10px;"></i>
                <p>Tidak ada data pengajuan.</p>
            </div>
        <?php endif; ?>

    </div>
</div>

<div id="reviewModal" class="modal-overlay" style="display: none;">
    <div class="modal-box">
        <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:15px;">
            <h3 style="margin:0; font-size:18px; font-weight:700;">Review Reimbursement</h3>
            <span onclick="closeModal()" style="cursor:pointer; font-size:20px; color:#999;">&times;</span>
        </div>
        <p style="color:#666; font-size:14px; margin-top:-10px; margin-bottom:20px;">Review dan tambahkan catatan untuk pengajuan ini</p>

        <div class="modal-info-card">
            <div id="mdlTitle" style="font-weight:700; font-size:16px; color:#111; margin-bottom:5px;">-</div>
            <div id="mdlDesc" style="font-size:13px; color:#555; margin-bottom:10px; line-height:1.4;">-</div>
            <div style="font-weight:800; font-size:18px; color:#111; margin-bottom:5px;">Rp <span id="mdlAmount">0</span></div>
            <div id="mdlUser"></div>
        </div>

        <div style="margin-bottom:20px;">
            <label style="font-weight:600; font-size:13px; color:#333; display:block; margin-bottom:8px;">Catatan Admin (opsional)</label>
            <textarea id="mdlNotes" class="form-control" rows="3" placeholder="Tambahkan catatan untuk pegawai..."></textarea>
        </div>

        <div style="display:flex; justify-content:flex-end; gap:10px;">
            <button onclick="closeModal()" class="btn-modal-cancel">Batal</button>
            <button id="btnConfirmAction" class="btn-modal-confirm"></button>
        </div>
    </div>
</div>

<script>
    let currentId = 0;
    let currentAction = '';

    function openModal(btn, action) {
        currentId = btn.getAttribute('data-id');
        currentAction = action;
        
        let title = btn.getAttribute('data-title');
        let desc = btn.getAttribute('data-desc');
        let amount = btn.getAttribute('data-amount');
        let user = btn.getAttribute('data-user');
        let email = btn.getAttribute('data-email');

        document.getElementById('mdlTitle').innerText = title;
        document.getElementById('mdlDesc').innerText = desc;
        document.getElementById('mdlAmount').innerText = amount;
        
        document.getElementById('mdlUser').innerHTML = `
            <span style="font-size:14px; font-weight:600; color:#1f2937;">${user}</span>
            <span style="margin: 0 6px; color: #d1d5db;">&bull;</span>
            <span style="font-size:13px; color:#6b7280;">${email}</span>
        `;
        
        document.getElementById('mdlNotes').value = '';

        let btnConfirm = document.getElementById('btnConfirmAction');
        btnConfirm.classList.remove('btn-confirm-green', 'btn-confirm-red');

        if (action === 'approve') {
            btnConfirm.innerHTML = '<i class="fas fa-check-circle"></i> Setujui';
            btnConfirm.classList.add('btn-confirm-green');
        } else {
            btnConfirm.innerHTML = '<i class="fas fa-times-circle"></i> Tolak';
            btnConfirm.classList.add('btn-confirm-red');
        }

        document.getElementById('reviewModal').style.display = 'flex';
    }

    function closeModal() {
        document.getElementById('reviewModal').style.display = 'none';
    }

    document.getElementById('btnConfirmAction').onclick = function() {
        let notes = document.getElementById('mdlNotes').value;
        
        if (currentAction === 'reject' && notes.trim() === '') {
            alert('Harap isi alasan penolakan pada kolom catatan.');
            return;
        }

        let url = 'DashboardAdmin?status=Pending&action=' + currentAction + '&id=' + currentId + '&reason=' + encodeURIComponent(notes);
        window.location.href = url;
    };
</script>
