<?php

namespace PHPMaker2026\Reimbursement;
?>
<?= $Page->getHtmlMessage() ?>
<?php
    $userId = CurrentUserID();
    if (empty($userId)) $userId = 0;
    $isAdmin = ($userId == -1 || $userId == 2);

    $sqlUser = "SELECT FullName FROM mtuser WHERE ID = " . AdjustSql($userId) . "";
    $welcomeName = ExecuteScalar($sqlUser);

    if (empty($welcomeName)) $welcomeName = CurrentUserName();

    $sql = "SELECT * FROM trreimbursement WHERE MTUserRequesterID = " . AdjustSql($userId) . " ORDER BY RequestDateTime DESC";
    $rows = ExecuteRows($sql);

    if (!function_exists('formatUang')) {



        function formatUang($n) { return "Rp " . number_format((float)$n, 0, ',', '.'); }
    }

    if (!function_exists('formatTgl')) {



        function formatTgl($d) {
            if (empty($d)) return "-";
            $bulan = [1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'];
            $ts = strtotime($d);
            return date('d', $ts) . ' ' . $bulan[(int)date('m', $ts)] . ' ' . date('Y', $ts);
        }
    }
?>

<style>
    .content-header, .breadcrumb, .content-header .container-fluid {
        display: none !important;
        height: 0 !important; margin: 0 !important; padding: 0 !important;
    }
    
    .content-wrapper, .content {
        background-color: #f4f6f9 !important;
    }

    .db-container {
        max-width: 70%;
        margin: 0 auto;
        padding: 30px 20px;
        font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
    }

    .db-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 15px;
    }
    .db-title {
        font-size: 28px;
        font-weight: 800;
        color: #111827;
        margin: 0;
        line-height: 1.2;
    }
    .db-subtitle {
        color: #6b7280;
        font-size: 15px;
        margin-top: 5px;
    }

    .btn-ajukan {
        background-color: #111;
        color: #fff;
        padding: 12px 24px;
        border-radius: 8px;
        font-weight: 600;
        font-size: 14px;
        text-decoration: none;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        transition: background 0.2s;
    }
    .btn-ajukan:hover {
        background-color: #333;
        color: #fff;
    }

    .section-box {
        background: #fff;
        border: 1px solid #d1d5db;
        border-radius: 10px;
        padding: 20px;
    }

    .section-title {
        font-size: 18px;
        font-weight: 700;
        color: #111;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .section-text{
        margin-bottom: 15px;
        color: #9ca3af;
    }

    .card-item {
        background: #fff;
        border: 1px solid #e5e7eb;
        border-radius: 12px;
        padding: 25px;
        margin-bottom: 20px;
        box-shadow: 0 1px 2px rgba(0,0,0,0.05);
        transition: transform 0.1s;
    }
    .card-item:hover {
        border-color: #d1d5db;
    }

    .item-head {
        display: flex;
        align-items: center;
        flex-wrap: wrap;
        gap: 12px;
        margin-bottom: 8px;
    }
    .item-title {
        font-size: 16px;
        font-weight: 700;
        color: #111;
    }

    .badge-status {
        padding: 4px 12px;
        border-radius: 50px;
        font-size: 12px;
        font-weight: 600;
        display: inline-flex;
        align-items: center;
        gap: 5px;
    }
    .st-approved { background-color: #ecfdf5; color: #047857; border: 1px solid #d1fae5; }
    .st-pending  { background-color: #fffbeb; color: #b45309; border: 1px solid #fde68a; }
    .st-rejected { background-color: #fef2f2; color: #b91c1c; border: 1px solid #fecaca; }

    .item-desc {
        color: #4b5563;
        font-size: 14px;
        line-height: 1.5;
        margin-bottom: 12px;
    }
    .item-meta {
        font-size: 14px;
        display: flex;
        align-items: center;
        gap: 10px;
        color: #6b7280;
    }
    .text-money {
        font-weight: 700;
        color: #111;
        font-size: 15px;
    }

    .note-box {
        background-color: #f9fafb;
        border: 1px solid #f3f4f6;
        border-radius: 8px;
        padding: 15px;
        margin-top: 15px;
        font-size: 13px;
        color: #4b5563;
    }
    
    .btn-bukti {
        background: #fff;
        border: 1px solid #d1d5db;
        color: #374151;
        font-size: 13px;
        font-weight: 500;
        padding: 8px 16px;
        border-radius: 6px;
        text-decoration: none;
        display: inline-block;
    }
    .btn-bukti:hover {
        background-color: #f3f4f6;
        color: #111;
    }
</style>

<div class="db-container">
    
    <div class="db-header">
        <div>
            <h1 class="db-title">Dashboard</h1>
            <p class="db-subtitle">Selamat datang, <strong><?php echo $welcomeName; ?></strong></p>
        </div>
        <a href="TrreimbursementAdd" class="btn-ajukan">
            <i class="fas fa-plus"></i> Ajukan Reimbursement
        </a>
    </div>

    <?php if ($isAdmin): ?>
    <div style="background-color: #e0f2fe; border: 1px solid #bae6fd; color: #0284c7; padding: 20px; border-radius: 12px; margin-bottom: 25px; display: flex; align-items: center; gap: 15px; flex-wrap: wrap;">
        
        <div style="background: #0ea5e9; color: #fff; width: 40px; height: 40px; border-radius: 50%; display: flex; align-items: center; justify-content: center; flex-shrink: 0; font-size: 18px;">
            <i class="fas fa-user-shield"></i>
        </div>
        
        <div style="margin-right: auto;">
            <div style="font-weight: 700; font-size: 16px; color: #0c4a6e;">Panel Admin</div>
            <div style="font-size: 14px; opacity: 0.9;">
                Anda memiliki akses admin.
            </div>
        </div>

        <div style="display: flex; gap: 8px; flex-wrap: wrap;">
            
            <a href="MtreimbursementtypeList" style="background-color: #fff; color: #0284c7; border: 1px solid #bae6fd; padding: 8px 14px; border-radius: 6px; font-weight: 600; font-size: 13px; text-decoration: none; white-space: nowrap; display: inline-flex; align-items: center; gap: 5px;">
                <i class="fas fa-tags"></i> Tipe
            </a>

            <a href="MtuserList" style="background-color: #fff; color: #0284c7; border: 1px solid #bae6fd; padding: 8px 14px; border-radius: 6px; font-weight: 600; font-size: 13px; text-decoration: none; white-space: nowrap; display: inline-flex; align-items: center; gap: 5px;">
                <i class="fas fa-users"></i> User
            </a>

            <a href="MtprojectList" style="background-color: #fff; color: #0284c7; border: 1px solid #bae6fd; padding: 8px 14px; border-radius: 6px; font-weight: 600; font-size: 13px; text-decoration: none; white-space: nowrap; display: inline-flex; align-items: center; gap: 5px;">
                <i class="fas fa-project-diagram"></i> Project
            </a>

            <a href="DashboardAdmin" style="background-color: #0284c7; color: #fff; border: 1px solid #0284c7; padding: 8px 16px; border-radius: 6px; font-weight: 600; font-size: 13px; text-decoration: none; white-space: nowrap; display: inline-flex; align-items: center; gap: 5px; box-shadow: 0 2px 4px rgba(2, 132, 199, 0.2);">
                <i class="fas fa-tachometer-alt"></i> Dashboard
            </a>

        </div>

    </div>
    <?php endif; ?>

    <div class="section-box">
        <div class="section-title">
            <i class="far fa-file-alt"></i> Riwayat Pengajuan Saya
        </div>
        <p class="section-text">
            Daftar semua pengajuan reimbursement Anda
        </p>
        
        <?php if (is_array($rows) && count($rows) > 0): ?>
            <?php foreach ($rows as $row): ?>
                <?php 
                    $status = 'Pending';
                    $stClass = 'st-pending';
                    $stIcon = '<i class="far fa-clock"></i>';
                    $stText = 'Menunggu';
                    $adminNote = '';

                    if (!empty($row['RejectedDateTime'])) {
                        $status = 'Rejected';
                        $stClass = 'st-rejected';
                        $stIcon = '<i class="fas fa-times-circle"></i>';
                        $stText = 'Ditolak';
                        if (!empty($row['Notes'])) {
                            $adminNote = $row['Notes'];
                        }
                    } 
                    elseif (!empty($row['ApprovedDateTime'])) {
                        $status = 'Approved';
                        $stClass = 'st-approved';
                        $stIcon = '<i class="fas fa-check-circle"></i>';
                        $stText = 'Disetujui';

                        if (!empty($row['Notes'])) {
                            $adminNote =  $row['Notes'];
                        }
                    }

                    $project = "-";
                    if (!empty($row['ProjectID'])) {
                        $uProject = ExecuteScalar("SELECT ProjectName FROM mtproject WHERE ProjectID = " . $row['ProjectID']);
                        if ($uProject) $project = $uProject;
                    }

                    // --- 2. LOGIKA BUKTI ---
                    $linkBukti = "#";
                    $hasBukti = false;
                    if (!empty($row['Attachment'])) {
                        // Pastikan path sesuai (AppUrl() atau BaseUrl())
                        $linkBukti = "files/" . $row['Attachment']; 
                        if (function_exists('AppUrl')) {
                             $linkBukti = AppUrl() . "files/" . $row['Attachment'];
                        }
                        $hasBukti = true;
                    }
                ?>

                <div class="card-item">
                    <div class="d-flex justify-content-between align-items-start">
                        <div style="flex: 1; padding-right: 20px;">
                            <div class="item-head">
                                <span class="item-title"><?php echo $row['Title']; ?></span>
                                <span class="badge-status <?php echo $stClass; ?>">
                                    <?php echo $stIcon . " " . $stText; ?>
                                </span>
                            </div>

                            <div class="item-desc">
                                <?php echo $row['Description']; ?>
                            </div>

                            <div class="item-meta">
                                <span class="text-money"><?php echo formatUang($row['Amount']); ?></span>
                                <span>&bull;</span>
                                <span style="color: #6b7280;"><?php echo $project; ?></span>
                                <span>&bull;</span>
                                <span><?php echo formatTgl($row['RequestDateTime']); ?></span>
                            </div>

                            <?php if (!empty($adminNote) && $status != 'Pending'): ?>
                                <div class="note-box">
                                    <strong>Catatan Admin:</strong><br>
                                    <?php echo $adminNote; ?>
                                </div>
                            <?php endif; ?>
                        </div>

                        <div>
                            <?php if ($hasBukti): ?>
                                <a href="<?php echo $linkBukti; ?>" target="_blank" class="btn-bukti">Lihat Bukti</a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

            <?php endforeach; ?>
        
        <?php else: ?>
            <div style="text-align: center; padding: 60px 20px; color: #9ca3af; background: #fff; border-radius: 12px; border: 1px dashed #e5e7eb;">
                <i class="far fa-folder-open" style="font-size: 48px; margin-bottom: 15px; opacity: 0.5;"></i>
                <h4 style="font-size: 16px; font-weight: 600; color: #374151;">Belum ada pengajuan</h4>
                <p style="font-size: 14px;">Silakan buat pengajuan reimbursement baru.</p>
            </div>
        <?php endif; ?>

    </div>
</div>
