<?php

namespace PHPMaker2026\Reimbursement;
?>
<script<?= Nonce() ?>>
ew.on("head", function () {
    // Write your client script here, no need to add script tags.
});
</script>
<?= $Page->getPageHeader() ?>
<div class="ew-login-box">
    <div class="login-logo"></div>
    <div class="card ew-login-card">
        <div class="card-body">
<?= $Page->getHtmlMessage() ?>
<script<?= Nonce() ?>>
// Script inside .card-body
var flogin,
    $overlay,
    showLoading = () => $(".ew-login-card").append($overlay ??= $(ew.overlayTemplate())),
    hideLoading = () => $(".ew-login-card").find($overlay).detach();
ew.on("wrapper", function() {
    let $ = jQuery;
    ew.PAGE_ID ||= "login";
    window.currentPageID ||= "login";
    let form = new ew.FormBuilder()
        .setId("flogin")
        // Add fields
        .addFields([
            ["username", ew.Validators.required(ew.language.phrase("UserName")), <?= $Page->_Username->IsInvalid ? "true" : "false" ?>],
            ["password", ew.Validators.required(ew.language.phrase("Password")), <?= $Page->_Password->IsInvalid ? "true" : "false" ?>]
        ])

        // Captcha
        <?= Captcha()?->getScript() ?>

        // Validate
        .setValidate(
            async function() {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;
                return true;
            }
        )

        // Use JavaScript validation
        .setValidateRequired(ew.CLIENT_VALIDATE)
        .build();

    // Submit
    let $form = form.$element;
    $form.off("beforesubmit").on("beforesubmit", function(e) {
        e.preventDefault();
        showLoading();
        form.disableForm();
        ew.fetch(ew.sanitize(form.element.getAttribute("action")), {
            method: "POST",
            body: new FormData(form.element),
            headers: {
                "Accept": "application/json, */*; q=0.01",
            },
        }).then(async (response) => {
            response = await ew.checkError(response);
            let result = await response.json();
            if ($.isObject(result)) {
                let error = ew.getError(result);
                if (result?.errorUrl) { // Redirect
                    window.location = ew.sanitize(result.errorUrl);
                } else if (error) { // Failure
                    form.fields.username.clearErrors()
                        .addError({ username: ew.language.phrase("InvalidUidPwd") })
                        .updateFeedback();
                    form.fields.password.clearErrors()
                        .addError({ username: ew.language.phrase("InvalidUidPwd") })
                        .updateFeedback();
                    if (error != ew.language.phrase("InvalidUidPwd") && error != "The presented password is invalid." && error != "Invalid credentials.") // Not BadCredentialsException
                        ew.showToast(error);
                } else if (result?.url) { // Success
                    ew.setValid(form.element.username);
                    ew.setValid(form.element.password);
                    window.location = ew.sanitize(result.url);
                }
            }
        }).catch((error) => {
            ew.alert(ew.getError(error) || error);
        }).finally(() => {
            form.enableForm();
            hideLoading();
        });
    });
    window[form.id] = form;
    window.currentForm ||= form;
    ew.emit(form.id);
});
</script>
<?php
$formAction = Config("USE_TWO_FACTOR_AUTHENTICATION") || Config("USE_PHPCAPTCHA_FOR_LOGIN") ? UrlFor("login1fa") : UrlFor("login");
?>
<form name="flogin" id="flogin" class="ew-form ew-login-form" action="<?= $formAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CSRF_PROTECTION")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token ID -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
    <p class="login-box-msg"><?= Language()->phrase("LoginMsg") ?></p>
    <div class="row gx-0">
        <input type="text" name="username" id="username" autocomplete="username" value="<?= HtmlEncode($Page->_Username->CurrentValue) ?>" placeholder="<?= HtmlEncode($Page->_Username->PlaceHolder) ?>"<?= $Page->_Username->editAttributes() ?>>
        <div class="invalid-feedback"><?= $Page->_Username->getErrorMessage() ?></div>
    </div>
    <?php if (!Config("OTP_ONLY")) { // Disable password checking ?>
    <div class="row gx-0">
        <div class="input-group px-0">
            <input type="password" name="password" id="password" autocomplete="current-password" placeholder="<?= HtmlEncode($Page->_Password->PlaceHolder) ?>"<?= $Page->_Password->editAttributes() ?>>
            <button type="button" class="btn btn-default ew-toggle-password rounded-end" data-ew-action="password"><i class="fa-regular fa-eye"></i></button>
        </div>
        <div class="valid-feedback"><?= Language()->phrase("LoginSuccess") ?></div>
        <div class="invalid-feedback"><?= $Page->_Password->getErrorMessage() ?></div>
    </div>
    <?php } ?>
<!-- captcha html (begin) -->
<?= Captcha()?->getHtml(); ?>
<!-- captcha html (end) -->
    <div class="d-grid">
        <button class="btn btn-primary ew-btn ew-submit disabled enable-on-init" name="btn-submit" id="btn-submit" type="submit" formaction="<?= $formAction ?>"><?= Language()->phrase("Login", true) ?></button>
    </div>
<div class="social-auth-links text-center mt-3 d-grid gap-2"></div>
<script type="text/html" class="ew-js-template" data-name="external-login" data-seq="10" data-data="login" data-target=".social-auth-links">
{{if externalLogin && externalLogin.length}}
<p><?= Language()->phrase("LoginOr") ?></p>
    {{for externalLogin}}
    <a href="{{:url}}" class="btn btn-outline-{{:color}}">{{:text}}</a>
    {{/for}}
{{/if}}
</script>
<div class="login-page-links text-center mt-3"></div>
<script type="text/html" class="ew-js-template"<?php if (!$Page->IsModal) { ?> data-name="login-page" data-seq="10"<?php } ?> data-data="login" data-target=".login-page-links">
{{if canResetPassword && resetPassword}}
<a class="card-link me-2"{{props resetPassword}} data-{{:key}}="{{>prop}}"{{/props}}>{{:resetPasswordText}}</a>
{{/if}}
{{if canRegister && register}}
<a class="card-link me-2"{{props register}} data-{{:key}}="{{>prop}}"{{/props}}>{{:registerText}}</a>
{{/if}}
</script>
</form>
        </div><!-- ./card-body -->
    </div><!-- ./card -->
</div><!-- ./ew-login-box -->
<?= $Page->getPageFooter() ?>
<script<?= Nonce() ?>>
ew.on("load", function () {
    // Write your startup script here, no need to add script tags.
});
</script>
