<?php

namespace PHPMaker2026\Reimbursement;
?>
<script<?= Nonce() ?>>
var currentTable = <?= json_encode($Page->getClientVars()) ?>;
ew.deepAssign(ew.vars, { tables: { mtproject: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fmtprojectadd;
ew.on("wrapper", function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fmtprojectadd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["ProjectCode", [fields.ProjectCode.visible && fields.ProjectCode.required ? ew.Validators.required(fields.ProjectCode.caption) : null], fields.ProjectCode.isInvalid],
            ["ProjectName", [fields.ProjectName.visible && fields.ProjectName.required ? ew.Validators.required(fields.ProjectName.caption) : null], fields.ProjectName.isInvalid],
            ["Description", [fields.Description.visible && fields.Description.required ? ew.Validators.required(fields.Description.caption) : null], fields.Description.isInvalid],
            ["IsActive", [fields.IsActive.visible && fields.IsActive.required ? ew.Validators.required(fields.IsActive.caption) : null], fields.IsActive.isInvalid]
        ])

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "IsActive": <?= $Page->IsActive->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    ew.emit(form.id);
});
</script>
<script<?= Nonce() ?>>
ew.on("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?= $Page->getPageHeader() ?>
<?= $Page->getHtmlMessage() ?>
<form name="fmtprojectadd" id="fmtprojectadd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CSRF_PROTECTION")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token ID -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="mtproject">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->getFormOldKeyName() ?>" value="<?= $Page->getOldKeyAsString() ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->ProjectCode->Visible) { // ProjectCode ?>
    <div id="r_ProjectCode"<?= $Page->ProjectCode->rowAttributes() ?>>
        <label id="elh_mtproject_ProjectCode" for="x_ProjectCode" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ProjectCode->caption() ?><?= $Page->ProjectCode->Required ? Language()->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ProjectCode->cellAttributes() ?>>
<span id="el_mtproject_ProjectCode">
<input type="<?= $Page->ProjectCode->getInputTextType() ?>" name="x_ProjectCode" id="x_ProjectCode" data-table="mtproject" data-field="x_ProjectCode" value="<?= $Page->ProjectCode->getEditValue() ?>" size="30" maxlength="20" placeholder="<?= HtmlEncode($Page->ProjectCode->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProjectCode->formatPattern()) ?>"<?= $Page->ProjectCode->editAttributes() ?> aria-describedby="x_ProjectCode_help">
<?= $Page->ProjectCode->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ProjectCode->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->ProjectName->Visible) { // ProjectName ?>
    <div id="r_ProjectName"<?= $Page->ProjectName->rowAttributes() ?>>
        <label id="elh_mtproject_ProjectName" for="x_ProjectName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->ProjectName->caption() ?><?= $Page->ProjectName->Required ? Language()->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ProjectName->cellAttributes() ?>>
<span id="el_mtproject_ProjectName">
<input type="<?= $Page->ProjectName->getInputTextType() ?>" name="x_ProjectName" id="x_ProjectName" data-table="mtproject" data-field="x_ProjectName" value="<?= $Page->ProjectName->getEditValue() ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->ProjectName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ProjectName->formatPattern()) ?>"<?= $Page->ProjectName->editAttributes() ?> aria-describedby="x_ProjectName_help">
<?= $Page->ProjectName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->ProjectName->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Description->Visible) { // Description ?>
    <div id="r_Description"<?= $Page->Description->rowAttributes() ?>>
        <label id="elh_mtproject_Description" for="x_Description" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Description->caption() ?><?= $Page->Description->Required ? Language()->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Description->cellAttributes() ?>>
<span id="el_mtproject_Description">
<input type="<?= $Page->Description->getInputTextType() ?>" name="x_Description" id="x_Description" data-table="mtproject" data-field="x_Description" value="<?= $Page->Description->getEditValue() ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Description->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Description->formatPattern()) ?>"<?= $Page->Description->editAttributes() ?> aria-describedby="x_Description_help">
<?= $Page->Description->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Description->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->IsActive->Visible) { // IsActive ?>
    <div id="r_IsActive"<?= $Page->IsActive->rowAttributes() ?>>
        <label id="elh_mtproject_IsActive" class="<?= $Page->LeftColumnClass ?>"><?= $Page->IsActive->caption() ?><?= $Page->IsActive->Required ? Language()->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->IsActive->cellAttributes() ?>>
<span id="el_mtproject_IsActive">
<div class="form-check d-inline-block">
    <input type="checkbox" class="form-check-input<?= $Page->IsActive->isInvalidClass() ?>" data-table="mtproject" data-field="x_IsActive" data-boolean name="x_IsActive" id="x_IsActive" value="1"<?= ConvertToBool($Page->IsActive->CurrentValue) ? " checked" : "" ?><?= $Page->IsActive->editAttributes() ?> aria-describedby="x_IsActive_help">
    <div class="invalid-feedback"><?= $Page->IsActive->getErrorMessage() ?></div>
</div>
<?= $Page->IsActive->getCustomMessage() ?>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn ew-submit" name="btn-action" id="btn-action" type="submit" form="fmtprojectadd"><?= Language()->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= Language()->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmtprojectadd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= Language()->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?= $Page->getPageFooter() ?>
<script<?= Nonce() ?>>
// Field event handlers
ew.on("head", function() {
    ew.addEventHandlers("mtproject");
});
</script>
<script<?= Nonce() ?>>
ew.on("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
