<?php

namespace PHPMaker2026\Reimbursement;
?>
<?php if (!$Page->isExport()) { ?>
<script<?= Nonce() ?>>
var currentTable = <?= json_encode($Page->getClientVars()) ?>;
ew.deepAssign(ew.vars, { tables: { mtproject: currentTable } });
var currentPageID = ew.PAGE_ID = "list";
var currentForm;
var <?= $Page->FormName ?>;
ew.on("wrapper", function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("<?= $Page->FormName ?>")
        .setPageId("list")
        .setSubmitWithFetch(<?= $Page->UseAjaxActions ? "true" : "false" ?>)
        .setFormKeyCountName("<?= $Page->getFormKeyCountName() ?>")
        .build();
    window[form.id] = form;
    currentForm = form;
    ew.emit(form.id);
});
</script>
<script<?= Nonce() ?>>
ew.on("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php } ?>
<?php if (!$Page->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($Page->TotalRecords > 0) { ?>
<?= $Page->ExportOptions->render("body") ?>
<?php } ?>
<?= $Page->ImportOptions->render("body") ?>
<?= $Page->SearchOptions->render("body") ?>
<?= $Page->FilterOptions->render("body") ?>
</div>
<?php } ?>
<?php if (!$Page->IsModal) { ?>
<form name="fmtprojectsrch" id="fmtprojectsrch" class="ew-form ew-ext-search-form" action="<?= CurrentPageUrl(false) ?>" novalidate autocomplete="off">
<div id="fmtprojectsrch_search_panel" class="mb-2 mb-sm-0 <?= $Page->SearchPanelClass ?>"><!-- .ew-search-panel -->
<script<?= Nonce() ?>>
var currentTable = <?= json_encode($Page->getClientVars()) ?>;
ew.deepAssign(ew.vars, { tables: { mtproject: currentTable } });
var currentForm;
var fmtprojectsrch, currentSearchForm, currentAdvancedSearchForm;
ew.on("wrapper", () => {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmtprojectsrch")
        .setPageId("list")
<?php if ($Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Dynamic selection lists
        .setLists({
        })

        // Filters
        .setFilterList(<?= $Page->getFilterList() ?>)
        .build();
    window[form.id] = form;
    currentSearchForm = form;
    ew.emit(form.id);
});
</script>
<input type="hidden" name="cmd" value="search">
<?php if (Security()->canSearch()) { ?>
<?php if (!$Page->isExport() && !($Page->CurrentAction && $Page->CurrentAction != "search") && $Page->hasSearchFields()) { ?>
<div class="ew-extended-search container-fluid ps-2">
<div class="row mb-0">
    <div class="col-sm-auto px-0 pe-sm-2">
        <div class="ew-basic-search input-group">
            <input type="search" name="<?= Config("TABLE_BASIC_SEARCH") ?>" id="<?= Config("TABLE_BASIC_SEARCH") ?>" class="form-control ew-basic-search-keyword" value="<?= HtmlEncode($Page->BasicSearch->getKeyword()) ?>" placeholder="<?= HtmlEncode(Language()->phrase("Search")) ?>" aria-label="<?= HtmlEncode(Language()->phrase("Search")) ?>">
            <input type="hidden" name="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?= Config("TABLE_BASIC_SEARCH_TYPE") ?>" class="ew-basic-search-type" value="<?= HtmlEncode($Page->BasicSearch->getType()) ?>">
            <button type="button" data-bs-toggle="dropdown" class="btn btn-outline-secondary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false">
                <span id="searchtype"><?= $Page->BasicSearch->getTypeNameShort() ?></span>
            </button>
            <div class="dropdown-menu dropdown-menu-end">
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "" ? " active" : "" ?>" form="fmtprojectsrch" data-ew-action="search-type"><?= Language()->phrase("QuickSearchAuto") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "=" ? " active" : "" ?>" form="fmtprojectsrch" data-ew-action="search-type" data-search-type="="><?= Language()->phrase("QuickSearchExact") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "AND" ? " active" : "" ?>" form="fmtprojectsrch" data-ew-action="search-type" data-search-type="AND"><?= Language()->phrase("QuickSearchAll") ?></button>
                <button type="button" class="dropdown-item<?= $Page->BasicSearch->getType() == "OR" ? " active" : "" ?>" form="fmtprojectsrch" data-ew-action="search-type" data-search-type="OR"><?= Language()->phrase("QuickSearchAny") ?></button>
            </div>
        </div>
    </div>
    <div class="col-sm-auto mb-3">
        <button class="btn btn-primary ew-submit" name="btn-submit" id="btn-submit" type="submit"><?= Language()->phrase("SearchBtn") ?></button>
    </div>
</div>
</div><!-- /.ew-extended-search -->
<?php } ?>
<?php } ?>
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?= $Page->getPageHeader() ?>
<?= $Page->getHtmlMessage() ?>
<main class="list<?= ($Page->TotalRecords == 0 && !$Page->isAdd()) ? " ew-no-record" : "" ?>">
<div id="ew-header-options">
<?php $Page->HeaderOptions?->render("body") ?>
</div>
<div id="ew-list">
<?php if ($Page->TotalRecords > 0 || $Page->CurrentAction) { ?>
<div class="card ew-card ew-grid<?= $Page->isAddOrEdit() ? " ew-grid-add-edit" : "" ?> <?= $Page->TableGridClass ?>">
<?php $formAction = GetUrl(UrlFor("list.mtproject", $Page->getUrlKey(true))) ?>
<form name="<?= $Page->FormName ?>" id="<?= $Page->FormName ?>" class="ew-form ew-list-form" action="<?= $formAction ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CSRF_PROTECTION")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token ID -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="mtproject">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div id="gmp_mtproject" class="card-body ew-grid-middle-panel <?= $Page->TableContainerClass ?>">
<?php if ($Page->TotalRecords > 0 || $Page->isGridEdit() || $Page->isMultiEdit()) { ?>
<table id="tbl_mtprojectlist" class="<?= $Page->TableClass ?>"><!-- .ew-table -->
<thead>
    <tr class="ew-table-header">
<?php
// Header row
$Page->RowType = RowType::HEADER;

// Render list options
$Page->renderListOptions();

// Render list options (header, left)
$Page->ListOptions->render("header", "left");
?>
<?php if ($Page->_ProjectID->Visible) { // ProjectID ?>
        <th data-name="_ProjectID" class="<?= $Page->_ProjectID->headerCellClass() ?>"><div id="elh_mtproject__ProjectID" class="mtproject__ProjectID"><?= $Page->renderFieldHeader($Page->_ProjectID) ?></div></th>
<?php } ?>
<?php if ($Page->ProjectCode->Visible) { // ProjectCode ?>
        <th data-name="ProjectCode" class="<?= $Page->ProjectCode->headerCellClass() ?>"><div id="elh_mtproject_ProjectCode" class="mtproject_ProjectCode"><?= $Page->renderFieldHeader($Page->ProjectCode) ?></div></th>
<?php } ?>
<?php if ($Page->ProjectName->Visible) { // ProjectName ?>
        <th data-name="ProjectName" class="<?= $Page->ProjectName->headerCellClass() ?>"><div id="elh_mtproject_ProjectName" class="mtproject_ProjectName"><?= $Page->renderFieldHeader($Page->ProjectName) ?></div></th>
<?php } ?>
<?php if ($Page->Description->Visible) { // Description ?>
        <th data-name="Description" class="<?= $Page->Description->headerCellClass() ?>"><div id="elh_mtproject_Description" class="mtproject_Description"><?= $Page->renderFieldHeader($Page->Description) ?></div></th>
<?php } ?>
<?php if ($Page->IsActive->Visible) { // IsActive ?>
        <th data-name="IsActive" class="<?= $Page->IsActive->headerCellClass() ?>"><div id="elh_mtproject_IsActive" class="mtproject_IsActive"><?= $Page->renderFieldHeader($Page->IsActive) ?></div></th>
<?php } ?>
<?php if ($Page->CreatedByUserID->Visible) { // CreatedByUserID ?>
        <th data-name="CreatedByUserID" class="<?= $Page->CreatedByUserID->headerCellClass() ?>"><div id="elh_mtproject_CreatedByUserID" class="mtproject_CreatedByUserID"><?= $Page->renderFieldHeader($Page->CreatedByUserID) ?></div></th>
<?php } ?>
<?php if ($Page->CreatedDateTime->Visible) { // CreatedDateTime ?>
        <th data-name="CreatedDateTime" class="<?= $Page->CreatedDateTime->headerCellClass() ?>"><div id="elh_mtproject_CreatedDateTime" class="mtproject_CreatedDateTime"><?= $Page->renderFieldHeader($Page->CreatedDateTime) ?></div></th>
<?php } ?>
<?php if ($Page->LastUpdatedByUserID->Visible) { // LastUpdatedByUserID ?>
        <th data-name="LastUpdatedByUserID" class="<?= $Page->LastUpdatedByUserID->headerCellClass() ?>"><div id="elh_mtproject_LastUpdatedByUserID" class="mtproject_LastUpdatedByUserID"><?= $Page->renderFieldHeader($Page->LastUpdatedByUserID) ?></div></th>
<?php } ?>
<?php if ($Page->LastUpdatedDateTime->Visible) { // LastUpdatedDateTime ?>
        <th data-name="LastUpdatedDateTime" class="<?= $Page->LastUpdatedDateTime->headerCellClass() ?>"><div id="elh_mtproject_LastUpdatedDateTime" class="mtproject_LastUpdatedDateTime"><?= $Page->renderFieldHeader($Page->LastUpdatedDateTime) ?></div></th>
<?php } ?>
<?php
// Render list options (header, right)
$Page->ListOptions->render("header", "right");
?>
    </tr>
</thead>
<tbody data-page="<?= $Page->getPageNumber() ?>">
<?php
while ($Page->getRowData()) {
?>
    <tr <?= $Page->rowAttributes() ?>>
<?php
// Render list options (body, left)
$Page->ListOptions->render("body", "left", $Page->RowCount);
?>
    <?php if ($Page->_ProjectID->Visible) { // ProjectID ?>
        <td data-name="_ProjectID"<?= $Page->_ProjectID->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_mtproject__ProjectID" class="el_mtproject__ProjectID">
<span<?= $Page->_ProjectID->viewAttributes() ?>>
<?= $Page->_ProjectID->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ProjectCode->Visible) { // ProjectCode ?>
        <td data-name="ProjectCode"<?= $Page->ProjectCode->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_mtproject_ProjectCode" class="el_mtproject_ProjectCode">
<span<?= $Page->ProjectCode->viewAttributes() ?>>
<?= $Page->ProjectCode->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->ProjectName->Visible) { // ProjectName ?>
        <td data-name="ProjectName"<?= $Page->ProjectName->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_mtproject_ProjectName" class="el_mtproject_ProjectName">
<span<?= $Page->ProjectName->viewAttributes() ?>>
<?= $Page->ProjectName->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->Description->Visible) { // Description ?>
        <td data-name="Description"<?= $Page->Description->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_mtproject_Description" class="el_mtproject_Description">
<span<?= $Page->Description->viewAttributes() ?>>
<?= $Page->Description->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->IsActive->Visible) { // IsActive ?>
        <td data-name="IsActive"<?= $Page->IsActive->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_mtproject_IsActive" class="el_mtproject_IsActive">
<span<?= $Page->IsActive->viewAttributes() ?>>
<i class="fa-regular fa-square<?php if (ConvertToBool($Page->IsActive->CurrentValue)) { ?>-check<?php } ?> ew-icon ew-boolean"></i>
</span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->CreatedByUserID->Visible) { // CreatedByUserID ?>
        <td data-name="CreatedByUserID"<?= $Page->CreatedByUserID->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_mtproject_CreatedByUserID" class="el_mtproject_CreatedByUserID">
<span<?= $Page->CreatedByUserID->viewAttributes() ?>>
<?= $Page->CreatedByUserID->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->CreatedDateTime->Visible) { // CreatedDateTime ?>
        <td data-name="CreatedDateTime"<?= $Page->CreatedDateTime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_mtproject_CreatedDateTime" class="el_mtproject_CreatedDateTime">
<span<?= $Page->CreatedDateTime->viewAttributes() ?>>
<?= $Page->CreatedDateTime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->LastUpdatedByUserID->Visible) { // LastUpdatedByUserID ?>
        <td data-name="LastUpdatedByUserID"<?= $Page->LastUpdatedByUserID->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_mtproject_LastUpdatedByUserID" class="el_mtproject_LastUpdatedByUserID">
<span<?= $Page->LastUpdatedByUserID->viewAttributes() ?>>
<?= $Page->LastUpdatedByUserID->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
    <?php if ($Page->LastUpdatedDateTime->Visible) { // LastUpdatedDateTime ?>
        <td data-name="LastUpdatedDateTime"<?= $Page->LastUpdatedDateTime->cellAttributes() ?>>
<span id="el<?= $Page->RowIndex == '$rowindex$' ? '$rowindex$' : $Page->RowCount ?>_mtproject_LastUpdatedDateTime" class="el_mtproject_LastUpdatedDateTime">
<span<?= $Page->LastUpdatedDateTime->viewAttributes() ?>>
<?= $Page->LastUpdatedDateTime->getViewValue() ?></span>
</span>
</td>
    <?php } ?>
<?php
// Render list options (body, right)
$Page->ListOptions->render("body", "right", $Page->RowCount);
?>
    </tr>
<?php
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$Page->CurrentAction && !$Page->UseAjaxActions) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php if (!$Page->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?= $Page->Pager?->render() ?>
<div class="ew-list-other-options">
<?= $Page->OtherOptions->render("body", "bottom") ?>
</div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } else { ?>
<div class="ew-list-other-options">
<?php $Page->OtherOptions->render("body") ?>
</div>
<?php } ?>
</div>
<div id="ew-footer-options">
<?php $Page->FooterOptions?->render("body") ?>
</div>
</main>
<?= $Page->getPageFooter() ?>
<?php if (!$Page->isExport()) { ?>
<script<?= Nonce() ?>>
// Field event handlers
ew.on("head", function() {
    ew.addEventHandlers("mtproject");
});
</script>
<script<?= Nonce() ?>>
ew.on("load", function () {
    // Startup script
    // Write your table-specific startup script here, no need to add script tags.
    $(document).ready(function() {
        var btnBack = '<a href="DashboardPanel" class="btn btn-default btn-sm" style="margin-right: 10px;">' +
                      '<i class="fas fa-arrow-left"></i> Kembali ke Dashboard' +
                      '</a>';
        $(".content-header .container-fluid .col-sm-6 h1").prepend(btnBack);
    });
});
</script>
<?php } ?>
