<?php

namespace PHPMaker2026\Reimbursement;
?>
<script<?= Nonce() ?>>
var currentTable = <?= json_encode($Page->getClientVars()) ?>;
ew.deepAssign(ew.vars, { tables: { mtuser: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fmtuseradd;
ew.on("wrapper", function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fmtuseradd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["_Email", [fields._Email.visible && fields._Email.required ? ew.Validators.required(fields._Email.caption) : null], fields._Email.isInvalid],
            ["Password", [fields.Password.visible && fields.Password.required ? ew.Validators.required(fields.Password.caption) : null], fields.Password.isInvalid],
            ["FullName", [fields.FullName.visible && fields.FullName.required ? ew.Validators.required(fields.FullName.caption) : null], fields.FullName.isInvalid],
            ["MTUserLevelID", [fields.MTUserLevelID.visible && fields.MTUserLevelID.required ? ew.Validators.required(fields.MTUserLevelID.caption) : null], fields.MTUserLevelID.isInvalid]
        ])

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "MTUserLevelID": <?= $Page->MTUserLevelID->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    ew.emit(form.id);
});
</script>
<script<?= Nonce() ?>>
ew.on("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?= $Page->getPageHeader() ?>
<?= $Page->getHtmlMessage() ?>
<form name="fmtuseradd" id="fmtuseradd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CSRF_PROTECTION")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token ID -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="mtuser">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->getFormOldKeyName() ?>" value="<?= $Page->getOldKeyAsString() ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->_Email->Visible) { // Email ?>
    <div id="r__Email"<?= $Page->_Email->rowAttributes() ?>>
        <label id="elh_mtuser__Email" for="x__Email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_Email->caption() ?><?= $Page->_Email->Required ? Language()->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_Email->cellAttributes() ?>>
<span id="el_mtuser__Email">
<input type="<?= $Page->_Email->getInputTextType() ?>" name="x__Email" id="x__Email" data-table="mtuser" data-field="x__Email" value="<?= $Page->_Email->getEditValue() ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->_Email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_Email->formatPattern()) ?>"<?= $Page->_Email->editAttributes() ?> aria-describedby="x__Email_help">
<?= $Page->_Email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_Email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Password->Visible) { // Password ?>
    <div id="r_Password"<?= $Page->Password->rowAttributes() ?>>
        <label id="elh_mtuser_Password" for="x_Password" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Password->caption() ?><?= $Page->Password->Required ? Language()->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Password->cellAttributes() ?>>
<span id="el_mtuser_Password">
<div class="input-group">
    <input type="password" name="x_Password" id="x_Password" autocomplete="new-password" data-field="x_Password" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Password->getPlaceHolder()) ?>"<?= $Page->Password->editAttributes() ?> aria-describedby="x_Password_help">
    <button type="button" class="btn btn-default ew-toggle-password rounded-end" data-ew-action="password"><i class="fa-regular fa-eye"></i></button>
</div>
<?= $Page->Password->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Password->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->FullName->Visible) { // FullName ?>
    <div id="r_FullName"<?= $Page->FullName->rowAttributes() ?>>
        <label id="elh_mtuser_FullName" for="x_FullName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FullName->caption() ?><?= $Page->FullName->Required ? Language()->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FullName->cellAttributes() ?>>
<span id="el_mtuser_FullName">
<input type="<?= $Page->FullName->getInputTextType() ?>" name="x_FullName" id="x_FullName" data-table="mtuser" data-field="x_FullName" value="<?= $Page->FullName->getEditValue() ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->FullName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FullName->formatPattern()) ?>"<?= $Page->FullName->editAttributes() ?> aria-describedby="x_FullName_help">
<?= $Page->FullName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->FullName->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->MTUserLevelID->Visible) { // MTUserLevelID ?>
    <div id="r_MTUserLevelID"<?= $Page->MTUserLevelID->rowAttributes() ?>>
        <label id="elh_mtuser_MTUserLevelID" for="x_MTUserLevelID" class="<?= $Page->LeftColumnClass ?>"><?= $Page->MTUserLevelID->caption() ?><?= $Page->MTUserLevelID->Required ? Language()->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->MTUserLevelID->cellAttributes() ?>>
<?php if (!Security()->canAccess() && Security()->isLoggedIn()) { // No access permission ?>
<span id="el_mtuser_MTUserLevelID">
<span class="form-control-plaintext"><?= $Page->MTUserLevelID->getDisplayValue($Page->MTUserLevelID->getEditValue()) ?></span>
</span>
<?php } else { ?>
<span id="el_mtuser_MTUserLevelID">
    <select
        id="x_MTUserLevelID"
        name="x_MTUserLevelID"
        class="form-select ew-select<?= $Page->MTUserLevelID->isInvalidClass() ?>"
        <?php if (!$Page->MTUserLevelID->IsNativeSelect) { ?>
        data-select2-id="fmtuseradd_x_MTUserLevelID"
        <?php } ?>
        data-table="mtuser"
        data-field="x_MTUserLevelID"
        data-value-separator="<?= $Page->MTUserLevelID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->MTUserLevelID->getPlaceHolder()) ?>"
        <?= $Page->MTUserLevelID->editAttributes() ?>>
        <?= $Page->MTUserLevelID->selectOptionListHtml("x_MTUserLevelID") ?>
    </select>
    <?= $Page->MTUserLevelID->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->MTUserLevelID->getErrorMessage() ?></div>
<?= $Page->MTUserLevelID->Lookup->getParamTag($Page, "p_x_MTUserLevelID") ?>
<?php if (!$Page->MTUserLevelID->IsNativeSelect) { ?>
<script<?= Nonce() ?>>
ew.on("fmtuseradd", function() {
    var options = { name: "x_MTUserLevelID", selectId: "fmtuseradd_x_MTUserLevelID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (fmtuseradd.lists.MTUserLevelID?.lookupOptions.length) {
        options.data = { id: "x_MTUserLevelID", form: "fmtuseradd" };
    } else {
        options.ajax = { id: "x_MTUserLevelID", form: "fmtuseradd", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.mtuser.fields.MTUserLevelID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span>
<?php } ?>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn ew-submit" name="btn-action" id="btn-action" type="submit" form="fmtuseradd"><?= Language()->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= Language()->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmtuseradd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= Language()->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?= $Page->getPageFooter() ?>
<script<?= Nonce() ?>>
// Field event handlers
ew.on("head", function() {
    ew.addEventHandlers("mtuser");
});
</script>
<script<?= Nonce() ?>>
ew.on("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
