<?php

namespace PHPMaker2026\Reimbursement;
?>
<script<?= Nonce() ?>>
var currentTable = <?= json_encode($Page->getClientVars()) ?>;
ew.deepAssign(ew.vars, { tables: { mtuserlevel: currentTable } });
var currentPageID = ew.PAGE_ID = "add";
var currentForm;
var fmtuserleveladd;
ew.on("wrapper", function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fmtuserleveladd")
        .setPageId("add")

        // Add fields
        .setFields([
            ["UserLevelName", [fields.UserLevelName.visible && fields.UserLevelName.required ? ew.Validators.required(fields.UserLevelName.caption) : null, ew.Validators.userLevelName('UserLevelID')], fields.UserLevelName.isInvalid],
            ["Hierarchy", [fields.Hierarchy.visible && fields.Hierarchy.required ? ew.Validators.required(fields.Hierarchy.caption) : null], fields.Hierarchy.isInvalid]
        ])

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    ew.emit(form.id);
});
</script>
<script<?= Nonce() ?>>
ew.on("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?= $Page->getPageHeader() ?>
<?= $Page->getHtmlMessage() ?>
<form name="fmtuserleveladd" id="fmtuserleveladd" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CSRF_PROTECTION")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token ID -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="mtuserlevel">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->getFormOldKeyName() ?>" value="<?= $Page->getOldKeyAsString() ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($Page->UserLevelName->Visible) { // UserLevelName ?>
    <div id="r_UserLevelName"<?= $Page->UserLevelName->rowAttributes() ?>>
        <label id="elh_mtuserlevel_UserLevelName" for="x_UserLevelName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->UserLevelName->caption() ?><?= $Page->UserLevelName->Required ? Language()->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->UserLevelName->cellAttributes() ?>>
<span id="el_mtuserlevel_UserLevelName">
<input type="<?= $Page->UserLevelName->getInputTextType() ?>" name="x_UserLevelName" id="x_UserLevelName" data-table="mtuserlevel" data-field="x_UserLevelName" value="<?= $Page->UserLevelName->getEditValue() ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->UserLevelName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->UserLevelName->formatPattern()) ?>"<?= $Page->UserLevelName->editAttributes() ?> aria-describedby="x_UserLevelName_help">
<?= $Page->UserLevelName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->UserLevelName->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Hierarchy->Visible) { // Hierarchy ?>
    <div id="r_Hierarchy"<?= $Page->Hierarchy->rowAttributes() ?>>
        <label id="elh_mtuserlevel_Hierarchy" for="x_Hierarchy" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Hierarchy->caption() ?><?= $Page->Hierarchy->Required ? Language()->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Hierarchy->cellAttributes() ?>>
<span id="el_mtuserlevel_Hierarchy">
<input type="<?= $Page->Hierarchy->getInputTextType() ?>" name="x_Hierarchy" id="x_Hierarchy" data-table="mtuserlevel" data-field="x_Hierarchy" value="<?= $Page->Hierarchy->getEditValue() ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Hierarchy->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Hierarchy->formatPattern()) ?>"<?= $Page->Hierarchy->editAttributes() ?> aria-describedby="x_Hierarchy_help">
<?= $Page->Hierarchy->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Hierarchy->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
    <!-- row for permission values -->
    <div id="rp_permission" class="row">
        <label id="elh_permission" class="<?= $Page->LeftColumnClass ?>"><?= HtmlTitle(Language()->phrase("Permission")) ?></label>
        <div class="<?= $Page->RightColumnClass ?>">
        <?php
            foreach (array_keys(Allow::privileges()) as $priv) {
        ?>
            <div class="form-check">
                <input type="checkbox" class="form-check-input" name="x__Allow<?= $priv ?>" id="<?= $priv ?>" value="<?= GetPrivilege($priv) ?>" /><label class="form-check-label" for="<?= $priv ?>"><?= Language()->phrase("Permission" . $priv, true) ?></label>
            </div>
        <?php
            }
        ?>
        </div>
    </div>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn ew-submit" name="btn-action" id="btn-action" type="submit" form="fmtuserleveladd"><?= Language()->phrase("AddBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= Language()->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmtuserleveladd" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= Language()->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?= $Page->getPageFooter() ?>
<script<?= Nonce() ?>>
// Field event handlers
ew.on("head", function() {
    ew.addEventHandlers("mtuserlevel");
});
</script>
<script<?= Nonce() ?>>
ew.on("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
