<?php

namespace PHPMaker2026\Reimbursement;
?>
<script<?= Nonce() ?>>
var currentTable = <?= json_encode($Page->getClientVars()) ?>;
ew.deepAssign(ew.vars, { tables: { mtuser: currentTable } });
var currentPageID = ew.PAGE_ID = "register";
var currentForm;
var fregister;
ew.on("wrapper", function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fregister")
        .setPageId("register")

        // Add fields
        .setFields([
            ["ID", [fields.ID.visible && fields.ID.required ? ew.Validators.required(fields.ID.caption) : null], fields.ID.isInvalid],
            ["_Email", [fields._Email.visible && fields._Email.required ? ew.Validators.required(fields._Email.caption) : null, ew.Validators.username], fields._Email.isInvalid],
            ["c_Password", [ew.Validators.required(ew.language.phrase("ConfirmPassword")), ew.Validators.mismatchPassword], fields.Password.isInvalid],
            ["Password", [fields.Password.visible && fields.Password.required ? ew.Validators.required(fields.Password.caption) : null, ew.Validators.password], fields.Password.isInvalid],
            ["FullName", [fields.FullName.visible && fields.FullName.required ? ew.Validators.required(fields.FullName.caption) : null], fields.FullName.isInvalid]
        ])
        <?= Captcha()?->getScript() ?>

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    ew.emit(form.id);
});
</script>
<script<?= Nonce() ?>>
ew.on("head", function () {
    // Write your client script here, no need to add script tags.
});
</script>
<?= $Page->getPageHeader() ?>
<?= $Page->getHtmlMessage() ?>
<form name="fregister" id="fregister" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CSRF_PROTECTION")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token ID -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<input type="hidden" name="t" value="mtuser">
<input type="hidden" name="action" id="action" value="insert">
<div class="ew-register-div"><!-- page* -->
<?php if ($Page->_Email->Visible) { // Email ?>
    <div id="r__Email"<?= $Page->_Email->rowAttributes() ?>>
        <label id="elh_mtuser__Email" for="x__Email" class="<?= $Page->LeftColumnClass ?>"><?= $Page->_Email->caption() ?><?= $Page->_Email->Required ? Language()->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_Email->cellAttributes() ?>>
<span id="el_mtuser__Email">
<input type="<?= $Page->_Email->getInputTextType() ?>" name="x__Email" id="x__Email" data-table="mtuser" data-field="x__Email" value="<?= $Page->_Email->getEditValue() ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->_Email->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_Email->formatPattern()) ?>"<?= $Page->_Email->editAttributes() ?> aria-describedby="x__Email_help">
<?= $Page->_Email->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_Email->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Password->Visible) { // Password ?>
    <div id="r_Password"<?= $Page->Password->rowAttributes() ?>>
        <label id="elh_mtuser_Password" for="x_Password" class="<?= $Page->LeftColumnClass ?>"><?= $Page->Password->caption() ?><?= $Page->Password->Required ? Language()->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Password->cellAttributes() ?>>
<span id="el_mtuser_Password">
<div class="input-group">
    <input type="password" name="x_Password" id="x_Password" autocomplete="new-password" data-field="x_Password" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Password->getPlaceHolder()) ?>"<?= $Page->Password->editAttributes() ?> aria-describedby="x_Password_help">
    <button type="button" class="btn btn-default ew-toggle-password rounded-end" data-ew-action="password"><i class="fa-regular fa-eye"></i></button>
</div>
<?= $Page->Password->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Password->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Password->Visible) { // Password ?>
    <div id="r_c_Password" class="row">
        <label id="elh_c_mtuser_Password" for="c_Password" class="<?= $Page->LeftColumnClass ?>"><?= Language()->phrase("Confirm") ?> <?= $Page->Password->caption() ?><?= $Page->Password->Required ? Language()->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Password->cellAttributes() ?>>
<span id="el_c_mtuser_Password">
<div class="input-group">
    <input type="password" name="c_Password" id="c_Password" autocomplete="new-password" data-field="c_Password" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Password->getPlaceHolder()) ?>"<?= $Page->Password->editAttributes() ?> aria-describedby="x_Password_help">
    <button type="button" class="btn btn-default ew-toggle-password rounded-end" data-ew-action="password"><i class="fa-regular fa-eye"></i></button>
</div>
<?= $Page->Password->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Password->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->FullName->Visible) { // FullName ?>
    <div id="r_FullName"<?= $Page->FullName->rowAttributes() ?>>
        <label id="elh_mtuser_FullName" for="x_FullName" class="<?= $Page->LeftColumnClass ?>"><?= $Page->FullName->caption() ?><?= $Page->FullName->Required ? Language()->phrase("FieldRequiredIndicator") : "" ?></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->FullName->cellAttributes() ?>>
<span id="el_mtuser_FullName">
<input type="<?= $Page->FullName->getInputTextType() ?>" name="x_FullName" id="x_FullName" data-table="mtuser" data-field="x_FullName" value="<?= $Page->FullName->getEditValue() ?>" size="30" maxlength="50" placeholder="<?= HtmlEncode($Page->FullName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->FullName->formatPattern()) ?>"<?= $Page->FullName->editAttributes() ?> aria-describedby="x_FullName_help">
<?= $Page->FullName->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->FullName->getErrorMessage() ?></div>
</span>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<!-- captcha html (begin) -->
<?= Captcha()?->getHtml(); ?>
<!-- captcha html (end) -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn ew-submit disabled enable-on-init" name="btn-action" id="btn-action" type="submit" form="fregister"><?= Language()->phrase("RegisterBtn") ?></button>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?= $Page->getPageFooter() ?>
<script<?= Nonce() ?>>
// Field event handlers
ew.on("head", function() {
    ew.addEventHandlers("mtuser");
});
</script>
<script<?= Nonce() ?>>
ew.on("load", function () {
    // Write your startup script here, no need to add script tags.
});
</script>
