<?php

namespace PHPMaker2026\Reimbursement;
?>
<?= $Page->getHtmlMessage() ?>
<?php
if (!IsLoggedIn()) {
    Security()->saveUserLevel();
    if (!IsSysAdmin() && CurrentUserLevel() != -1) {
        echo '<div class="alert alert-danger" style="margin: 20px;">Akses Ditolak. Halaman ini khusus Admin.</div>';
        exit();
    }
}

$f_start = $_GET['start_date'] ?? date('Y-m-01'); 
$f_end   = $_GET['end_date']   ?? date('Y-m-d');
$f_proj  = $_GET['project_id'] ?? '';


$whereClause = " WHERE t.RequestDateTime BETWEEN '" . AdjustSql($f_start . ' 00:00:00') . "' AND '" . AdjustSql($f_end . ' 23:59:59') . "'";

if (!empty($f_proj)) {
    $whereClause .= " AND t.ProjectID = " . AdjustSql($f_proj);
}

$sqlTable = "SELECT t.*, p.ProjectName 
             FROM trreimbursement t
             LEFT JOIN mtproject p ON t.ProjectID = p.ProjectID
             $whereClause
             ORDER BY t.RequestDateTime DESC";
$rows = ExecuteRows($sqlTable);

$sqlChart = "SELECT 
                p.ProjectName, 
                SUM(CASE WHEN t.ApprovedDateTime IS NOT NULL THEN t.Amount ELSE 0 END) as TotalApproved,
                SUM(CASE WHEN t.RejectedDateTime IS NOT NULL THEN t.Amount ELSE 0 END) as TotalRejected
             FROM trreimbursement t
             LEFT JOIN mtproject p ON t.ProjectID = p.ProjectID
             $whereClause
             GROUP BY p.ProjectName";
$chartRows = ExecuteRows($sqlChart);

$labels = [];
$dataApproved = [];
$dataRejected = [];

$grandTotalApproved = 0;
$grandTotalRejected = 0;

foreach ($chartRows as $r) {
    $labels[] = $r['ProjectName'] ?? 'Tanpa Project';
    
    $valApp = (float)$r['TotalApproved'];
    $valRej = (float)$r['TotalRejected'];
    
    $dataApproved[] = $valApp;
    $dataRejected[] = $valRej;
    
    $grandTotalApproved += $valApp;
    $grandTotalRejected += $valRej;
}

if (!function_exists('fmtTgl')) {

    function fmtTgl($d) { return empty($d) ? "-" : date('d M Y', strtotime($d)); }
}
?>

<style>
    .content-header, .breadcrumb, .content-header .container-fluid { display: none !important; }
    .content-wrapper, .content { background-color: #f8fafc !important; }

    .admin-wrapper { 
        max-width: 70%; 
        margin: 0 auto; 
        padding: 30px 20px; 
        font-family: 'Inter', -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, sans-serif; 
        min-height: 100vh;
        color: #1f2937;
    }

    .page-header-custom { display: flex; align-items: center; justify-content: space-between; margin-bottom: 30px; }
    
    .header-left { display: flex; align-items: center; gap: 15px; }
    .header-icon-box { 
        width: 52px; height: 52px; 
        background-color: #2563eb; color: white; 
        border-radius: 14px; 
        display: flex; align-items: center; justify-content: center; 
        font-size: 24px; 
        box-shadow: 0 10px 15px -3px rgba(37, 99, 235, 0.3); 
    }
    .header-text h1 { font-size: 26px; font-weight: 800; margin: 0; color: #111827; letter-spacing: -0.025em; line-height: 1.2; }
    .header-text p { margin: 2px 0 0 0; color: #6b7280; font-size: 14px; }

    .clean-card {
        background: white; border-radius: 16px;
        border: 1px solid #e5e7eb;
        padding: 24px;
        margin-bottom: 24px;
        box-shadow: 0 1px 3px rgba(0,0,0,0.05);
    }
    .card-title { font-size: 16px; font-weight: 700; color: #111827; margin-bottom: 20px; display: block; }

    .filter-grid { display: grid; grid-template-columns: repeat(4, 1fr); gap: 15px; align-items: end; }
    @media (max-width: 768px) { .filter-grid { grid-template-columns: 1fr; } }

    .form-group label { font-size: 13px; font-weight: 600; color: #374151; margin-bottom: 6px; display: block; }
    .form-control-clean {
        width: 100%; padding: 10px 14px; border-radius: 8px; border: 1px solid #d1d5db;
        font-size: 14px; color: #111; outline: none; transition: border 0.2s;
    }
    .form-control-clean:focus { border-color: #2563eb; ring: 2px solid #bfdbfe; }
    
    .btn-filter {
        background: #2563eb; color: white; border: none; padding: 11px 20px;
        border-radius: 8px; font-weight: 600; cursor: pointer; width: 100%;
        display: flex; align-items: center; justify-content: center; gap: 8px;
        transition: background 0.2s;
    }
    .btn-filter:hover { background: #1d4ed8; }

    .summary-box {
        padding: 20px; border-radius: 12px; margin-bottom: 15px;
        border-left: 5px solid transparent;
        background: #fff; border: 1px solid #e5e7eb;
    }
    .sb-blue { border-left: 5px solid #2563eb; background: #f0f9ff; }
    .sb-red { border-left: 5px solid #ef4444; background: #fef2f2; }

    .sb-label { font-size: 13px; font-weight: 600; color: #6b7280; text-transform: uppercase; letter-spacing: 0.5px; }
    .sb-value { font-size: 24px; font-weight: 800; margin-top: 5px; }
    .val-blue { color: #2563eb; }
    .val-red { color: #ef4444; }

    .clean-table { width: 100%; border-collapse: collapse; font-size: 14px; }
    .clean-table th { 
        text-align: left; padding: 12px 16px; 
        background: #f9fafb; color: #6b7280; font-weight: 600; 
        border-bottom: 1px solid #e5e7eb;
    }
    .clean-table td { 
        padding: 14px 16px; border-bottom: 1px solid #f3f4f6; color: #374151; vertical-align: middle;
    }
    .clean-table tr:last-child td { border-bottom: none; }
    .clean-table tr:hover td { background: #f8fafc; }

    .badge-status { padding: 4px 10px; border-radius: 6px; font-size: 12px; font-weight: 600; display: inline-block; }
    .bs-pending { background: #fef9c3; color: #854d0e; }
    .bs-approved { background: #dcfce7; color: #166534; }
    .bs-rejected { background: #fee2e2; color: #991b1b; }

    .mb-30 { margin-bottom: 30px; }
</style>

<div class="admin-wrapper">

    <div class="page-header-custom">
        <div class="header-left">
            <a href="DashboardAdmin" style="background:#fff; width:40px; height:40px; border-radius:10px; display:flex; align-items:center; justify-content:center; color:#2563eb; box-shadow:0 2px 5px rgba(0,0,0,0.05); text-decoration:none; margin-right:5px; transition:transform 0.2s;">
                <i class="fas fa-arrow-left"></i>
            </a>
            <div class="header-icon-box"><i class="fas fa-chart-pie"></i></div>
            <div class="header-text">
                <h1>Laporan Reimbursement</h1>
                <p>Analisis pengeluaran dan rincian data</p>
            </div>
        </div>
    </div>

    <div class="clean-card">
        <form method="GET" action="">
            <div class="filter-grid">
                <div class="form-group">
                    <label>Dari Tanggal</label>
                    <input type="date" name="start_date" class="form-control-clean" value="<?= $f_start ?>">
                </div>
                <div class="form-group">
                    <label>Sampai Tanggal</label>
                    <input type="date" name="end_date" class="form-control-clean" value="<?= $f_end ?>">
                </div>
                <div class="form-group">
                    <label>Project</label>
                    <select name="project_id" class="form-control-clean">
                        <option value="">Semua Project</option>
                        <?php
                        $projs = ExecuteRows("SELECT ProjectID, ProjectName FROM mtproject ORDER BY ProjectName");
                        foreach ($projs as $p) {
                            $sel = ($p['ProjectID'] == $f_proj) ? 'selected' : '';
                            echo "<option value='{$p['ProjectID']}' $sel>{$p['ProjectName']}</option>";
                        }
                        ?>
                    </select>
                </div>
                <div class="form-group">
                    <button type="submit" class="btn-filter"><i class="fas fa-search"></i> Tampilkan Data</button>
                </div>
            </div>
        </form>
    </div>

    <div class="row mb-30"> 
        
        <div class="col-md-4">
            <div class="clean-card" style="height: 100%; display: flex; flex-direction: column; justify-content: center;">
                
                <div class="summary-box sb-blue">
                    <div class="sb-label"><i class="fas fa-check-circle"></i> Total Disetujui</div>
                    <div class="sb-value val-blue">
                        Rp <?= number_format($grandTotalApproved, 0, ',', '.') ?>
                    </div>
                </div>

                <div class="summary-box sb-red">
                    <div class="sb-label"><i class="fas fa-times-circle"></i> Total Ditolak</div>
                    <div class="sb-value val-red">
                        Rp <?= number_format($grandTotalRejected, 0, ',', '.') ?>
                    </div>
                </div>

                <div style="font-size: 13px; color: #6b7280; text-align: center; margin-top: 10px;">
                    <i class="fas fa-info-circle"></i> Berdasarkan filter periode
                </div>
            </div>
        </div>

        <div class="col-md-8">
            <div class="clean-card" style="height: 100%; min-height: 350px;">
                <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:15px;">
                    <span class="card-title" style="margin:0;">Grafik Biaya per Project</span>
                    <div style="font-size:12px; display:flex; gap:10px;">
                        <span style="display:flex; align-items:center; gap:5px;"><span style="width:10px; height:10px; background:#2563eb; border-radius:50%;"></span> Disetujui</span>
                        <span style="display:flex; align-items:center; gap:5px;"><span style="width:10px; height:10px; background:#ef4444; border-radius:50%;"></span> Ditolak</span>
                    </div>
                </div>
                
                <div style="height: 280px; position: relative;">
                    <canvas id="reimbChart"></canvas>
                </div>
            </div>
        </div>
    </div>
    <div class="clean-card" style="margin-top: 40px;"> <div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px;">
            <span class="card-title" style="margin-bottom: 0;">Rincian Data Transaksi</span>
            <span style="font-size: 13px; color: #6b7280;">Menampilkan <?= count($rows) ?> data</span>
        </div>
        
        <div style="overflow-x: auto;">
            <table class="clean-table">
                <thead>
                    <tr>
                        <th style="width: 50px;">No</th>
                        <th>Tanggal</th>
                        <th>Requester</th>
                        <th>Project</th>
                        <th>Keterangan</th>
                        <th>Status</th>
                        <th style="text-align: right;">Jumlah (Rp)</th>
                    </tr>
                </thead>
                <tbody>
                <?php if (count($rows) > 0): ?>
                    <?php $no = 1; foreach ($rows as $row): ?>
                        <?php 
                            $stClass = 'bs-pending'; $stText = 'Pending';
                            if (!empty($row['RejectedDateTime'])) { $stClass = 'bs-rejected'; $stText = 'Rejected'; }
                            elseif (!empty($row['ApprovedDateTime'])) { $stClass = 'bs-approved'; $stText = 'Approved'; }
                            
                            $reqName = "User #" . $row['MTUserRequesterID'];
                            if (!empty($row['MTUserRequesterID'])) {
                                $uName = ExecuteScalar("SELECT FullName FROM mtuser WHERE ID = " . $row['MTUserRequesterID']);
                                if ($uName) $reqName = $uName;
                            }
                        ?>
                        <tr>
                            <td><?= $no++ ?></td>
                            <td><?= fmtTgl($row['RequestDateTime']) ?></td>
                            <td>
                                <div style="font-weight: 600;"><?= $reqName ?></div>
                            </td>
                            <td><?= $row['ProjectName'] ?? '-' ?></td>
                            <td><?= $row['Description'] ?></td>
                            <td><span class="badge-status <?= $stClass ?>"><?= $stText ?></span></td>
                            <td style="text-align: right; font-weight: 600;"><?= number_format($row['Amount'], 0, ',', '.') ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="7" style="text-align: center; padding: 40px; color: #9ca3af;">
                            Tidak ada data ditemukan untuk periode ini.
                        </td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
$(function () {
    var ctx = document.getElementById('reimbChart').getContext('2d');
    
    var labels = <?= json_encode($labels) ?>;
    var dataApp = <?= json_encode($dataApproved) ?>;
    var dataRej = <?= json_encode($dataRejected) ?>;

    if (labels.length === 0) {
        labels = ['Tidak ada data'];
        dataApp = [0];
        dataRej = [0];
    }

    new Chart(ctx, {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [
                {
                    label: 'Disetujui',
                    data: dataApp,
                    backgroundColor: '#2563eb',
                    borderRadius: 4,
                    barThickness: 'flex',
                    maxBarThickness: 40
                },
                {
                    label: 'Ditolak',
                    data: dataRej,
                    backgroundColor: '#ef4444',
                    borderRadius: 4,
                    barThickness: 'flex',
                    maxBarThickness: 40
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: { display: false },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            let label = context.dataset.label || '';
                            if (label) {
                                label += ': ';
                            }
                            if (context.parsed.y !== null) {
                                label += new Intl.NumberFormat('id-ID', { style: 'currency', currency: 'IDR' }).format(context.parsed.y);
                            }
                            return label;
                        }
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    grid: { borderDash: [2, 4], color: '#f3f4f6' },
                    ticks: { 
                        font: { size: 11 },
                        callback: function(value) {
                            if(value >= 1000000) return (value/1000000) + 'jt';
                            if(value >= 1000) return (value/1000) + 'rb';
                            return value;
                        }
                    }
                },
                x: {
                    grid: { display: false }
                }
            }
        }
    });
});
</script>
