<?php

namespace PHPMaker2026\Reimbursement;
?>
<?= $Page->getPageHeader() ?>
<?= $Page->getHtmlMessage() ?>
<main class="edit">
<?php $formAction = UrlFor("edit.trreimbursement", $Page->getUrlKey(true)) ?>
<form name="ftrreimbursementedit" id="ftrreimbursementedit" class="<?= $Page->FormClassName ?>" action="<?= $formAction ?>" method="post" novalidate autocomplete="off">
<script<?= Nonce() ?>>
var currentTable = <?= json_encode($Page->getClientVars()) ?>;
ew.deepAssign(ew.vars, { tables: { trreimbursement: currentTable } });
var currentPageID = ew.PAGE_ID = "edit";
var currentForm;
var ftrreimbursementedit;
ew.on("wrapper", function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("ftrreimbursementedit")
        .setPageId("edit")

        // Add fields
        .setFields([
            ["ID", [fields.ID.visible && fields.ID.required ? ew.Validators.required(fields.ID.caption) : null], fields.ID.isInvalid],
            ["MTReimbursementTypeID", [fields.MTReimbursementTypeID.visible && fields.MTReimbursementTypeID.required ? ew.Validators.required(fields.MTReimbursementTypeID.caption) : null], fields.MTReimbursementTypeID.isInvalid],
            ["_Title", [fields._Title.visible && fields._Title.required ? ew.Validators.required(fields._Title.caption) : null], fields._Title.isInvalid],
            ["Description", [fields.Description.visible && fields.Description.required ? ew.Validators.required(fields.Description.caption) : null], fields.Description.isInvalid],
            ["Amount", [fields.Amount.visible && fields.Amount.required ? ew.Validators.required(fields.Amount.caption) : null, ew.Validators.float], fields.Amount.isInvalid],
            ["Attachment", [fields.Attachment.visible && fields.Attachment.required ? ew.Validators.fileRequired(fields.Attachment.caption) : null], fields.Attachment.isInvalid],
            ["_ProjectID", [fields._ProjectID.visible && fields._ProjectID.required ? ew.Validators.required(fields._ProjectID.caption) : null], fields._ProjectID.isInvalid]
        ])

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "MTReimbursementTypeID": <?= $Page->MTReimbursementTypeID->toClientList($Page) ?>,
            "_ProjectID": <?= $Page->_ProjectID->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    ew.emit(form.id);
});
</script>
<script<?= Nonce() ?>>
ew.on("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php if (Config("CSRF_PROTECTION")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token ID -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="trreimbursement">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php if (IsJsonResponse()) { ?>
<input type="hidden" name="json" value="1">
<?php } ?>
<input type="hidden" name="<?= $Page->getFormOldKeyName() ?>" value="<?= $Page->getOldKeyAsString() ?>">
<div class="ew-edit-div d-none"><!-- page* -->
<?php if ($Page->ID->Visible) { // ID ?>
    <div id="r_ID"<?= $Page->ID->rowAttributes() ?>>
        <label id="elh_trreimbursement_ID" class="<?= $Page->LeftColumnClass ?>"><template id="tpc_trreimbursement_ID"><?= $Page->ID->caption() ?><?= $Page->ID->Required ? Language()->phrase("FieldRequiredIndicator") : "" ?></template></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->ID->cellAttributes() ?>>
<template id="tpx_trreimbursement_ID"><span id="el_trreimbursement_ID">
<span<?= $Page->ID->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?= $Page->ID->getDisplayValue($Page->ID->getEditValue()) ?>"></span>
<input type="hidden" data-table="trreimbursement" data-field="x_ID" data-hidden="1" name="x_ID" id="x_ID" value="<?= HtmlEncode(ConvertToString($Page->ID->CurrentValue)) ?>">
</span></template>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->MTReimbursementTypeID->Visible) { // MTReimbursementTypeID ?>
    <div id="r_MTReimbursementTypeID"<?= $Page->MTReimbursementTypeID->rowAttributes() ?>>
        <label id="elh_trreimbursement_MTReimbursementTypeID" for="x_MTReimbursementTypeID" class="<?= $Page->LeftColumnClass ?>"><template id="tpc_trreimbursement_MTReimbursementTypeID"><?= $Page->MTReimbursementTypeID->caption() ?><?= $Page->MTReimbursementTypeID->Required ? Language()->phrase("FieldRequiredIndicator") : "" ?></template></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->MTReimbursementTypeID->cellAttributes() ?>>
<template id="tpx_trreimbursement_MTReimbursementTypeID"><span id="el_trreimbursement_MTReimbursementTypeID">
    <select
        id="x_MTReimbursementTypeID"
        name="x_MTReimbursementTypeID"
        class="form-select ew-select<?= $Page->MTReimbursementTypeID->isInvalidClass() ?>"
        <?php if (!$Page->MTReimbursementTypeID->IsNativeSelect) { ?>
        data-select2-id="ftrreimbursementedit_x_MTReimbursementTypeID"
        <?php } ?>
        data-table="trreimbursement"
        data-field="x_MTReimbursementTypeID"
        data-value-separator="<?= $Page->MTReimbursementTypeID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->MTReimbursementTypeID->getPlaceHolder()) ?>"
        <?= $Page->MTReimbursementTypeID->editAttributes() ?>>
        <?= $Page->MTReimbursementTypeID->selectOptionListHtml("x_MTReimbursementTypeID") ?>
    </select>
    <?= $Page->MTReimbursementTypeID->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->MTReimbursementTypeID->getErrorMessage() ?></div>
<?= $Page->MTReimbursementTypeID->Lookup->getParamTag($Page, "p_x_MTReimbursementTypeID") ?>
<?php if (!$Page->MTReimbursementTypeID->IsNativeSelect) { ?>
<script<?= Nonce() ?>>
ew.on("ftrreimbursementedit", function() {
    var options = { name: "x_MTReimbursementTypeID", selectId: "ftrreimbursementedit_x_MTReimbursementTypeID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ftrreimbursementedit.lists.MTReimbursementTypeID?.lookupOptions.length) {
        options.data = { id: "x_MTReimbursementTypeID", form: "ftrreimbursementedit" };
    } else {
        options.ajax = { id: "x_MTReimbursementTypeID", form: "ftrreimbursementedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.trreimbursement.fields.MTReimbursementTypeID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_Title->Visible) { // Title ?>
    <div id="r__Title"<?= $Page->_Title->rowAttributes() ?>>
        <label id="elh_trreimbursement__Title" for="x__Title" class="<?= $Page->LeftColumnClass ?>"><template id="tpc_trreimbursement__Title"><?= $Page->_Title->caption() ?><?= $Page->_Title->Required ? Language()->phrase("FieldRequiredIndicator") : "" ?></template></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_Title->cellAttributes() ?>>
<template id="tpx_trreimbursement__Title"><span id="el_trreimbursement__Title">
<input type="<?= $Page->_Title->getInputTextType() ?>" name="x__Title" id="x__Title" data-table="trreimbursement" data-field="x__Title" value="<?= $Page->_Title->getEditValue() ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->_Title->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->_Title->formatPattern()) ?>"<?= $Page->_Title->editAttributes() ?> aria-describedby="x__Title_help">
<?= $Page->_Title->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->_Title->getErrorMessage() ?></div>
</span></template>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Description->Visible) { // Description ?>
    <div id="r_Description"<?= $Page->Description->rowAttributes() ?>>
        <label id="elh_trreimbursement_Description" for="x_Description" class="<?= $Page->LeftColumnClass ?>"><template id="tpc_trreimbursement_Description"><?= $Page->Description->caption() ?><?= $Page->Description->Required ? Language()->phrase("FieldRequiredIndicator") : "" ?></template></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Description->cellAttributes() ?>>
<template id="tpx_trreimbursement_Description"><span id="el_trreimbursement_Description">
<textarea data-table="trreimbursement" data-field="x_Description" name="x_Description" id="x_Description" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->Description->getPlaceHolder()) ?>"<?= $Page->Description->editAttributes() ?> aria-describedby="x_Description_help"><?= $Page->Description->getEditValue() ?></textarea>
<?= $Page->Description->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Description->getErrorMessage() ?></div>
</span></template>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Amount->Visible) { // Amount ?>
    <div id="r_Amount"<?= $Page->Amount->rowAttributes() ?>>
        <label id="elh_trreimbursement_Amount" for="x_Amount" class="<?= $Page->LeftColumnClass ?>"><template id="tpc_trreimbursement_Amount"><?= $Page->Amount->caption() ?><?= $Page->Amount->Required ? Language()->phrase("FieldRequiredIndicator") : "" ?></template></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Amount->cellAttributes() ?>>
<template id="tpx_trreimbursement_Amount"><span id="el_trreimbursement_Amount">
<input type="<?= $Page->Amount->getInputTextType() ?>" name="x_Amount" id="x_Amount" data-table="trreimbursement" data-field="x_Amount" value="<?= $Page->Amount->getEditValue() ?>" size="30" placeholder="<?= HtmlEncode($Page->Amount->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Amount->formatPattern()) ?>"<?= $Page->Amount->editAttributes() ?> aria-describedby="x_Amount_help">
<?= $Page->Amount->getCustomMessage() ?>
<div class="invalid-feedback"><?= $Page->Amount->getErrorMessage() ?></div>
</span></template>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->Attachment->Visible) { // Attachment ?>
    <div id="r_Attachment"<?= $Page->Attachment->rowAttributes() ?>>
        <label id="elh_trreimbursement_Attachment" class="<?= $Page->LeftColumnClass ?>"><template id="tpc_trreimbursement_Attachment"><?= $Page->Attachment->caption() ?><?= $Page->Attachment->Required ? Language()->phrase("FieldRequiredIndicator") : "" ?></template></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->Attachment->cellAttributes() ?>>
<template id="tpx_trreimbursement_Attachment"><span id="el_trreimbursement_Attachment">
<div id="fd_x_Attachment" class="fileinput-button ew-file-drop-zone">
    <input
        type="file"
        id="x_Attachment"
        name="x_Attachment"
        class="form-control ew-file-input"
        title="<?= $Page->Attachment->title() ?>"
        lang="<?= CurrentLanguageID() ?>"
        data-table="trreimbursement"
        data-field="x_Attachment"
        data-size="200"
        data-accept-file-types="<?= $Page->Attachment->acceptFileTypes() ?>"
        data-max-file-size="<?= $Page->Attachment->UploadMaxFileSize ?>"
        data-max-number-of-files="null"
        data-disable-image-crop="<?= $Page->Attachment->ImageCropper ? 0 : 1 ?>"
        aria-describedby="x_Attachment_help"
        <?= ($Page->Attachment->ReadOnly || $Page->Attachment->Disabled) ? " disabled" : "" ?>
        <?= $Page->Attachment->editAttributes() ?>
    >
    <div class="text-body-secondary ew-file-text"><?= Language()->phrase("ChooseFile") ?></div>
    <?= $Page->Attachment->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->Attachment->getErrorMessage() ?></div>
</div>
<input type="hidden" name="fn_x_Attachment" id= "fn_x_Attachment" value="<?= $Page->Attachment->Upload->FileName ?>">
<input type="hidden" name="fa_x_Attachment" id= "fa_x_Attachment" value="<?= (Post("fa_x_Attachment") == "0") ? "0" : "1" ?>">
<table id="ft_x_Attachment" class="table table-sm float-start ew-upload-table"><tbody class="files"></tbody></table>
</span></template>
</div></div>
    </div>
<?php } ?>
<?php if ($Page->_ProjectID->Visible) { // ProjectID ?>
    <div id="r__ProjectID"<?= $Page->_ProjectID->rowAttributes() ?>>
        <label id="elh_trreimbursement__ProjectID" for="x__ProjectID" class="<?= $Page->LeftColumnClass ?>"><template id="tpc_trreimbursement__ProjectID"><?= $Page->_ProjectID->caption() ?><?= $Page->_ProjectID->Required ? Language()->phrase("FieldRequiredIndicator") : "" ?></template></label>
        <div class="<?= $Page->RightColumnClass ?>"><div<?= $Page->_ProjectID->cellAttributes() ?>>
<template id="tpx_trreimbursement__ProjectID"><span id="el_trreimbursement__ProjectID">
    <select
        id="x__ProjectID"
        name="x__ProjectID"
        class="form-select ew-select<?= $Page->_ProjectID->isInvalidClass() ?>"
        <?php if (!$Page->_ProjectID->IsNativeSelect) { ?>
        data-select2-id="ftrreimbursementedit_x__ProjectID"
        <?php } ?>
        data-table="trreimbursement"
        data-field="x__ProjectID"
        data-value-separator="<?= $Page->_ProjectID->displayValueSeparatorAttribute() ?>"
        data-placeholder="<?= HtmlEncode($Page->_ProjectID->getPlaceHolder()) ?>"
        <?= $Page->_ProjectID->editAttributes() ?>>
        <?= $Page->_ProjectID->selectOptionListHtml("x__ProjectID") ?>
    </select>
    <?= $Page->_ProjectID->getCustomMessage() ?>
    <div class="invalid-feedback"><?= $Page->_ProjectID->getErrorMessage() ?></div>
<?= $Page->_ProjectID->Lookup->getParamTag($Page, "p_x__ProjectID") ?>
<?php if (!$Page->_ProjectID->IsNativeSelect) { ?>
<script<?= Nonce() ?>>
ew.on("ftrreimbursementedit", function() {
    var options = { name: "x__ProjectID", selectId: "ftrreimbursementedit_x__ProjectID" },
        el = document.querySelector("select[data-select2-id='" + options.selectId + "']");
    if (!el)
        return;
    options.closeOnSelect = !options.multiple;
    options.dropdownParent = el.closest("#ew-modal-dialog, #ew-add-opt-dialog");
    if (ftrreimbursementedit.lists._ProjectID?.lookupOptions.length) {
        options.data = { id: "x__ProjectID", form: "ftrreimbursementedit" };
    } else {
        options.ajax = { id: "x__ProjectID", form: "ftrreimbursementedit", limit: ew.LOOKUP_PAGE_SIZE };
    }
    options.minimumResultsForSearch = Infinity;
    options = Object.assign({}, ew.selectOptions, options, ew.vars.tables.trreimbursement.fields._ProjectID.selectOptions);
    ew.createSelect(options);
});
</script>
<?php } ?>
</span></template>
</div></div>
    </div>
<?php } ?>
</div><!-- /page* -->
<div id="tpd_trreimbursementedit" class="ew-custom-template"></div>
<template id="tpm_trreimbursementedit">
<div id="ct_TrreimbursementEdit"><style>
    .content-header { 
        display: none !important; 
    }
    .ew-buttons { 
        display: none !important; 
    }
    .content-wrapper {
        background-color: #f4f6f9 !important;
        display: flex !important;
        justify-content: center !important;
        align-items: flex-start !important;
        min-height: 100vh !important;
    }
    .ew-form-label { display: none !important; }
    .row.mb-3 { margin-bottom: 0 !important; }
    .reimburse-form-card {
        background: #fff;
        border-radius: 12px;
        border: 1px solid #e5e7eb;
        padding: 40px;
        max-width: 700px;
        margin: 30px auto;
        box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.05);
        font-family: 'Segoe UI', sans-serif;
    }
    .form-title { font-size: 24px; font-weight: 700; color: #111; margin-bottom: 8px; }
    .form-desc { color: #6b7280; font-size: 14px; margin-bottom: 30px; line-height: 1.5; }
    .custom-label {
        font-weight: 600; color: #374151; margin-bottom: 8px; display: block; font-size: 14px;
    }
    .form-control, .form-select {
        display: block;
        width: 100%;
        padding: 10px 12px;
        font-size: 14px;
        line-height: 1.5;
        color: #1f2937;
        background-color: #fff;
        border: 1px solid #d1d5db;
        border-radius: 6px;
        margin-bottom: 0;
    }
    .form-control:focus, .form-select:focus {
        border-color: #2563eb;
        box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1);
        outline: none;
    }
    textarea.form-control { min-height: 100px; }
    .btn-submit-black {
        background-color: #111;
        color: #fff;
        width: 100%;
        padding: 12px;
        border-radius: 8px;
        font-weight: 600;
        font-size: 14px;
        border: none;
        cursor: pointer;
        margin-top: 10px;
        transition: background 0.2s;
    }
    .btn-submit-black:hover { background-color: #333; color: #fff; }
    .ew-file-upload { 
        width: 100%; 
    }
    .dropzone {
        border: 2px dashed #d1d5db !important;
        border-radius: 8px !important;
        background: #f9fafb !important;
        padding: 20px !important;
        text-align: center !important;
        min-height: auto !important;
    }
    .dropzone .dz-message { margin: 0 !important; font-size: 13px; color: #6b7280; }
    .btn-back {
        display: inline-flex; align-items: center; gap: 5px;
        text-decoration: none; color: #6b7280; font-size: 13px; font-weight: 600;
        margin-bottom: 15px; transition: color 0.2s;
    }
    .btn-back:hover { color: #111; }
</style>
<div class="reimburse-form-card">
    <a href="DashboardPanel" class="btn-back">
        <i class="fas fa-arrow-left"></i> Kembali
    </a>
    <h1 class="form-title">Ajukan Reimbursement</h1>
    <p class="form-desc">Isi formulir di bawah ini untuk mengajukan reimbursement travel atau kerusakan peralatan.</p>
    <div class="mb-4">
        <label class="custom-label">Project</label>
        <slot class="ew-slot" name="tpx_trreimbursement__ProjectID"></slot>
    </div
    <div class="mb-4">
        <label class="custom-label">Tipe Reimbursement</label>
        <slot class="ew-slot" name="tpx_trreimbursement_MTReimbursementTypeID"></slot>
    </div>
    <div class="mb-4">
        <label class="custom-label">Judul</label>
        <slot class="ew-slot" name="tpx_trreimbursement__Title"></slot>
        <div style="font-size: 12px; color: #9ca3af; margin-top: 4px;">Contoh: Perjalanan ke Jakarta</div>
    </div>
    <div class="mb-4">
        <label class="custom-label">Deskripsi</label>
        <slot class="ew-slot" name="tpx_trreimbursement_Description"></slot>
    </div>
    <div class="mb-4">
        <label class="custom-label">Jumlah (Rp)</label>
        <slot class="ew-slot" name="tpx_trreimbursement_Amount"></slot>
    </div>
    <div class="mb-4">
        <label class="custom-label">Bukti / Kuitansi</label>
        <div style="width: 100%;">
            <slot class="ew-slot" name="tpx_trreimbursement_Attachment"></slot>
        </div>
        <div style="font-size: 12px; color: #9ca3af; margin-top: 4px;">Format: JPG, PNG, PDF (Max 2MB)</div>
    </div>
    <button type="submit" class="btn-submit-black">
        Ajukan Reimbursement
    </button>
</div></div>
</template>
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn ew-submit" name="btn-action" id="btn-action" type="submit" form="ftrreimbursementedit" formaction="<?= $formAction ?>"><?= Language()->phrase("SaveBtn") ?></button>
<?php if (IsJsonResponse()) { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-bs-dismiss="modal"><?= Language()->phrase("CancelBtn") ?></button>
<?php } else { ?>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="ftrreimbursementedit" formaction="<?= $formAction ?>" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= Language()->phrase("CancelBtn") ?></button>
<?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<script<?= Nonce() ?> class="ew-apply-template">
ew.on("wrapper", function() {
    ew.templateData = { rows: <?= JsonEncode($Page->Rows) ?> };
    ew.applyTemplate("tpd_trreimbursementedit", "tpm_trreimbursementedit", "trreimbursementedit", "<?= $Page->Export ?>", "trreimbursement", ew.templateData.rows[0], <?= $Page->IsModal ? "true" : "false" ?>);
    ew.emit("customtemplate");
});
</script>
</main>
<?= $Page->getPageFooter() ?>
<script<?= Nonce() ?>>
// Field event handlers
ew.on("head", function() {
    ew.addEventHandlers("trreimbursement");
});
</script>
<script<?= Nonce() ?>>
ew.on("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
