<?php

namespace PHPMaker2026\Reimbursement;
?>
<script<?= Nonce() ?>>
var currentTable = <?= json_encode($Page->getClientVars()) ?>;
ew.deepAssign(ew.vars, { tables: { mtuserlevel: currentTable } });
var currentPageID = ew.PAGE_ID = "userpriv";
var currentForm;
var fuserpriv;
ew.on("wrapper", function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fuserpriv")
        .setPageId("userpriv")
        .build();
    window[form.id] = form;
    currentForm = form;
    ew.emit(form.id);
});
</script>
<script<?= Nonce() ?>>
var headerSortTristate = false,
    tableOptions = {
        locale: ew.LANGUAGE_ID,
        langs: {
            [ew.LANGUAGE_ID]: {
                "data": {
                    "loading": ew.language.phrase("Loading"),
                    "error": ew.language.phrase("Error")
                }
            }
        }
    },
    priv = <?= json_encode($Page->Privileges) ?>;
</script>
<style<?= Nonce() ?>>
main .tooltip {
    --bs-tooltip-max-width: 500px;
}
</style>
<script<?= Nonce() ?>>
ew.on("head", function () {
    // Write your client script here, no need to add script tags.
});
</script>
<?= $Page->getHtmlMessage() ?>
<main>
<form name="fuserpriv" id="fuserpriv" class="ew-form ew-user-priv-form w-100" action="<?= CurrentPageUrl(false) ?>" method="post" novalidate autocomplete="off">
<?php if (Config("CSRF_PROTECTION")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token ID -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="mtuserlevel">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="x_UserLevelID" id="x_UserLevelID" value="<?= $Page->UserLevelID->CurrentValue ?>">
<div class="ew-desktop">
<div class="card ew-card ew-user-priv">
<div class="card-header">
    <h3 class="card-title"><?= Language()->phrase("UserLevel") ?><?= $Security->getUserLevelName((int)$Page->UserLevelID->CurrentValue) ?> (<?= $Page->UserLevelID->CurrentValue ?>)</h3>
    <div class="card-tools float-none float-sm-end">
        <div class="input-group">
            <span class="input-group-text"><i class="fa-solid fa-magnifying-glass"></i></span>
            <input type="text" name="table-name" id="table-name" class="form-control form-control-sm" placeholder="<?= HtmlEncode(Language()->phrase("Search", true)) ?>">
        </div>
    </div>
</div>
<div class="card-body ew-card-body p-0 <?= $Page->ResponsiveTableClass ?>"></div>
</div>
<div class="ew-buttons ew-desktop-buttons">
<button class="btn btn-primary ew-btn ew-submit" name="btn-submit" id="btn-submit" type="submit"<?= $Page->Disabled ?>><?= Language()->phrase("Update") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= Language()->phrase("CancelBtn") ?></button>
</div>
</div>
</form>
</main>
<script<?= Nonce() ?>>
ew.on("load", function () {
    // Write your startup script here, no need to add script tags.
});
</script>
<script<?= Nonce() ?> src="js/userpriv.min.js?v=26.3.12"></script>
