<?php

namespace ProjectManagement\prjProjectManagement;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use ProjectManagement\prjProjectManagement\Attributes\Delete;
use ProjectManagement\prjProjectManagement\Attributes\Get;
use ProjectManagement\prjProjectManagement\Attributes\Map;
use ProjectManagement\prjProjectManagement\Attributes\Options;
use ProjectManagement\prjProjectManagement\Attributes\Patch;
use ProjectManagement\prjProjectManagement\Attributes\Post;
use ProjectManagement\prjProjectManagement\Attributes\Put;

class ManualdocumentController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/manualdocumentlist[/{ManualID}]", [PermissionMiddleware::class], "list.manualdocument")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ManualdocumentList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/manualdocumentadd[/{ManualID}]", [PermissionMiddleware::class], "add.manualdocument")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ManualdocumentAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/manualdocumentview[/{ManualID}]", [PermissionMiddleware::class], "view.manualdocument")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ManualdocumentView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/manualdocumentedit[/{ManualID}]", [PermissionMiddleware::class], "edit.manualdocument")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ManualdocumentEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/manualdocumentupdate", [PermissionMiddleware::class], "update.manualdocument")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ManualdocumentUpdate");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/manualdocumentdelete[/{ManualID}]", [PermissionMiddleware::class], "delete.manualdocument")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ManualdocumentDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/manualdocumentsearch", [PermissionMiddleware::class], "search.manualdocument")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ManualdocumentSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/manualdocumentquery", [PermissionMiddleware::class], "query.manualdocument")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ManualdocumentSearch", "ManualdocumentQuery");
    }
}
