<?php

namespace ProjectManagement\prjProjectManagement;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use ProjectManagement\prjProjectManagement\Attributes\Delete;
use ProjectManagement\prjProjectManagement\Attributes\Get;
use ProjectManagement\prjProjectManagement\Attributes\Map;
use ProjectManagement\prjProjectManagement\Attributes\Options;
use ProjectManagement\prjProjectManagement\Attributes\Patch;
use ProjectManagement\prjProjectManagement\Attributes\Post;
use ProjectManagement\prjProjectManagement\Attributes\Put;

class MasterclientController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/masterclientlist[/{ClientID}]", [PermissionMiddleware::class], "list.masterclient")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterclientList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/masterclientadd[/{ClientID}]", [PermissionMiddleware::class], "add.masterclient")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterclientAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/masterclientaddopt", [PermissionMiddleware::class], "addopt.masterclient")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterclientAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/masterclientview[/{ClientID}]", [PermissionMiddleware::class], "view.masterclient")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterclientView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/masterclientedit[/{ClientID}]", [PermissionMiddleware::class], "edit.masterclient")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterclientEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/masterclientupdate", [PermissionMiddleware::class], "update.masterclient")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterclientUpdate");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/masterclientdelete[/{ClientID}]", [PermissionMiddleware::class], "delete.masterclient")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterclientDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/masterclientsearch", [PermissionMiddleware::class], "search.masterclient")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterclientSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/masterclientquery", [PermissionMiddleware::class], "query.masterclient")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterclientSearch", "MasterclientQuery");
    }
}
