<?php

namespace ProjectManagement\prjProjectManagement;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use ProjectManagement\prjProjectManagement\Attributes\Delete;
use ProjectManagement\prjProjectManagement\Attributes\Get;
use ProjectManagement\prjProjectManagement\Attributes\Map;
use ProjectManagement\prjProjectManagement\Attributes\Options;
use ProjectManagement\prjProjectManagement\Attributes\Patch;
use ProjectManagement\prjProjectManagement\Attributes\Post;
use ProjectManagement\prjProjectManagement\Attributes\Put;

class MasterprojectController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/masterprojectlist[/{_ProjectID}]", [PermissionMiddleware::class], "list.masterproject")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterprojectList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/masterprojectadd[/{_ProjectID}]", [PermissionMiddleware::class], "add.masterproject")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterprojectAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/masterprojectview[/{_ProjectID}]", [PermissionMiddleware::class], "view.masterproject")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterprojectView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/masterprojectedit[/{_ProjectID}]", [PermissionMiddleware::class], "edit.masterproject")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterprojectEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/masterprojectupdate", [PermissionMiddleware::class], "update.masterproject")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterprojectUpdate");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/masterprojectdelete[/{_ProjectID}]", [PermissionMiddleware::class], "delete.masterproject")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterprojectDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/masterprojectsearch", [PermissionMiddleware::class], "search.masterproject")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterprojectSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/masterprojectquery", [PermissionMiddleware::class], "query.masterproject")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterprojectSearch", "MasterprojectQuery");
    }
}
