<?php

namespace ProjectManagement\prjProjectManagement;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use ProjectManagement\prjProjectManagement\Attributes\Delete;
use ProjectManagement\prjProjectManagement\Attributes\Get;
use ProjectManagement\prjProjectManagement\Attributes\Map;
use ProjectManagement\prjProjectManagement\Attributes\Options;
use ProjectManagement\prjProjectManagement\Attributes\Patch;
use ProjectManagement\prjProjectManagement\Attributes\Post;
use ProjectManagement\prjProjectManagement\Attributes\Put;

class MasterprojectcategoryController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/masterprojectcategorylist[/{CategoryID}]", [PermissionMiddleware::class], "list.masterprojectcategory")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterprojectcategoryList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/masterprojectcategoryadd[/{CategoryID}]", [PermissionMiddleware::class], "add.masterprojectcategory")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterprojectcategoryAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/masterprojectcategoryaddopt", [PermissionMiddleware::class], "addopt.masterprojectcategory")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterprojectcategoryAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/masterprojectcategoryview[/{CategoryID}]", [PermissionMiddleware::class], "view.masterprojectcategory")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterprojectcategoryView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/masterprojectcategoryedit[/{CategoryID}]", [PermissionMiddleware::class], "edit.masterprojectcategory")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterprojectcategoryEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/masterprojectcategorydelete[/{CategoryID}]", [PermissionMiddleware::class], "delete.masterprojectcategory")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterprojectcategoryDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/masterprojectcategorysearch", [PermissionMiddleware::class], "search.masterprojectcategory")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterprojectcategorySearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/masterprojectcategoryquery", [PermissionMiddleware::class], "query.masterprojectcategory")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterprojectcategorySearch", "MasterprojectcategoryQuery");
    }
}
