<?php

namespace ProjectManagement\prjProjectManagement;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use ProjectManagement\prjProjectManagement\Attributes\Delete;
use ProjectManagement\prjProjectManagement\Attributes\Get;
use ProjectManagement\prjProjectManagement\Attributes\Map;
use ProjectManagement\prjProjectManagement\Attributes\Options;
use ProjectManagement\prjProjectManagement\Attributes\Patch;
use ProjectManagement\prjProjectManagement\Attributes\Post;
use ProjectManagement\prjProjectManagement\Attributes\Put;

class MasterroleController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/masterrolelist[/{RoleID}]", [PermissionMiddleware::class], "list.masterrole")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterroleList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/masterroleadd[/{RoleID}]", [PermissionMiddleware::class], "add.masterrole")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterroleAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/masterroleaddopt", [PermissionMiddleware::class], "addopt.masterrole")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterroleAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/masterroleview[/{RoleID}]", [PermissionMiddleware::class], "view.masterrole")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterroleView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/masterroleedit[/{RoleID}]", [PermissionMiddleware::class], "edit.masterrole")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterroleEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/masterroledelete[/{RoleID}]", [PermissionMiddleware::class], "delete.masterrole")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterroleDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/masterrolesearch", [PermissionMiddleware::class], "search.masterrole")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterroleSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/masterrolequery", [PermissionMiddleware::class], "query.masterrole")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasterroleSearch", "MasterroleQuery");
    }
}
