<?php

namespace ProjectManagement\prjProjectManagement;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use ProjectManagement\prjProjectManagement\Attributes\Delete;
use ProjectManagement\prjProjectManagement\Attributes\Get;
use ProjectManagement\prjProjectManagement\Attributes\Map;
use ProjectManagement\prjProjectManagement\Attributes\Options;
use ProjectManagement\prjProjectManagement\Attributes\Patch;
use ProjectManagement\prjProjectManagement\Attributes\Post;
use ProjectManagement\prjProjectManagement\Attributes\Put;

class MasteruserController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/masteruserlist[/{EmployeeID}]", [PermissionMiddleware::class], "list.masteruser")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasteruserList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/masteruseradd[/{EmployeeID}]", [PermissionMiddleware::class], "add.masteruser")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasteruserAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/masteruseraddopt", [PermissionMiddleware::class], "addopt.masteruser")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasteruserAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/masteruserview[/{EmployeeID}]", [PermissionMiddleware::class], "view.masteruser")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasteruserView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/masteruseredit[/{EmployeeID}]", [PermissionMiddleware::class], "edit.masteruser")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasteruserEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/masteruserupdate", [PermissionMiddleware::class], "update.masteruser")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasteruserUpdate");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/masteruserdelete[/{EmployeeID}]", [PermissionMiddleware::class], "delete.masteruser")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasteruserDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/masterusersearch", [PermissionMiddleware::class], "search.masteruser")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasteruserSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/masteruserquery", [PermissionMiddleware::class], "query.masteruser")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "MasteruserSearch", "MasteruserQuery");
    }
}
