<?php

namespace ProjectManagement\prjProjectManagement;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use ProjectManagement\prjProjectManagement\Attributes\Delete;
use ProjectManagement\prjProjectManagement\Attributes\Get;
use ProjectManagement\prjProjectManagement\Attributes\Map;
use ProjectManagement\prjProjectManagement\Attributes\Options;
use ProjectManagement\prjProjectManagement\Attributes\Patch;
use ProjectManagement\prjProjectManagement\Attributes\Post;
use ProjectManagement\prjProjectManagement\Attributes\Put;

class ProjectdocumentsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/projectdocumentslist[/{DocID}]", [PermissionMiddleware::class], "list.projectdocuments")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectdocumentsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/projectdocumentsadd[/{DocID}]", [PermissionMiddleware::class], "add.projectdocuments")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectdocumentsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/projectdocumentsview[/{DocID}]", [PermissionMiddleware::class], "view.projectdocuments")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectdocumentsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/projectdocumentsedit[/{DocID}]", [PermissionMiddleware::class], "edit.projectdocuments")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectdocumentsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/projectdocumentsdelete[/{DocID}]", [PermissionMiddleware::class], "delete.projectdocuments")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectdocumentsDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/projectdocumentssearch", [PermissionMiddleware::class], "search.projectdocuments")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectdocumentsSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/projectdocumentsquery", [PermissionMiddleware::class], "query.projectdocuments")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectdocumentsSearch", "ProjectdocumentsQuery");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/projectdocumentspreview", [PermissionMiddleware::class], "preview.projectdocuments")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectdocumentsPreview", null, false);
    }
}
