<?php

namespace ProjectManagement\prjProjectManagement;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use ProjectManagement\prjProjectManagement\Attributes\Delete;
use ProjectManagement\prjProjectManagement\Attributes\Get;
use ProjectManagement\prjProjectManagement\Attributes\Map;
use ProjectManagement\prjProjectManagement\Attributes\Options;
use ProjectManagement\prjProjectManagement\Attributes\Patch;
use ProjectManagement\prjProjectManagement\Attributes\Post;
use ProjectManagement\prjProjectManagement\Attributes\Put;

class ProjectmemberController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/projectmemberlist[/{MemberID}]", [PermissionMiddleware::class], "list.projectmember")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectmemberList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/projectmemberadd[/{MemberID}]", [PermissionMiddleware::class], "add.projectmember")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectmemberAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/projectmemberview[/{MemberID}]", [PermissionMiddleware::class], "view.projectmember")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectmemberView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/projectmemberedit[/{MemberID}]", [PermissionMiddleware::class], "edit.projectmember")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectmemberEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/projectmemberupdate", [PermissionMiddleware::class], "update.projectmember")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectmemberUpdate");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/projectmemberdelete[/{MemberID}]", [PermissionMiddleware::class], "delete.projectmember")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectmemberDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/projectmembersearch", [PermissionMiddleware::class], "search.projectmember")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectmemberSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/projectmemberquery", [PermissionMiddleware::class], "query.projectmember")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectmemberSearch", "ProjectmemberQuery");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/projectmemberpreview", [PermissionMiddleware::class], "preview.projectmember")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectmemberPreview", null, false);
    }
}
