<?php

namespace ProjectManagement\prjProjectManagement;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use ProjectManagement\prjProjectManagement\Attributes\Delete;
use ProjectManagement\prjProjectManagement\Attributes\Get;
use ProjectManagement\prjProjectManagement\Attributes\Map;
use ProjectManagement\prjProjectManagement\Attributes\Options;
use ProjectManagement\prjProjectManagement\Attributes\Patch;
use ProjectManagement\prjProjectManagement\Attributes\Post;
use ProjectManagement\prjProjectManagement\Attributes\Put;

class ProjectmomController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/projectmomlist[/{MOMID}]", [PermissionMiddleware::class], "list.projectmom")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectmomList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/projectmomadd[/{MOMID}]", [PermissionMiddleware::class], "add.projectmom")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectmomAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/projectmomview[/{MOMID}]", [PermissionMiddleware::class], "view.projectmom")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectmomView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/projectmomedit[/{MOMID}]", [PermissionMiddleware::class], "edit.projectmom")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectmomEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/projectmomdelete[/{MOMID}]", [PermissionMiddleware::class], "delete.projectmom")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectmomDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/projectmomsearch", [PermissionMiddleware::class], "search.projectmom")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectmomSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/projectmomquery", [PermissionMiddleware::class], "query.projectmom")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectmomSearch", "ProjectmomQuery");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/projectmompreview", [PermissionMiddleware::class], "preview.projectmom")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectmomPreview", null, false);
    }
}
