<?php

namespace ProjectManagement\prjProjectManagement;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use ProjectManagement\prjProjectManagement\Attributes\Delete;
use ProjectManagement\prjProjectManagement\Attributes\Get;
use ProjectManagement\prjProjectManagement\Attributes\Map;
use ProjectManagement\prjProjectManagement\Attributes\Options;
use ProjectManagement\prjProjectManagement\Attributes\Patch;
use ProjectManagement\prjProjectManagement\Attributes\Post;
use ProjectManagement\prjProjectManagement\Attributes\Put;

class ProjectpaymentprocessController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/projectpaymentprocesslist[/{PaymentProcessID}]", [PermissionMiddleware::class], "list.projectpaymentprocess")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectpaymentprocessList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/projectpaymentprocessadd[/{PaymentProcessID}]", [PermissionMiddleware::class], "add.projectpaymentprocess")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectpaymentprocessAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/projectpaymentprocessview[/{PaymentProcessID}]", [PermissionMiddleware::class], "view.projectpaymentprocess")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectpaymentprocessView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/projectpaymentprocessedit[/{PaymentProcessID}]", [PermissionMiddleware::class], "edit.projectpaymentprocess")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectpaymentprocessEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/projectpaymentprocessupdate", [PermissionMiddleware::class], "update.projectpaymentprocess")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectpaymentprocessUpdate");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/projectpaymentprocessdelete[/{PaymentProcessID}]", [PermissionMiddleware::class], "delete.projectpaymentprocess")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectpaymentprocessDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/projectpaymentprocesssearch", [PermissionMiddleware::class], "search.projectpaymentprocess")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectpaymentprocessSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/projectpaymentprocessquery", [PermissionMiddleware::class], "query.projectpaymentprocess")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectpaymentprocessSearch", "ProjectpaymentprocessQuery");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/projectpaymentprocesspreview", [PermissionMiddleware::class], "preview.projectpaymentprocess")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectpaymentprocessPreview", null, false);
    }
}
