<?php

namespace ProjectManagement\prjProjectManagement;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use ProjectManagement\prjProjectManagement\Attributes\Delete;
use ProjectManagement\prjProjectManagement\Attributes\Get;
use ProjectManagement\prjProjectManagement\Attributes\Map;
use ProjectManagement\prjProjectManagement\Attributes\Options;
use ProjectManagement\prjProjectManagement\Attributes\Patch;
use ProjectManagement\prjProjectManagement\Attributes\Post;
use ProjectManagement\prjProjectManagement\Attributes\Put;

class ProjectproblemsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/projectproblemslist[/{ProblemId}]", [PermissionMiddleware::class], "list.projectproblems")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectproblemsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/projectproblemsadd[/{ProblemId}]", [PermissionMiddleware::class], "add.projectproblems")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectproblemsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/projectproblemsview[/{ProblemId}]", [PermissionMiddleware::class], "view.projectproblems")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectproblemsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/projectproblemsedit[/{ProblemId}]", [PermissionMiddleware::class], "edit.projectproblems")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectproblemsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/projectproblemsdelete[/{ProblemId}]", [PermissionMiddleware::class], "delete.projectproblems")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectproblemsDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/projectproblemssearch", [PermissionMiddleware::class], "search.projectproblems")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectproblemsSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/projectproblemsquery", [PermissionMiddleware::class], "query.projectproblems")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectproblemsSearch", "ProjectproblemsQuery");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/projectproblemspreview", [PermissionMiddleware::class], "preview.projectproblems")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectproblemsPreview", null, false);
    }
}
