<?php

namespace ProjectManagement\prjProjectManagement;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use ProjectManagement\prjProjectManagement\Attributes\Delete;
use ProjectManagement\prjProjectManagement\Attributes\Get;
use ProjectManagement\prjProjectManagement\Attributes\Map;
use ProjectManagement\prjProjectManagement\Attributes\Options;
use ProjectManagement\prjProjectManagement\Attributes\Patch;
use ProjectManagement\prjProjectManagement\Attributes\Post;
use ProjectManagement\prjProjectManagement\Attributes\Put;

class ProjectresultController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/projectresultlist[/{ResultID}]", [PermissionMiddleware::class], "list.projectresult")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectresultList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/projectresultadd[/{ResultID}]", [PermissionMiddleware::class], "add.projectresult")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectresultAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/projectresultview[/{ResultID}]", [PermissionMiddleware::class], "view.projectresult")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectresultView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/projectresultedit[/{ResultID}]", [PermissionMiddleware::class], "edit.projectresult")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectresultEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/projectresultupdate", [PermissionMiddleware::class], "update.projectresult")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectresultUpdate");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/projectresultdelete[/{ResultID}]", [PermissionMiddleware::class], "delete.projectresult")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectresultDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/projectresultsearch", [PermissionMiddleware::class], "search.projectresult")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectresultSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/projectresultquery", [PermissionMiddleware::class], "query.projectresult")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectresultSearch", "ProjectresultQuery");
    }

    // preview
    #[Map(["GET","OPTIONS"], "/projectresultpreview", [PermissionMiddleware::class], "preview.projectresult")]
    public function preview(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjectresultPreview", null, false);
    }
}
