<?php

namespace ProjectManagement\prjProjectManagement;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use ProjectManagement\prjProjectManagement\Attributes\Delete;
use ProjectManagement\prjProjectManagement\Attributes\Get;
use ProjectManagement\prjProjectManagement\Attributes\Map;
use ProjectManagement\prjProjectManagement\Attributes\Options;
use ProjectManagement\prjProjectManagement\Attributes\Patch;
use ProjectManagement\prjProjectManagement\Attributes\Post;
use ProjectManagement\prjProjectManagement\Attributes\Put;

class ProjecttemplateController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/projecttemplatelist[/{ID}]", [PermissionMiddleware::class], "list.projecttemplate")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplateList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/projecttemplateadd[/{ID}]", [PermissionMiddleware::class], "add.projecttemplate")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplateAdd");
    }

    // addopt
    #[Map(["GET","POST","OPTIONS"], "/projecttemplateaddopt", [PermissionMiddleware::class], "addopt.projecttemplate")]
    public function addopt(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplateAddopt", null, false);
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/projecttemplateview[/{ID}]", [PermissionMiddleware::class], "view.projecttemplate")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplateView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/projecttemplateedit[/{ID}]", [PermissionMiddleware::class], "edit.projecttemplate")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplateEdit");
    }

    // update
    #[Map(["GET","POST","OPTIONS"], "/projecttemplateupdate", [PermissionMiddleware::class], "update.projecttemplate")]
    public function update(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplateUpdate");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/projecttemplatedelete[/{ID}]", [PermissionMiddleware::class], "delete.projecttemplate")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplateDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/projecttemplatesearch", [PermissionMiddleware::class], "search.projecttemplate")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplateSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/projecttemplatequery", [PermissionMiddleware::class], "query.projecttemplate")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ProjecttemplateSearch", "ProjecttemplateQuery");
    }
}
