<?php

namespace ProjectManagement\prjProjectManagement;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use ProjectManagement\prjProjectManagement\Attributes\Delete;
use ProjectManagement\prjProjectManagement\Attributes\Get;
use ProjectManagement\prjProjectManagement\Attributes\Map;
use ProjectManagement\prjProjectManagement\Attributes\Options;
use ProjectManagement\prjProjectManagement\Attributes\Patch;
use ProjectManagement\prjProjectManagement\Attributes\Post;
use ProjectManagement\prjProjectManagement\Attributes\Put;

class UserlevelpermissionsController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/userlevelpermissionslist[/{keys:.*}]", [PermissionMiddleware::class], "list.userlevelpermissions")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "UserlevelpermissionsList");
    }

    // add
    #[Map(["GET","POST","OPTIONS"], "/userlevelpermissionsadd[/{keys:.*}]", [PermissionMiddleware::class], "add.userlevelpermissions")]
    public function add(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "UserlevelpermissionsAdd");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/userlevelpermissionsview[/{keys:.*}]", [PermissionMiddleware::class], "view.userlevelpermissions")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "UserlevelpermissionsView");
    }

    // edit
    #[Map(["GET","POST","OPTIONS"], "/userlevelpermissionsedit[/{keys:.*}]", [PermissionMiddleware::class], "edit.userlevelpermissions")]
    public function edit(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "UserlevelpermissionsEdit");
    }

    // delete
    #[Map(["GET","POST","OPTIONS"], "/userlevelpermissionsdelete[/{keys:.*}]", [PermissionMiddleware::class], "delete.userlevelpermissions")]
    public function delete(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "UserlevelpermissionsDelete");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/userlevelpermissionssearch", [PermissionMiddleware::class], "search.userlevelpermissions")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "UserlevelpermissionsSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/userlevelpermissionsquery", [PermissionMiddleware::class], "query.userlevelpermissions")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $this->getKeyParams($args), "UserlevelpermissionsSearch", "UserlevelpermissionsQuery");
    }

    // Get keys as associative array
    protected function getKeyParams($args)
    {
        global $RouteValues;
        if (array_key_exists("keys", $args)) {
            $sep = Container("userlevelpermissions")->RouteCompositeKeySeparator;
            $keys = explode($sep, $args["keys"]);
            if (count($keys) == 2) {
                $keyArgs = array_combine(["userlevelid","_tablename"], $keys);
                $RouteValues = array_merge(Route(), $keyArgs);
                $args = array_merge($args, $keyArgs);
            }
        }
        return $args;
    }
}
