<?php

namespace ProjectManagement\prjProjectManagement;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use ProjectManagement\prjProjectManagement\Attributes\Delete;
use ProjectManagement\prjProjectManagement\Attributes\Get;
use ProjectManagement\prjProjectManagement\Attributes\Map;
use ProjectManagement\prjProjectManagement\Attributes\Options;
use ProjectManagement\prjProjectManagement\Attributes\Patch;
use ProjectManagement\prjProjectManagement\Attributes\Post;
use ProjectManagement\prjProjectManagement\Attributes\Put;

class ViewwaitingfortaskController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/viewwaitingfortasklist[/{EmployeeID}]", [PermissionMiddleware::class], "list.viewwaitingfortask")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ViewwaitingfortaskList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/viewwaitingfortaskview[/{EmployeeID}]", [PermissionMiddleware::class], "view.viewwaitingfortask")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ViewwaitingfortaskView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/viewwaitingfortasksearch", [PermissionMiddleware::class], "search.viewwaitingfortask")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ViewwaitingfortaskSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/viewwaitingfortaskquery", [PermissionMiddleware::class], "query.viewwaitingfortask")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "ViewwaitingfortaskSearch", "ViewwaitingfortaskQuery");
    }
}
