<?php

namespace ProjectManagement\prjProjectManagement;

use Psr\Container\ContainerInterface;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use ProjectManagement\prjProjectManagement\Attributes\Delete;
use ProjectManagement\prjProjectManagement\Attributes\Get;
use ProjectManagement\prjProjectManagement\Attributes\Map;
use ProjectManagement\prjProjectManagement\Attributes\Options;
use ProjectManagement\prjProjectManagement\Attributes\Patch;
use ProjectManagement\prjProjectManagement\Attributes\Post;
use ProjectManagement\prjProjectManagement\Attributes\Put;

class VuserController extends ControllerBase
{
    // list
    #[Map(["GET","POST","OPTIONS"], "/vuserlist[/{EmployeeID}]", [PermissionMiddleware::class], "list.vuser")]
    public function list(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "VuserList");
    }

    // view
    #[Map(["GET","POST","OPTIONS"], "/vuserview[/{EmployeeID}]", [PermissionMiddleware::class], "view.vuser")]
    public function view(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "VuserView");
    }

    // search
    #[Map(["GET","POST","OPTIONS"], "/vusersearch", [PermissionMiddleware::class], "search.vuser")]
    public function search(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "VuserSearch");
    }

    // query
    #[Map(["GET","POST","OPTIONS"], "/vuserquery", [PermissionMiddleware::class], "query.vuser")]
    public function query(Request $request, Response $response, array $args): Response
    {
        return $this->runPage($request, $response, $args, "VuserSearch", "VuserQuery");
    }
}
