<?php

namespace ProjectManagement\prjProjectManagement;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class MasterprojectDelete extends Masterproject
{
    use MessagesTrait;

    // Page ID
    public $PageID = "delete";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "MasterprojectDelete";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "masterprojectdelete";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->_ProjectID->Visible = false;
        $this->ProjectName->setVisibility();
        $this->PlanStart->setVisibility();
        $this->PlanEnd->setVisibility();
        $this->StartDate->setVisibility();
        $this->EndDate->setVisibility();
        $this->WarrantyEnd->setVisibility();
        $this->Status->setVisibility();
        $this->Progress->setVisibility();
        $this->Target->setVisibility();
        $this->Track->setVisibility();
        $this->PaymentProgress->setVisibility();
        $this->PaymentDate->setVisibility();
        $this->PaymentComplete->setVisibility();
        $this->AgingPayment->setVisibility();
        $this->ClientID->setVisibility();
        $this->ManagerID->setVisibility();
        $this->ProjectTemplateID->setVisibility();
        $this->Priority->setVisibility();
        $this->Description->Visible = false;
        $this->ProjectValue->setVisibility();
        $this->ProjectDebt->setVisibility();
        $this->PONumber->setVisibility();
        $this->PaymentLink->Visible = false;
        $this->ClearingDate->setVisibility();
        $this->ClearingAging->setVisibility();
        $this->Active->setVisibility();
        $this->Created_Date->setVisibility();
        $this->Created_By->setVisibility();
        $this->Last_Updated_Date->setVisibility();
        $this->Last_Updated_By->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'masterproject';
        $this->TableName = 'masterproject';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (masterproject)
        if (!isset($GLOBALS["masterproject"]) || $GLOBALS["masterproject"]::class == PROJECT_NAMESPACE . "masterproject") {
            $GLOBALS["masterproject"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'masterproject');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['ProjectID'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->_ProjectID->Visible = false;
        }
    }
    public $DbMasterFilter = "";
    public $DbDetailFilter = "";
    public $StartRecord;
    public $TotalRecords = 0;
    public $RecordCount;
    public $RecKeys = [];
    public $StartRowCount = 1;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->Status);
        $this->setupLookupOptions($this->ClientID);
        $this->setupLookupOptions($this->ManagerID);
        $this->setupLookupOptions($this->ProjectTemplateID);
        $this->setupLookupOptions($this->Priority);
        $this->setupLookupOptions($this->Active);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Load key parameters
        $this->RecKeys = $this->getRecordKeys(); // Load record keys
        $filter = $this->getFilterFromRecordKeys();
        if ($filter == "") {
            $this->terminate("masterprojectlist"); // Prevent SQL injection, return to list
            return;
        }

        // Set up filter (WHERE Clause)
        $this->CurrentFilter = $filter;

        // Get action
        if (IsApi()) {
            $this->CurrentAction = "delete"; // Delete record directly
        } elseif (Param("action") !== null) {
            $this->CurrentAction = Param("action") == "delete" ? "delete" : "show";
        } else {
            $this->CurrentAction = $this->InlineDelete ?
                "delete" : // Delete record directly
                "show"; // Display record
        }
        if ($this->isDelete()) {
            $this->SendEmail = true; // Send email on delete success
            if ($this->deleteRows()) { // Delete rows
                if ($this->getSuccessMessage() == "") {
                    $this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
                }
                if (IsJsonResponse()) {
                    $this->terminate(true);
                    return;
                } else {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                }
            } else { // Delete failed
                if (IsJsonResponse()) {
                    $this->terminate();
                    return;
                }
                // Return JSON error message if UseAjaxActions
                if ($this->UseAjaxActions) {
                    WriteJson(["success" => false, "error" => $this->getFailureMessage()]);
                    $this->clearFailureMessage();
                    $this->terminate();
                    return;
                }
                if ($this->InlineDelete) {
                    $this->terminate($this->getReturnUrl()); // Return to caller
                    return;
                } else {
                    $this->CurrentAction = "show"; // Display record
                }
            }
        }
        if ($this->isShow()) { // Load records for display
            $this->Recordset = $this->loadRecordset();
            if ($this->TotalRecords <= 0) { // No record found, exit
                $this->Recordset?->free();
                $this->terminate("masterprojectlist"); // Return to list
                return;
            }
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->_ProjectID->setDbValue($row['ProjectID']);
        $this->ProjectName->setDbValue($row['ProjectName']);
        $this->PlanStart->setDbValue($row['PlanStart']);
        $this->PlanEnd->setDbValue($row['PlanEnd']);
        $this->StartDate->setDbValue($row['StartDate']);
        $this->EndDate->setDbValue($row['EndDate']);
        $this->WarrantyEnd->setDbValue($row['WarrantyEnd']);
        $this->Status->setDbValue($row['Status']);
        $this->Progress->setDbValue($row['Progress']);
        $this->Target->setDbValue($row['Target']);
        $this->Track->setDbValue($row['Track']);
        $this->PaymentProgress->setDbValue($row['PaymentProgress']);
        $this->PaymentDate->setDbValue($row['PaymentDate']);
        $this->PaymentComplete->setDbValue($row['PaymentComplete']);
        $this->AgingPayment->setDbValue($row['AgingPayment']);
        $this->ClientID->setDbValue($row['ClientID']);
        $this->ManagerID->setDbValue($row['ManagerID']);
        $this->ProjectTemplateID->setDbValue($row['ProjectTemplateID']);
        $this->Priority->setDbValue($row['Priority']);
        $this->Description->setDbValue($row['Description']);
        $this->ProjectValue->setDbValue($row['ProjectValue']);
        $this->ProjectDebt->setDbValue($row['ProjectDebt']);
        $this->PONumber->setDbValue($row['PONumber']);
        $this->PaymentLink->setDbValue($row['PaymentLink']);
        $this->ClearingDate->setDbValue($row['ClearingDate']);
        $this->ClearingAging->setDbValue($row['ClearingAging']);
        $this->Active->setDbValue($row['Active']);
        $this->Created_Date->setDbValue($row['Created_Date']);
        $this->Created_By->setDbValue($row['Created_By']);
        $this->Last_Updated_Date->setDbValue($row['Last_Updated_Date']);
        $this->Last_Updated_By->setDbValue($row['Last_Updated_By']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['ProjectID'] = $this->_ProjectID->DefaultValue;
        $row['ProjectName'] = $this->ProjectName->DefaultValue;
        $row['PlanStart'] = $this->PlanStart->DefaultValue;
        $row['PlanEnd'] = $this->PlanEnd->DefaultValue;
        $row['StartDate'] = $this->StartDate->DefaultValue;
        $row['EndDate'] = $this->EndDate->DefaultValue;
        $row['WarrantyEnd'] = $this->WarrantyEnd->DefaultValue;
        $row['Status'] = $this->Status->DefaultValue;
        $row['Progress'] = $this->Progress->DefaultValue;
        $row['Target'] = $this->Target->DefaultValue;
        $row['Track'] = $this->Track->DefaultValue;
        $row['PaymentProgress'] = $this->PaymentProgress->DefaultValue;
        $row['PaymentDate'] = $this->PaymentDate->DefaultValue;
        $row['PaymentComplete'] = $this->PaymentComplete->DefaultValue;
        $row['AgingPayment'] = $this->AgingPayment->DefaultValue;
        $row['ClientID'] = $this->ClientID->DefaultValue;
        $row['ManagerID'] = $this->ManagerID->DefaultValue;
        $row['ProjectTemplateID'] = $this->ProjectTemplateID->DefaultValue;
        $row['Priority'] = $this->Priority->DefaultValue;
        $row['Description'] = $this->Description->DefaultValue;
        $row['ProjectValue'] = $this->ProjectValue->DefaultValue;
        $row['ProjectDebt'] = $this->ProjectDebt->DefaultValue;
        $row['PONumber'] = $this->PONumber->DefaultValue;
        $row['PaymentLink'] = $this->PaymentLink->DefaultValue;
        $row['ClearingDate'] = $this->ClearingDate->DefaultValue;
        $row['ClearingAging'] = $this->ClearingAging->DefaultValue;
        $row['Active'] = $this->Active->DefaultValue;
        $row['Created_Date'] = $this->Created_Date->DefaultValue;
        $row['Created_By'] = $this->Created_By->DefaultValue;
        $row['Last_Updated_Date'] = $this->Last_Updated_Date->DefaultValue;
        $row['Last_Updated_By'] = $this->Last_Updated_By->DefaultValue;
        return $row;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // ProjectID

        // ProjectName
        $this->ProjectName->CellCssStyle = "white-space: nowrap;";

        // PlanStart
        $this->PlanStart->CellCssStyle = "white-space: nowrap;";

        // PlanEnd
        $this->PlanEnd->CellCssStyle = "white-space: nowrap;";

        // StartDate
        $this->StartDate->CellCssStyle = "white-space: nowrap;";

        // EndDate
        $this->EndDate->CellCssStyle = "white-space: nowrap;";

        // WarrantyEnd
        $this->WarrantyEnd->CellCssStyle = "white-space: nowrap;";

        // Status
        $this->Status->CellCssStyle = "white-space: nowrap;";

        // Progress
        $this->Progress->CellCssStyle = "white-space: nowrap;";

        // Target
        $this->Target->CellCssStyle = "white-space: nowrap;";

        // Track
        $this->Track->CellCssStyle = "white-space: nowrap;";

        // PaymentProgress
        $this->PaymentProgress->CellCssStyle = "white-space: nowrap;";

        // PaymentDate
        $this->PaymentDate->CellCssStyle = "white-space: nowrap;";

        // PaymentComplete
        $this->PaymentComplete->CellCssStyle = "white-space: nowrap;";

        // AgingPayment
        $this->AgingPayment->CellCssStyle = "white-space: nowrap;";

        // ClientID
        $this->ClientID->CellCssStyle = "white-space: nowrap;";

        // ManagerID
        $this->ManagerID->CellCssStyle = "white-space: nowrap;";

        // ProjectTemplateID
        $this->ProjectTemplateID->CellCssStyle = "white-space: nowrap;";

        // Priority
        $this->Priority->CellCssStyle = "white-space: nowrap;";

        // Description
        $this->Description->CellCssStyle = "white-space: nowrap;";

        // ProjectValue
        $this->ProjectValue->CellCssStyle = "white-space: nowrap;";

        // ProjectDebt
        $this->ProjectDebt->CellCssStyle = "white-space: nowrap;";

        // PONumber
        $this->PONumber->CellCssStyle = "white-space: nowrap;";

        // PaymentLink

        // ClearingDate

        // ClearingAging

        // Active
        $this->Active->CellCssStyle = "white-space: nowrap;";

        // Created_Date
        $this->Created_Date->CellCssStyle = "white-space: nowrap;";

        // Created_By
        $this->Created_By->CellCssStyle = "white-space: nowrap;";

        // Last_Updated_Date
        $this->Last_Updated_Date->CellCssStyle = "white-space: nowrap;";

        // Last_Updated_By
        $this->Last_Updated_By->CellCssStyle = "white-space: nowrap;";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // ProjectID
            $this->_ProjectID->ViewValue = $this->_ProjectID->CurrentValue;

            // ProjectName
            $this->ProjectName->ViewValue = $this->ProjectName->CurrentValue;

            // PlanStart
            $this->PlanStart->ViewValue = $this->PlanStart->CurrentValue;
            $this->PlanStart->ViewValue = FormatDateTime($this->PlanStart->ViewValue, $this->PlanStart->formatPattern());

            // PlanEnd
            $this->PlanEnd->ViewValue = $this->PlanEnd->CurrentValue;
            $this->PlanEnd->ViewValue = FormatDateTime($this->PlanEnd->ViewValue, $this->PlanEnd->formatPattern());

            // StartDate
            $this->StartDate->ViewValue = $this->StartDate->CurrentValue;
            $this->StartDate->ViewValue = FormatDateTime($this->StartDate->ViewValue, $this->StartDate->formatPattern());

            // EndDate
            $this->EndDate->ViewValue = $this->EndDate->CurrentValue;
            $this->EndDate->ViewValue = FormatDateTime($this->EndDate->ViewValue, $this->EndDate->formatPattern());

            // WarrantyEnd
            $this->WarrantyEnd->ViewValue = $this->WarrantyEnd->CurrentValue;
            $this->WarrantyEnd->ViewValue = FormatDateTime($this->WarrantyEnd->ViewValue, $this->WarrantyEnd->formatPattern());

            // Status
            $curVal = strval($this->Status->CurrentValue);
            if ($curVal != "") {
                $this->Status->ViewValue = $this->Status->lookupCacheOption($curVal);
                if ($this->Status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->Status->Lookup->getTable()->Fields["Status"]->searchExpression(), "=", $curVal, $this->Status->Lookup->getTable()->Fields["Status"]->searchDataType(), "");
                    $sqlWrk = $this->Status->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Status->Lookup->renderViewRow($rswrk[0]);
                        $this->Status->ViewValue = $this->Status->displayValue($arwrk);
                    } else {
                        $this->Status->ViewValue = $this->Status->CurrentValue;
                    }
                }
            } else {
                $this->Status->ViewValue = null;
            }

            // Progress
            $this->Progress->ViewValue = $this->Progress->CurrentValue;
            $this->Progress->ViewValue = FormatPercent($this->Progress->ViewValue, $this->Progress->formatPattern());
            $this->Progress->CellCssStyle .= "text-align: right;";

            // Target
            $this->Target->ViewValue = $this->Target->CurrentValue;
            $this->Target->ViewValue = FormatPercent($this->Target->ViewValue, $this->Target->formatPattern());
            $this->Target->CellCssStyle .= "text-align: right;";

            // Track
            $this->Track->ViewValue = $this->Track->CurrentValue;
            $this->Track->CellCssStyle .= "text-align: right;";

            // PaymentProgress
            $this->PaymentProgress->ViewValue = $this->PaymentProgress->CurrentValue;
            $this->PaymentProgress->ViewValue = FormatPercent($this->PaymentProgress->ViewValue, $this->PaymentProgress->formatPattern());
            $this->PaymentProgress->CellCssStyle .= "text-align: right;";

            // PaymentDate
            $this->PaymentDate->ViewValue = $this->PaymentDate->CurrentValue;
            $this->PaymentDate->ViewValue = FormatDateTime($this->PaymentDate->ViewValue, $this->PaymentDate->formatPattern());

            // PaymentComplete
            $this->PaymentComplete->ViewValue = $this->PaymentComplete->CurrentValue;

            // AgingPayment
            $this->AgingPayment->ViewValue = $this->AgingPayment->CurrentValue;
            $this->AgingPayment->ViewValue = FormatNumber($this->AgingPayment->ViewValue, $this->AgingPayment->formatPattern());
            $this->AgingPayment->CellCssStyle .= "text-align: right;";

            // ClientID
            $curVal = strval($this->ClientID->CurrentValue);
            if ($curVal != "") {
                $this->ClientID->ViewValue = $this->ClientID->lookupCacheOption($curVal);
                if ($this->ClientID->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ClientID->Lookup->getTable()->Fields["ClientID"]->searchExpression(), "=", $curVal, $this->ClientID->Lookup->getTable()->Fields["ClientID"]->searchDataType(), "");
                    $lookupFilter = $this->ClientID->getSelectFilter($this); // PHP
                    $sqlWrk = $this->ClientID->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ClientID->Lookup->renderViewRow($rswrk[0]);
                        $this->ClientID->ViewValue = $this->ClientID->displayValue($arwrk);
                    } else {
                        $this->ClientID->ViewValue = FormatNumber($this->ClientID->CurrentValue, $this->ClientID->formatPattern());
                    }
                }
            } else {
                $this->ClientID->ViewValue = null;
            }

            // ManagerID
            $curVal = strval($this->ManagerID->CurrentValue);
            if ($curVal != "") {
                $this->ManagerID->ViewValue = $this->ManagerID->lookupCacheOption($curVal);
                if ($this->ManagerID->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ManagerID->Lookup->getTable()->Fields["EmployeeID"]->searchExpression(), "=", $curVal, $this->ManagerID->Lookup->getTable()->Fields["EmployeeID"]->searchDataType(), "");
                    $lookupFilter = $this->ManagerID->getSelectFilter($this); // PHP
                    $sqlWrk = $this->ManagerID->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ManagerID->Lookup->renderViewRow($rswrk[0]);
                        $this->ManagerID->ViewValue = $this->ManagerID->displayValue($arwrk);
                    } else {
                        $this->ManagerID->ViewValue = FormatNumber($this->ManagerID->CurrentValue, $this->ManagerID->formatPattern());
                    }
                }
            } else {
                $this->ManagerID->ViewValue = null;
            }

            // ProjectTemplateID
            $curVal = strval($this->ProjectTemplateID->CurrentValue);
            if ($curVal != "") {
                $this->ProjectTemplateID->ViewValue = $this->ProjectTemplateID->lookupCacheOption($curVal);
                if ($this->ProjectTemplateID->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ProjectTemplateID->Lookup->getTable()->Fields["ID"]->searchExpression(), "=", $curVal, $this->ProjectTemplateID->Lookup->getTable()->Fields["ID"]->searchDataType(), "");
                    $lookupFilter = $this->ProjectTemplateID->getSelectFilter($this); // PHP
                    $sqlWrk = $this->ProjectTemplateID->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ProjectTemplateID->Lookup->renderViewRow($rswrk[0]);
                        $this->ProjectTemplateID->ViewValue = $this->ProjectTemplateID->displayValue($arwrk);
                    } else {
                        $this->ProjectTemplateID->ViewValue = FormatNumber($this->ProjectTemplateID->CurrentValue, $this->ProjectTemplateID->formatPattern());
                    }
                }
            } else {
                $this->ProjectTemplateID->ViewValue = null;
            }

            // Priority
            if (strval($this->Priority->CurrentValue) != "") {
                $this->Priority->ViewValue = $this->Priority->optionCaption($this->Priority->CurrentValue);
            } else {
                $this->Priority->ViewValue = null;
            }

            // Description
            $this->Description->ViewValue = $this->Description->CurrentValue;

            // ProjectValue
            $this->ProjectValue->ViewValue = $this->ProjectValue->CurrentValue;
            $this->ProjectValue->ViewValue = FormatNumber($this->ProjectValue->ViewValue, $this->ProjectValue->formatPattern());
            $this->ProjectValue->CellCssStyle .= "text-align: right;";

            // ProjectDebt
            $this->ProjectDebt->ViewValue = $this->ProjectDebt->CurrentValue;
            $this->ProjectDebt->ViewValue = FormatNumber($this->ProjectDebt->ViewValue, $this->ProjectDebt->formatPattern());
            $this->ProjectDebt->CellCssStyle .= "text-align: right;";

            // PONumber
            $this->PONumber->ViewValue = $this->PONumber->CurrentValue;

            // PaymentLink
            $this->PaymentLink->ViewValue = $this->PaymentLink->CurrentValue;

            // ClearingDate
            $this->ClearingDate->ViewValue = $this->ClearingDate->CurrentValue;
            $this->ClearingDate->ViewValue = FormatDateTime($this->ClearingDate->ViewValue, $this->ClearingDate->formatPattern());

            // ClearingAging
            $this->ClearingAging->ViewValue = $this->ClearingAging->CurrentValue;
            $this->ClearingAging->ViewValue = FormatNumber($this->ClearingAging->ViewValue, $this->ClearingAging->formatPattern());
            $this->ClearingAging->CellCssStyle .= "text-align: right;";

            // Active
            if (ConvertToBool($this->Active->CurrentValue)) {
                $this->Active->ViewValue = $this->Active->tagCaption(1) != "" ? $this->Active->tagCaption(1) : "Yes";
            } else {
                $this->Active->ViewValue = $this->Active->tagCaption(2) != "" ? $this->Active->tagCaption(2) : "No";
            }
            $this->Active->CellCssStyle .= "text-align: center;";

            // Created_Date
            $this->Created_Date->ViewValue = $this->Created_Date->CurrentValue;
            $this->Created_Date->ViewValue = FormatDateTime($this->Created_Date->ViewValue, $this->Created_Date->formatPattern());

            // Created_By
            $this->Created_By->ViewValue = $this->Created_By->CurrentValue;

            // Last_Updated_Date
            $this->Last_Updated_Date->ViewValue = $this->Last_Updated_Date->CurrentValue;
            $this->Last_Updated_Date->ViewValue = FormatDateTime($this->Last_Updated_Date->ViewValue, $this->Last_Updated_Date->formatPattern());

            // Last_Updated_By
            $this->Last_Updated_By->ViewValue = $this->Last_Updated_By->CurrentValue;

            // ProjectName
            $this->ProjectName->HrefValue = "";
            $this->ProjectName->TooltipValue = "";

            // PlanStart
            $this->PlanStart->HrefValue = "";
            $this->PlanStart->TooltipValue = "";

            // PlanEnd
            $this->PlanEnd->HrefValue = "";
            $this->PlanEnd->TooltipValue = "";

            // StartDate
            $this->StartDate->HrefValue = "";
            $this->StartDate->TooltipValue = "";

            // EndDate
            $this->EndDate->HrefValue = "";
            $this->EndDate->TooltipValue = "";

            // WarrantyEnd
            $this->WarrantyEnd->HrefValue = "";
            $this->WarrantyEnd->TooltipValue = "";

            // Status
            $this->Status->HrefValue = "";
            $this->Status->TooltipValue = "";

            // Progress
            $this->Progress->HrefValue = "";
            $this->Progress->TooltipValue = "";

            // Target
            $this->Target->HrefValue = "";
            $this->Target->TooltipValue = "";

            // Track
            $this->Track->HrefValue = "";
            $this->Track->TooltipValue = "";

            // PaymentProgress
            $this->PaymentProgress->HrefValue = "";
            $this->PaymentProgress->TooltipValue = "";

            // PaymentDate
            $this->PaymentDate->HrefValue = "";
            $this->PaymentDate->TooltipValue = "";

            // PaymentComplete
            $this->PaymentComplete->HrefValue = "";
            $this->PaymentComplete->TooltipValue = "";

            // AgingPayment
            $this->AgingPayment->HrefValue = "";
            $this->AgingPayment->TooltipValue = "";

            // ClientID
            $this->ClientID->HrefValue = "";
            $this->ClientID->TooltipValue = "";

            // ManagerID
            $this->ManagerID->HrefValue = "";
            $this->ManagerID->TooltipValue = "";

            // ProjectTemplateID
            $this->ProjectTemplateID->HrefValue = "";
            $this->ProjectTemplateID->TooltipValue = "";

            // Priority
            $this->Priority->HrefValue = "";
            $this->Priority->TooltipValue = "";

            // ProjectValue
            $this->ProjectValue->HrefValue = "";
            $this->ProjectValue->TooltipValue = "";

            // ProjectDebt
            $this->ProjectDebt->HrefValue = "";
            $this->ProjectDebt->TooltipValue = "";

            // PONumber
            $this->PONumber->HrefValue = "";
            $this->PONumber->TooltipValue = "";

            // ClearingDate
            $this->ClearingDate->HrefValue = "";
            $this->ClearingDate->TooltipValue = "";

            // ClearingAging
            $this->ClearingAging->HrefValue = "";
            $this->ClearingAging->TooltipValue = "";

            // Active
            $this->Active->HrefValue = "";
            $this->Active->TooltipValue = "";

            // Created_Date
            $this->Created_Date->HrefValue = "";
            $this->Created_Date->TooltipValue = "";

            // Created_By
            $this->Created_By->HrefValue = "";
            $this->Created_By->TooltipValue = "";

            // Last_Updated_Date
            $this->Last_Updated_Date->HrefValue = "";
            $this->Last_Updated_Date->TooltipValue = "";

            // Last_Updated_By
            $this->Last_Updated_By->HrefValue = "";
            $this->Last_Updated_By->TooltipValue = "";
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Delete records based on current filter
    protected function deleteRows()
    {
        global $Language, $Security;
        if (!$Security->canDelete()) {
            $this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
            return false;
        }
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $rows = $conn->fetchAllAssociative($sql);
        if (count($rows) == 0) {
            $this->setFailureMessage($Language->phrase("NoRecord")); // No record found
            return false;
        }
        if ($this->UseTransaction) {
            $conn->beginTransaction();
        }

        // Clone old rows
        $rsold = $rows;
        $successKeys = [];
        $failKeys = [];
        foreach ($rsold as $row) {
            $thisKey = "";
            if ($thisKey != "") {
                $thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
            }
            $thisKey .= $row['ProjectID'];

            // Call row deleting event
            $deleteRow = $this->rowDeleting($row);
            if ($deleteRow) { // Delete
                $deleteRow = $this->delete($row);
                if (!$deleteRow && !EmptyValue($this->DbErrorMessage)) { // Show database error
                    $this->setFailureMessage($this->DbErrorMessage);
                }
            }
            if ($deleteRow === false) {
                if ($this->UseTransaction) {
                    $successKeys = []; // Reset success keys
                    break;
                }
                $failKeys[] = $thisKey;
            } else {
                if (Config("DELETE_UPLOADED_FILES")) { // Delete old files
                    $this->deleteUploadedFiles($row);
                }

                // Call Row Deleted event
                $this->rowDeleted($row);
                $successKeys[] = $thisKey;
            }
        }

        // Any records deleted
        $deleteRows = count($successKeys) > 0;
        if (!$deleteRows) {
            // Set up error message
            if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                // Use the message, do nothing
            } elseif ($this->CancelMessage != "") {
                $this->setFailureMessage($this->CancelMessage);
                $this->CancelMessage = "";
            } else {
                $this->setFailureMessage($Language->phrase("DeleteCancelled"));
            }
        }
        if ($deleteRows) {
            if ($this->UseTransaction) { // Commit transaction
                $conn->commit();
            }

            // Set warning message if delete some records failed
            if (count($failKeys) > 0) {
                $this->setWarningMessage(str_replace("%k", explode(", ", $failKeys), $Language->phrase("DeleteRecordsFailed")));
            }
        } else {
            if ($this->UseTransaction) { // Rollback transaction
                $conn->rollback();
            }
        }

        // Write JSON response
        if ((IsJsonResponse() || ConvertToBool(Param("infinitescroll"))) && $deleteRows) {
            $rows = $this->getRecordsFromRecordset($rsold);
            $table = $this->TableVar;
            if (Param("key_m") === null) { // Single delete
                $rows = $rows[0]; // Return object
            }
            WriteJson(["success" => true, "action" => Config("API_DELETE_ACTION"), $table => $rows]);
        }
        return $deleteRows;
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("masterprojectlist");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("masterprojectlist"), "", $this->TableVar, true);
        $pageId = "delete";
        $Breadcrumb->add("delete", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_Status":
                    break;
                case "x_ClientID":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_ManagerID":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_ProjectTemplateID":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_Priority":
                    break;
                case "x_Active":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }
}
