<?php

namespace ProjectManagement\prjProjectManagement;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class MasterprojectList extends Masterproject
{
    use MessagesTrait;

    // Page ID
    public $PageID = "list";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "MasterprojectList";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // Grid form hidden field names
    public $FormName = "fmasterprojectlist";
    public $FormActionName = "";
    public $FormBlankRowName = "";
    public $FormKeyCountName = "";

    // CSS class/style
    public $CurrentPageName = "masterprojectlist";

    // Page URLs
    public $AddUrl;
    public $EditUrl;
    public $DeleteUrl;
    public $ViewUrl;
    public $CopyUrl;
    public $ListUrl;

    // Update URLs
    public $InlineAddUrl;
    public $InlineCopyUrl;
    public $InlineEditUrl;
    public $GridAddUrl;
    public $GridEditUrl;
    public $MultiEditUrl;
    public $MultiDeleteUrl;
    public $MultiUpdateUrl;

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->_ProjectID->Visible = false;
        $this->ProjectName->setVisibility();
        $this->PlanStart->setVisibility();
        $this->PlanEnd->setVisibility();
        $this->StartDate->setVisibility();
        $this->EndDate->setVisibility();
        $this->WarrantyEnd->setVisibility();
        $this->Status->setVisibility();
        $this->Progress->setVisibility();
        $this->Target->setVisibility();
        $this->Track->setVisibility();
        $this->PaymentProgress->setVisibility();
        $this->PaymentDate->setVisibility();
        $this->PaymentComplete->setVisibility();
        $this->AgingPayment->setVisibility();
        $this->ClientID->setVisibility();
        $this->ManagerID->setVisibility();
        $this->ProjectTemplateID->setVisibility();
        $this->Priority->setVisibility();
        $this->Description->Visible = false;
        $this->ProjectValue->setVisibility();
        $this->ProjectDebt->setVisibility();
        $this->PONumber->setVisibility();
        $this->PaymentLink->Visible = false;
        $this->ClearingDate->setVisibility();
        $this->ClearingAging->setVisibility();
        $this->Active->setVisibility();
        $this->Created_Date->setVisibility();
        $this->Created_By->setVisibility();
        $this->Last_Updated_Date->setVisibility();
        $this->Last_Updated_By->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->FormActionName = Config("FORM_ROW_ACTION_NAME");
        $this->FormBlankRowName = Config("FORM_BLANK_ROW_NAME");
        $this->FormKeyCountName = Config("FORM_KEY_COUNT_NAME");
        $this->TableVar = 'masterproject';
        $this->TableName = 'masterproject';

        // Table CSS class
        $this->TableClass = "table table-bordered table-hover table-sm ew-table";

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->TableGridClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (masterproject)
        if (!isset($GLOBALS["masterproject"]) || $GLOBALS["masterproject"]::class == PROJECT_NAMESPACE . "masterproject") {
            $GLOBALS["masterproject"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs
        $this->AddUrl = "masterprojectadd?" . Config("TABLE_SHOW_DETAIL") . "=";
        $this->InlineAddUrl = $pageUrl . "action=add";
        $this->GridAddUrl = $pageUrl . "action=gridadd";
        $this->GridEditUrl = $pageUrl . "action=gridedit";
        $this->MultiEditUrl = $pageUrl . "action=multiedit";
        $this->MultiDeleteUrl = "masterprojectdelete";
        $this->MultiUpdateUrl = "masterprojectupdate";

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'masterproject');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // List options
        $this->ListOptions = new ListOptions(Tag: "td", TableVar: $this->TableVar);

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Import options
        $this->ImportOptions = new ListOptions(TagClassName: "ew-import-option");

        // Other options
        $this->OtherOptions = new ListOptionsArray();

        // Grid-Add/Edit
        $this->OtherOptions["addedit"] = new ListOptions(
            TagClassName: "ew-add-edit-option",
            UseDropDownButton: false,
            DropDownButtonPhrase: $Language->phrase("ButtonAddEdit"),
            UseButtonGroup: true
        );

        // Detail tables
        $this->OtherOptions["detail"] = new ListOptions(TagClassName: "ew-detail-option");
        // Actions
        $this->OtherOptions["action"] = new ListOptions(TagClassName: "ew-action-option");

        // Column visibility
        $this->OtherOptions["column"] = new ListOptions(
            TableVar: $this->TableVar,
            TagClassName: "ew-column-option",
            ButtonGroupClass: "ew-column-dropdown",
            UseDropDownButton: true,
            DropDownButtonPhrase: $Language->phrase("Columns"),
            DropDownAutoClose: "outside",
            UseButtonGroup: false
        );

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");

        // List actions
        $this->ListActions = new ListActions();
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "masterprojectview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        if ($fld->DataType == DataType::MEMO && $fld->MemoMaxLength > 0) {
                            $val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
                        }
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['ProjectID'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->_ProjectID->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->Last_Updated_Date->Visible = false;
        }
        if ($this->isAddOrEdit()) {
            $this->Last_Updated_By->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Class variables
    public $ListOptions; // List options
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $OtherOptions; // Other options
    public $HeaderOptions; // Header options
    public $FooterOptions; // Footer options
    public $FilterOptions; // Filter options
    public $ImportOptions; // Import options
    public $ListActions; // List actions
    public $SelectedCount = 0;
    public $SelectedIndex = 0;
    public $DisplayRecords = 10;
    public $StartRecord;
    public $StopRecord;
    public $TotalRecords = 0;
    public $RecordRange = 10;
    public $PageSizes = "10,20,50,-1"; // Page sizes (comma separated)
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = ""; // Search WHERE clause
    public $SearchPanelClass = "ew-search-panel collapse show"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 1; // For extended search
    public $RecordCount = 0; // Record count
    public $InlineRowCount = 0;
    public $StartRowCount = 1;
    public $Attrs = []; // Row attributes and cell attributes
    public $RowIndex = 0; // Row index
    public $KeyCount = 0; // Key count
    public $MultiColumnGridClass = "row-cols-md";
    public $MultiColumnEditClass = "col-12 w-100";
    public $MultiColumnCardClass = "card h-100 ew-card";
    public $MultiColumnListOptionsPosition = "bottom-start";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $MasterRecordExists;
    public $MultiSelectKey;
    public $Command;
    public $UserAction; // User action
    public $RestoreSearch = false;
    public $HashValue; // Hash value
    public $DetailPages;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";
    public $PageAction;
    public $RecKeys = [];
    public $IsModal = false;
    protected $FilterForModalActions = "";
    private $UseInfiniteScroll = false;

    /**
     * Load result set from filter
     *
     * @return void
     */
    public function loadRecordsetFromFilter($filter)
    {
        // Set up list options
        $this->setupListOptions();

        // Search options
        $this->setupSearchOptions();

        // Other options
        $this->setupOtherOptions();

        // Set visibility
        $this->setVisibility();

        // Load result set
        $this->TotalRecords = $this->loadRecordCount($filter);
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords;
        $this->CurrentFilter = $filter;
        $this->Recordset = $this->loadRecordset();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
    }

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $DashboardReport;

        // Multi column button position
        $this->MultiColumnListOptionsPosition = Config("MULTI_COLUMN_LIST_OPTIONS_POSITION");
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        } else {
            $this->setExportReturnUrl(CurrentUrl());
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Get grid add count
        $gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
        if (is_numeric($gridaddcnt) && $gridaddcnt > 0) {
            $this->GridAddRowCount = $gridaddcnt;
        }

        // Set up list options
        $this->setupListOptions();

        // Setup export options
        $this->setupExportOptions();

        // Setup import options
        $this->setupImportOptions();
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up lookup cache
        $this->setupLookupOptions($this->Status);
        $this->setupLookupOptions($this->ClientID);
        $this->setupLookupOptions($this->ManagerID);
        $this->setupLookupOptions($this->ProjectTemplateID);
        $this->setupLookupOptions($this->Priority);
        $this->setupLookupOptions($this->Active);

        // Update form name to avoid conflict
        if ($this->IsModal) {
            $this->FormName = "fmasterprojectgrid";
        }

        // Set up page action
        $this->PageAction = CurrentPageUrl(false);

        // Set up infinite scroll
        $this->UseInfiniteScroll = ConvertToBool(Param("infinitescroll"));

        // Search filters
        $srchAdvanced = ""; // Advanced search filter
        $srchBasic = ""; // Basic search filter
        $query = ""; // Query builder

        // Set up Dashboard Filter
        if ($DashboardReport) {
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar));
        }

        // Get command
        $this->Command = strtolower(Get("cmd", ""));

        // Process list action first
        if ($this->processListAction()) { // Ajax request
            $this->terminate();
            return;
        }

        // Set up records per page
        $this->setupDisplayRecords();

        // Handle reset command
        $this->resetCmd();

        // Set up Breadcrumb
        if (!$this->isExport()) {
            $this->setupBreadcrumb();
        }

        // Process import
        if ($this->isImport()) {
            $this->import(Param(Config("API_FILE_TOKEN_NAME")), ConvertToBool(Param("rollback")));
            $this->terminate();
            return;
        }

        // Hide list options
        if ($this->isExport()) {
            $this->ListOptions->hideAllOptions(["sequence"]);
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        } elseif ($this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit() || $this->isConfirm()) {
            $this->ListOptions->hideAllOptions();
            $this->ListOptions->UseDropDownButton = false; // Disable drop down button
            $this->ListOptions->UseButtonGroup = false; // Disable button group
        }

        // Hide options
        if ($this->isExport() || !(EmptyValue($this->CurrentAction) || $this->isSearch())) {
            $this->ExportOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
            $this->ImportOptions->hideAllOptions();
        }

        // Hide other options
        if ($this->isExport()) {
            $this->OtherOptions->hideAllOptions();
        }

        // Get default search criteria
        AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(true));
        AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(true));

        // Get basic search values
        $this->loadBasicSearchValues();

        // Get and validate search values for advanced search
        if (EmptyValue($this->UserAction)) { // Skip if user action
            $this->loadSearchValues();
        }

        // Process filter list
        if ($this->processFilterList()) {
            $this->terminate();
            return;
        }
        if (!$this->validateSearch()) {
            // Nothing to do
        }

        // Restore search parms from Session if not searching / reset / export
        if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms()) {
            $this->restoreSearchParms();
        }

        // Call Recordset SearchValidated event
        $this->recordsetSearchValidated();

        // Set up sorting order
        $this->setupSortOrder();

        // Get basic search criteria
        if (!$this->hasInvalidFields()) {
            $srchBasic = $this->basicSearchWhere();
        }

        // Get advanced search criteria
        if (!$this->hasInvalidFields()) {
            $srchAdvanced = $this->advancedSearchWhere();
        }

        // Get query builder criteria
        $query = $DashboardReport ? "" : $this->queryBuilderWhere();

        // Restore display records
        if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
            $this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
        } else {
            $this->DisplayRecords = 10; // Load default
            $this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
        }

        // Load search default if no existing search criteria
        if (!$this->checkSearchParms() && !$query) {
            // Load basic search from default
            $this->BasicSearch->loadDefault();
            if ($this->BasicSearch->Keyword != "") {
                $srchBasic = $this->basicSearchWhere(); // Save to session
            }

            // Load advanced search from default
            if ($this->loadAdvancedSearchDefault()) {
                $srchAdvanced = $this->advancedSearchWhere(); // Save to session
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Build search criteria
        if ($query) {
            AddFilter($this->SearchWhere, $query);
        } else {
            AddFilter($this->SearchWhere, $srchAdvanced);
            AddFilter($this->SearchWhere, $srchBasic);
        }

        // Call Recordset_Searching event
        $this->recordsetSearching($this->SearchWhere);

        // Save search criteria
        if ($this->Command == "search" && !$this->RestoreSearch) {
            $this->setSearchWhere($this->SearchWhere); // Save to Session
            $this->StartRecord = 1; // Reset start record counter
            $this->setStartRecordNumber($this->StartRecord);
        } elseif ($this->Command != "json" && !$query) {
            $this->SearchWhere = $this->getSearchWhere();
        }

        // Build filter
        if (!$Security->canList()) {
            $this->Filter = "(0=1)"; // Filter all records
        }
        AddFilter($this->Filter, $this->DbDetailFilter);
        AddFilter($this->Filter, $this->SearchWhere);

        // Set up filter
        if ($this->Command == "json") {
            $this->UseSessionForListSql = false; // Do not use session for ListSQL
            $this->CurrentFilter = $this->Filter;
        } else {
            $this->setSessionWhere($this->Filter);
            $this->CurrentFilter = "";
        }
        $this->Filter = $this->applyUserIDFilters($this->Filter);
        if ($this->isGridAdd()) {
            $this->CurrentFilter = "0=1";
            $this->StartRecord = 1;
            $this->DisplayRecords = $this->GridAddRowCount;
            $this->TotalRecords = $this->DisplayRecords;
            $this->StopRecord = $this->DisplayRecords;
        } elseif (($this->isEdit() || $this->isCopy() || $this->isInlineInserted() || $this->isInlineUpdated()) && $this->UseInfiniteScroll) { // Get current record only
            $this->CurrentFilter = $this->isInlineUpdated() ? $this->getRecordFilter() : $this->getFilterFromRecordKeys();
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } elseif (
            $this->UseInfiniteScroll && $this->isGridInserted() ||
            $this->UseInfiniteScroll && ($this->isGridEdit() || $this->isGridUpdated()) ||
            $this->isMultiEdit() ||
            $this->UseInfiniteScroll && $this->isMultiUpdated()
        ) { // Get current records only
            $this->CurrentFilter = $this->FilterForModalActions; // Restore filter
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            $this->StopRecord = $this->DisplayRecords;
            $this->Recordset = $this->loadRecordset();
        } else {
            $this->TotalRecords = $this->listRecordCount();
            $this->StartRecord = 1;
            if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) { // Display all records
                $this->DisplayRecords = $this->TotalRecords;
            }
            if (!($this->isExport() && $this->ExportAll)) { // Set up start record position
                $this->setupStartRecord();
            }
            $this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

            // Set no record found message
            if ((EmptyValue($this->CurrentAction) || $this->isSearch()) && $this->TotalRecords == 0) {
                if (!$Security->canList()) {
                    $this->setWarningMessage(DeniedMessage());
                }
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            }
        }

        // Set up list action columns
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Allowed) {
                if ($listAction->Select == ACTION_MULTIPLE) { // Show checkbox column if multiple action
                    $this->ListOptions["checkbox"]->Visible = true;
                } elseif ($listAction->Select == ACTION_SINGLE) { // Show list action column
                        $this->ListOptions["listactions"]->Visible = true; // Set visible if any list action is allowed
                }
            }
        }

        // Search options
        $this->setupSearchOptions();

        // Set up search panel class
        if ($this->SearchWhere != "") {
            if ($query) { // Hide search panel if using QueryBuilder
                RemoveClass($this->SearchPanelClass, "show");
            } else {
                AppendClass($this->SearchPanelClass, "show");
            }
        }

        // API list action
        if (IsApi()) {
            if (Route(0) == Config("API_LIST_ACTION")) {
                if (!$this->isExport()) {
                    $rows = $this->getRecordsFromRecordset($this->Recordset);
                    $this->Recordset?->free();
                    WriteJson([
                        "success" => true,
                        "action" => Config("API_LIST_ACTION"),
                        $this->TableVar => $rows,
                        "totalRecordCount" => $this->TotalRecords
                    ]);
                    $this->terminate(true);
                }
                return;
            } elseif ($this->getFailureMessage() != "") {
                WriteJson(["error" => $this->getFailureMessage()]);
                $this->clearFailureMessage();
                $this->terminate(true);
                return;
            }
        }

        // Render other options
        $this->renderOtherOptions();

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartRecord, $this->DisplayRecords, $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Set ReturnUrl in header if necessary
        if ($returnUrl = Container("app.flash")->getFirstMessage("Return-Url")) {
            AddHeader("Return-Url", GetUrl($returnUrl));
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Get page number
    public function getPageNumber()
    {
        return ($this->DisplayRecords > 0 && $this->StartRecord > 0) ? ceil($this->StartRecord / $this->DisplayRecords) : 1;
    }

    // Set up number of records displayed per page
    protected function setupDisplayRecords()
    {
        $wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
        if ($wrk != "") {
            if (is_numeric($wrk)) {
                $this->DisplayRecords = (int)$wrk;
            } else {
                if (SameText($wrk, "all")) { // Display all records
                    $this->DisplayRecords = -1;
                } else {
                    $this->DisplayRecords = 10; // Non-numeric, load default
                }
            }
            $this->setRecordsPerPage($this->DisplayRecords); // Save to Session
            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Build filter for all keys
    protected function buildKeyFilter()
    {
        global $CurrentForm;
        $wrkFilter = "";

        // Update row index and get row key
        $rowindex = 1;
        $CurrentForm->Index = $rowindex;
        $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        while ($thisKey != "") {
            $this->setKey($thisKey);
            if ($this->OldKey != "") {
                $filter = $this->getRecordFilter();
                if ($wrkFilter != "") {
                    $wrkFilter .= " OR ";
                }
                $wrkFilter .= $filter;
            } else {
                $wrkFilter = "0=1";
                break;
            }

            // Update row index and get row key
            $rowindex++; // Next row
            $CurrentForm->Index = $rowindex;
            $thisKey = strval($CurrentForm->getValue($this->OldKeyName));
        }
        return $wrkFilter;
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";
        $filterList = Concat($filterList, $this->_ProjectID->AdvancedSearch->toJson(), ","); // Field ProjectID
        $filterList = Concat($filterList, $this->ProjectName->AdvancedSearch->toJson(), ","); // Field ProjectName
        $filterList = Concat($filterList, $this->PlanStart->AdvancedSearch->toJson(), ","); // Field PlanStart
        $filterList = Concat($filterList, $this->PlanEnd->AdvancedSearch->toJson(), ","); // Field PlanEnd
        $filterList = Concat($filterList, $this->StartDate->AdvancedSearch->toJson(), ","); // Field StartDate
        $filterList = Concat($filterList, $this->EndDate->AdvancedSearch->toJson(), ","); // Field EndDate
        $filterList = Concat($filterList, $this->WarrantyEnd->AdvancedSearch->toJson(), ","); // Field WarrantyEnd
        $filterList = Concat($filterList, $this->Status->AdvancedSearch->toJson(), ","); // Field Status
        $filterList = Concat($filterList, $this->Progress->AdvancedSearch->toJson(), ","); // Field Progress
        $filterList = Concat($filterList, $this->Target->AdvancedSearch->toJson(), ","); // Field Target
        $filterList = Concat($filterList, $this->Track->AdvancedSearch->toJson(), ","); // Field Track
        $filterList = Concat($filterList, $this->PaymentProgress->AdvancedSearch->toJson(), ","); // Field PaymentProgress
        $filterList = Concat($filterList, $this->PaymentDate->AdvancedSearch->toJson(), ","); // Field PaymentDate
        $filterList = Concat($filterList, $this->PaymentComplete->AdvancedSearch->toJson(), ","); // Field PaymentComplete
        $filterList = Concat($filterList, $this->AgingPayment->AdvancedSearch->toJson(), ","); // Field AgingPayment
        $filterList = Concat($filterList, $this->ClientID->AdvancedSearch->toJson(), ","); // Field ClientID
        $filterList = Concat($filterList, $this->ManagerID->AdvancedSearch->toJson(), ","); // Field ManagerID
        $filterList = Concat($filterList, $this->ProjectTemplateID->AdvancedSearch->toJson(), ","); // Field ProjectTemplateID
        $filterList = Concat($filterList, $this->Priority->AdvancedSearch->toJson(), ","); // Field Priority
        $filterList = Concat($filterList, $this->ProjectValue->AdvancedSearch->toJson(), ","); // Field ProjectValue
        $filterList = Concat($filterList, $this->ProjectDebt->AdvancedSearch->toJson(), ","); // Field ProjectDebt
        $filterList = Concat($filterList, $this->PONumber->AdvancedSearch->toJson(), ","); // Field PONumber
        $filterList = Concat($filterList, $this->PaymentLink->AdvancedSearch->toJson(), ","); // Field PaymentLink
        $filterList = Concat($filterList, $this->ClearingDate->AdvancedSearch->toJson(), ","); // Field ClearingDate
        $filterList = Concat($filterList, $this->ClearingAging->AdvancedSearch->toJson(), ","); // Field ClearingAging
        $filterList = Concat($filterList, $this->Active->AdvancedSearch->toJson(), ","); // Field Active
        $filterList = Concat($filterList, $this->Created_Date->AdvancedSearch->toJson(), ","); // Field Created_Date
        $filterList = Concat($filterList, $this->Created_By->AdvancedSearch->toJson(), ","); // Field Created_By
        $filterList = Concat($filterList, $this->Last_Updated_Date->AdvancedSearch->toJson(), ","); // Field Last_Updated_Date
        $filterList = Concat($filterList, $this->Last_Updated_By->AdvancedSearch->toJson(), ","); // Field Last_Updated_By
        if ($this->BasicSearch->Keyword != "") {
            $wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
            $filterList = Concat($filterList, $wrk, ",");
        }

        // Query Builder rules
        $rules = $this->queryBuilderRules();
        if ($rules) {
            $filterList = Concat($filterList, "\"" . Config("TABLE_RULES") . "\":\"" . JsEncode($rules) . "\"", ",");
        }

        // Return filter list in JSON
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Process filter list
    protected function processFilterList()
    {
        if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
            $filters = Post("filters");
            Profile()->setSearchFilters("fmasterprojectsrch", $filters);
            WriteJson([["success" => true]]); // Success
            return true;
        } elseif (Post("cmd") == "resetfilter") {
            $this->restoreFilterList();
        }
        return false;
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd") !== "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter"), true);
        $this->Command = "search";

        // Field ProjectID
        $this->_ProjectID->AdvancedSearch->SearchValue = @$filter["x__ProjectID"];
        $this->_ProjectID->AdvancedSearch->SearchOperator = @$filter["z__ProjectID"];
        $this->_ProjectID->AdvancedSearch->SearchCondition = @$filter["v__ProjectID"];
        $this->_ProjectID->AdvancedSearch->SearchValue2 = @$filter["y__ProjectID"];
        $this->_ProjectID->AdvancedSearch->SearchOperator2 = @$filter["w__ProjectID"];
        $this->_ProjectID->AdvancedSearch->save();

        // Field ProjectName
        $this->ProjectName->AdvancedSearch->SearchValue = @$filter["x_ProjectName"];
        $this->ProjectName->AdvancedSearch->SearchOperator = @$filter["z_ProjectName"];
        $this->ProjectName->AdvancedSearch->SearchCondition = @$filter["v_ProjectName"];
        $this->ProjectName->AdvancedSearch->SearchValue2 = @$filter["y_ProjectName"];
        $this->ProjectName->AdvancedSearch->SearchOperator2 = @$filter["w_ProjectName"];
        $this->ProjectName->AdvancedSearch->save();

        // Field PlanStart
        $this->PlanStart->AdvancedSearch->SearchValue = @$filter["x_PlanStart"];
        $this->PlanStart->AdvancedSearch->SearchOperator = @$filter["z_PlanStart"];
        $this->PlanStart->AdvancedSearch->SearchCondition = @$filter["v_PlanStart"];
        $this->PlanStart->AdvancedSearch->SearchValue2 = @$filter["y_PlanStart"];
        $this->PlanStart->AdvancedSearch->SearchOperator2 = @$filter["w_PlanStart"];
        $this->PlanStart->AdvancedSearch->save();

        // Field PlanEnd
        $this->PlanEnd->AdvancedSearch->SearchValue = @$filter["x_PlanEnd"];
        $this->PlanEnd->AdvancedSearch->SearchOperator = @$filter["z_PlanEnd"];
        $this->PlanEnd->AdvancedSearch->SearchCondition = @$filter["v_PlanEnd"];
        $this->PlanEnd->AdvancedSearch->SearchValue2 = @$filter["y_PlanEnd"];
        $this->PlanEnd->AdvancedSearch->SearchOperator2 = @$filter["w_PlanEnd"];
        $this->PlanEnd->AdvancedSearch->save();

        // Field StartDate
        $this->StartDate->AdvancedSearch->SearchValue = @$filter["x_StartDate"];
        $this->StartDate->AdvancedSearch->SearchOperator = @$filter["z_StartDate"];
        $this->StartDate->AdvancedSearch->SearchCondition = @$filter["v_StartDate"];
        $this->StartDate->AdvancedSearch->SearchValue2 = @$filter["y_StartDate"];
        $this->StartDate->AdvancedSearch->SearchOperator2 = @$filter["w_StartDate"];
        $this->StartDate->AdvancedSearch->save();

        // Field EndDate
        $this->EndDate->AdvancedSearch->SearchValue = @$filter["x_EndDate"];
        $this->EndDate->AdvancedSearch->SearchOperator = @$filter["z_EndDate"];
        $this->EndDate->AdvancedSearch->SearchCondition = @$filter["v_EndDate"];
        $this->EndDate->AdvancedSearch->SearchValue2 = @$filter["y_EndDate"];
        $this->EndDate->AdvancedSearch->SearchOperator2 = @$filter["w_EndDate"];
        $this->EndDate->AdvancedSearch->save();

        // Field WarrantyEnd
        $this->WarrantyEnd->AdvancedSearch->SearchValue = @$filter["x_WarrantyEnd"];
        $this->WarrantyEnd->AdvancedSearch->SearchOperator = @$filter["z_WarrantyEnd"];
        $this->WarrantyEnd->AdvancedSearch->SearchCondition = @$filter["v_WarrantyEnd"];
        $this->WarrantyEnd->AdvancedSearch->SearchValue2 = @$filter["y_WarrantyEnd"];
        $this->WarrantyEnd->AdvancedSearch->SearchOperator2 = @$filter["w_WarrantyEnd"];
        $this->WarrantyEnd->AdvancedSearch->save();

        // Field Status
        $this->Status->AdvancedSearch->SearchValue = @$filter["x_Status"];
        $this->Status->AdvancedSearch->SearchOperator = @$filter["z_Status"];
        $this->Status->AdvancedSearch->SearchCondition = @$filter["v_Status"];
        $this->Status->AdvancedSearch->SearchValue2 = @$filter["y_Status"];
        $this->Status->AdvancedSearch->SearchOperator2 = @$filter["w_Status"];
        $this->Status->AdvancedSearch->save();

        // Field Progress
        $this->Progress->AdvancedSearch->SearchValue = @$filter["x_Progress"];
        $this->Progress->AdvancedSearch->SearchOperator = @$filter["z_Progress"];
        $this->Progress->AdvancedSearch->SearchCondition = @$filter["v_Progress"];
        $this->Progress->AdvancedSearch->SearchValue2 = @$filter["y_Progress"];
        $this->Progress->AdvancedSearch->SearchOperator2 = @$filter["w_Progress"];
        $this->Progress->AdvancedSearch->save();

        // Field Target
        $this->Target->AdvancedSearch->SearchValue = @$filter["x_Target"];
        $this->Target->AdvancedSearch->SearchOperator = @$filter["z_Target"];
        $this->Target->AdvancedSearch->SearchCondition = @$filter["v_Target"];
        $this->Target->AdvancedSearch->SearchValue2 = @$filter["y_Target"];
        $this->Target->AdvancedSearch->SearchOperator2 = @$filter["w_Target"];
        $this->Target->AdvancedSearch->save();

        // Field Track
        $this->Track->AdvancedSearch->SearchValue = @$filter["x_Track"];
        $this->Track->AdvancedSearch->SearchOperator = @$filter["z_Track"];
        $this->Track->AdvancedSearch->SearchCondition = @$filter["v_Track"];
        $this->Track->AdvancedSearch->SearchValue2 = @$filter["y_Track"];
        $this->Track->AdvancedSearch->SearchOperator2 = @$filter["w_Track"];
        $this->Track->AdvancedSearch->save();

        // Field PaymentProgress
        $this->PaymentProgress->AdvancedSearch->SearchValue = @$filter["x_PaymentProgress"];
        $this->PaymentProgress->AdvancedSearch->SearchOperator = @$filter["z_PaymentProgress"];
        $this->PaymentProgress->AdvancedSearch->SearchCondition = @$filter["v_PaymentProgress"];
        $this->PaymentProgress->AdvancedSearch->SearchValue2 = @$filter["y_PaymentProgress"];
        $this->PaymentProgress->AdvancedSearch->SearchOperator2 = @$filter["w_PaymentProgress"];
        $this->PaymentProgress->AdvancedSearch->save();

        // Field PaymentDate
        $this->PaymentDate->AdvancedSearch->SearchValue = @$filter["x_PaymentDate"];
        $this->PaymentDate->AdvancedSearch->SearchOperator = @$filter["z_PaymentDate"];
        $this->PaymentDate->AdvancedSearch->SearchCondition = @$filter["v_PaymentDate"];
        $this->PaymentDate->AdvancedSearch->SearchValue2 = @$filter["y_PaymentDate"];
        $this->PaymentDate->AdvancedSearch->SearchOperator2 = @$filter["w_PaymentDate"];
        $this->PaymentDate->AdvancedSearch->save();

        // Field PaymentComplete
        $this->PaymentComplete->AdvancedSearch->SearchValue = @$filter["x_PaymentComplete"];
        $this->PaymentComplete->AdvancedSearch->SearchOperator = @$filter["z_PaymentComplete"];
        $this->PaymentComplete->AdvancedSearch->SearchCondition = @$filter["v_PaymentComplete"];
        $this->PaymentComplete->AdvancedSearch->SearchValue2 = @$filter["y_PaymentComplete"];
        $this->PaymentComplete->AdvancedSearch->SearchOperator2 = @$filter["w_PaymentComplete"];
        $this->PaymentComplete->AdvancedSearch->save();

        // Field AgingPayment
        $this->AgingPayment->AdvancedSearch->SearchValue = @$filter["x_AgingPayment"];
        $this->AgingPayment->AdvancedSearch->SearchOperator = @$filter["z_AgingPayment"];
        $this->AgingPayment->AdvancedSearch->SearchCondition = @$filter["v_AgingPayment"];
        $this->AgingPayment->AdvancedSearch->SearchValue2 = @$filter["y_AgingPayment"];
        $this->AgingPayment->AdvancedSearch->SearchOperator2 = @$filter["w_AgingPayment"];
        $this->AgingPayment->AdvancedSearch->save();

        // Field ClientID
        $this->ClientID->AdvancedSearch->SearchValue = @$filter["x_ClientID"];
        $this->ClientID->AdvancedSearch->SearchOperator = @$filter["z_ClientID"];
        $this->ClientID->AdvancedSearch->SearchCondition = @$filter["v_ClientID"];
        $this->ClientID->AdvancedSearch->SearchValue2 = @$filter["y_ClientID"];
        $this->ClientID->AdvancedSearch->SearchOperator2 = @$filter["w_ClientID"];
        $this->ClientID->AdvancedSearch->save();

        // Field ManagerID
        $this->ManagerID->AdvancedSearch->SearchValue = @$filter["x_ManagerID"];
        $this->ManagerID->AdvancedSearch->SearchOperator = @$filter["z_ManagerID"];
        $this->ManagerID->AdvancedSearch->SearchCondition = @$filter["v_ManagerID"];
        $this->ManagerID->AdvancedSearch->SearchValue2 = @$filter["y_ManagerID"];
        $this->ManagerID->AdvancedSearch->SearchOperator2 = @$filter["w_ManagerID"];
        $this->ManagerID->AdvancedSearch->save();

        // Field ProjectTemplateID
        $this->ProjectTemplateID->AdvancedSearch->SearchValue = @$filter["x_ProjectTemplateID"];
        $this->ProjectTemplateID->AdvancedSearch->SearchOperator = @$filter["z_ProjectTemplateID"];
        $this->ProjectTemplateID->AdvancedSearch->SearchCondition = @$filter["v_ProjectTemplateID"];
        $this->ProjectTemplateID->AdvancedSearch->SearchValue2 = @$filter["y_ProjectTemplateID"];
        $this->ProjectTemplateID->AdvancedSearch->SearchOperator2 = @$filter["w_ProjectTemplateID"];
        $this->ProjectTemplateID->AdvancedSearch->save();

        // Field Priority
        $this->Priority->AdvancedSearch->SearchValue = @$filter["x_Priority"];
        $this->Priority->AdvancedSearch->SearchOperator = @$filter["z_Priority"];
        $this->Priority->AdvancedSearch->SearchCondition = @$filter["v_Priority"];
        $this->Priority->AdvancedSearch->SearchValue2 = @$filter["y_Priority"];
        $this->Priority->AdvancedSearch->SearchOperator2 = @$filter["w_Priority"];
        $this->Priority->AdvancedSearch->save();

        // Field ProjectValue
        $this->ProjectValue->AdvancedSearch->SearchValue = @$filter["x_ProjectValue"];
        $this->ProjectValue->AdvancedSearch->SearchOperator = @$filter["z_ProjectValue"];
        $this->ProjectValue->AdvancedSearch->SearchCondition = @$filter["v_ProjectValue"];
        $this->ProjectValue->AdvancedSearch->SearchValue2 = @$filter["y_ProjectValue"];
        $this->ProjectValue->AdvancedSearch->SearchOperator2 = @$filter["w_ProjectValue"];
        $this->ProjectValue->AdvancedSearch->save();

        // Field ProjectDebt
        $this->ProjectDebt->AdvancedSearch->SearchValue = @$filter["x_ProjectDebt"];
        $this->ProjectDebt->AdvancedSearch->SearchOperator = @$filter["z_ProjectDebt"];
        $this->ProjectDebt->AdvancedSearch->SearchCondition = @$filter["v_ProjectDebt"];
        $this->ProjectDebt->AdvancedSearch->SearchValue2 = @$filter["y_ProjectDebt"];
        $this->ProjectDebt->AdvancedSearch->SearchOperator2 = @$filter["w_ProjectDebt"];
        $this->ProjectDebt->AdvancedSearch->save();

        // Field PONumber
        $this->PONumber->AdvancedSearch->SearchValue = @$filter["x_PONumber"];
        $this->PONumber->AdvancedSearch->SearchOperator = @$filter["z_PONumber"];
        $this->PONumber->AdvancedSearch->SearchCondition = @$filter["v_PONumber"];
        $this->PONumber->AdvancedSearch->SearchValue2 = @$filter["y_PONumber"];
        $this->PONumber->AdvancedSearch->SearchOperator2 = @$filter["w_PONumber"];
        $this->PONumber->AdvancedSearch->save();

        // Field PaymentLink
        $this->PaymentLink->AdvancedSearch->SearchValue = @$filter["x_PaymentLink"];
        $this->PaymentLink->AdvancedSearch->SearchOperator = @$filter["z_PaymentLink"];
        $this->PaymentLink->AdvancedSearch->SearchCondition = @$filter["v_PaymentLink"];
        $this->PaymentLink->AdvancedSearch->SearchValue2 = @$filter["y_PaymentLink"];
        $this->PaymentLink->AdvancedSearch->SearchOperator2 = @$filter["w_PaymentLink"];
        $this->PaymentLink->AdvancedSearch->save();

        // Field ClearingDate
        $this->ClearingDate->AdvancedSearch->SearchValue = @$filter["x_ClearingDate"];
        $this->ClearingDate->AdvancedSearch->SearchOperator = @$filter["z_ClearingDate"];
        $this->ClearingDate->AdvancedSearch->SearchCondition = @$filter["v_ClearingDate"];
        $this->ClearingDate->AdvancedSearch->SearchValue2 = @$filter["y_ClearingDate"];
        $this->ClearingDate->AdvancedSearch->SearchOperator2 = @$filter["w_ClearingDate"];
        $this->ClearingDate->AdvancedSearch->save();

        // Field ClearingAging
        $this->ClearingAging->AdvancedSearch->SearchValue = @$filter["x_ClearingAging"];
        $this->ClearingAging->AdvancedSearch->SearchOperator = @$filter["z_ClearingAging"];
        $this->ClearingAging->AdvancedSearch->SearchCondition = @$filter["v_ClearingAging"];
        $this->ClearingAging->AdvancedSearch->SearchValue2 = @$filter["y_ClearingAging"];
        $this->ClearingAging->AdvancedSearch->SearchOperator2 = @$filter["w_ClearingAging"];
        $this->ClearingAging->AdvancedSearch->save();

        // Field Active
        $this->Active->AdvancedSearch->SearchValue = @$filter["x_Active"];
        $this->Active->AdvancedSearch->SearchOperator = @$filter["z_Active"];
        $this->Active->AdvancedSearch->SearchCondition = @$filter["v_Active"];
        $this->Active->AdvancedSearch->SearchValue2 = @$filter["y_Active"];
        $this->Active->AdvancedSearch->SearchOperator2 = @$filter["w_Active"];
        $this->Active->AdvancedSearch->save();

        // Field Created_Date
        $this->Created_Date->AdvancedSearch->SearchValue = @$filter["x_Created_Date"];
        $this->Created_Date->AdvancedSearch->SearchOperator = @$filter["z_Created_Date"];
        $this->Created_Date->AdvancedSearch->SearchCondition = @$filter["v_Created_Date"];
        $this->Created_Date->AdvancedSearch->SearchValue2 = @$filter["y_Created_Date"];
        $this->Created_Date->AdvancedSearch->SearchOperator2 = @$filter["w_Created_Date"];
        $this->Created_Date->AdvancedSearch->save();

        // Field Created_By
        $this->Created_By->AdvancedSearch->SearchValue = @$filter["x_Created_By"];
        $this->Created_By->AdvancedSearch->SearchOperator = @$filter["z_Created_By"];
        $this->Created_By->AdvancedSearch->SearchCondition = @$filter["v_Created_By"];
        $this->Created_By->AdvancedSearch->SearchValue2 = @$filter["y_Created_By"];
        $this->Created_By->AdvancedSearch->SearchOperator2 = @$filter["w_Created_By"];
        $this->Created_By->AdvancedSearch->save();

        // Field Last_Updated_Date
        $this->Last_Updated_Date->AdvancedSearch->SearchValue = @$filter["x_Last_Updated_Date"];
        $this->Last_Updated_Date->AdvancedSearch->SearchOperator = @$filter["z_Last_Updated_Date"];
        $this->Last_Updated_Date->AdvancedSearch->SearchCondition = @$filter["v_Last_Updated_Date"];
        $this->Last_Updated_Date->AdvancedSearch->SearchValue2 = @$filter["y_Last_Updated_Date"];
        $this->Last_Updated_Date->AdvancedSearch->SearchOperator2 = @$filter["w_Last_Updated_Date"];
        $this->Last_Updated_Date->AdvancedSearch->save();

        // Field Last_Updated_By
        $this->Last_Updated_By->AdvancedSearch->SearchValue = @$filter["x_Last_Updated_By"];
        $this->Last_Updated_By->AdvancedSearch->SearchOperator = @$filter["z_Last_Updated_By"];
        $this->Last_Updated_By->AdvancedSearch->SearchCondition = @$filter["v_Last_Updated_By"];
        $this->Last_Updated_By->AdvancedSearch->SearchValue2 = @$filter["y_Last_Updated_By"];
        $this->Last_Updated_By->AdvancedSearch->SearchOperator2 = @$filter["w_Last_Updated_By"];
        $this->Last_Updated_By->AdvancedSearch->save();
        $this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
        $this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
        if ($filter[Config("TABLE_RULES")] ?? false) {
            $this->Command = "query"; // Set command for query builder
            $this->setSessionRules($filter[Config("TABLE_RULES")]);
        }
    }

    // Advanced search WHERE clause based on QueryString
    public function advancedSearchWhere($default = false)
    {
        global $Security;
        $where = "";
        if (!$Security->canSearch()) {
            return "";
        }
        $this->buildSearchSql($where, $this->_ProjectID, $default, false); // ProjectID
        $this->buildSearchSql($where, $this->ProjectName, $default, true); // ProjectName
        $this->buildSearchSql($where, $this->PlanStart, $default, true); // PlanStart
        $this->buildSearchSql($where, $this->PlanEnd, $default, true); // PlanEnd
        $this->buildSearchSql($where, $this->StartDate, $default, true); // StartDate
        $this->buildSearchSql($where, $this->EndDate, $default, true); // EndDate
        $this->buildSearchSql($where, $this->WarrantyEnd, $default, true); // WarrantyEnd
        $this->buildSearchSql($where, $this->Status, $default, true); // Status
        $this->buildSearchSql($where, $this->Progress, $default, true); // Progress
        $this->buildSearchSql($where, $this->Target, $default, true); // Target
        $this->buildSearchSql($where, $this->Track, $default, true); // Track
        $this->buildSearchSql($where, $this->PaymentProgress, $default, true); // PaymentProgress
        $this->buildSearchSql($where, $this->PaymentDate, $default, true); // PaymentDate
        $this->buildSearchSql($where, $this->PaymentComplete, $default, true); // PaymentComplete
        $this->buildSearchSql($where, $this->AgingPayment, $default, true); // AgingPayment
        $this->buildSearchSql($where, $this->ClientID, $default, true); // ClientID
        $this->buildSearchSql($where, $this->ManagerID, $default, true); // ManagerID
        $this->buildSearchSql($where, $this->ProjectTemplateID, $default, true); // ProjectTemplateID
        $this->buildSearchSql($where, $this->Priority, $default, true); // Priority
        $this->buildSearchSql($where, $this->ProjectValue, $default, true); // ProjectValue
        $this->buildSearchSql($where, $this->ProjectDebt, $default, true); // ProjectDebt
        $this->buildSearchSql($where, $this->PONumber, $default, true); // PONumber
        $this->buildSearchSql($where, $this->PaymentLink, $default, false); // PaymentLink
        $this->buildSearchSql($where, $this->ClearingDate, $default, false); // ClearingDate
        $this->buildSearchSql($where, $this->ClearingAging, $default, false); // ClearingAging
        $this->buildSearchSql($where, $this->Active, $default, true); // Active
        $this->buildSearchSql($where, $this->Created_Date, $default, true); // Created_Date
        $this->buildSearchSql($where, $this->Created_By, $default, true); // Created_By
        $this->buildSearchSql($where, $this->Last_Updated_Date, $default, true); // Last_Updated_Date
        $this->buildSearchSql($where, $this->Last_Updated_By, $default, true); // Last_Updated_By

        // Set up search command
        if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
            $this->Command = "search";
        }
        if (!$default && $this->Command == "search") {
            $this->_ProjectID->AdvancedSearch->save(); // ProjectID
            $this->ProjectName->AdvancedSearch->save(); // ProjectName
            $this->PlanStart->AdvancedSearch->save(); // PlanStart
            $this->PlanEnd->AdvancedSearch->save(); // PlanEnd
            $this->StartDate->AdvancedSearch->save(); // StartDate
            $this->EndDate->AdvancedSearch->save(); // EndDate
            $this->WarrantyEnd->AdvancedSearch->save(); // WarrantyEnd
            $this->Status->AdvancedSearch->save(); // Status
            $this->Progress->AdvancedSearch->save(); // Progress
            $this->Target->AdvancedSearch->save(); // Target
            $this->Track->AdvancedSearch->save(); // Track
            $this->PaymentProgress->AdvancedSearch->save(); // PaymentProgress
            $this->PaymentDate->AdvancedSearch->save(); // PaymentDate
            $this->PaymentComplete->AdvancedSearch->save(); // PaymentComplete
            $this->AgingPayment->AdvancedSearch->save(); // AgingPayment
            $this->ClientID->AdvancedSearch->save(); // ClientID
            $this->ManagerID->AdvancedSearch->save(); // ManagerID
            $this->ProjectTemplateID->AdvancedSearch->save(); // ProjectTemplateID
            $this->Priority->AdvancedSearch->save(); // Priority
            $this->ProjectValue->AdvancedSearch->save(); // ProjectValue
            $this->ProjectDebt->AdvancedSearch->save(); // ProjectDebt
            $this->PONumber->AdvancedSearch->save(); // PONumber
            $this->PaymentLink->AdvancedSearch->save(); // PaymentLink
            $this->ClearingDate->AdvancedSearch->save(); // ClearingDate
            $this->ClearingAging->AdvancedSearch->save(); // ClearingAging
            $this->Active->AdvancedSearch->save(); // Active
            $this->Created_Date->AdvancedSearch->save(); // Created_Date
            $this->Created_By->AdvancedSearch->save(); // Created_By
            $this->Last_Updated_Date->AdvancedSearch->save(); // Last_Updated_Date
            $this->Last_Updated_By->AdvancedSearch->save(); // Last_Updated_By

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $where;
    }

    // Query builder rules
    public function queryBuilderRules()
    {
        return Post("rules") ?? $this->getSessionRules();
    }

    // Quey builder WHERE clause
    public function queryBuilderWhere($fieldName = "")
    {
        global $Security;
        if (!$Security->canSearch()) {
            return "";
        }

        // Get rules by query builder
        $rules = $this->queryBuilderRules();

        // Decode and parse rules
        $where = $rules ? $this->parseRules(json_decode($rules, true), $fieldName) : "";

        // Clear other search and save rules to session
        if ($where && $fieldName == "") { // Skip if get query for specific field
            $this->resetSearchParms();
            $this->setSessionRules($rules);
        }

        // Return query
        return $where;
    }

    // Build search SQL
    protected function buildSearchSql(&$where, $fld, $default, $multiValue)
    {
        $fldParm = $fld->Param;
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldCond = $default ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        $fldOpr2 = $default ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
        $fldVal = ConvertSearchValue($fldVal, $fldOpr, $fld);
        $fldVal2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld);
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $fldVal);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $fldVal2);
        $wrk = "";
        $sep = $fld->UseFilter ? Config("FILTER_OPTION_SEPARATOR") : Config("MULTIPLE_OPTION_SEPARATOR");
        if (is_array($fldVal)) {
            $fldVal = implode($sep, $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode($sep, $fldVal2);
        }
        if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 && !$fld->UseFilter || !IsMultiSearchOperator($fldOpr)) {
            $multiValue = false;
        }
        if ($multiValue) {
            $wrk = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
            $wrk2 = $fldVal2 != "" ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
            AddFilter($wrk, $wrk2, $fldCond);
        } else {
            $wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
        }
        if ($this->SearchOption == "AUTO" && in_array($this->BasicSearch->getType(), ["AND", "OR"])) {
            $cond = $this->BasicSearch->getType();
        } else {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
        }
        AddFilter($where, $wrk, $cond);
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field ProjectName
        $filter = $this->queryBuilderWhere("ProjectName");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->ProjectName, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->ProjectName->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field PlanStart
        $filter = $this->queryBuilderWhere("PlanStart");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->PlanStart, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->PlanStart->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field PlanEnd
        $filter = $this->queryBuilderWhere("PlanEnd");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->PlanEnd, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->PlanEnd->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field StartDate
        $filter = $this->queryBuilderWhere("StartDate");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->StartDate, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->StartDate->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field EndDate
        $filter = $this->queryBuilderWhere("EndDate");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->EndDate, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->EndDate->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field WarrantyEnd
        $filter = $this->queryBuilderWhere("WarrantyEnd");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->WarrantyEnd, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->WarrantyEnd->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Status
        $filter = $this->queryBuilderWhere("Status");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Status, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Status->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Progress
        $filter = $this->queryBuilderWhere("Progress");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Progress, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Progress->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Target
        $filter = $this->queryBuilderWhere("Target");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Target, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Target->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Track
        $filter = $this->queryBuilderWhere("Track");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Track, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Track->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field PaymentProgress
        $filter = $this->queryBuilderWhere("PaymentProgress");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->PaymentProgress, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->PaymentProgress->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field PaymentDate
        $filter = $this->queryBuilderWhere("PaymentDate");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->PaymentDate, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->PaymentDate->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field PaymentComplete
        $filter = $this->queryBuilderWhere("PaymentComplete");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->PaymentComplete, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->PaymentComplete->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field AgingPayment
        $filter = $this->queryBuilderWhere("AgingPayment");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->AgingPayment, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->AgingPayment->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field ClientID
        $filter = $this->queryBuilderWhere("ClientID");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->ClientID, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->ClientID->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field ManagerID
        $filter = $this->queryBuilderWhere("ManagerID");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->ManagerID, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->ManagerID->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field ProjectTemplateID
        $filter = $this->queryBuilderWhere("ProjectTemplateID");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->ProjectTemplateID, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->ProjectTemplateID->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Priority
        $filter = $this->queryBuilderWhere("Priority");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Priority, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Priority->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field ProjectValue
        $filter = $this->queryBuilderWhere("ProjectValue");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->ProjectValue, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->ProjectValue->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field ProjectDebt
        $filter = $this->queryBuilderWhere("ProjectDebt");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->ProjectDebt, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->ProjectDebt->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field PONumber
        $filter = $this->queryBuilderWhere("PONumber");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->PONumber, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->PONumber->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field ClearingDate
        $filter = $this->queryBuilderWhere("ClearingDate");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->ClearingDate, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->ClearingDate->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field ClearingAging
        $filter = $this->queryBuilderWhere("ClearingAging");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->ClearingAging, false, false);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->ClearingAging->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Active
        $filter = $this->queryBuilderWhere("Active");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Active, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Active->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Created_Date
        $filter = $this->queryBuilderWhere("Created_Date");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Created_Date, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Created_Date->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Created_By
        $filter = $this->queryBuilderWhere("Created_By");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Created_By, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Created_By->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Last_Updated_Date
        $filter = $this->queryBuilderWhere("Last_Updated_Date");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Last_Updated_Date, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Last_Updated_Date->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field Last_Updated_By
        $filter = $this->queryBuilderWhere("Last_Updated_By");
        if (!$filter) {
            $this->buildSearchSql($filter, $this->Last_Updated_By, false, true);
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->Last_Updated_By->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }
        if ($this->BasicSearch->Keyword != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $Language->phrase("BasicSearchKeyword") . "</span>" . $captionSuffix . $this->BasicSearch->Keyword . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Return basic search WHERE clause based on search keyword and type
    public function basicSearchWhere($default = false)
    {
        global $Security;
        $searchStr = "";
        if (!$Security->canSearch()) {
            return "";
        }

        // Fields to search
        $searchFlds = [];
        $searchFlds[] = &$this->ProjectName;
        $searchFlds[] = &$this->Status;
        $searchFlds[] = &$this->Track;
        $searchFlds[] = &$this->PaymentComplete;
        $searchFlds[] = &$this->Description;
        $searchFlds[] = &$this->PONumber;
        $searchFlds[] = &$this->PaymentLink;
        $searchFlds[] = &$this->Created_By;
        $searchFlds[] = &$this->Last_Updated_By;
        $searchKeyword = $default ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
        $searchType = $default ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

        // Get search SQL
        if ($searchKeyword != "") {
            $ar = $this->BasicSearch->keywordList($default);
            $searchStr = GetQuickSearchFilter($searchFlds, $ar, $searchType, Config("BASIC_SEARCH_ANY_FIELDS"), $this->Dbid);
            if (!$default && in_array($this->Command, ["", "reset", "resetall"])) {
                $this->Command = "search";
            }
        }
        if (!$default && $this->Command == "search") {
            $this->BasicSearch->setKeyword($searchKeyword);
            $this->BasicSearch->setType($searchType);

            // Clear rules for QueryBuilder
            $this->setSessionRules("");
        }
        return $searchStr;
    }

    // Check if search parm exists
    protected function checkSearchParms()
    {
        // Check basic search
        if ($this->BasicSearch->issetSession()) {
            return true;
        }
        if ($this->_ProjectID->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->ProjectName->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->PlanStart->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->PlanEnd->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->StartDate->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->EndDate->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->WarrantyEnd->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Status->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Progress->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Target->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Track->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->PaymentProgress->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->PaymentDate->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->PaymentComplete->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->AgingPayment->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->ClientID->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->ManagerID->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->ProjectTemplateID->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Priority->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->ProjectValue->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->ProjectDebt->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->PONumber->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->PaymentLink->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->ClearingDate->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->ClearingAging->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Active->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Created_Date->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Created_By->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Last_Updated_Date->AdvancedSearch->issetSession()) {
            return true;
        }
        if ($this->Last_Updated_By->AdvancedSearch->issetSession()) {
            return true;
        }
        return false;
    }

    // Clear all search parameters
    protected function resetSearchParms()
    {
        // Clear search WHERE clause
        $this->SearchWhere = "";
        $this->setSearchWhere($this->SearchWhere);

        // Clear basic search parameters
        $this->resetBasicSearchParms();

        // Clear advanced search parameters
        $this->resetAdvancedSearchParms();

        // Clear queryBuilder
        $this->setSessionRules("");
    }

    // Load advanced search default values
    protected function loadAdvancedSearchDefault()
    {
        return false;
    }

    // Clear all basic search parameters
    protected function resetBasicSearchParms()
    {
        $this->BasicSearch->unsetSession();
    }

    // Clear all advanced search parameters
    protected function resetAdvancedSearchParms()
    {
        $this->_ProjectID->AdvancedSearch->unsetSession();
        $this->ProjectName->AdvancedSearch->unsetSession();
        $this->PlanStart->AdvancedSearch->unsetSession();
        $this->PlanEnd->AdvancedSearch->unsetSession();
        $this->StartDate->AdvancedSearch->unsetSession();
        $this->EndDate->AdvancedSearch->unsetSession();
        $this->WarrantyEnd->AdvancedSearch->unsetSession();
        $this->Status->AdvancedSearch->unsetSession();
        $this->Progress->AdvancedSearch->unsetSession();
        $this->Target->AdvancedSearch->unsetSession();
        $this->Track->AdvancedSearch->unsetSession();
        $this->PaymentProgress->AdvancedSearch->unsetSession();
        $this->PaymentDate->AdvancedSearch->unsetSession();
        $this->PaymentComplete->AdvancedSearch->unsetSession();
        $this->AgingPayment->AdvancedSearch->unsetSession();
        $this->ClientID->AdvancedSearch->unsetSession();
        $this->ManagerID->AdvancedSearch->unsetSession();
        $this->ProjectTemplateID->AdvancedSearch->unsetSession();
        $this->Priority->AdvancedSearch->unsetSession();
        $this->ProjectValue->AdvancedSearch->unsetSession();
        $this->ProjectDebt->AdvancedSearch->unsetSession();
        $this->PONumber->AdvancedSearch->unsetSession();
        $this->PaymentLink->AdvancedSearch->unsetSession();
        $this->ClearingDate->AdvancedSearch->unsetSession();
        $this->ClearingAging->AdvancedSearch->unsetSession();
        $this->Active->AdvancedSearch->unsetSession();
        $this->Created_Date->AdvancedSearch->unsetSession();
        $this->Created_By->AdvancedSearch->unsetSession();
        $this->Last_Updated_Date->AdvancedSearch->unsetSession();
        $this->Last_Updated_By->AdvancedSearch->unsetSession();
    }

    // Restore all search parameters
    protected function restoreSearchParms()
    {
        $this->RestoreSearch = true;

        // Restore basic search values
        $this->BasicSearch->load();

        // Restore advanced search values
        $this->_ProjectID->AdvancedSearch->load();
        $this->ProjectName->AdvancedSearch->load();
        $this->PlanStart->AdvancedSearch->load();
        $this->PlanEnd->AdvancedSearch->load();
        $this->StartDate->AdvancedSearch->load();
        $this->EndDate->AdvancedSearch->load();
        $this->WarrantyEnd->AdvancedSearch->load();
        $this->Status->AdvancedSearch->load();
        $this->Progress->AdvancedSearch->load();
        $this->Target->AdvancedSearch->load();
        $this->Track->AdvancedSearch->load();
        $this->PaymentProgress->AdvancedSearch->load();
        $this->PaymentDate->AdvancedSearch->load();
        $this->PaymentComplete->AdvancedSearch->load();
        $this->AgingPayment->AdvancedSearch->load();
        $this->ClientID->AdvancedSearch->load();
        $this->ManagerID->AdvancedSearch->load();
        $this->ProjectTemplateID->AdvancedSearch->load();
        $this->Priority->AdvancedSearch->load();
        $this->ProjectValue->AdvancedSearch->load();
        $this->ProjectDebt->AdvancedSearch->load();
        $this->PONumber->AdvancedSearch->load();
        $this->PaymentLink->AdvancedSearch->load();
        $this->ClearingDate->AdvancedSearch->load();
        $this->ClearingAging->AdvancedSearch->load();
        $this->Active->AdvancedSearch->load();
        $this->Created_Date->AdvancedSearch->load();
        $this->Created_By->AdvancedSearch->load();
        $this->Last_Updated_Date->AdvancedSearch->load();
        $this->Last_Updated_By->AdvancedSearch->load();
    }

    // Set up sort parameters
    protected function setupSortOrder()
    {
        // Load default Sorting Order
        if ($this->Command != "json") {
            $defaultSort = ""; // Set up default sort
            if ($this->getSessionOrderBy() == "" && $defaultSort != "") {
                $this->setSessionOrderBy($defaultSort);
            }
        }

        // Check for "order" parameter
        if (Get("order") !== null) {
            $this->CurrentOrder = Get("order");
            $this->CurrentOrderType = Get("ordertype", "");
            $this->updateSort($this->ProjectName); // ProjectName
            $this->updateSort($this->PlanStart); // PlanStart
            $this->updateSort($this->PlanEnd); // PlanEnd
            $this->updateSort($this->StartDate); // StartDate
            $this->updateSort($this->EndDate); // EndDate
            $this->updateSort($this->WarrantyEnd); // WarrantyEnd
            $this->updateSort($this->Status); // Status
            $this->updateSort($this->Progress); // Progress
            $this->updateSort($this->Target); // Target
            $this->updateSort($this->Track); // Track
            $this->updateSort($this->PaymentProgress); // PaymentProgress
            $this->updateSort($this->PaymentDate); // PaymentDate
            $this->updateSort($this->PaymentComplete); // PaymentComplete
            $this->updateSort($this->AgingPayment); // AgingPayment
            $this->updateSort($this->ClientID); // ClientID
            $this->updateSort($this->ManagerID); // ManagerID
            $this->updateSort($this->ProjectTemplateID); // ProjectTemplateID
            $this->updateSort($this->Priority); // Priority
            $this->updateSort($this->ProjectValue); // ProjectValue
            $this->updateSort($this->ProjectDebt); // ProjectDebt
            $this->updateSort($this->PONumber); // PONumber
            $this->updateSort($this->ClearingDate); // ClearingDate
            $this->updateSort($this->ClearingAging); // ClearingAging
            $this->updateSort($this->Active); // Active
            $this->updateSort($this->Created_Date); // Created_Date
            $this->updateSort($this->Created_By); // Created_By
            $this->updateSort($this->Last_Updated_Date); // Last_Updated_Date
            $this->updateSort($this->Last_Updated_By); // Last_Updated_By
            $this->setStartRecordNumber(1); // Reset start position
        }

        // Update field sort
        $this->updateFieldSort();
    }

    // Reset command
    // - cmd=reset (Reset search parameters)
    // - cmd=resetall (Reset search and master/detail parameters)
    // - cmd=resetsort (Reset sort parameters)
    protected function resetCmd()
    {
        // Check if reset command
        if (StartsString("reset", $this->Command)) {
            // Reset search criteria
            if ($this->Command == "reset" || $this->Command == "resetall") {
                $this->resetSearchParms();
            }

            // Reset (clear) sorting order
            if ($this->Command == "resetsort") {
                $orderBy = "";
                $this->setSessionOrderBy($orderBy);
                $this->_ProjectID->setSort("");
                $this->ProjectName->setSort("");
                $this->PlanStart->setSort("");
                $this->PlanEnd->setSort("");
                $this->StartDate->setSort("");
                $this->EndDate->setSort("");
                $this->WarrantyEnd->setSort("");
                $this->Status->setSort("");
                $this->Progress->setSort("");
                $this->Target->setSort("");
                $this->Track->setSort("");
                $this->PaymentProgress->setSort("");
                $this->PaymentDate->setSort("");
                $this->PaymentComplete->setSort("");
                $this->AgingPayment->setSort("");
                $this->ClientID->setSort("");
                $this->ManagerID->setSort("");
                $this->ProjectTemplateID->setSort("");
                $this->Priority->setSort("");
                $this->Description->setSort("");
                $this->ProjectValue->setSort("");
                $this->ProjectDebt->setSort("");
                $this->PONumber->setSort("");
                $this->PaymentLink->setSort("");
                $this->ClearingDate->setSort("");
                $this->ClearingAging->setSort("");
                $this->Active->setSort("");
                $this->Created_Date->setSort("");
                $this->Created_By->setSort("");
                $this->Last_Updated_Date->setSort("");
                $this->Last_Updated_By->setSort("");
            }

            // Reset start position
            $this->StartRecord = 1;
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Set up list options
    protected function setupListOptions()
    {
        global $Security, $Language;

        // Add group option item ("button")
        $item = &$this->ListOptions->addGroupOption();
        $item->Body = "";
        $item->OnLeft = true;
        $item->Visible = false;

        // "view"
        $item = &$this->ListOptions->add("view");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canView();
        $item->OnLeft = true;

        // "edit"
        $item = &$this->ListOptions->add("edit");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canEdit();
        $item->OnLeft = true;

        // "copy"
        $item = &$this->ListOptions->add("copy");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->canAdd();
        $item->OnLeft = true;

        // "detail_projectmember"
        $item = &$this->ListOptions->add("detail_projectmember");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->allowList(CurrentProjectID() . 'projectmember');
        $item->OnLeft = true;
        $item->ShowInButtonGroup = false;

        // "detail_projecttask"
        $item = &$this->ListOptions->add("detail_projecttask");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->allowList(CurrentProjectID() . 'projecttask');
        $item->OnLeft = true;
        $item->ShowInButtonGroup = false;

        // "detail_projectresult"
        $item = &$this->ListOptions->add("detail_projectresult");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->allowList(CurrentProjectID() . 'projectresult');
        $item->OnLeft = true;
        $item->ShowInButtonGroup = false;

        // "detail_projectmom"
        $item = &$this->ListOptions->add("detail_projectmom");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->allowList(CurrentProjectID() . 'projectmom');
        $item->OnLeft = true;
        $item->ShowInButtonGroup = false;

        // "detail_projectdocuments"
        $item = &$this->ListOptions->add("detail_projectdocuments");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->allowList(CurrentProjectID() . 'projectdocuments');
        $item->OnLeft = true;
        $item->ShowInButtonGroup = false;

        // "detail_projectpaymentprocess"
        $item = &$this->ListOptions->add("detail_projectpaymentprocess");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->allowList(CurrentProjectID() . 'projectpaymentprocess');
        $item->OnLeft = true;
        $item->ShowInButtonGroup = false;

        // "detail_projectproblems"
        $item = &$this->ListOptions->add("detail_projectproblems");
        $item->CssClass = "text-nowrap";
        $item->Visible = $Security->allowList(CurrentProjectID() . 'projectproblems');
        $item->OnLeft = true;
        $item->ShowInButtonGroup = false;

        // Multiple details
        if ($this->ShowMultipleDetails) {
            $item = &$this->ListOptions->add("details");
            $item->CssClass = "text-nowrap";
            $item->Visible = $this->ShowMultipleDetails && $this->ListOptions->detailVisible();
            $item->OnLeft = true;
            $item->ShowInButtonGroup = false;
            $this->ListOptions->hideDetailItems();
        }

        // Set up detail pages
        $pages = new SubPages();
        $pages->add("projectmember");
        $pages->add("projecttask");
        $pages->add("projectresult");
        $pages->add("projectmom");
        $pages->add("projectdocuments");
        $pages->add("projectpaymentprocess");
        $pages->add("projectproblems");
        $this->DetailPages = $pages;

        // List actions
        $item = &$this->ListOptions->add("listactions");
        $item->CssClass = "text-nowrap";
        $item->OnLeft = true;
        $item->Visible = false;
        $item->ShowInButtonGroup = false;
        $item->ShowInDropDown = false;

        // "checkbox"
        $item = &$this->ListOptions->add("checkbox");
        $item->Visible = ($Security->canDelete() || $Security->canEdit());
        $item->OnLeft = true;
        $item->Header = "<div class=\"form-check\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"form-check-input\" data-ew-action=\"select-all-keys\"></div>";
        if ($item->OnLeft) {
            $item->moveTo(0);
        }
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // "sequence"
        $item = &$this->ListOptions->add("sequence");
        $item->CssClass = "text-nowrap";
        $item->Visible = true;
        $item->OnLeft = true; // Always on left
        $item->ShowInDropDown = false;
        $item->ShowInButtonGroup = false;

        // Drop down button for ListOptions
        $this->ListOptions->UseDropDownButton = true;
        $this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
        $this->ListOptions->UseButtonGroup = true;
        if ($this->ListOptions->UseButtonGroup && IsMobile()) {
            $this->ListOptions->UseDropDownButton = true;
        }

        //$this->ListOptions->ButtonClass = ""; // Class for button group

        // Call ListOptions_Load event
        $this->listOptionsLoad();
        $this->setupListOptionsExt();
        $item = $this->ListOptions[$this->ListOptions->GroupOptionName];
        $item->Visible = $this->ListOptions->groupOptionVisible();
    }

    // Set up list options (extensions)
    protected function setupListOptionsExt()
    {
        // Preview extension
        $this->ListOptions->hideDetailItemsForDropDown(); // Hide detail items for dropdown if necessary
    }

    // Add "hash" parameter to URL
    public function urlAddHash($url, $hash)
    {
        return $this->UseAjaxActions ? $url : UrlAddQuery($url, "hash=" . $hash);
    }

    // Render list options
    public function renderListOptions()
    {
        global $Security, $Language, $CurrentForm;
        $this->ListOptions->loadDefault();

        // Call ListOptions_Rendering event
        $this->listOptionsRendering();

        // "sequence"
        $opt = $this->ListOptions["sequence"];
        $opt->Body = FormatSequenceNumber($this->RecordCount);
        $pageUrl = $this->pageUrl(false);
        if ($this->CurrentMode == "view") {
            // "view"
            $opt = $this->ListOptions["view"];
            $viewcaption = HtmlTitle($Language->phrase("ViewLink"));
            if ($Security->canView()) {
                if ($this->ModalView && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-table=\"masterproject\" data-caption=\"" . $viewcaption . "\" data-ew-action=\"modal\" data-action=\"view\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\" data-btn=\"null\">" . $Language->phrase("ViewLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode(GetUrl($this->ViewUrl)) . "\">" . $Language->phrase("ViewLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "edit"
            $opt = $this->ListOptions["edit"];
            $editcaption = HtmlTitle($Language->phrase("EditLink"));
            if ($Security->canEdit()) {
                if ($this->ModalEdit && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-table=\"masterproject\" data-caption=\"" . $editcaption . "\" data-ew-action=\"modal\" data-action=\"edit\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\" data-btn=\"SaveBtn\">" . $Language->phrase("EditLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode(GetUrl($this->EditUrl)) . "\">" . $Language->phrase("EditLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }

            // "copy"
            $opt = $this->ListOptions["copy"];
            $copycaption = HtmlTitle($Language->phrase("CopyLink"));
            if ($Security->canAdd()) {
                if ($this->ModalAdd && !IsMobile()) {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-table=\"masterproject\" data-caption=\"" . $copycaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("CopyLink") . "</a>";
                } else {
                    $opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode(GetUrl($this->CopyUrl)) . "\">" . $Language->phrase("CopyLink") . "</a>";
                }
            } else {
                $opt->Body = "";
            }
        } // End View mode

        // Set up list action buttons
        $opt = $this->ListOptions["listactions"];
        if ($opt && !$this->isExport() && !$this->CurrentAction) {
            $body = "";
            $links = [];
            foreach ($this->ListActions as $listAction) {
                $action = $listAction->Action;
                $allowed = $listAction->Allowed;
                $disabled = false;
                if ($listAction->Select == ACTION_SINGLE && $allowed) {
                    $caption = $listAction->Caption;
                    $title = HtmlTitle($caption);
                    if ($action != "") {
                        $icon = ($listAction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listAction->Icon)) . "\" data-caption=\"" . $title . "\"></i> " : "";
                        $link = $disabled
                            ? "<li><div class=\"alert alert-light\">" . $icon . " " . $caption . "</div></li>"
                            : "<li><button type=\"button\" class=\"dropdown-item ew-action ew-list-action\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fmasterprojectlist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttrs() . ">" . $icon . " " . $caption . "</button></li>";
                        $links[] = $link;
                        if ($body == "") { // Setup first button
                            $body = $disabled
                            ? "<div class=\"alert alert-light\">" . $icon . " " . $caption . "</div>"
                            : "<button type=\"button\" class=\"btn btn-default ew-action ew-list-action\" title=\"" . $title . "\" data-caption=\"" . $title . "\" data-ew-action=\"submit\" form=\"fmasterprojectlist\" data-key=\"" . $this->keyToJson(true) . "\"" . $listAction->toDataAttrs() . ">" . $icon . " " . $caption . "</button>";
                        }
                    }
                }
            }
            if (count($links) > 1) { // More than one buttons, use dropdown
                $body = "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
                $content = "";
                foreach ($links as $link) {
                    $content .= "<li>" . $link . "</li>";
                }
                $body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">" . $content . "</ul>";
                $body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
            }
            if (count($links) > 0) {
                $opt->Body = $body;
            }
        }
        $detailViewTblVar = "";
        $detailCopyTblVar = "";
        $detailEditTblVar = "";

        // "detail_projectmember"
        $opt = $this->ListOptions["detail_projectmember"];
        if ($Security->allowList(CurrentProjectID() . 'projectmember')) {
            $body = $Language->phrase("DetailLink") . $Language->tablePhrase("projectmember", "TblCaption");
            $body = "<a class=\"btn btn-default ew-row-link ew-detail" . ($this->ListOptions->UseDropDownButton ? " dropdown-toggle" : "") . "\" data-action=\"list\" href=\"" . HtmlEncode("projectmemberlist?" . Config("TABLE_SHOW_MASTER") . "=masterproject&" . GetForeignKeyUrl("fk__ProjectID", $this->_ProjectID->CurrentValue) . "") . "\">" . $body . "</a>";
            $links = "";
            $detailPage = Container("ProjectmemberGrid");
            if ($detailPage->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $url = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=projectmember");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailViewTblVar != "") {
                    $detailViewTblVar .= ",";
                }
                $detailViewTblVar .= "projectmember";
            }
            if ($detailPage->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $url = $this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=projectmember");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailEditTblVar != "") {
                    $detailEditTblVar .= ",";
                }
                $detailEditTblVar .= "projectmember";
            }
            if ($detailPage->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $url = $this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=projectmember");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailCopyTblVar != "") {
                    $detailCopyTblVar .= ",";
                }
                $detailCopyTblVar .= "projectmember";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-detail\" data-bs-toggle=\"dropdown\"></button>";
                $body .= "<ul class=\"dropdown-menu\">" . $links . "</ul>";
            } else {
                $body = preg_replace('/\b\s+dropdown-toggle\b/', "", $body);
            }
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
            $opt->Body = $body;
            if ($this->ShowMultipleDetails) {
                $opt->Visible = false;
            }
        }

        // "detail_projecttask"
        $opt = $this->ListOptions["detail_projecttask"];
        if ($Security->allowList(CurrentProjectID() . 'projecttask')) {
            $body = $Language->phrase("DetailLink") . $Language->tablePhrase("projecttask", "TblCaption");
            $body = "<a class=\"btn btn-default ew-row-link ew-detail" . ($this->ListOptions->UseDropDownButton ? " dropdown-toggle" : "") . "\" data-action=\"list\" href=\"" . HtmlEncode("projecttasklist?" . Config("TABLE_SHOW_MASTER") . "=masterproject&" . GetForeignKeyUrl("fk__ProjectID", $this->_ProjectID->CurrentValue) . "") . "\">" . $body . "</a>";
            $links = "";
            $detailPage = Container("ProjecttaskGrid");
            if ($detailPage->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $url = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=projecttask");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailViewTblVar != "") {
                    $detailViewTblVar .= ",";
                }
                $detailViewTblVar .= "projecttask";
            }
            if ($detailPage->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $url = $this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=projecttask");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailEditTblVar != "") {
                    $detailEditTblVar .= ",";
                }
                $detailEditTblVar .= "projecttask";
            }
            if ($detailPage->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $url = $this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=projecttask");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailCopyTblVar != "") {
                    $detailCopyTblVar .= ",";
                }
                $detailCopyTblVar .= "projecttask";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-detail\" data-bs-toggle=\"dropdown\"></button>";
                $body .= "<ul class=\"dropdown-menu\">" . $links . "</ul>";
            } else {
                $body = preg_replace('/\b\s+dropdown-toggle\b/', "", $body);
            }
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
            $opt->Body = $body;
            if ($this->ShowMultipleDetails) {
                $opt->Visible = false;
            }
        }

        // "detail_projectresult"
        $opt = $this->ListOptions["detail_projectresult"];
        if ($Security->allowList(CurrentProjectID() . 'projectresult')) {
            $body = $Language->phrase("DetailLink") . $Language->tablePhrase("projectresult", "TblCaption");
            $body = "<a class=\"btn btn-default ew-row-link ew-detail" . ($this->ListOptions->UseDropDownButton ? " dropdown-toggle" : "") . "\" data-action=\"list\" href=\"" . HtmlEncode("projectresultlist?" . Config("TABLE_SHOW_MASTER") . "=masterproject&" . GetForeignKeyUrl("fk__ProjectID", $this->_ProjectID->CurrentValue) . "") . "\">" . $body . "</a>";
            $links = "";
            $detailPage = Container("ProjectresultGrid");
            if ($detailPage->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $url = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=projectresult");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailViewTblVar != "") {
                    $detailViewTblVar .= ",";
                }
                $detailViewTblVar .= "projectresult";
            }
            if ($detailPage->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $url = $this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=projectresult");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailEditTblVar != "") {
                    $detailEditTblVar .= ",";
                }
                $detailEditTblVar .= "projectresult";
            }
            if ($detailPage->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $url = $this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=projectresult");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailCopyTblVar != "") {
                    $detailCopyTblVar .= ",";
                }
                $detailCopyTblVar .= "projectresult";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-detail\" data-bs-toggle=\"dropdown\"></button>";
                $body .= "<ul class=\"dropdown-menu\">" . $links . "</ul>";
            } else {
                $body = preg_replace('/\b\s+dropdown-toggle\b/', "", $body);
            }
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
            $opt->Body = $body;
            if ($this->ShowMultipleDetails) {
                $opt->Visible = false;
            }
        }

        // "detail_projectmom"
        $opt = $this->ListOptions["detail_projectmom"];
        if ($Security->allowList(CurrentProjectID() . 'projectmom')) {
            $body = $Language->phrase("DetailLink") . $Language->tablePhrase("projectmom", "TblCaption");
            $body = "<a class=\"btn btn-default ew-row-link ew-detail" . ($this->ListOptions->UseDropDownButton ? " dropdown-toggle" : "") . "\" data-action=\"list\" href=\"" . HtmlEncode("projectmomlist?" . Config("TABLE_SHOW_MASTER") . "=masterproject&" . GetForeignKeyUrl("fk__ProjectID", $this->_ProjectID->CurrentValue) . "") . "\">" . $body . "</a>";
            $links = "";
            $detailPage = Container("ProjectmomGrid");
            if ($detailPage->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $url = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=projectmom");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailViewTblVar != "") {
                    $detailViewTblVar .= ",";
                }
                $detailViewTblVar .= "projectmom";
            }
            if ($detailPage->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $url = $this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=projectmom");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailEditTblVar != "") {
                    $detailEditTblVar .= ",";
                }
                $detailEditTblVar .= "projectmom";
            }
            if ($detailPage->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $url = $this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=projectmom");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailCopyTblVar != "") {
                    $detailCopyTblVar .= ",";
                }
                $detailCopyTblVar .= "projectmom";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-detail\" data-bs-toggle=\"dropdown\"></button>";
                $body .= "<ul class=\"dropdown-menu\">" . $links . "</ul>";
            } else {
                $body = preg_replace('/\b\s+dropdown-toggle\b/', "", $body);
            }
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
            $opt->Body = $body;
            if ($this->ShowMultipleDetails) {
                $opt->Visible = false;
            }
        }

        // "detail_projectdocuments"
        $opt = $this->ListOptions["detail_projectdocuments"];
        if ($Security->allowList(CurrentProjectID() . 'projectdocuments')) {
            $body = $Language->phrase("DetailLink") . $Language->tablePhrase("projectdocuments", "TblCaption");
            $body = "<a class=\"btn btn-default ew-row-link ew-detail" . ($this->ListOptions->UseDropDownButton ? " dropdown-toggle" : "") . "\" data-action=\"list\" href=\"" . HtmlEncode("projectdocumentslist?" . Config("TABLE_SHOW_MASTER") . "=masterproject&" . GetForeignKeyUrl("fk__ProjectID", $this->_ProjectID->CurrentValue) . "") . "\">" . $body . "</a>";
            $links = "";
            $detailPage = Container("ProjectdocumentsGrid");
            if ($detailPage->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $url = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=projectdocuments");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailViewTblVar != "") {
                    $detailViewTblVar .= ",";
                }
                $detailViewTblVar .= "projectdocuments";
            }
            if ($detailPage->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $url = $this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=projectdocuments");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailEditTblVar != "") {
                    $detailEditTblVar .= ",";
                }
                $detailEditTblVar .= "projectdocuments";
            }
            if ($detailPage->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $url = $this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=projectdocuments");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailCopyTblVar != "") {
                    $detailCopyTblVar .= ",";
                }
                $detailCopyTblVar .= "projectdocuments";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-detail\" data-bs-toggle=\"dropdown\"></button>";
                $body .= "<ul class=\"dropdown-menu\">" . $links . "</ul>";
            } else {
                $body = preg_replace('/\b\s+dropdown-toggle\b/', "", $body);
            }
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
            $opt->Body = $body;
            if ($this->ShowMultipleDetails) {
                $opt->Visible = false;
            }
        }

        // "detail_projectpaymentprocess"
        $opt = $this->ListOptions["detail_projectpaymentprocess"];
        if ($Security->allowList(CurrentProjectID() . 'projectpaymentprocess')) {
            $body = $Language->phrase("DetailLink") . $Language->tablePhrase("projectpaymentprocess", "TblCaption");
            $body = "<a class=\"btn btn-default ew-row-link ew-detail" . ($this->ListOptions->UseDropDownButton ? " dropdown-toggle" : "") . "\" data-action=\"list\" href=\"" . HtmlEncode("projectpaymentprocesslist?" . Config("TABLE_SHOW_MASTER") . "=masterproject&" . GetForeignKeyUrl("fk__ProjectID", $this->_ProjectID->CurrentValue) . "") . "\">" . $body . "</a>";
            $links = "";
            $detailPage = Container("ProjectpaymentprocessGrid");
            if ($detailPage->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $url = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=projectpaymentprocess");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailViewTblVar != "") {
                    $detailViewTblVar .= ",";
                }
                $detailViewTblVar .= "projectpaymentprocess";
            }
            if ($detailPage->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $url = $this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=projectpaymentprocess");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailEditTblVar != "") {
                    $detailEditTblVar .= ",";
                }
                $detailEditTblVar .= "projectpaymentprocess";
            }
            if ($detailPage->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $url = $this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=projectpaymentprocess");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailCopyTblVar != "") {
                    $detailCopyTblVar .= ",";
                }
                $detailCopyTblVar .= "projectpaymentprocess";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-detail\" data-bs-toggle=\"dropdown\"></button>";
                $body .= "<ul class=\"dropdown-menu\">" . $links . "</ul>";
            } else {
                $body = preg_replace('/\b\s+dropdown-toggle\b/', "", $body);
            }
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
            $opt->Body = $body;
            if ($this->ShowMultipleDetails) {
                $opt->Visible = false;
            }
        }

        // "detail_projectproblems"
        $opt = $this->ListOptions["detail_projectproblems"];
        if ($Security->allowList(CurrentProjectID() . 'projectproblems')) {
            $body = $Language->phrase("DetailLink") . $Language->tablePhrase("projectproblems", "TblCaption");
            $body = "<a class=\"btn btn-default ew-row-link ew-detail" . ($this->ListOptions->UseDropDownButton ? " dropdown-toggle" : "") . "\" data-action=\"list\" href=\"" . HtmlEncode("projectproblemslist?" . Config("TABLE_SHOW_MASTER") . "=masterproject&" . GetForeignKeyUrl("fk__ProjectID", $this->_ProjectID->CurrentValue) . "") . "\">" . $body . "</a>";
            $links = "";
            $detailPage = Container("ProjectproblemsGrid");
            if ($detailPage->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $url = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=projectproblems");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailViewTblVar != "") {
                    $detailViewTblVar .= ",";
                }
                $detailViewTblVar .= "projectproblems";
            }
            if ($detailPage->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $url = $this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=projectproblems");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailEditTblVar != "") {
                    $detailEditTblVar .= ",";
                }
                $detailEditTblVar .= "projectproblems";
            }
            if ($detailPage->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $url = $this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=projectproblems");
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a></li>";
                if ($detailCopyTblVar != "") {
                    $detailCopyTblVar .= ",";
                }
                $detailCopyTblVar .= "projectproblems";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-detail\" data-bs-toggle=\"dropdown\"></button>";
                $body .= "<ul class=\"dropdown-menu\">" . $links . "</ul>";
            } else {
                $body = preg_replace('/\b\s+dropdown-toggle\b/', "", $body);
            }
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
            $opt->Body = $body;
            if ($this->ShowMultipleDetails) {
                $opt->Visible = false;
            }
        }
        if ($this->ShowMultipleDetails) {
            $body = "<div class=\"btn-group btn-group-sm ew-btn-group\">";
            $links = "";
            if ($detailViewTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailViewLink", true)) . "\" href=\"" . HtmlEncode($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailViewTblVar)) . "\">" . $Language->phrase("MasterDetailViewLink", null) . "</a></li>";
            }
            if ($detailEditTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailEditLink", true)) . "\" href=\"" . HtmlEncode($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailEditTblVar)) . "\">" . $Language->phrase("MasterDetailEditLink", null) . "</a></li>";
            }
            if ($detailCopyTblVar != "") {
                $links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlEncode($Language->phrase("MasterDetailCopyLink", true)) . "\" href=\"" . HtmlEncode($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailCopyTblVar)) . "\">" . $Language->phrase("MasterDetailCopyLink", null) . "</a></li>";
            }
            if ($links != "") {
                $body .= "<button type=\"button\" class=\"dropdown-toggle btn btn-default ew-master-detail\" title=\"" . HtmlEncode($Language->phrase("MultipleMasterDetails", true)) . "\" data-bs-toggle=\"dropdown\">" . $Language->phrase("MultipleMasterDetails") . "</button>";
                $body .= "<ul class=\"dropdown-menu ew-dropdown-menu\">" . $links . "</ul>";
            }
            $body .= "</div>";
            // Multiple details
            $opt = $this->ListOptions["details"];
            $opt->Body = $body;
        }

        // "checkbox"
        $opt = $this->ListOptions["checkbox"];
        $opt->Body = "<div class=\"form-check\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"form-check-input ew-multi-select\" value=\"" . HtmlEncode($this->_ProjectID->CurrentValue) . "\" data-ew-action=\"select-key\"></div>";
        $this->renderListOptionsExt();

        // Call ListOptions_Rendered event
        $this->listOptionsRendered();
    }

    // Render list options (extensions)
    protected function renderListOptionsExt()
    {
        // Render list options (to be implemented by extensions)
        global $Security, $Language;

        // Preview extension
        $links = "";
        $detailFilters = [];
        $masterKeys = []; // Reset
        $masterKeys["_ProjectID"] = strval($this->_ProjectID->DbValue);

        // Column "detail_projectmember"
        if ($this->DetailPages?->getItem("projectmember")?->Visible && $Security->allowList(CurrentProjectID() . 'projectmember')) {
            $link = "";
            $option = $this->ListOptions["detail_projectmember"];
            $detailTbl = Container("projectmember");
            $detailFilter = $detailTbl->getDetailFilter($this);
            $detailTbl->setCurrentMasterTable($this->TableVar);
            $detailFilter = $detailTbl->applyUserIDFilters($detailFilter);
            $url = "projectmemberpreview?t=masterproject&f=" . Encrypt($detailFilter . "|" . implode("|", array_values($masterKeys)));
            $btngrp = "<div data-table=\"projectmember\" data-url=\"" . $url . "\" class=\"ew-detail-btn-group btn-group btn-group-sm d-none\">";
            if ($Security->allowList(CurrentProjectID() . 'masterproject')) {
                $label = $Language->tablePhrase("projectmember", "TblCaption");
                $link = "<button class=\"nav-link\" data-bs-toggle=\"tab\" data-table=\"projectmember\" data-url=\"" . $url . "\" type=\"button\" role=\"tab\" aria-selected=\"false\">" . $label . "</button>";
                $detaillnk = GetUrl("projectmemberlist?" . Config("TABLE_SHOW_MASTER") . "=masterproject");
                foreach ($masterKeys as $key => $value) {
                    $detaillnk .= "&" . GetForeignKeyUrl("fk_$key", $value);
                }
                $title = $Language->tablePhrase("projectmember", "TblCaption");
                $caption = $Language->phrase("MasterDetailListLink");
                $caption .= "&nbsp;" . $title;
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($detaillnk) . "\">" . $caption . "</button>";
            }
            $detailPageObj = Container("ProjectmemberGrid");
            if ($detailPageObj->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $viewurl = GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=projectmember"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($viewurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $editurl = GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=projectmember"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($editurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $copyurl = GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=projectmember"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($copyurl) . "\">" . $caption . "</button>";
            }
            $btngrp .= "</div>";
            if ($link != "") {
                $link = "<li class=\"nav-item\">" . $btngrp . $link . "</li>";  // Note: Place $btngrp before $link
                $links .= $link;
                $option->Body .= "<div class=\"ew-preview d-none\">" . $link . "</div>";
            }
        }
        $masterKeys = []; // Reset
        $masterKeys["_ProjectID"] = strval($this->_ProjectID->DbValue);

        // Column "detail_projecttask"
        if ($this->DetailPages?->getItem("projecttask")?->Visible && $Security->allowList(CurrentProjectID() . 'projecttask')) {
            $link = "";
            $option = $this->ListOptions["detail_projecttask"];
            $detailTbl = Container("projecttask");
            $detailFilter = $detailTbl->getDetailFilter($this);
            $detailTbl->setCurrentMasterTable($this->TableVar);
            $detailFilter = $detailTbl->applyUserIDFilters($detailFilter);
            $url = "projecttaskpreview?t=masterproject&f=" . Encrypt($detailFilter . "|" . implode("|", array_values($masterKeys)));
            $btngrp = "<div data-table=\"projecttask\" data-url=\"" . $url . "\" class=\"ew-detail-btn-group btn-group btn-group-sm d-none\">";
            if ($Security->allowList(CurrentProjectID() . 'masterproject')) {
                $label = $Language->tablePhrase("projecttask", "TblCaption");
                $link = "<button class=\"nav-link\" data-bs-toggle=\"tab\" data-table=\"projecttask\" data-url=\"" . $url . "\" type=\"button\" role=\"tab\" aria-selected=\"false\">" . $label . "</button>";
                $detaillnk = GetUrl("projecttasklist?" . Config("TABLE_SHOW_MASTER") . "=masterproject");
                foreach ($masterKeys as $key => $value) {
                    $detaillnk .= "&" . GetForeignKeyUrl("fk_$key", $value);
                }
                $title = $Language->tablePhrase("projecttask", "TblCaption");
                $caption = $Language->phrase("MasterDetailListLink");
                $caption .= "&nbsp;" . $title;
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($detaillnk) . "\">" . $caption . "</button>";
            }
            $detailPageObj = Container("ProjecttaskGrid");
            if ($detailPageObj->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $viewurl = GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=projecttask"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($viewurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $editurl = GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=projecttask"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($editurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $copyurl = GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=projecttask"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($copyurl) . "\">" . $caption . "</button>";
            }
            $btngrp .= "</div>";
            if ($link != "") {
                $link = "<li class=\"nav-item\">" . $btngrp . $link . "</li>";  // Note: Place $btngrp before $link
                $links .= $link;
                $option->Body .= "<div class=\"ew-preview d-none\">" . $link . "</div>";
            }
        }
        $masterKeys = []; // Reset
        $masterKeys["_ProjectID"] = strval($this->_ProjectID->DbValue);

        // Column "detail_projectresult"
        if ($this->DetailPages?->getItem("projectresult")?->Visible && $Security->allowList(CurrentProjectID() . 'projectresult')) {
            $link = "";
            $option = $this->ListOptions["detail_projectresult"];
            $detailTbl = Container("projectresult");
            $detailFilter = $detailTbl->getDetailFilter($this);
            $detailTbl->setCurrentMasterTable($this->TableVar);
            $detailFilter = $detailTbl->applyUserIDFilters($detailFilter);
            $url = "projectresultpreview?t=masterproject&f=" . Encrypt($detailFilter . "|" . implode("|", array_values($masterKeys)));
            $btngrp = "<div data-table=\"projectresult\" data-url=\"" . $url . "\" class=\"ew-detail-btn-group btn-group btn-group-sm d-none\">";
            if ($Security->allowList(CurrentProjectID() . 'masterproject')) {
                $label = $Language->tablePhrase("projectresult", "TblCaption");
                $link = "<button class=\"nav-link\" data-bs-toggle=\"tab\" data-table=\"projectresult\" data-url=\"" . $url . "\" type=\"button\" role=\"tab\" aria-selected=\"false\">" . $label . "</button>";
                $detaillnk = GetUrl("projectresultlist?" . Config("TABLE_SHOW_MASTER") . "=masterproject");
                foreach ($masterKeys as $key => $value) {
                    $detaillnk .= "&" . GetForeignKeyUrl("fk_$key", $value);
                }
                $title = $Language->tablePhrase("projectresult", "TblCaption");
                $caption = $Language->phrase("MasterDetailListLink");
                $caption .= "&nbsp;" . $title;
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($detaillnk) . "\">" . $caption . "</button>";
            }
            $detailPageObj = Container("ProjectresultGrid");
            if ($detailPageObj->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $viewurl = GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=projectresult"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($viewurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $editurl = GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=projectresult"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($editurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $copyurl = GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=projectresult"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($copyurl) . "\">" . $caption . "</button>";
            }
            $btngrp .= "</div>";
            if ($link != "") {
                $link = "<li class=\"nav-item\">" . $btngrp . $link . "</li>";  // Note: Place $btngrp before $link
                $links .= $link;
                $option->Body .= "<div class=\"ew-preview d-none\">" . $link . "</div>";
            }
        }
        $masterKeys = []; // Reset
        $masterKeys["_ProjectID"] = strval($this->_ProjectID->DbValue);

        // Column "detail_projectmom"
        if ($this->DetailPages?->getItem("projectmom")?->Visible && $Security->allowList(CurrentProjectID() . 'projectmom')) {
            $link = "";
            $option = $this->ListOptions["detail_projectmom"];
            $detailTbl = Container("projectmom");
            $detailFilter = $detailTbl->getDetailFilter($this);
            $detailTbl->setCurrentMasterTable($this->TableVar);
            $detailFilter = $detailTbl->applyUserIDFilters($detailFilter);
            $url = "projectmompreview?t=masterproject&f=" . Encrypt($detailFilter . "|" . implode("|", array_values($masterKeys)));
            $btngrp = "<div data-table=\"projectmom\" data-url=\"" . $url . "\" class=\"ew-detail-btn-group btn-group btn-group-sm d-none\">";
            if ($Security->allowList(CurrentProjectID() . 'masterproject')) {
                $label = $Language->tablePhrase("projectmom", "TblCaption");
                $link = "<button class=\"nav-link\" data-bs-toggle=\"tab\" data-table=\"projectmom\" data-url=\"" . $url . "\" type=\"button\" role=\"tab\" aria-selected=\"false\">" . $label . "</button>";
                $detaillnk = GetUrl("projectmomlist?" . Config("TABLE_SHOW_MASTER") . "=masterproject");
                foreach ($masterKeys as $key => $value) {
                    $detaillnk .= "&" . GetForeignKeyUrl("fk_$key", $value);
                }
                $title = $Language->tablePhrase("projectmom", "TblCaption");
                $caption = $Language->phrase("MasterDetailListLink");
                $caption .= "&nbsp;" . $title;
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($detaillnk) . "\">" . $caption . "</button>";
            }
            $detailPageObj = Container("ProjectmomGrid");
            if ($detailPageObj->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $viewurl = GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=projectmom"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($viewurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $editurl = GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=projectmom"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($editurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $copyurl = GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=projectmom"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($copyurl) . "\">" . $caption . "</button>";
            }
            $btngrp .= "</div>";
            if ($link != "") {
                $link = "<li class=\"nav-item\">" . $btngrp . $link . "</li>";  // Note: Place $btngrp before $link
                $links .= $link;
                $option->Body .= "<div class=\"ew-preview d-none\">" . $link . "</div>";
            }
        }
        $masterKeys = []; // Reset
        $masterKeys["_ProjectID"] = strval($this->_ProjectID->DbValue);

        // Column "detail_projectdocuments"
        if ($this->DetailPages?->getItem("projectdocuments")?->Visible && $Security->allowList(CurrentProjectID() . 'projectdocuments')) {
            $link = "";
            $option = $this->ListOptions["detail_projectdocuments"];
            $detailTbl = Container("projectdocuments");
            $detailFilter = $detailTbl->getDetailFilter($this);
            $detailTbl->setCurrentMasterTable($this->TableVar);
            $detailFilter = $detailTbl->applyUserIDFilters($detailFilter);
            $url = "projectdocumentspreview?t=masterproject&f=" . Encrypt($detailFilter . "|" . implode("|", array_values($masterKeys)));
            $btngrp = "<div data-table=\"projectdocuments\" data-url=\"" . $url . "\" class=\"ew-detail-btn-group btn-group btn-group-sm d-none\">";
            if ($Security->allowList(CurrentProjectID() . 'masterproject')) {
                $label = $Language->tablePhrase("projectdocuments", "TblCaption");
                $link = "<button class=\"nav-link\" data-bs-toggle=\"tab\" data-table=\"projectdocuments\" data-url=\"" . $url . "\" type=\"button\" role=\"tab\" aria-selected=\"false\">" . $label . "</button>";
                $detaillnk = GetUrl("projectdocumentslist?" . Config("TABLE_SHOW_MASTER") . "=masterproject");
                foreach ($masterKeys as $key => $value) {
                    $detaillnk .= "&" . GetForeignKeyUrl("fk_$key", $value);
                }
                $title = $Language->tablePhrase("projectdocuments", "TblCaption");
                $caption = $Language->phrase("MasterDetailListLink");
                $caption .= "&nbsp;" . $title;
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($detaillnk) . "\">" . $caption . "</button>";
            }
            $detailPageObj = Container("ProjectdocumentsGrid");
            if ($detailPageObj->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $viewurl = GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=projectdocuments"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($viewurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $editurl = GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=projectdocuments"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($editurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $copyurl = GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=projectdocuments"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($copyurl) . "\">" . $caption . "</button>";
            }
            $btngrp .= "</div>";
            if ($link != "") {
                $link = "<li class=\"nav-item\">" . $btngrp . $link . "</li>";  // Note: Place $btngrp before $link
                $links .= $link;
                $option->Body .= "<div class=\"ew-preview d-none\">" . $link . "</div>";
            }
        }
        $masterKeys = []; // Reset
        $masterKeys["_ProjectID"] = strval($this->_ProjectID->DbValue);

        // Column "detail_projectpaymentprocess"
        if ($this->DetailPages?->getItem("projectpaymentprocess")?->Visible && $Security->allowList(CurrentProjectID() . 'projectpaymentprocess')) {
            $link = "";
            $option = $this->ListOptions["detail_projectpaymentprocess"];
            $detailTbl = Container("projectpaymentprocess");
            $detailFilter = $detailTbl->getDetailFilter($this);
            $detailTbl->setCurrentMasterTable($this->TableVar);
            $detailFilter = $detailTbl->applyUserIDFilters($detailFilter);
            $url = "projectpaymentprocesspreview?t=masterproject&f=" . Encrypt($detailFilter . "|" . implode("|", array_values($masterKeys)));
            $btngrp = "<div data-table=\"projectpaymentprocess\" data-url=\"" . $url . "\" class=\"ew-detail-btn-group btn-group btn-group-sm d-none\">";
            if ($Security->allowList(CurrentProjectID() . 'masterproject')) {
                $label = $Language->tablePhrase("projectpaymentprocess", "TblCaption");
                $link = "<button class=\"nav-link\" data-bs-toggle=\"tab\" data-table=\"projectpaymentprocess\" data-url=\"" . $url . "\" type=\"button\" role=\"tab\" aria-selected=\"false\">" . $label . "</button>";
                $detaillnk = GetUrl("projectpaymentprocesslist?" . Config("TABLE_SHOW_MASTER") . "=masterproject");
                foreach ($masterKeys as $key => $value) {
                    $detaillnk .= "&" . GetForeignKeyUrl("fk_$key", $value);
                }
                $title = $Language->tablePhrase("projectpaymentprocess", "TblCaption");
                $caption = $Language->phrase("MasterDetailListLink");
                $caption .= "&nbsp;" . $title;
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($detaillnk) . "\">" . $caption . "</button>";
            }
            $detailPageObj = Container("ProjectpaymentprocessGrid");
            if ($detailPageObj->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $viewurl = GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=projectpaymentprocess"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($viewurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $editurl = GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=projectpaymentprocess"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($editurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $copyurl = GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=projectpaymentprocess"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($copyurl) . "\">" . $caption . "</button>";
            }
            $btngrp .= "</div>";
            if ($link != "") {
                $link = "<li class=\"nav-item\">" . $btngrp . $link . "</li>";  // Note: Place $btngrp before $link
                $links .= $link;
                $option->Body .= "<div class=\"ew-preview d-none\">" . $link . "</div>";
            }
        }
        $masterKeys = []; // Reset
        $masterKeys["_ProjectID"] = strval($this->_ProjectID->DbValue);

        // Column "detail_projectproblems"
        if ($this->DetailPages?->getItem("projectproblems")?->Visible && $Security->allowList(CurrentProjectID() . 'projectproblems')) {
            $link = "";
            $option = $this->ListOptions["detail_projectproblems"];
            $detailTbl = Container("projectproblems");
            $detailFilter = $detailTbl->getDetailFilter($this);
            $detailTbl->setCurrentMasterTable($this->TableVar);
            $detailFilter = $detailTbl->applyUserIDFilters($detailFilter);
            $url = "projectproblemspreview?t=masterproject&f=" . Encrypt($detailFilter . "|" . implode("|", array_values($masterKeys)));
            $btngrp = "<div data-table=\"projectproblems\" data-url=\"" . $url . "\" class=\"ew-detail-btn-group btn-group btn-group-sm d-none\">";
            if ($Security->allowList(CurrentProjectID() . 'masterproject')) {
                $label = $Language->tablePhrase("projectproblems", "TblCaption");
                $link = "<button class=\"nav-link\" data-bs-toggle=\"tab\" data-table=\"projectproblems\" data-url=\"" . $url . "\" type=\"button\" role=\"tab\" aria-selected=\"false\">" . $label . "</button>";
                $detaillnk = GetUrl("projectproblemslist?" . Config("TABLE_SHOW_MASTER") . "=masterproject");
                foreach ($masterKeys as $key => $value) {
                    $detaillnk .= "&" . GetForeignKeyUrl("fk_$key", $value);
                }
                $title = $Language->tablePhrase("projectproblems", "TblCaption");
                $caption = $Language->phrase("MasterDetailListLink");
                $caption .= "&nbsp;" . $title;
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($detaillnk) . "\">" . $caption . "</button>";
            }
            $detailPageObj = Container("ProjectproblemsGrid");
            if ($detailPageObj->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailViewLink", null);
                $viewurl = GetUrl($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=projectproblems"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($viewurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailEditLink", null);
                $editurl = GetUrl($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=projectproblems"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($editurl) . "\">" . $caption . "</button>";
            }
            if ($detailPageObj->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'masterproject')) {
                $caption = $Language->phrase("MasterDetailCopyLink", null);
                $copyurl = GetUrl($this->getCopyUrl(Config("TABLE_SHOW_DETAIL") . "=projectproblems"));
                $btngrp .= "<button type=\"button\" class=\"btn btn-default\" data-ew-action=\"redirect\" data-url=\"" . HtmlEncode($copyurl) . "\">" . $caption . "</button>";
            }
            $btngrp .= "</div>";
            if ($link != "") {
                $link = "<li class=\"nav-item\">" . $btngrp . $link . "</li>";  // Note: Place $btngrp before $link
                $links .= $link;
                $option->Body .= "<div class=\"ew-preview d-none\">" . $link . "</div>";
            }
        }

        // Add row attributes for expandable row
        if ($this->RowType == RowType::VIEW) {
            $this->RowAttrs["data-widget"] = "expandable-table";
            $this->RowAttrs["aria-expanded"] = "false";
        }

        // Column "preview"
        $option = $this->ListOptions["preview"];
        if (!$option) { // Add preview column
            $option = &$this->ListOptions->add("preview");
            $option->OnLeft = true;
            $checkboxPos = $this->ListOptions->itemPos("checkbox");
            $pos = $checkboxPos === false
                ? ($option->OnLeft ? 0 : -1)
                : ($option->OnLeft ? $checkboxPos + 1 : $checkboxPos);
            $option->moveTo($pos);
            $option->Visible = !($this->isExport() || $this->isGridAdd() || $this->isGridEdit() || $this->isMultiEdit());
            $option->ShowInDropDown = false;
            $option->ShowInButtonGroup = false;
        }
        if ($option) {
            $icon = "fa-solid fa-caret-right"; // Right
            if (property_exists($this, "MultiColumnLayout") && $this->MultiColumnLayout == "table") {
                $option->CssStyle = "width: 1%;";
                if (!$option->OnLeft) {
                    $icon = preg_replace('/\\bright\\b/', "left", $icon);
                }
            }
            if (IsRTL()) { // Reverse
                if (preg_match('/\\bleft\\b/', $icon)) {
                    $icon = preg_replace('/\\bleft\\b/', "right", $icon);
                } elseif (preg_match('/\\bright\\b/', $icon)) {
                    $icon = preg_replace('/\\bright\\b/', "left", $icon);
                }
            }
            $option->Body = "<i role=\"button\" class=\"ew-preview-btn expandable-table-caret ew-icon " . $icon . "\"></i>" .
                "<div class=\"ew-preview d-none\">" . $links . "</div>";
            if ($option->Visible) {
                $option->Visible = $links != "";
            }
        }

        // Column "details" (Multiple details)
        $option = $this->ListOptions["details"];
        if ($option) {
            $option->Body .= "<div class=\"ew-preview d-none\">" . $links . "</div>";
            if ($option->Visible) {
                $option->Visible = $links != "";
            }
        }
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["addedit"];

        // Add
        $item = &$option->add("add");
        $addcaption = HtmlTitle($Language->phrase("AddLink"));
        if ($this->ModalAdd && !IsMobile()) {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-table=\"masterproject\" data-caption=\"" . $addcaption . "\" data-ew-action=\"modal\" data-action=\"add\" data-ajax=\"" . ($this->UseAjaxActions ? "true" : "false") . "\" data-url=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\" data-btn=\"AddBtn\">" . $Language->phrase("AddLink") . "</a>";
        } else {
            $item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode(GetUrl($this->AddUrl)) . "\">" . $Language->phrase("AddLink") . "</a>";
        }
        $item->Visible = $this->AddUrl != "" && $Security->canAdd();
        $option = $options["detail"];
        $detailTableLink = "";
        $item = &$option->add("detailadd_projectmember");
        $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=projectmember");
        $detailPage = Container("ProjectmemberGrid");
        $caption = $Language->phrase("Add") . "&nbsp;" . $this->tableCaption() . "/" . $detailPage->tableCaption();
        $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
        $item->Visible = ($detailPage->DetailAdd && $Security->allowAdd(CurrentProjectID() . 'masterproject') && $Security->canAdd());
        if ($item->Visible) {
            if ($detailTableLink != "") {
                $detailTableLink .= ",";
            }
            $detailTableLink .= "projectmember";
        }
        $item = &$option->add("detailadd_projecttask");
        $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=projecttask");
        $detailPage = Container("ProjecttaskGrid");
        $caption = $Language->phrase("Add") . "&nbsp;" . $this->tableCaption() . "/" . $detailPage->tableCaption();
        $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
        $item->Visible = ($detailPage->DetailAdd && $Security->allowAdd(CurrentProjectID() . 'masterproject') && $Security->canAdd());
        if ($item->Visible) {
            if ($detailTableLink != "") {
                $detailTableLink .= ",";
            }
            $detailTableLink .= "projecttask";
        }
        $item = &$option->add("detailadd_projectresult");
        $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=projectresult");
        $detailPage = Container("ProjectresultGrid");
        $caption = $Language->phrase("Add") . "&nbsp;" . $this->tableCaption() . "/" . $detailPage->tableCaption();
        $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
        $item->Visible = ($detailPage->DetailAdd && $Security->allowAdd(CurrentProjectID() . 'masterproject') && $Security->canAdd());
        if ($item->Visible) {
            if ($detailTableLink != "") {
                $detailTableLink .= ",";
            }
            $detailTableLink .= "projectresult";
        }
        $item = &$option->add("detailadd_projectmom");
        $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=projectmom");
        $detailPage = Container("ProjectmomGrid");
        $caption = $Language->phrase("Add") . "&nbsp;" . $this->tableCaption() . "/" . $detailPage->tableCaption();
        $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
        $item->Visible = ($detailPage->DetailAdd && $Security->allowAdd(CurrentProjectID() . 'masterproject') && $Security->canAdd());
        if ($item->Visible) {
            if ($detailTableLink != "") {
                $detailTableLink .= ",";
            }
            $detailTableLink .= "projectmom";
        }
        $item = &$option->add("detailadd_projectdocuments");
        $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=projectdocuments");
        $detailPage = Container("ProjectdocumentsGrid");
        $caption = $Language->phrase("Add") . "&nbsp;" . $this->tableCaption() . "/" . $detailPage->tableCaption();
        $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
        $item->Visible = ($detailPage->DetailAdd && $Security->allowAdd(CurrentProjectID() . 'masterproject') && $Security->canAdd());
        if ($item->Visible) {
            if ($detailTableLink != "") {
                $detailTableLink .= ",";
            }
            $detailTableLink .= "projectdocuments";
        }
        $item = &$option->add("detailadd_projectpaymentprocess");
        $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=projectpaymentprocess");
        $detailPage = Container("ProjectpaymentprocessGrid");
        $caption = $Language->phrase("Add") . "&nbsp;" . $this->tableCaption() . "/" . $detailPage->tableCaption();
        $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
        $item->Visible = ($detailPage->DetailAdd && $Security->allowAdd(CurrentProjectID() . 'masterproject') && $Security->canAdd());
        if ($item->Visible) {
            if ($detailTableLink != "") {
                $detailTableLink .= ",";
            }
            $detailTableLink .= "projectpaymentprocess";
        }
        $item = &$option->add("detailadd_projectproblems");
        $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=projectproblems");
        $detailPage = Container("ProjectproblemsGrid");
        $caption = $Language->phrase("Add") . "&nbsp;" . $this->tableCaption() . "/" . $detailPage->tableCaption();
        $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
        $item->Visible = ($detailPage->DetailAdd && $Security->allowAdd(CurrentProjectID() . 'masterproject') && $Security->canAdd());
        if ($item->Visible) {
            if ($detailTableLink != "") {
                $detailTableLink .= ",";
            }
            $detailTableLink .= "projectproblems";
        }

        // Add multiple details
        if ($this->ShowMultipleDetails) {
            $item = &$option->add("detailsadd");
            $url = $this->getAddUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailTableLink);
            $caption = $Language->phrase("AddMasterDetailLink");
            $item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode(GetUrl($url)) . "\">" . $caption . "</a>";
            $item->Visible = $detailTableLink != "" && $Security->canAdd();
            // Hide single master/detail items
            $ar = explode(",", $detailTableLink);
            $cnt = count($ar);
            for ($i = 0; $i < $cnt; $i++) {
                if ($item = $option["detailadd_" . $ar[$i]]) {
                    $item->Visible = false;
                }
            }
        }
        $option = $options["action"];

        // Add multi delete
        $item = &$option->add("multidelete");
        $item->Body = "<button type=\"button\" class=\"ew-action ew-multi-delete\" title=\"" .
            HtmlTitle($Language->phrase("DeleteSelectedLink")) . "\" data-caption=\"" .
            HtmlTitle($Language->phrase("DeleteSelectedLink")) . "\" form=\"fmasterprojectlist\"" .
            " data-ew-action=\"" . ($this->UseAjaxActions ? "inline" : "submit") . "\"" .
            ($this->UseAjaxActions ? " data-action=\"delete\"" : "") .
            " data-url=\"" . GetUrl($this->MultiDeleteUrl) . "\"" .
            ($this->InlineDelete ? " data-msg=\"" . HtmlEncode($Language->phrase("DeleteConfirm")) . "\" data-data='{\"action\":\"delete\"}'" : " data-data='{\"action\":\"show\"}'") .
            ">" . $Language->phrase("DeleteSelectedLink") . "</button>";
        $item->Visible = $Security->canDelete();

        // Add multi update
        $item = &$option->add("multiupdate");
        $item->Body = "<button type=\"button\" class=\"ew-action ew-multi-update\" title=\"" .
            $Language->phrase("UpdateSelectedLink", true) . "\" data-table=\"masterproject\" data-caption=\"" .
            $Language->phrase("UpdateSelectedLink", true) . "\" form=\"fmasterprojectlist\" data-ew-action=\"" .
            ($this->ModalUpdate && !IsMobile() ? "modal" : "submit") . "\"" .
            ($this->ModalUpdate && !IsMobile() ? " data-action=\"update\"" : "") .
            ($this->UseAjaxActions ? " data-ajax=\"true\"" : "") .
            " data-url=\"" . GetUrl($this->MultiUpdateUrl) . "\">" . $Language->phrase("UpdateSelectedLink") . "</button>";
        $item->Visible = $Security->canEdit();

        // Show column list for column visibility
        if ($this->UseColumnVisibility) {
            $option = $this->OtherOptions["column"];
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = $this->UseColumnVisibility;
            $this->createColumnOption($option, "ProjectName");
            $this->createColumnOption($option, "PlanStart");
            $this->createColumnOption($option, "PlanEnd");
            $this->createColumnOption($option, "StartDate");
            $this->createColumnOption($option, "EndDate");
            $this->createColumnOption($option, "WarrantyEnd");
            $this->createColumnOption($option, "Status");
            $this->createColumnOption($option, "Progress");
            $this->createColumnOption($option, "Target");
            $this->createColumnOption($option, "Track");
            $this->createColumnOption($option, "PaymentProgress");
            $this->createColumnOption($option, "PaymentDate");
            $this->createColumnOption($option, "PaymentComplete");
            $this->createColumnOption($option, "AgingPayment");
            $this->createColumnOption($option, "ClientID");
            $this->createColumnOption($option, "ManagerID");
            $this->createColumnOption($option, "ProjectTemplateID");
            $this->createColumnOption($option, "Priority");
            $this->createColumnOption($option, "ProjectValue");
            $this->createColumnOption($option, "ProjectDebt");
            $this->createColumnOption($option, "PONumber");
            $this->createColumnOption($option, "ClearingDate");
            $this->createColumnOption($option, "ClearingAging");
            $this->createColumnOption($option, "Active");
            $this->createColumnOption($option, "Created_Date");
            $this->createColumnOption($option, "Created_By");
            $this->createColumnOption($option, "Last_Updated_Date");
            $this->createColumnOption($option, "Last_Updated_By");
        }

        // Set up custom actions
        foreach ($this->CustomActions as $name => $action) {
            $this->ListActions[$name] = $action;
        }

        // Set up options default
        foreach ($options as $name => $option) {
            if ($name != "column") { // Always use dropdown for column
                $option->UseDropDownButton = true;
                $option->UseButtonGroup = true;
            }
            //$option->ButtonClass = ""; // Class for button group
            $item = &$option->addGroupOption();
            $item->Body = "";
            $item->Visible = false;
        }
        $options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
        $options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
        $options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fmasterprojectsrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fmasterprojectsrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Page header/footer options
        $this->HeaderOptions = new ListOptions(TagClassName: "ew-header-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->HeaderOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        $this->FooterOptions = new ListOptions(TagClassName: "ew-footer-option", UseDropDownButton: false, UseButtonGroup: false);
        $item = &$this->FooterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Show active user count from SQL
    }

    // Active user filter
    // - Get active users by SQL (SELECT COUNT(*) FROM UserTable WHERE ProfileField LIKE '%"SessionID":%')
    protected function activeUserFilter()
    {
        if (UserProfile::$FORCE_LOGOUT_USER) {
            $userProfileField = $this->Fields[Config("USER_PROFILE_FIELD_NAME")];
            return $userProfileField->Expression . " LIKE '%\"" . UserProfile::$SESSION_ID . "\":%'";
        }
        return "0=1"; // No active users
    }

    // Create new column option
    protected function createColumnOption($option, $name)
    {
        $field = $this->Fields[$name] ?? null;
        if ($field?->Visible) {
            $item = $option->add($field->Name);
            $item->Body = '<button class="dropdown-item">' .
                '<div class="form-check ew-dropdown-checkbox">' .
                '<div class="form-check-input ew-dropdown-check-input" data-field="' . $field->Param . '"></div>' .
                '<label class="form-check-label ew-dropdown-check-label">' . $field->caption() . '</label></div></button>';
        }
    }

    // Render other options
    public function renderOtherOptions()
    {
        global $Language, $Security;
        $options = &$this->OtherOptions;
        $option = $options["action"];
        // Set up list action buttons
        foreach ($this->ListActions as $listAction) {
            if ($listAction->Select == ACTION_MULTIPLE) {
                $item = &$option->add("custom_" . $listAction->Action);
                $caption = $listAction->Caption;
                $icon = ($listAction->Icon != "") ? '<i class="' . HtmlEncode($listAction->Icon) . '" data-caption="' . HtmlEncode($caption) . '"></i>' . $caption : $caption;
                $item->Body = '<button type="button" class="btn btn-default ew-action ew-list-action" title="' . HtmlEncode($caption) . '" data-caption="' . HtmlEncode($caption) . '" data-ew-action="submit" form="fmasterprojectlist"' . $listAction->toDataAttrs() . '>' . $icon . '</button>';
                $item->Visible = $listAction->Allowed;
            }
        }

        // Hide multi edit, grid edit and other options
        if ($this->TotalRecords <= 0) {
            $option = $options["addedit"];
            $item = $option["gridedit"];
            if ($item) {
                $item->Visible = false;
            }
            $option = $options["action"];
            $option->hideAllOptions();
        }
    }

    // Process list action
    protected function processListAction()
    {
        global $Language, $Security, $Response;
        $users = [];
        $user = "";
        $filter = $this->getFilterFromRecordKeys();
        $userAction = Post("action", "");
        if ($filter != "" && $userAction != "") {
            $conn = $this->getConnection();
            // Clear current action
            $this->CurrentAction = "";
            // Check permission first
            $actionCaption = $userAction;
            $listAction = $this->ListActions[$userAction] ?? null;
            if ($listAction) {
                $this->UserAction = $userAction;
                $actionCaption = $listAction->Caption ?: $listAction->Action;
                if (!$listAction->Allowed) {
                    $errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
                    if (Post("ajax") == $userAction) { // Ajax
                        echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                        return true;
                    } else {
                        $this->setFailureMessage($errmsg);
                        return false;
                    }
                }
            } else {
                $errmsg = str_replace('%s', $userAction, $Language->phrase("CustomActionNotFound"));
                if (Post("ajax") == $userAction) { // Ajax
                    echo "<p class=\"text-danger\">" . $errmsg . "</p>";
                    return true;
                } else {
                    $this->setFailureMessage($errmsg);
                    return false;
                }
            }
            $rows = $this->loadRs($filter)->fetchAllAssociative();
            $this->SelectedCount = count($rows);
            $this->ActionValue = Post("actionvalue");

            // Call row action event
            if ($this->SelectedCount > 0) {
                if ($this->UseTransaction) {
                    $conn->beginTransaction();
                }
                $this->SelectedIndex = 0;
                foreach ($rows as $row) {
                    $this->SelectedIndex++;
                    $processed = $listAction->handle($row, $this);
                    if (!$processed) {
                        break;
                    }
                    $processed = $this->rowCustomAction($userAction, $row);
                    if (!$processed) {
                        break;
                    }
                }
                if ($processed) {
                    if ($this->UseTransaction) { // Commit transaction
                        $conn->commit();
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage($listAction->SuccessMessage);
                    }
                    if ($this->getSuccessMessage() == "") {
                        $this->setSuccessMessage(str_replace("%s", $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
                    }
                } else {
                    if ($this->UseTransaction) { // Rollback transaction
                        $conn->rollback();
                    }
                    if ($this->getFailureMessage() == "") {
                        $this->setFailureMessage($listAction->FailureMessage);
                    }

                    // Set up error message
                    if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {
                        // Use the message, do nothing
                    } elseif ($this->CancelMessage != "") {
                        $this->setFailureMessage($this->CancelMessage);
                        $this->CancelMessage = "";
                    } else {
                        $this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
                    }
                }
            }
            if (Post("ajax") == $userAction) { // Ajax
                if (WithJsonResponse()) { // List action returns JSON
                    $this->clearSuccessMessage(); // Clear success message
                    $this->clearFailureMessage(); // Clear failure message
                } else {
                    if ($this->getSuccessMessage() != "") {
                        echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
                        $this->clearSuccessMessage(); // Clear success message
                    }
                    if ($this->getFailureMessage() != "") {
                        echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
                        $this->clearFailureMessage(); // Clear failure message
                    }
                }
                return true;
            }
        }
        return false; // Not ajax request
    }

    // Set up Grid
    public function setupGrid()
    {
        global $CurrentForm;
        if ($this->ExportAll && $this->isExport()) {
            $this->StopRecord = $this->TotalRecords;
        } else {
            // Set the last record to display
            if ($this->TotalRecords > $this->StartRecord + $this->DisplayRecords - 1) {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            } else {
                $this->StopRecord = $this->TotalRecords;
            }
        }
        $this->RecordCount = $this->StartRecord - 1;
        if ($this->CurrentRow !== false) {
            // Nothing to do
        } elseif ($this->isGridAdd() && !$this->AllowAddDeleteRow && $this->StopRecord == 0) { // Grid-Add with no records
            $this->StopRecord = $this->GridAddRowCount;
        } elseif ($this->isAdd() && $this->TotalRecords == 0) { // Inline-Add with no records
            $this->StopRecord = 1;
        }

        // Initialize aggregate
        $this->RowType = RowType::AGGREGATEINIT;
        $this->resetAttributes();
        $this->renderRow();
        if (($this->isGridAdd() || $this->isGridEdit())) { // Render template row first
            $this->RowIndex = '$rowindex$';
        }
    }

    // Set up Row
    public function setupRow()
    {
        global $CurrentForm;
        if ($this->isGridAdd() || $this->isGridEdit()) {
            if ($this->RowIndex === '$rowindex$') { // Render template row first
                $this->loadRowValues();

                // Set row properties
                $this->resetAttributes();
                $this->RowAttrs->merge(["data-rowindex" => $this->RowIndex, "id" => "r0_masterproject", "data-rowtype" => RowType::ADD]);
                $this->RowAttrs->appendClass("ew-template");
                // Render row
                $this->RowType = RowType::ADD;
                $this->renderRow();

                // Render list options
                $this->renderListOptions();

                // Reset record count for template row
                $this->RecordCount--;
                return;
            }
        }

        // Set up key count
        $this->KeyCount = $this->RowIndex;

        // Init row class and style
        $this->resetAttributes();
        $this->CssClass = "";
        if ($this->isCopy() && $this->InlineRowCount == 0 && !$this->loadRow()) { // Inline copy
            $this->CurrentAction = "add";
        }
        if ($this->isAdd() && $this->InlineRowCount == 0 || $this->isGridAdd()) {
            $this->loadRowValues(); // Load default values
            $this->OldKey = "";
            $this->setKey($this->OldKey);
        } elseif ($this->isInlineInserted() && $this->UseInfiniteScroll) {
            // Nothing to do, just use current values
        } elseif (!($this->isCopy() && $this->InlineRowCount == 0)) {
            $this->loadRowValues($this->CurrentRow); // Load row values
            if ($this->isGridEdit() || $this->isMultiEdit()) {
                $this->OldKey = $this->getKey(true); // Get from CurrentValue
                $this->setKey($this->OldKey);
            }
        }
        $this->RowType = RowType::VIEW; // Render view
        if (($this->isAdd() || $this->isCopy()) && $this->InlineRowCount == 0 || $this->isGridAdd()) { // Add
            $this->RowType = RowType::ADD; // Render add
        }

        // Inline Add/Copy row (row 0)
        if ($this->RowType == RowType::ADD && ($this->isAdd() || $this->isCopy())) {
            $this->InlineRowCount++;
            $this->RecordCount--; // Reset record count for inline add/copy row
            if ($this->TotalRecords == 0) { // Reset stop record if no records
                $this->StopRecord = 0;
            }
        } else {
            // Inline Edit row
            if ($this->RowType == RowType::EDIT && $this->isEdit()) {
                $this->InlineRowCount++;
            }
            $this->RowCount++; // Increment row count
        }

        // Set up row attributes
        $this->RowAttrs->merge([
            "data-rowindex" => $this->RowCount,
            "data-key" => $this->getKey(true),
            "id" => "r" . $this->RowCount . "_masterproject",
            "data-rowtype" => $this->RowType,
            "data-inline" => ($this->isAdd() || $this->isCopy() || $this->isEdit()) ? "true" : "false", // Inline-Add/Copy/Edit
            "class" => ($this->RowCount % 2 != 1) ? "ew-table-alt-row" : "",
        ]);
        if ($this->isAdd() && $this->RowType == RowType::ADD || $this->isEdit() && $this->RowType == RowType::EDIT) { // Inline-Add/Edit row
            $this->RowAttrs->appendClass("table-active");
        }

        // Render row
        $this->renderRow();

        // Render list options
        $this->renderListOptions();
    }

    // Load basic search values
    protected function loadBasicSearchValues()
    {
        $this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), false);
        if ($this->BasicSearch->Keyword != "" && $this->Command == "") {
            $this->Command = "search";
        }
        $this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), false);
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // Load query builder rules
        $rules = Post("rules");
        if ($rules && $this->Command == "") {
            $this->QueryRules = $rules;
            $this->Command = "search";
        }

        // ProjectID
        if ($this->_ProjectID->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->_ProjectID->AdvancedSearch->SearchValue != "" || $this->_ProjectID->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // ProjectName
        if ($this->ProjectName->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->ProjectName->AdvancedSearch->SearchValue != "" || $this->ProjectName->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // PlanStart
        if ($this->PlanStart->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->PlanStart->AdvancedSearch->SearchValue != "" || $this->PlanStart->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // PlanEnd
        if ($this->PlanEnd->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->PlanEnd->AdvancedSearch->SearchValue != "" || $this->PlanEnd->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // StartDate
        if ($this->StartDate->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->StartDate->AdvancedSearch->SearchValue != "" || $this->StartDate->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // EndDate
        if ($this->EndDate->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->EndDate->AdvancedSearch->SearchValue != "" || $this->EndDate->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // WarrantyEnd
        if ($this->WarrantyEnd->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->WarrantyEnd->AdvancedSearch->SearchValue != "" || $this->WarrantyEnd->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Status
        if ($this->Status->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Status->AdvancedSearch->SearchValue != "" || $this->Status->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Progress
        if ($this->Progress->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Progress->AdvancedSearch->SearchValue != "" || $this->Progress->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Target
        if ($this->Target->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Target->AdvancedSearch->SearchValue != "" || $this->Target->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Track
        if ($this->Track->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Track->AdvancedSearch->SearchValue != "" || $this->Track->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // PaymentProgress
        if ($this->PaymentProgress->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->PaymentProgress->AdvancedSearch->SearchValue != "" || $this->PaymentProgress->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // PaymentDate
        if ($this->PaymentDate->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->PaymentDate->AdvancedSearch->SearchValue != "" || $this->PaymentDate->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // PaymentComplete
        if ($this->PaymentComplete->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->PaymentComplete->AdvancedSearch->SearchValue != "" || $this->PaymentComplete->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // AgingPayment
        if ($this->AgingPayment->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->AgingPayment->AdvancedSearch->SearchValue != "" || $this->AgingPayment->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // ClientID
        if ($this->ClientID->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->ClientID->AdvancedSearch->SearchValue != "" || $this->ClientID->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // ManagerID
        if ($this->ManagerID->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->ManagerID->AdvancedSearch->SearchValue != "" || $this->ManagerID->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // ProjectTemplateID
        if ($this->ProjectTemplateID->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->ProjectTemplateID->AdvancedSearch->SearchValue != "" || $this->ProjectTemplateID->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Priority
        if ($this->Priority->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Priority->AdvancedSearch->SearchValue != "" || $this->Priority->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // ProjectValue
        if ($this->ProjectValue->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->ProjectValue->AdvancedSearch->SearchValue != "" || $this->ProjectValue->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // ProjectDebt
        if ($this->ProjectDebt->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->ProjectDebt->AdvancedSearch->SearchValue != "" || $this->ProjectDebt->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // PONumber
        if ($this->PONumber->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->PONumber->AdvancedSearch->SearchValue != "" || $this->PONumber->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // PaymentLink
        if ($this->PaymentLink->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->PaymentLink->AdvancedSearch->SearchValue != "" || $this->PaymentLink->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // ClearingDate
        if ($this->ClearingDate->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->ClearingDate->AdvancedSearch->SearchValue != "" || $this->ClearingDate->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // ClearingAging
        if ($this->ClearingAging->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->ClearingAging->AdvancedSearch->SearchValue != "" || $this->ClearingAging->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Active
        if ($this->Active->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Active->AdvancedSearch->SearchValue != "" || $this->Active->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        if (is_array($this->Active->AdvancedSearch->SearchValue)) {
            $this->Active->AdvancedSearch->SearchValue = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->Active->AdvancedSearch->SearchValue);
        }
        if (is_array($this->Active->AdvancedSearch->SearchValue2)) {
            $this->Active->AdvancedSearch->SearchValue2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $this->Active->AdvancedSearch->SearchValue2);
        }

        // Created_Date
        if ($this->Created_Date->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Created_Date->AdvancedSearch->SearchValue != "" || $this->Created_Date->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Created_By
        if ($this->Created_By->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Created_By->AdvancedSearch->SearchValue != "" || $this->Created_By->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Last_Updated_Date
        if ($this->Last_Updated_Date->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Last_Updated_Date->AdvancedSearch->SearchValue != "" || $this->Last_Updated_Date->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }

        // Last_Updated_By
        if ($this->Last_Updated_By->AdvancedSearch->get()) {
            $hasValue = true;
            if (($this->Last_Updated_By->AdvancedSearch->SearchValue != "" || $this->Last_Updated_By->AdvancedSearch->SearchValue2 != "") && $this->Command == "") {
                $this->Command = "search";
            }
        }
        return $hasValue;
    }

    /**
     * Load result set
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return Doctrine\DBAL\Result Result
     */
    public function loadRecordset($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        if (property_exists($this, "TotalRecords") && $rowcnt < 0) {
            $this->TotalRecords = $result->rowCount();
            if ($this->TotalRecords <= 0) { // Handle database drivers that does not return rowCount()
                $this->TotalRecords = $this->getRecordCount($this->getListSql());
            }
        }

        // Call Recordset Selected event
        $this->recordsetSelected($result);
        return $result;
    }

    /**
     * Load records as associative array
     *
     * @param int $offset Offset
     * @param int $rowcnt Maximum number of rows
     * @return void
     */
    public function loadRows($offset = -1, $rowcnt = -1)
    {
        // Load List page SQL (QueryBuilder)
        $sql = $this->getListSql();

        // Load result set
        if ($offset > -1) {
            $sql->setFirstResult($offset);
        }
        if ($rowcnt > 0) {
            $sql->setMaxResults($rowcnt);
        }
        $result = $sql->executeQuery();
        return $result->fetchAllAssociative();
    }

    /**
     * Load row based on key values
     *
     * @return void
     */
    public function loadRow()
    {
        global $Security, $Language;
        $filter = $this->getRecordFilter();

        // Call Row Selecting event
        $this->rowSelecting($filter);

        // Load SQL based on filter
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        $res = false;
        $row = $conn->fetchAssociative($sql);
        if ($row) {
            $res = true;
            $this->loadRowValues($row); // Load row values
        }
        return $res;
    }

    /**
     * Load row values from result set or record
     *
     * @param array $row Record
     * @return void
     */
    public function loadRowValues($row = null)
    {
        $row = is_array($row) ? $row : $this->newRow();

        // Call Row Selected event
        $this->rowSelected($row);
        $this->_ProjectID->setDbValue($row['ProjectID']);
        $this->ProjectName->setDbValue($row['ProjectName']);
        $this->PlanStart->setDbValue($row['PlanStart']);
        $this->PlanEnd->setDbValue($row['PlanEnd']);
        $this->StartDate->setDbValue($row['StartDate']);
        $this->EndDate->setDbValue($row['EndDate']);
        $this->WarrantyEnd->setDbValue($row['WarrantyEnd']);
        $this->Status->setDbValue($row['Status']);
        $this->Progress->setDbValue($row['Progress']);
        $this->Target->setDbValue($row['Target']);
        $this->Track->setDbValue($row['Track']);
        $this->PaymentProgress->setDbValue($row['PaymentProgress']);
        $this->PaymentDate->setDbValue($row['PaymentDate']);
        $this->PaymentComplete->setDbValue($row['PaymentComplete']);
        $this->AgingPayment->setDbValue($row['AgingPayment']);
        $this->ClientID->setDbValue($row['ClientID']);
        $this->ManagerID->setDbValue($row['ManagerID']);
        $this->ProjectTemplateID->setDbValue($row['ProjectTemplateID']);
        $this->Priority->setDbValue($row['Priority']);
        $this->Description->setDbValue($row['Description']);
        $this->ProjectValue->setDbValue($row['ProjectValue']);
        $this->ProjectDebt->setDbValue($row['ProjectDebt']);
        $this->PONumber->setDbValue($row['PONumber']);
        $this->PaymentLink->setDbValue($row['PaymentLink']);
        $this->ClearingDate->setDbValue($row['ClearingDate']);
        $this->ClearingAging->setDbValue($row['ClearingAging']);
        $this->Active->setDbValue($row['Active']);
        $this->Created_Date->setDbValue($row['Created_Date']);
        $this->Created_By->setDbValue($row['Created_By']);
        $this->Last_Updated_Date->setDbValue($row['Last_Updated_Date']);
        $this->Last_Updated_By->setDbValue($row['Last_Updated_By']);
    }

    // Return a row with default values
    protected function newRow()
    {
        $row = [];
        $row['ProjectID'] = $this->_ProjectID->DefaultValue;
        $row['ProjectName'] = $this->ProjectName->DefaultValue;
        $row['PlanStart'] = $this->PlanStart->DefaultValue;
        $row['PlanEnd'] = $this->PlanEnd->DefaultValue;
        $row['StartDate'] = $this->StartDate->DefaultValue;
        $row['EndDate'] = $this->EndDate->DefaultValue;
        $row['WarrantyEnd'] = $this->WarrantyEnd->DefaultValue;
        $row['Status'] = $this->Status->DefaultValue;
        $row['Progress'] = $this->Progress->DefaultValue;
        $row['Target'] = $this->Target->DefaultValue;
        $row['Track'] = $this->Track->DefaultValue;
        $row['PaymentProgress'] = $this->PaymentProgress->DefaultValue;
        $row['PaymentDate'] = $this->PaymentDate->DefaultValue;
        $row['PaymentComplete'] = $this->PaymentComplete->DefaultValue;
        $row['AgingPayment'] = $this->AgingPayment->DefaultValue;
        $row['ClientID'] = $this->ClientID->DefaultValue;
        $row['ManagerID'] = $this->ManagerID->DefaultValue;
        $row['ProjectTemplateID'] = $this->ProjectTemplateID->DefaultValue;
        $row['Priority'] = $this->Priority->DefaultValue;
        $row['Description'] = $this->Description->DefaultValue;
        $row['ProjectValue'] = $this->ProjectValue->DefaultValue;
        $row['ProjectDebt'] = $this->ProjectDebt->DefaultValue;
        $row['PONumber'] = $this->PONumber->DefaultValue;
        $row['PaymentLink'] = $this->PaymentLink->DefaultValue;
        $row['ClearingDate'] = $this->ClearingDate->DefaultValue;
        $row['ClearingAging'] = $this->ClearingAging->DefaultValue;
        $row['Active'] = $this->Active->DefaultValue;
        $row['Created_Date'] = $this->Created_Date->DefaultValue;
        $row['Created_By'] = $this->Created_By->DefaultValue;
        $row['Last_Updated_Date'] = $this->Last_Updated_Date->DefaultValue;
        $row['Last_Updated_By'] = $this->Last_Updated_By->DefaultValue;
        return $row;
    }

    // Load old record
    protected function loadOldRecord()
    {
        // Load old record
        if ($this->OldKey != "") {
            $this->setKey($this->OldKey);
            $this->CurrentFilter = $this->getRecordFilter();
            $sql = $this->getCurrentSql();
            $conn = $this->getConnection();
            $rs = ExecuteQuery($sql, $conn);
            if ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Load row values
                return $row;
            }
        }
        $this->loadRowValues(); // Load default row values
        return null;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs
        $this->ViewUrl = $this->getViewUrl();
        $this->EditUrl = $this->getEditUrl();
        $this->InlineEditUrl = $this->getInlineEditUrl();
        $this->CopyUrl = $this->getCopyUrl();
        $this->InlineCopyUrl = $this->getInlineCopyUrl();
        $this->DeleteUrl = $this->getDeleteUrl();

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // ProjectID

        // ProjectName
        $this->ProjectName->CellCssStyle = "white-space: nowrap;";

        // PlanStart
        $this->PlanStart->CellCssStyle = "white-space: nowrap;";

        // PlanEnd
        $this->PlanEnd->CellCssStyle = "white-space: nowrap;";

        // StartDate
        $this->StartDate->CellCssStyle = "white-space: nowrap;";

        // EndDate
        $this->EndDate->CellCssStyle = "white-space: nowrap;";

        // WarrantyEnd
        $this->WarrantyEnd->CellCssStyle = "white-space: nowrap;";

        // Status
        $this->Status->CellCssStyle = "white-space: nowrap;";

        // Progress
        $this->Progress->CellCssStyle = "white-space: nowrap;";

        // Target
        $this->Target->CellCssStyle = "white-space: nowrap;";

        // Track
        $this->Track->CellCssStyle = "white-space: nowrap;";

        // PaymentProgress
        $this->PaymentProgress->CellCssStyle = "white-space: nowrap;";

        // PaymentDate
        $this->PaymentDate->CellCssStyle = "white-space: nowrap;";

        // PaymentComplete
        $this->PaymentComplete->CellCssStyle = "white-space: nowrap;";

        // AgingPayment
        $this->AgingPayment->CellCssStyle = "white-space: nowrap;";

        // ClientID
        $this->ClientID->CellCssStyle = "white-space: nowrap;";

        // ManagerID
        $this->ManagerID->CellCssStyle = "white-space: nowrap;";

        // ProjectTemplateID
        $this->ProjectTemplateID->CellCssStyle = "white-space: nowrap;";

        // Priority
        $this->Priority->CellCssStyle = "white-space: nowrap;";

        // Description
        $this->Description->CellCssStyle = "white-space: nowrap;";

        // ProjectValue
        $this->ProjectValue->CellCssStyle = "white-space: nowrap;";

        // ProjectDebt
        $this->ProjectDebt->CellCssStyle = "white-space: nowrap;";

        // PONumber
        $this->PONumber->CellCssStyle = "white-space: nowrap;";

        // PaymentLink

        // ClearingDate

        // ClearingAging

        // Active
        $this->Active->CellCssStyle = "white-space: nowrap;";

        // Created_Date
        $this->Created_Date->CellCssStyle = "white-space: nowrap;";

        // Created_By
        $this->Created_By->CellCssStyle = "white-space: nowrap;";

        // Last_Updated_Date
        $this->Last_Updated_Date->CellCssStyle = "white-space: nowrap;";

        // Last_Updated_By
        $this->Last_Updated_By->CellCssStyle = "white-space: nowrap;";

        // Accumulate aggregate value
        if ($this->RowType != RowType::AGGREGATEINIT && $this->RowType != RowType::AGGREGATE && $this->RowType != RowType::PREVIEWFIELD) {
            if (is_numeric($this->ProjectValue->CurrentValue)) {
                $this->ProjectValue->Total += $this->ProjectValue->CurrentValue; // Accumulate total
            }
            if (is_numeric($this->ProjectDebt->CurrentValue)) {
                $this->ProjectDebt->Total += $this->ProjectDebt->CurrentValue; // Accumulate total
            }
        }

        // View row
        if ($this->RowType == RowType::VIEW) {
            // ProjectID
            $this->_ProjectID->ViewValue = $this->_ProjectID->CurrentValue;

            // ProjectName
            $this->ProjectName->ViewValue = $this->ProjectName->CurrentValue;

            // PlanStart
            $this->PlanStart->ViewValue = $this->PlanStart->CurrentValue;
            $this->PlanStart->ViewValue = FormatDateTime($this->PlanStart->ViewValue, $this->PlanStart->formatPattern());

            // PlanEnd
            $this->PlanEnd->ViewValue = $this->PlanEnd->CurrentValue;
            $this->PlanEnd->ViewValue = FormatDateTime($this->PlanEnd->ViewValue, $this->PlanEnd->formatPattern());

            // StartDate
            $this->StartDate->ViewValue = $this->StartDate->CurrentValue;
            $this->StartDate->ViewValue = FormatDateTime($this->StartDate->ViewValue, $this->StartDate->formatPattern());

            // EndDate
            $this->EndDate->ViewValue = $this->EndDate->CurrentValue;
            $this->EndDate->ViewValue = FormatDateTime($this->EndDate->ViewValue, $this->EndDate->formatPattern());

            // WarrantyEnd
            $this->WarrantyEnd->ViewValue = $this->WarrantyEnd->CurrentValue;
            $this->WarrantyEnd->ViewValue = FormatDateTime($this->WarrantyEnd->ViewValue, $this->WarrantyEnd->formatPattern());

            // Status
            $curVal = strval($this->Status->CurrentValue);
            if ($curVal != "") {
                $this->Status->ViewValue = $this->Status->lookupCacheOption($curVal);
                if ($this->Status->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->Status->Lookup->getTable()->Fields["Status"]->searchExpression(), "=", $curVal, $this->Status->Lookup->getTable()->Fields["Status"]->searchDataType(), "");
                    $sqlWrk = $this->Status->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Status->Lookup->renderViewRow($rswrk[0]);
                        $this->Status->ViewValue = $this->Status->displayValue($arwrk);
                    } else {
                        $this->Status->ViewValue = $this->Status->CurrentValue;
                    }
                }
            } else {
                $this->Status->ViewValue = null;
            }

            // Progress
            $this->Progress->ViewValue = $this->Progress->CurrentValue;
            $this->Progress->ViewValue = FormatPercent($this->Progress->ViewValue, $this->Progress->formatPattern());
            $this->Progress->CellCssStyle .= "text-align: right;";

            // Target
            $this->Target->ViewValue = $this->Target->CurrentValue;
            $this->Target->ViewValue = FormatPercent($this->Target->ViewValue, $this->Target->formatPattern());
            $this->Target->CellCssStyle .= "text-align: right;";

            // Track
            $this->Track->ViewValue = $this->Track->CurrentValue;
            $this->Track->CellCssStyle .= "text-align: right;";

            // PaymentProgress
            $this->PaymentProgress->ViewValue = $this->PaymentProgress->CurrentValue;
            $this->PaymentProgress->ViewValue = FormatPercent($this->PaymentProgress->ViewValue, $this->PaymentProgress->formatPattern());
            $this->PaymentProgress->CellCssStyle .= "text-align: right;";

            // PaymentDate
            $this->PaymentDate->ViewValue = $this->PaymentDate->CurrentValue;
            $this->PaymentDate->ViewValue = FormatDateTime($this->PaymentDate->ViewValue, $this->PaymentDate->formatPattern());

            // PaymentComplete
            $this->PaymentComplete->ViewValue = $this->PaymentComplete->CurrentValue;

            // AgingPayment
            $this->AgingPayment->ViewValue = $this->AgingPayment->CurrentValue;
            $this->AgingPayment->ViewValue = FormatNumber($this->AgingPayment->ViewValue, $this->AgingPayment->formatPattern());
            $this->AgingPayment->CellCssStyle .= "text-align: right;";

            // ClientID
            $curVal = strval($this->ClientID->CurrentValue);
            if ($curVal != "") {
                $this->ClientID->ViewValue = $this->ClientID->lookupCacheOption($curVal);
                if ($this->ClientID->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ClientID->Lookup->getTable()->Fields["ClientID"]->searchExpression(), "=", $curVal, $this->ClientID->Lookup->getTable()->Fields["ClientID"]->searchDataType(), "");
                    $lookupFilter = $this->ClientID->getSelectFilter($this); // PHP
                    $sqlWrk = $this->ClientID->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ClientID->Lookup->renderViewRow($rswrk[0]);
                        $this->ClientID->ViewValue = $this->ClientID->displayValue($arwrk);
                    } else {
                        $this->ClientID->ViewValue = FormatNumber($this->ClientID->CurrentValue, $this->ClientID->formatPattern());
                    }
                }
            } else {
                $this->ClientID->ViewValue = null;
            }

            // ManagerID
            $curVal = strval($this->ManagerID->CurrentValue);
            if ($curVal != "") {
                $this->ManagerID->ViewValue = $this->ManagerID->lookupCacheOption($curVal);
                if ($this->ManagerID->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ManagerID->Lookup->getTable()->Fields["EmployeeID"]->searchExpression(), "=", $curVal, $this->ManagerID->Lookup->getTable()->Fields["EmployeeID"]->searchDataType(), "");
                    $lookupFilter = $this->ManagerID->getSelectFilter($this); // PHP
                    $sqlWrk = $this->ManagerID->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ManagerID->Lookup->renderViewRow($rswrk[0]);
                        $this->ManagerID->ViewValue = $this->ManagerID->displayValue($arwrk);
                    } else {
                        $this->ManagerID->ViewValue = FormatNumber($this->ManagerID->CurrentValue, $this->ManagerID->formatPattern());
                    }
                }
            } else {
                $this->ManagerID->ViewValue = null;
            }

            // ProjectTemplateID
            $curVal = strval($this->ProjectTemplateID->CurrentValue);
            if ($curVal != "") {
                $this->ProjectTemplateID->ViewValue = $this->ProjectTemplateID->lookupCacheOption($curVal);
                if ($this->ProjectTemplateID->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->ProjectTemplateID->Lookup->getTable()->Fields["ID"]->searchExpression(), "=", $curVal, $this->ProjectTemplateID->Lookup->getTable()->Fields["ID"]->searchDataType(), "");
                    $lookupFilter = $this->ProjectTemplateID->getSelectFilter($this); // PHP
                    $sqlWrk = $this->ProjectTemplateID->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->ProjectTemplateID->Lookup->renderViewRow($rswrk[0]);
                        $this->ProjectTemplateID->ViewValue = $this->ProjectTemplateID->displayValue($arwrk);
                    } else {
                        $this->ProjectTemplateID->ViewValue = FormatNumber($this->ProjectTemplateID->CurrentValue, $this->ProjectTemplateID->formatPattern());
                    }
                }
            } else {
                $this->ProjectTemplateID->ViewValue = null;
            }

            // Priority
            if (strval($this->Priority->CurrentValue) != "") {
                $this->Priority->ViewValue = $this->Priority->optionCaption($this->Priority->CurrentValue);
            } else {
                $this->Priority->ViewValue = null;
            }

            // Description
            $this->Description->ViewValue = $this->Description->CurrentValue;

            // ProjectValue
            $this->ProjectValue->ViewValue = $this->ProjectValue->CurrentValue;
            $this->ProjectValue->ViewValue = FormatNumber($this->ProjectValue->ViewValue, $this->ProjectValue->formatPattern());
            $this->ProjectValue->CellCssStyle .= "text-align: right;";

            // ProjectDebt
            $this->ProjectDebt->ViewValue = $this->ProjectDebt->CurrentValue;
            $this->ProjectDebt->ViewValue = FormatNumber($this->ProjectDebt->ViewValue, $this->ProjectDebt->formatPattern());
            $this->ProjectDebt->CellCssStyle .= "text-align: right;";

            // PONumber
            $this->PONumber->ViewValue = $this->PONumber->CurrentValue;

            // PaymentLink
            $this->PaymentLink->ViewValue = $this->PaymentLink->CurrentValue;

            // ClearingDate
            $this->ClearingDate->ViewValue = $this->ClearingDate->CurrentValue;
            $this->ClearingDate->ViewValue = FormatDateTime($this->ClearingDate->ViewValue, $this->ClearingDate->formatPattern());

            // ClearingAging
            $this->ClearingAging->ViewValue = $this->ClearingAging->CurrentValue;
            $this->ClearingAging->ViewValue = FormatNumber($this->ClearingAging->ViewValue, $this->ClearingAging->formatPattern());
            $this->ClearingAging->CellCssStyle .= "text-align: right;";

            // Active
            if (ConvertToBool($this->Active->CurrentValue)) {
                $this->Active->ViewValue = $this->Active->tagCaption(1) != "" ? $this->Active->tagCaption(1) : "Yes";
            } else {
                $this->Active->ViewValue = $this->Active->tagCaption(2) != "" ? $this->Active->tagCaption(2) : "No";
            }
            $this->Active->CellCssStyle .= "text-align: center;";

            // Created_Date
            $this->Created_Date->ViewValue = $this->Created_Date->CurrentValue;
            $this->Created_Date->ViewValue = FormatDateTime($this->Created_Date->ViewValue, $this->Created_Date->formatPattern());

            // Created_By
            $this->Created_By->ViewValue = $this->Created_By->CurrentValue;

            // Last_Updated_Date
            $this->Last_Updated_Date->ViewValue = $this->Last_Updated_Date->CurrentValue;
            $this->Last_Updated_Date->ViewValue = FormatDateTime($this->Last_Updated_Date->ViewValue, $this->Last_Updated_Date->formatPattern());

            // Last_Updated_By
            $this->Last_Updated_By->ViewValue = $this->Last_Updated_By->CurrentValue;

            // ProjectName
            $this->ProjectName->HrefValue = "";
            $this->ProjectName->TooltipValue = "";

            // PlanStart
            $this->PlanStart->HrefValue = "";
            $this->PlanStart->TooltipValue = "";

            // PlanEnd
            $this->PlanEnd->HrefValue = "";
            $this->PlanEnd->TooltipValue = "";

            // StartDate
            $this->StartDate->HrefValue = "";
            $this->StartDate->TooltipValue = "";

            // EndDate
            $this->EndDate->HrefValue = "";
            $this->EndDate->TooltipValue = "";

            // WarrantyEnd
            $this->WarrantyEnd->HrefValue = "";
            $this->WarrantyEnd->TooltipValue = "";

            // Status
            $this->Status->HrefValue = "";
            $this->Status->TooltipValue = "";

            // Progress
            $this->Progress->HrefValue = "";
            $this->Progress->TooltipValue = "";

            // Target
            $this->Target->HrefValue = "";
            $this->Target->TooltipValue = "";

            // Track
            $this->Track->HrefValue = "";
            $this->Track->TooltipValue = "";

            // PaymentProgress
            $this->PaymentProgress->HrefValue = "";
            $this->PaymentProgress->TooltipValue = "";

            // PaymentDate
            $this->PaymentDate->HrefValue = "";
            $this->PaymentDate->TooltipValue = "";

            // PaymentComplete
            $this->PaymentComplete->HrefValue = "";
            $this->PaymentComplete->TooltipValue = "";

            // AgingPayment
            $this->AgingPayment->HrefValue = "";
            $this->AgingPayment->TooltipValue = "";

            // ClientID
            $this->ClientID->HrefValue = "";
            $this->ClientID->TooltipValue = "";

            // ManagerID
            $this->ManagerID->HrefValue = "";
            $this->ManagerID->TooltipValue = "";

            // ProjectTemplateID
            $this->ProjectTemplateID->HrefValue = "";
            $this->ProjectTemplateID->TooltipValue = "";

            // Priority
            $this->Priority->HrefValue = "";
            $this->Priority->TooltipValue = "";

            // ProjectValue
            $this->ProjectValue->HrefValue = "";
            $this->ProjectValue->TooltipValue = "";

            // ProjectDebt
            $this->ProjectDebt->HrefValue = "";
            $this->ProjectDebt->TooltipValue = "";

            // PONumber
            $this->PONumber->HrefValue = "";
            $this->PONumber->TooltipValue = "";

            // ClearingDate
            $this->ClearingDate->HrefValue = "";
            $this->ClearingDate->TooltipValue = "";

            // ClearingAging
            $this->ClearingAging->HrefValue = "";
            $this->ClearingAging->TooltipValue = "";

            // Active
            $this->Active->HrefValue = "";
            $this->Active->TooltipValue = "";

            // Created_Date
            $this->Created_Date->HrefValue = "";
            $this->Created_Date->TooltipValue = "";

            // Created_By
            $this->Created_By->HrefValue = "";
            $this->Created_By->TooltipValue = "";

            // Last_Updated_Date
            $this->Last_Updated_Date->HrefValue = "";
            $this->Last_Updated_Date->TooltipValue = "";

            // Last_Updated_By
            $this->Last_Updated_By->HrefValue = "";
            $this->Last_Updated_By->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // ProjectName
            if ($this->ProjectName->UseFilter && !EmptyValue($this->ProjectName->AdvancedSearch->SearchValue)) {
                if (is_array($this->ProjectName->AdvancedSearch->SearchValue)) {
                    $this->ProjectName->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->ProjectName->AdvancedSearch->SearchValue);
                }
                $this->ProjectName->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->ProjectName->AdvancedSearch->SearchValue);
            }

            // PlanStart
            if ($this->PlanStart->UseFilter && !EmptyValue($this->PlanStart->AdvancedSearch->SearchValue)) {
                if (is_array($this->PlanStart->AdvancedSearch->SearchValue)) {
                    $this->PlanStart->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->PlanStart->AdvancedSearch->SearchValue);
                }
                $this->PlanStart->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->PlanStart->AdvancedSearch->SearchValue);
            }
            $this->PlanStart->setupEditAttributes();
            $this->PlanStart->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->PlanStart->AdvancedSearch->SearchValue2, $this->PlanStart->formatPattern()), $this->PlanStart->formatPattern()));
            $this->PlanStart->PlaceHolder = RemoveHtml($this->PlanStart->caption());

            // PlanEnd
            if ($this->PlanEnd->UseFilter && !EmptyValue($this->PlanEnd->AdvancedSearch->SearchValue)) {
                if (is_array($this->PlanEnd->AdvancedSearch->SearchValue)) {
                    $this->PlanEnd->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->PlanEnd->AdvancedSearch->SearchValue);
                }
                $this->PlanEnd->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->PlanEnd->AdvancedSearch->SearchValue);
            }
            $this->PlanEnd->setupEditAttributes();
            $this->PlanEnd->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->PlanEnd->AdvancedSearch->SearchValue2, $this->PlanEnd->formatPattern()), $this->PlanEnd->formatPattern()));
            $this->PlanEnd->PlaceHolder = RemoveHtml($this->PlanEnd->caption());

            // StartDate
            if ($this->StartDate->UseFilter && !EmptyValue($this->StartDate->AdvancedSearch->SearchValue)) {
                if (is_array($this->StartDate->AdvancedSearch->SearchValue)) {
                    $this->StartDate->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->StartDate->AdvancedSearch->SearchValue);
                }
                $this->StartDate->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->StartDate->AdvancedSearch->SearchValue);
            }
            $this->StartDate->setupEditAttributes();
            $this->StartDate->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->StartDate->AdvancedSearch->SearchValue2, $this->StartDate->formatPattern()), $this->StartDate->formatPattern()));
            $this->StartDate->PlaceHolder = RemoveHtml($this->StartDate->caption());

            // EndDate
            if ($this->EndDate->UseFilter && !EmptyValue($this->EndDate->AdvancedSearch->SearchValue)) {
                if (is_array($this->EndDate->AdvancedSearch->SearchValue)) {
                    $this->EndDate->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->EndDate->AdvancedSearch->SearchValue);
                }
                $this->EndDate->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->EndDate->AdvancedSearch->SearchValue);
            }
            $this->EndDate->setupEditAttributes();
            $this->EndDate->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->EndDate->AdvancedSearch->SearchValue2, $this->EndDate->formatPattern()), $this->EndDate->formatPattern()));
            $this->EndDate->PlaceHolder = RemoveHtml($this->EndDate->caption());

            // WarrantyEnd
            if ($this->WarrantyEnd->UseFilter && !EmptyValue($this->WarrantyEnd->AdvancedSearch->SearchValue)) {
                if (is_array($this->WarrantyEnd->AdvancedSearch->SearchValue)) {
                    $this->WarrantyEnd->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->WarrantyEnd->AdvancedSearch->SearchValue);
                }
                $this->WarrantyEnd->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->WarrantyEnd->AdvancedSearch->SearchValue);
            }
            $this->WarrantyEnd->setupEditAttributes();
            $this->WarrantyEnd->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->WarrantyEnd->AdvancedSearch->SearchValue2, $this->WarrantyEnd->formatPattern()), $this->WarrantyEnd->formatPattern()));
            $this->WarrantyEnd->PlaceHolder = RemoveHtml($this->WarrantyEnd->caption());

            // Status
            if ($this->Status->UseFilter && !EmptyValue($this->Status->AdvancedSearch->SearchValue)) {
                if (is_array($this->Status->AdvancedSearch->SearchValue)) {
                    $this->Status->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->Status->AdvancedSearch->SearchValue);
                }
                $this->Status->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->Status->AdvancedSearch->SearchValue);
            }
            $this->Status->setupEditAttributes();
            $curVal = trim(strval($this->Status->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->Status->AdvancedSearch->ViewValue2 = $this->Status->lookupCacheOption($curVal);
            } else {
                $this->Status->AdvancedSearch->ViewValue2 = $this->Status->Lookup !== null && is_array($this->Status->lookupOptions()) && count($this->Status->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->Status->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->Status->EditValue2 = array_values($this->Status->lookupOptions());
            } else { // Lookup from database
                $filterWrk = "";
                $sqlWrk = $this->Status->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Status->EditValue2 = $arwrk;
            }
            $this->Status->PlaceHolder = RemoveHtml($this->Status->caption());

            // Progress
            if ($this->Progress->UseFilter && !EmptyValue($this->Progress->AdvancedSearch->SearchValue)) {
                if (is_array($this->Progress->AdvancedSearch->SearchValue)) {
                    $this->Progress->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->Progress->AdvancedSearch->SearchValue);
                }
                $this->Progress->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->Progress->AdvancedSearch->SearchValue);
            }
            $this->Progress->setupEditAttributes();
            $this->Progress->EditValue2 = $this->Progress->AdvancedSearch->SearchValue2;
            $this->Progress->PlaceHolder = RemoveHtml($this->Progress->caption());

            // Target
            if ($this->Target->UseFilter && !EmptyValue($this->Target->AdvancedSearch->SearchValue)) {
                if (is_array($this->Target->AdvancedSearch->SearchValue)) {
                    $this->Target->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->Target->AdvancedSearch->SearchValue);
                }
                $this->Target->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->Target->AdvancedSearch->SearchValue);
            }

            // Track
            if ($this->Track->UseFilter && !EmptyValue($this->Track->AdvancedSearch->SearchValue)) {
                if (is_array($this->Track->AdvancedSearch->SearchValue)) {
                    $this->Track->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->Track->AdvancedSearch->SearchValue);
                }
                $this->Track->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->Track->AdvancedSearch->SearchValue);
            }

            // PaymentProgress
            if ($this->PaymentProgress->UseFilter && !EmptyValue($this->PaymentProgress->AdvancedSearch->SearchValue)) {
                if (is_array($this->PaymentProgress->AdvancedSearch->SearchValue)) {
                    $this->PaymentProgress->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->PaymentProgress->AdvancedSearch->SearchValue);
                }
                $this->PaymentProgress->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->PaymentProgress->AdvancedSearch->SearchValue);
            }
            $this->PaymentProgress->setupEditAttributes();
            $this->PaymentProgress->EditValue2 = $this->PaymentProgress->AdvancedSearch->SearchValue2;
            $this->PaymentProgress->PlaceHolder = RemoveHtml($this->PaymentProgress->caption());

            // PaymentDate
            if ($this->PaymentDate->UseFilter && !EmptyValue($this->PaymentDate->AdvancedSearch->SearchValue)) {
                if (is_array($this->PaymentDate->AdvancedSearch->SearchValue)) {
                    $this->PaymentDate->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->PaymentDate->AdvancedSearch->SearchValue);
                }
                $this->PaymentDate->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->PaymentDate->AdvancedSearch->SearchValue);
            }
            $this->PaymentDate->setupEditAttributes();
            $this->PaymentDate->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->PaymentDate->AdvancedSearch->SearchValue2, $this->PaymentDate->formatPattern()), $this->PaymentDate->formatPattern()));
            $this->PaymentDate->PlaceHolder = RemoveHtml($this->PaymentDate->caption());

            // PaymentComplete
            if ($this->PaymentComplete->UseFilter && !EmptyValue($this->PaymentComplete->AdvancedSearch->SearchValue)) {
                if (is_array($this->PaymentComplete->AdvancedSearch->SearchValue)) {
                    $this->PaymentComplete->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->PaymentComplete->AdvancedSearch->SearchValue);
                }
                $this->PaymentComplete->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->PaymentComplete->AdvancedSearch->SearchValue);
            }

            // AgingPayment
            if ($this->AgingPayment->UseFilter && !EmptyValue($this->AgingPayment->AdvancedSearch->SearchValue)) {
                if (is_array($this->AgingPayment->AdvancedSearch->SearchValue)) {
                    $this->AgingPayment->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->AgingPayment->AdvancedSearch->SearchValue);
                }
                $this->AgingPayment->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->AgingPayment->AdvancedSearch->SearchValue);
            }

            // ClientID
            if ($this->ClientID->UseFilter && !EmptyValue($this->ClientID->AdvancedSearch->SearchValue)) {
                if (is_array($this->ClientID->AdvancedSearch->SearchValue)) {
                    $this->ClientID->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->ClientID->AdvancedSearch->SearchValue);
                }
                $this->ClientID->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->ClientID->AdvancedSearch->SearchValue);
            }
            $this->ClientID->setupEditAttributes();
            $curVal = trim(strval($this->ClientID->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->ClientID->AdvancedSearch->ViewValue2 = $this->ClientID->lookupCacheOption($curVal);
            } else {
                $this->ClientID->AdvancedSearch->ViewValue2 = $this->ClientID->Lookup !== null && is_array($this->ClientID->lookupOptions()) && count($this->ClientID->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->ClientID->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->ClientID->EditValue2 = array_values($this->ClientID->lookupOptions());
            } else { // Lookup from database
                $filterWrk = "";
                $lookupFilter = $this->ClientID->getSelectFilter($this); // PHP
                $sqlWrk = $this->ClientID->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->ClientID->EditValue2 = $arwrk;
            }
            $this->ClientID->PlaceHolder = RemoveHtml($this->ClientID->caption());

            // ManagerID
            if ($this->ManagerID->UseFilter && !EmptyValue($this->ManagerID->AdvancedSearch->SearchValue)) {
                if (is_array($this->ManagerID->AdvancedSearch->SearchValue)) {
                    $this->ManagerID->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->ManagerID->AdvancedSearch->SearchValue);
                }
                $this->ManagerID->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->ManagerID->AdvancedSearch->SearchValue);
            }
            $this->ManagerID->setupEditAttributes();
            $curVal = trim(strval($this->ManagerID->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->ManagerID->AdvancedSearch->ViewValue2 = $this->ManagerID->lookupCacheOption($curVal);
            } else {
                $this->ManagerID->AdvancedSearch->ViewValue2 = $this->ManagerID->Lookup !== null && is_array($this->ManagerID->lookupOptions()) && count($this->ManagerID->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->ManagerID->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->ManagerID->EditValue2 = array_values($this->ManagerID->lookupOptions());
            } else { // Lookup from database
                $filterWrk = "";
                $lookupFilter = $this->ManagerID->getSelectFilter($this); // PHP
                $sqlWrk = $this->ManagerID->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->ManagerID->EditValue2 = $arwrk;
            }
            $this->ManagerID->PlaceHolder = RemoveHtml($this->ManagerID->caption());

            // ProjectTemplateID
            if ($this->ProjectTemplateID->UseFilter && !EmptyValue($this->ProjectTemplateID->AdvancedSearch->SearchValue)) {
                if (is_array($this->ProjectTemplateID->AdvancedSearch->SearchValue)) {
                    $this->ProjectTemplateID->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->ProjectTemplateID->AdvancedSearch->SearchValue);
                }
                $this->ProjectTemplateID->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->ProjectTemplateID->AdvancedSearch->SearchValue);
            }
            $this->ProjectTemplateID->setupEditAttributes();
            $curVal = trim(strval($this->ProjectTemplateID->AdvancedSearch->SearchValue2));
            if ($curVal != "") {
                $this->ProjectTemplateID->AdvancedSearch->ViewValue2 = $this->ProjectTemplateID->lookupCacheOption($curVal);
            } else {
                $this->ProjectTemplateID->AdvancedSearch->ViewValue2 = $this->ProjectTemplateID->Lookup !== null && is_array($this->ProjectTemplateID->lookupOptions()) && count($this->ProjectTemplateID->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->ProjectTemplateID->AdvancedSearch->ViewValue2 !== null) { // Load from cache
                $this->ProjectTemplateID->EditValue2 = array_values($this->ProjectTemplateID->lookupOptions());
            } else { // Lookup from database
                $filterWrk = "";
                $lookupFilter = $this->ProjectTemplateID->getSelectFilter($this); // PHP
                $sqlWrk = $this->ProjectTemplateID->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->ProjectTemplateID->EditValue2 = $arwrk;
            }
            $this->ProjectTemplateID->PlaceHolder = RemoveHtml($this->ProjectTemplateID->caption());

            // Priority
            if ($this->Priority->UseFilter && !EmptyValue($this->Priority->AdvancedSearch->SearchValue)) {
                if (is_array($this->Priority->AdvancedSearch->SearchValue)) {
                    $this->Priority->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->Priority->AdvancedSearch->SearchValue);
                }
                $this->Priority->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->Priority->AdvancedSearch->SearchValue);
            }

            // ProjectValue
            if ($this->ProjectValue->UseFilter && !EmptyValue($this->ProjectValue->AdvancedSearch->SearchValue)) {
                if (is_array($this->ProjectValue->AdvancedSearch->SearchValue)) {
                    $this->ProjectValue->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->ProjectValue->AdvancedSearch->SearchValue);
                }
                $this->ProjectValue->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->ProjectValue->AdvancedSearch->SearchValue);
            }
            $this->ProjectValue->setupEditAttributes();
            $this->ProjectValue->EditValue2 = $this->ProjectValue->AdvancedSearch->SearchValue2;
            $this->ProjectValue->PlaceHolder = RemoveHtml($this->ProjectValue->caption());

            // ProjectDebt
            if ($this->ProjectDebt->UseFilter && !EmptyValue($this->ProjectDebt->AdvancedSearch->SearchValue)) {
                if (is_array($this->ProjectDebt->AdvancedSearch->SearchValue)) {
                    $this->ProjectDebt->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->ProjectDebt->AdvancedSearch->SearchValue);
                }
                $this->ProjectDebt->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->ProjectDebt->AdvancedSearch->SearchValue);
            }
            $this->ProjectDebt->setupEditAttributes();
            $this->ProjectDebt->EditValue2 = $this->ProjectDebt->AdvancedSearch->SearchValue2;
            $this->ProjectDebt->PlaceHolder = RemoveHtml($this->ProjectDebt->caption());

            // PONumber
            if ($this->PONumber->UseFilter && !EmptyValue($this->PONumber->AdvancedSearch->SearchValue)) {
                if (is_array($this->PONumber->AdvancedSearch->SearchValue)) {
                    $this->PONumber->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->PONumber->AdvancedSearch->SearchValue);
                }
                $this->PONumber->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->PONumber->AdvancedSearch->SearchValue);
            }

            // ClearingDate
            $this->ClearingDate->setupEditAttributes();
            $this->ClearingDate->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->ClearingDate->AdvancedSearch->SearchValue, $this->ClearingDate->formatPattern()), $this->ClearingDate->formatPattern()));
            $this->ClearingDate->PlaceHolder = RemoveHtml($this->ClearingDate->caption());

            // ClearingAging
            $this->ClearingAging->setupEditAttributes();
            $this->ClearingAging->EditValue = $this->ClearingAging->AdvancedSearch->SearchValue;
            $this->ClearingAging->PlaceHolder = RemoveHtml($this->ClearingAging->caption());

            // Active
            if ($this->Active->UseFilter && !EmptyValue($this->Active->AdvancedSearch->SearchValue)) {
                if (is_array($this->Active->AdvancedSearch->SearchValue)) {
                    $this->Active->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->Active->AdvancedSearch->SearchValue);
                }
                $this->Active->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->Active->AdvancedSearch->SearchValue);
            }

            // Created_Date
            if ($this->Created_Date->UseFilter && !EmptyValue($this->Created_Date->AdvancedSearch->SearchValue)) {
                if (is_array($this->Created_Date->AdvancedSearch->SearchValue)) {
                    $this->Created_Date->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->Created_Date->AdvancedSearch->SearchValue);
                }
                $this->Created_Date->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->Created_Date->AdvancedSearch->SearchValue);
            }
            $this->Created_Date->setupEditAttributes();
            $this->Created_Date->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->Created_Date->AdvancedSearch->SearchValue2, $this->Created_Date->formatPattern()), $this->Created_Date->formatPattern()));
            $this->Created_Date->PlaceHolder = RemoveHtml($this->Created_Date->caption());

            // Created_By
            if ($this->Created_By->UseFilter && !EmptyValue($this->Created_By->AdvancedSearch->SearchValue)) {
                if (is_array($this->Created_By->AdvancedSearch->SearchValue)) {
                    $this->Created_By->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->Created_By->AdvancedSearch->SearchValue);
                }
                $this->Created_By->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->Created_By->AdvancedSearch->SearchValue);
            }

            // Last_Updated_Date
            if ($this->Last_Updated_Date->UseFilter && !EmptyValue($this->Last_Updated_Date->AdvancedSearch->SearchValue)) {
                if (is_array($this->Last_Updated_Date->AdvancedSearch->SearchValue)) {
                    $this->Last_Updated_Date->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->Last_Updated_Date->AdvancedSearch->SearchValue);
                }
                $this->Last_Updated_Date->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->Last_Updated_Date->AdvancedSearch->SearchValue);
            }
            $this->Last_Updated_Date->setupEditAttributes();
            $this->Last_Updated_Date->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->Last_Updated_Date->AdvancedSearch->SearchValue2, $this->Last_Updated_Date->formatPattern()), $this->Last_Updated_Date->formatPattern()));
            $this->Last_Updated_Date->PlaceHolder = RemoveHtml($this->Last_Updated_Date->caption());

            // Last_Updated_By
            if ($this->Last_Updated_By->UseFilter && !EmptyValue($this->Last_Updated_By->AdvancedSearch->SearchValue)) {
                if (is_array($this->Last_Updated_By->AdvancedSearch->SearchValue)) {
                    $this->Last_Updated_By->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->Last_Updated_By->AdvancedSearch->SearchValue);
                }
                $this->Last_Updated_By->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->Last_Updated_By->AdvancedSearch->SearchValue);
            }
        } elseif ($this->RowType == RowType::AGGREGATEINIT) { // Initialize aggregate row
                    $this->ProjectValue->Total = 0; // Initialize total
                    $this->ProjectDebt->Total = 0; // Initialize total
        } elseif ($this->RowType == RowType::AGGREGATE) { // Aggregate row
            $this->ProjectValue->CurrentValue = $this->ProjectValue->Total;
            $this->ProjectValue->ViewValue = $this->ProjectValue->CurrentValue;
            $this->ProjectValue->ViewValue = FormatNumber($this->ProjectValue->ViewValue, $this->ProjectValue->formatPattern());
            $this->ProjectValue->CellCssStyle .= "text-align: right;";
            $this->ProjectValue->HrefValue = ""; // Clear href value
            $this->ProjectDebt->CurrentValue = $this->ProjectDebt->Total;
            $this->ProjectDebt->ViewValue = $this->ProjectDebt->CurrentValue;
            $this->ProjectDebt->ViewValue = FormatNumber($this->ProjectDebt->ViewValue, $this->ProjectDebt->formatPattern());
            $this->ProjectDebt->CellCssStyle .= "text-align: right;";
            $this->ProjectDebt->HrefValue = ""; // Clear href value
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    /**
     * Import file
     *
     * @param string $filetoken File token to locate the uploaded import file
     * @param bool $rollback Try import and then rollback
     * @return bool
     */
    public function import($filetoken, $rollback = false)
    {
        global $Security, $Language;
        if (!$Security->canImport()) {
            return false; // Import not allowed
        }

        // Check if valid token
        if (EmptyValue($filetoken)) {
            return false;
        }

        // Get uploaded files by token
        $files = GetUploadedFileNames($filetoken);
        $exts = explode(",", Config("IMPORT_FILE_ALLOWED_EXTENSIONS"));
        $result = [Config("API_FILE_TOKEN_NAME") => $filetoken, "files" => []];

        // Set header
        if (ob_get_length()) {
            ob_clean();
        }
        header("Cache-Control: no-store");
        header("Content-Type: text/event-stream");

        // Import records
        try {
            foreach ($files as $file) {
                $res = ["file" => basename($file)];
                $ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));

                // Ignore log file
                if ($ext == "txt") {
                    continue;
                }

                // Check file extension
                if (!in_array($ext, $exts)) {
                    $res = array_merge($res, ["error" => str_replace("%e", $ext, $Language->phrase("ImportInvalidFileExtension"))]);
                    SendEvent($res, "error");
                    return false;
                }

                // Set up options
                $options = [
                    "file" => $file,
                    "inputEncoding" => "", // For CSV only
                    "delimiter" => ",", // For CSV only
                    "enclosure" => "\"", // For CSV only
                    "escape" => "\\", // For CSV only
                    "activeSheet" => null, // For PhpSpreadsheet only
                    "readOnly" => true, // For PhpSpreadsheet only
                    "maxRows" => null, // For PhpSpreadsheet only
                    "headerRowNumber" => 0,
                    "headers" => [],
                    "offset" => 0,
                    "limit" => null,
                ];
                foreach ($_GET as $key => $value) {
                    if (!in_array($key, [Config("API_ACTION_NAME"), Config("API_FILE_TOKEN_NAME")])) {
                        $options[$key] = $value;
                    }
                }

                // Workflow builder
                $builder = fn($workflow) => $workflow;

                // Call Page Importing server event
                if (!$this->pageImporting($builder, $options)) {
                    SendEvent($res, "error");
                    return false;
                }

                // Set max execution time
                if (Config("IMPORT_MAX_EXECUTION_TIME") > 0) {
                    ini_set("max_execution_time", Config("IMPORT_MAX_EXECUTION_TIME"));
                }

                // Reader
                try {
                    if ($ext == "csv") {
                        $csv = file_get_contents($file);
                        if ($csv !== false) {
                            if (StartsString("\xEF\xBB\xBF", $csv)) { // UTF-8 BOM
                                $csv = substr($csv, 3);
                            } elseif ($options["inputEncoding"] != "" && !SameText($options["inputEncoding"], "UTF-8")) {
                                $csv = Convert($options["inputEncoding"], "UTF-8", $csv);
                            }
                            file_put_contents($file, $csv);
                        }
                        $reader = new \Port\Csv\CsvReader(new \SplFileObject($file), $options["delimiter"], $options["enclosure"], $options["escape"]);
                    } else {
                        $reader = new \Port\Spreadsheet\SpreadsheetReader(new \SplFileObject($file), $options["headerRowNumber"], $options["activeSheet"], $options["readOnly"], $options["maxRows"]);
                    }
                    if (is_array($options["headers"]) && count($options["headers"]) > 0) {
                        $reader->setColumnHeaders($options["headers"]);
                    } elseif (is_int($options["headerRowNumber"])) {
                        $reader->setHeaderRowNumber($options["headerRowNumber"]);
                    }
                } catch (\Exception $e) {
                    $res = array_merge($res, ["error" => $e->getMessage()]);
                    SendEvent($res, "error");
                    return false;
                }

                // Column headers
                $headers = $reader->getColumnHeaders();
                if (count($headers) == 0) { // Missing headers
                    $res["error"] = $Language->phrase("ImportNoHeaderRow");
                    SendEvent($res, "error");
                    return false;
                }

                // Counts
                $recordCnt = $reader->count();
                if ($options["offset"] > 0) {
                    $recordCnt -= $options["offset"];
                    if ($options["limit"] > 0) {
                        $recordCnt = min($recordCnt, $options["limit"]);
                    }
                    if ($recordCnt < 0) {
                        $recordCnt = 0;
                    }
                }
                $cnt = 0;
                $successCnt = 0;
                $failCnt = 0;
                $res = array_merge($res, ["totalCount" => $recordCnt, "count" => $cnt, "successCount" => 0, "failCount" => 0]);

                // Writer
                $writer = new \Port\Writer\CallbackWriter(function ($row) use (&$res, &$cnt, &$successCnt, &$failCnt) {
                    try {
                        $row = array_filter($row, fn($k) => $k !== "", ARRAY_FILTER_USE_KEY); // Remove fields without field name
                        $success = $this->importRow($row, ++$cnt); // Import row
                        $err = "";
                        if ($success) {
                            $successCnt++;
                        } else {
                            if (!EmptyValue($this->DbErrorMessage)) {
                                $err = $this->DbErrorMessage;
                                Log("import error for record " . $cnt . ": " . $err); // Log error to log file
                            }
                            $failCnt++;
                        }
                    } catch (\Port\Exception $e) { // Catch exception so the workflow continues
                        $failCnt++;
                        $err = $e->getMessage();
                        Log("import error for record " . $cnt . ": " . $err); // Log error to log file
                        if ($failCnt > $this->ImportMaxFailures) {
                            throw $e; // Throw \Port\Exception to terminate the workflow
                        }
                    } finally {
                        $res = array_merge($res, [
                            "row" => $row, // Current row
                            "success" => $success, // For current row
                            "error" => $err, // For current row
                            "count" => $cnt,
                            "successCount" => $successCnt,
                            "failCount" => $failCnt
                        ]);
                        $this->clearMessages();
                        SendEvent($res);
                    }
                });

                // Connection
                $conn = $this->getConnection();

                // Begin transaction
                if ($this->ImportUseTransaction) {
                    $conn->beginTransaction();
                }

                // Workflow
                $workflow = new \Port\Steps\StepAggregator($reader);
                $workflow->setLogger(Logger());
                $workflow->setSkipItemOnFailure(false); // Stop on exception
                $workflow = $builder($workflow);

                // Filter step
                $step = new \Port\Steps\Step\FilterStep();
                $step->add(new \Port\Filter\OffsetFilter($options["offset"], $options["limit"]));
                try {
                    $info = @$workflow->addWriter($writer)->addStep($step)->process();
                } finally {
                    // Rollback transaction
                    if ($this->ImportUseTransaction) {
                        if ($rollback || $failCnt > $this->ImportMaxFailures) {
                            $res["rollbacked"] = $conn->rollback();
                        } else {
                            $conn->commit();
                        }
                    }
                    unset($res["row"], $res["error"]); // Remove current row info
                    $res["success"] = $cnt > 0 && $failCnt <= $this->ImportMaxFailures; // Set success status of current file
                    SendEvent($res); // Current file imported
                    $result["files"][] = $res;

                    // Call Page Imported server event
                    if (($res["rollbacked"] ?? false) === false) { // Not rollbacked
                        $this->pageImported($info, $res);
                    }
                }
            }
        } finally {
            $result["failCount"] = array_reduce($result["files"], fn($carry, $item) => $carry + $item["failCount"], 0); // For client side
            $result["success"] = array_reduce($result["files"], fn($carry, $item) => $carry && $item["success"], true); // All files successful
            $result["rollbacked"] = array_reduce($result["files"], fn($carry, $item) => $carry && $item["success"] && ($item["rollbacked"] ?? false), true); // All file rollbacked successfully
            if ($result["success"] && !$result["rollbacked"]) {
                CleanUploadTempPaths($filetoken);
            }
            SendEvent($result, "complete"); // All files imported
            return $result["success"];
        }
    }

    /**
     * Import a row
     *
     * @param array $row Row to be imported
     * @param int $cnt Index of the row (1-based)
     * @return bool
     */
    protected function importRow(&$row, $cnt)
    {
        global $Language;

        // Call Row Import server event
        if (!$this->rowImport($row, $cnt)) {
            return false;
        }

        // Check field names and values
        foreach ($row as $name => $value) {
            $fld = $this->Fields[$name];
            if (!$fld) {
                throw new \Port\Exception\UnexpectedValueException(str_replace("%f", $name, $Language->phrase("ImportInvalidFieldName")));
            }
            if (!$this->checkValue($fld, $value)) {
                throw new \Port\Exception\UnexpectedValueException(str_replace(["%f", "%v"], [$name, $value], $Language->phrase("ImportInvalidFieldValue")));
            }
        }

        // Insert/Update to database
        $res = false;
        if (!$this->ImportInsertOnly && $oldrow = $this->load($row)) {
            if (!method_exists($this, "rowUpdating") || $this->rowUpdating($oldrow, $row)) {
                if ($res = $this->update($row, "", $oldrow)) {
                    if (method_exists($this, "rowUpdated")) {
                        $this->rowUpdated($oldrow, $row);
                    }
                }
            }
        } else {
            if (!method_exists($this, "rowInserting") || $this->rowInserting(null, $row)) {
                if ($res = $this->insert($row)) {
                    if (method_exists($this, "rowInserted")) {
                        $this->rowInserted(null, $row);
                    }
                }
            }
        }
        return $res;
    }

    /**
     * Check field value
     *
     * @param object $fld Field object
     * @param object $value
     * @return bool
     */
    protected function checkValue($fld, $value)
    {
        if ($fld->DataType == DataType::NUMBER && !is_numeric($value)) {
            return false;
        } elseif ($fld->DataType == DataType::DATE && !CheckDate($value, $fld->formatPattern())) {
            return false;
        }
        return true;
    }

    // Load row
    protected function load($row)
    {
        $filter = $this->getRecordFilter($row);
        if (!$filter) {
            return null;
        }
        $this->CurrentFilter = $filter;
        $sql = $this->getCurrentSql();
        $conn = $this->getConnection();
        return $conn->fetchAssociative($sql);
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->_ProjectID->AdvancedSearch->load();
        $this->ProjectName->AdvancedSearch->load();
        $this->PlanStart->AdvancedSearch->load();
        $this->PlanEnd->AdvancedSearch->load();
        $this->StartDate->AdvancedSearch->load();
        $this->EndDate->AdvancedSearch->load();
        $this->WarrantyEnd->AdvancedSearch->load();
        $this->Status->AdvancedSearch->load();
        $this->Progress->AdvancedSearch->load();
        $this->Target->AdvancedSearch->load();
        $this->Track->AdvancedSearch->load();
        $this->PaymentProgress->AdvancedSearch->load();
        $this->PaymentDate->AdvancedSearch->load();
        $this->PaymentComplete->AdvancedSearch->load();
        $this->AgingPayment->AdvancedSearch->load();
        $this->ClientID->AdvancedSearch->load();
        $this->ManagerID->AdvancedSearch->load();
        $this->ProjectTemplateID->AdvancedSearch->load();
        $this->Priority->AdvancedSearch->load();
        $this->ProjectValue->AdvancedSearch->load();
        $this->ProjectDebt->AdvancedSearch->load();
        $this->PONumber->AdvancedSearch->load();
        $this->PaymentLink->AdvancedSearch->load();
        $this->ClearingDate->AdvancedSearch->load();
        $this->ClearingAging->AdvancedSearch->load();
        $this->Active->AdvancedSearch->load();
        $this->Created_Date->AdvancedSearch->load();
        $this->Created_By->AdvancedSearch->load();
        $this->Last_Updated_Date->AdvancedSearch->load();
        $this->Last_Updated_By->AdvancedSearch->load();
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" form=\"fmasterprojectlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"excel\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToExcel") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcel", true)) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
            }
        } elseif (SameText($type, "word")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" form=\"fmasterprojectlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"word\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToWord") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWord", true)) . "\">" . $Language->phrase("ExportToWord") . "</a>";
            }
        } elseif (SameText($type, "pdf")) {
            if ($custom) {
                return "<button type=\"button\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" form=\"fmasterprojectlist\" data-url=\"$exportUrl\" data-ew-action=\"export\" data-export=\"pdf\" data-custom=\"true\" data-export-selected=\"false\">" . $Language->phrase("ExportToPdf") . "</button>";
            } else {
                return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPdf", true)) . "\">" . $Language->phrase("ExportToPdf") . "</a>";
            }
        } elseif (SameText($type, "html")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtml", true)) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
        } elseif (SameText($type, "xml")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXml", true)) . "\">" . $Language->phrase("ExportToXml") . "</a>";
        } elseif (SameText($type, "csv")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsv", true)) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
        } elseif (SameText($type, "email")) {
            $url = $custom ? ' data-url="' . $exportUrl . '"' : '';
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . $Language->phrase("ExportToEmail", true) . '" data-caption="' . $Language->phrase("ExportToEmail", true) . '" form="fmasterprojectlist" data-ew-action="email" data-custom="false" data-hdr="' . $Language->phrase("ExportToEmail", true) . '" data-exported-selected="false"' . $url . '>' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = false;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to XML
        $item = &$this->ExportOptions->add("xml");
        $item->Body = $this->getExportTag("xml");
        $item->Visible = false;

        // Export to CSV
        $item = &$this->ExportOptions->add("csv");
        $item->Body = $this->getExportTag("csv");
        $item->Visible = true;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Advanced search button
        $item = &$this->SearchOptions->add("advancedsearch");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-table=\"masterproject\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-ew-action=\"modal\" data-url=\"masterprojectsearch\" data-btn=\"SearchBtn\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch", true) . "\" data-caption=\"" . $Language->phrase("AdvancedSearch", true) . "\" href=\"masterprojectsearch\">" . $Language->phrase("AdvancedSearch", false) . "</a>";
        }
        $item->Visible = true;

        // Query builder button
        $item = &$this->SearchOptions->add("querybuilder");
        if ($this->ModalSearch && !IsMobile()) {
            $item->Body = "<a class=\"btn btn-default ew-query-builder\" title=\"" . $Language->phrase("QueryBuilder", true) . "\" data-table=\"masterproject\" data-caption=\"" . $Language->phrase("QueryBuilder", true) . "\" data-ew-action=\"modal\" data-url=\"masterprojectquery\" data-btn=\"SearchBtn\">" . $Language->phrase("QueryBuilder", false) . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-query-builder\" title=\"" . $Language->phrase("QueryBuilder", true) . "\" data-caption=\"" . $Language->phrase("QueryBuilder", true) . "\" href=\"masterprojectquery\">" . $Language->phrase("QueryBuilder", false) . "</a>";
        }
        $item->Visible = true;

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return true;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    // Set up import options
    protected function setupImportOptions()
    {
        global $Security, $Language;

        // Import
        $item = &$this->ImportOptions->add("import");
        $item->Body = "<a class=\"ew-import-link ew-import\" role=\"button\" title=\"" . $Language->phrase("Import", true) . "\" data-caption=\"" . $Language->phrase("Import", true) . "\" data-ew-action=\"import\" data-hdr=\"" . $Language->phrase("Import", true) . "\">" . $Language->phrase("Import") . "</a>";
        $item->Visible = $Security->canImport();
        $this->ImportOptions->UseButtonGroup = true;
        $this->ImportOptions->UseDropDownButton = false;
        $this->ImportOptions->DropDownButtonPhrase = $Language->phrase("Import");

        // Add group option item
        $item = &$this->ImportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
    }

    /**
    * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
    *
    * @param bool $return Return the data rather than output it
    * @return mixed
    */
    public function exportData($doc)
    {
        global $Language;
        $rs = null;
        $this->TotalRecords = $this->listRecordCount();

        // Export all
        if ($this->ExportAll) {
            if (Config("EXPORT_ALL_TIME_LIMIT") >= 0) {
                @set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
            }
            $this->DisplayRecords = $this->TotalRecords;
            $this->StopRecord = $this->TotalRecords;
        } else { // Export one page only
            $this->setupStartRecord(); // Set up start record position
            // Set the last record to display
            if ($this->DisplayRecords <= 0) {
                $this->StopRecord = $this->TotalRecords;
            } else {
                $this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
            }
        }
        $rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
        if (!$rs || !$doc) {
            RemoveHeader("Content-Type"); // Remove header
            RemoveHeader("Content-Disposition");
            $this->showMessage();
            return;
        }
        $this->StartRecord = 1;
        $this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;

        // Call Page Exporting server event
        $doc->ExportCustom = !$this->pageExporting($doc);

        // Page header
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        $doc->Text .= $header;
        $this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
        $rs->free();

        // Page footer
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        $doc->Text .= $footer;

        // Export header and footer
        $doc->exportHeaderAndFooter();

        // Call Page Exported server event
        $this->pageExported($doc);
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("masterprojectlist");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_Status":
                    break;
                case "x_ClientID":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_ManagerID":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_ProjectTemplateID":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x_Priority":
                    break;
                case "x_Active":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up starting record parameters
    public function setupStartRecord()
    {
        if ($this->DisplayRecords == 0) {
            return;
        }
        $pageNo = Get(Config("TABLE_PAGE_NUMBER"));
        $startRec = Get(Config("TABLE_START_REC"));
        $infiniteScroll = ConvertToBool(Param("infinitescroll"));
        if ($pageNo !== null) { // Check for "pageno" parameter first
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
                if ($this->StartRecord <= 0) {
                    $this->StartRecord = 1;
                } elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1) {
                    $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1;
                }
            }
        } elseif ($startRec !== null && is_numeric($startRec)) { // Check for "start" parameter
            $this->StartRecord = $startRec;
        } elseif (!$infiniteScroll) {
            $this->StartRecord = $this->getStartRecordNumber();
        }

        // Check if correct start record counter
        if (!is_numeric($this->StartRecord) || intval($this->StartRecord) <= 0) { // Avoid invalid start record counter
            $this->StartRecord = 1; // Reset start record counter
        } elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
            $this->StartRecord = (int)(($this->TotalRecords - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
        } elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
            $this->StartRecord = (int)(($this->StartRecord - 1) / $this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
        }
        if (!$infiniteScroll) {
            $this->setStartRecordNumber($this->StartRecord);
        }
    }

    // Get page count
    public function pageCount() {
        return ceil($this->TotalRecords / $this->DisplayRecords);
    }

    // Parse query builder rule
    protected function parseRules($group, $fieldName = "", $itemName = "") {
        $group["condition"] ??= "AND";
        if (!in_array($group["condition"], ["AND", "OR"])) {
            throw new \Exception("Unable to build SQL query with condition '" . $group["condition"] . "'");
        }
        if (!is_array($group["rules"] ?? null)) {
            return "";
        }
        $parts = [];
        foreach ($group["rules"] as $rule) {
            if (is_array($rule["rules"] ?? null) && count($rule["rules"]) > 0) {
                $part = $this->parseRules($rule, $fieldName, $itemName);
                if ($part) {
                    $parts[] = "(" . " " . $part . " " . ")" . " ";
                }
            } else {
                $field = $rule["field"];
                $fld = $this->fieldByParam($field);
                $dbid = $this->Dbid;
                if ($fld instanceof ReportField && is_array($fld->DashboardSearchSourceFields)) {
                    $item = $fld->DashboardSearchSourceFields[$itemName] ?? null;
                    if ($item) {
                        $tbl = Container($item["table"]);
                        $dbid = $tbl->Dbid;
                        $fld = $tbl->Fields[$item["field"]];
                    } else {
                        $fld = null;
                    }
                }
                if ($fld && ($fieldName == "" || $fld->Name == $fieldName)) { // Field name not specified or matched field name
                    $fldOpr = array_search($rule["operator"], Config("CLIENT_SEARCH_OPERATORS"));
                    $ope = Config("QUERY_BUILDER_OPERATORS")[$rule["operator"]] ?? null;
                    if (!$ope || !$fldOpr) {
                        throw new \Exception("Unknown SQL operation for operator '" . $rule["operator"] . "'");
                    }
                    if ($ope["nb_inputs"] > 0 && ($rule["value"] ?? false) || IsNullOrEmptyOperator($fldOpr)) {
                        $fldVal = $rule["value"];
                        if (is_array($fldVal)) {
                            $fldVal = $fld->isMultiSelect() ? implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal) : $fldVal[0];
                        }
                        $useFilter = $fld->UseFilter; // Query builder does not use filter
                        try {
                            if ($fld instanceof ReportField) { // Search report fields
                                if ($fld->SearchType == "dropdown") {
                                    if (is_array($fldVal)) {
                                        $sql = "";
                                        foreach ($fldVal as $val) {
                                            AddFilter($sql, DropDownFilter($fld, $val, $fldOpr, $dbid), "OR");
                                        }
                                        $parts[] = $sql;
                                    } else {
                                        $parts[] = DropDownFilter($fld, $fldVal, $fldOpr, $dbid);
                                    }
                                } else {
                                    $fld->AdvancedSearch->SearchOperator = $fldOpr;
                                    $fld->AdvancedSearch->SearchValue = $fldVal;
                                    $parts[] = GetReportFilter($fld, false, $dbid);
                                }
                            } else { // Search normal fields
                                if ($fld->isMultiSelect()) {
                                    $parts[] = $fldVal != "" ? GetMultiSearchSql($fld, $fldOpr, ConvertSearchValue($fldVal, $fldOpr, $fld), $this->Dbid) : "";
                                } else {
                                    $fldVal2 = ContainsString($fldOpr, "BETWEEN") ? $rule["value"][1] : ""; // BETWEEN
                                    if (is_array($fldVal2)) {
                                        $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
                                    }
                                    $parts[] = GetSearchSql(
                                        $fld,
                                        ConvertSearchValue($fldVal, $fldOpr, $fld), // $fldVal
                                        $fldOpr,
                                        "", // $fldCond not used
                                        ConvertSearchValue($fldVal2, $fldOpr, $fld), // $fldVal2
                                        "", // $fldOpr2 not used
                                        $this->Dbid
                                    );
                                }
                            }
                        } finally {
                            $fld->UseFilter = $useFilter;
                        }
                    }
                }
            }
        }
        $where = "";
        foreach ($parts as $part) {
            AddFilter($where, $part, $group["condition"]);
        }
        if ($where && ($group["not"] ?? false)) {
            $where = "NOT (" . $where . ")";
        }
        return $where;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }

    // ListOptions Load event
    public function listOptionsLoad()
    {
        // Example:
        //$opt = &$this->ListOptions->add("new");
        //$opt->Header = "xxx";
        //$opt->OnLeft = true; // Link on left
        //$opt->moveTo(0); // Move to first column
    }

    // ListOptions Rendering event
    public function listOptionsRendering()
    {
        //Container("DetailTableGrid")->DetailAdd = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailEdit = (...condition...); // Set to true or false conditionally
        //Container("DetailTableGrid")->DetailView = (...condition...); // Set to true or false conditionally
    }

    // ListOptions Rendered event
    public function listOptionsRendered()
    {
        // Example:
        //$this->ListOptions["new"]->Body = "xxx";
    }

    // Row Custom Action event
    public function rowCustomAction($action, $row)
    {
        // Return false to abort
        return true;
    }

    // Page Exporting event
    // $doc = export object
    public function pageExporting(&$doc)
    {
        //$doc->Text = "my header"; // Export header
        //return false; // Return false to skip default export and use Row_Export event
        return true; // Return true to use default export and skip Row_Export event
    }

    // Row Export event
    // $doc = export document object
    public function rowExport($doc, $rs)
    {
        //$doc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
    }

    // Page Exported event
    // $doc = export document object
    public function pageExported($doc)
    {
        //$doc->Text .= "my footer"; // Export footer
        //Log($doc->Text);
    }

    // Page Importing event
    public function pageImporting(&$builder, &$options)
    {
        //var_dump($options); // Show all options for importing
        //$builder = fn($workflow) => $workflow->addStep($myStep);
        //return false; // Return false to skip import
        return true;
    }

    // Row Import event
    public function rowImport(&$row, $cnt)
    {
        //Log($cnt); // Import record count
        //var_dump($row); // Import row
        //return false; // Return false to skip import
        return true;
    }

    // Page Imported event
    public function pageImported($obj, $results)
    {
        //var_dump($obj); // Workflow result object
        //var_dump($results); // Import results
    }
}
