<?php

namespace ProjectManagement\prjProjectManagement;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class PerformanceReportSummary extends PerformanceReport
{
    use MessagesTrait;

    // Page ID
    public $PageID = "summary";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "PerformanceReportSummary";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $ReportContainerClass = "ew-grid";
    public $CurrentPageName = "performancereport";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'PerformanceReport';
        $this->TableName = 'PerformanceReport';

        // CSS class name as context
        $this->ContextClass = CheckClassName($this->TableVar);
        AppendClass($this->ReportContainerClass, $this->ContextClass);

        // Fixed header table
        if (!$this->UseCustomTemplate) {
            $this->setFixedHeaderTable(Config("USE_FIXED_HEADER_TABLE"), Config("FIXED_HEADER_TABLE_HEIGHT"));
        }

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (PerformanceReport)
        if (!isset($GLOBALS["PerformanceReport"]) || $GLOBALS["PerformanceReport"]::class == PROJECT_NAMESPACE . "PerformanceReport") {
            $GLOBALS["PerformanceReport"] = &$this;
        }

        // Page URL
        $pageUrl = $this->pageUrl(false);

        // Initialize URLs

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'PerformanceReport');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");

        // Export options
        $this->ExportOptions = new ListOptions(TagClassName: "ew-export-option");

        // Filter options
        $this->FilterOptions = new ListOptions(TagClassName: "ew-filter-option");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection if not in dashboard
        if (!$DashboardReport) {
            CloseConnections();
        }

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }
            SaveDebugMessage();
            Redirect(GetUrl($url));
        }
        return; // Return to controller
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }
        if ($fld instanceof ReportField) {
            $lookup->RenderViewFunc = "renderLookup"; // Set up view renderer
        }
        $lookup->RenderEditFunc = ""; // Set up edit renderer

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }

    // Options
    public $HideOptions = false;
    public $ExportOptions; // Export options
    public $SearchOptions; // Search options
    public $FilterOptions; // Filter options

    // Records
    public $GroupRecords = [];
    public $DetailRecords = [];
    public $DetailRecordCount = 0;

    // Paging variables
    public $RecordIndex = 0; // Record index
    public $RecordCount = 0; // Record count (start from 1 for each group)
    public $StartGroup = 0; // Start group
    public $StopGroup = 0; // Stop group
    public $TotalGroups = 0; // Total groups
    public $GroupCount = 0; // Group count
    public $GroupCounter = []; // Group counter
    public $DisplayGroups = 3; // Groups per page
    public $GroupRange = 10;
    public $PageSizes = "1,2,3,5,-1"; // Page sizes (comma separated)
    public $PageFirstGroupFilter = "";
    public $UserIDFilter = "";
    public $DefaultSearchWhere = ""; // Default search WHERE clause
    public $SearchWhere = "";
    public $SearchPanelClass = "ew-search-panel collapse show"; // Search Panel class
    public $SearchColumnCount = 0; // For extended search
    public $SearchFieldsPerRow = 1; // For extended search
    public $DrillDownList = "";
    public $DbMasterFilter = ""; // Master filter
    public $DbDetailFilter = ""; // Detail filter
    public $SearchCommand = false;
    public $ShowHeader = true;
    public $GroupColumnCount = 0;
    public $SubGroupColumnCount = 0;
    public $DetailColumnCount = 0;
    public $TotalCount;
    public $PageTotalCount;
    public $TopContentClass = "ew-top";
    public $MiddleContentClass = "ew-middle";
    public $BottomContentClass = "ew-bottom";

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $DrillDownInPanel, $Breadcrumb, $DashboardReport;

        // Set up dashboard report
        $DashboardReport ??= Param(Config("PAGE_DASHBOARD"));
        if ($DashboardReport) {
            $this->UseAjaxActions = true;
            AddFilter($this->Filter, $this->getDashboardFilter($DashboardReport, $this->TableVar)); // Set up Dashboard Filter
        }

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Get export parameters
        $custom = "";
        if (Param("export") !== null) {
            $this->Export = Param("export");
            $custom = Param("custom", "");
        }
        $ExportType = $this->Export; // Get export parameter, used in header
        if ($ExportType != "") {
            global $SkipHeaderFooter;
            $SkipHeaderFooter = true;
        }
        $this->CurrentAction = Param("action"); // Set up current action

        // Setup export options
        $this->setupExportOptions();

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Setup other options
        $this->setupOtherOptions();

        // Set up table class
        if ($this->isExport("word") || $this->isExport("excel") || $this->isExport("pdf")) {
            $this->TableClass = "ew-table table-bordered table-sm";
        } else {
            PrependClass($this->TableClass, "table ew-table table-bordered table-sm");
        }

        // Set up report container class
        if (!$this->isExport("word") && !$this->isExport("excel")) {
            $this->ReportContainerClass .= " card ew-card";
        }

        // Set field visibility for detail fields
        $this->TaskID->setVisibility();
        $this->TaskName->setVisibility();
        $this->Progress->setVisibility();
        $this->Target->setVisibility();
        $this->Track->setVisibility();
        $this->PlanStart->setVisibility();
        $this->PlanEnd->setVisibility();
        $this->StartDate->setVisibility();
        $this->EndDate->setVisibility();
        $this->Priority->setVisibility();
        $this->Category->setVisibility();
        $this->Complete->setVisibility();

        // Set up groups per page dynamically
        $this->setupDisplayGroups();

        // Set up Breadcrumb
        if (!$this->isExport() && !$DashboardReport) {
            $this->setupBreadcrumb();
        }

        // Check if search command
        $this->SearchCommand = (Get("cmd", "") == "search");

        // Load custom filters
        $this->pageFilterLoad();

        // Extended filter
        $extendedFilter = "";

        // Restore filter list
        $this->restoreFilterList();

        // Build extended filter
        $extendedFilter = $this->getExtendedFilter();
        AddFilter($this->SearchWhere, $extendedFilter);

        // Call Page Selecting event
        $this->pageSelecting($this->SearchWhere);

        // Set up search panel class
        if ($this->SearchWhere != "") {
            AppendClass($this->SearchPanelClass, "show");
        }

        // Get sort
        $this->Sort = $this->getSort();

        // Search options
        $this->setupSearchOptions();

        // Update filter
        AddFilter($this->Filter, $this->SearchWhere);

        // Get total group count
        $sql = $this->buildReportSql($this->getSqlSelectGroup(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
        $this->TotalGroups = $this->getRecordCount($sql);
        if ($this->DisplayGroups <= 0 || $this->DrillDown) { // Display all groups
            $this->DisplayGroups = $this->TotalGroups;
        }
        $this->StartGroup = 1;

        // Set up start position if not export all
        if ($this->ExportAll && $this->isExport()) {
            $this->DisplayGroups = $this->TotalGroups;
        } else {
            $this->setupStartGroup();
        }

        // Set no record found message
        if ($this->TotalGroups == 0) {
            $this->ShowHeader = false;
            if ($Security->canList()) {
                if ($this->SearchWhere == "0=101") {
                    $this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
                } else {
                    $this->setWarningMessage($Language->phrase("NoRecord"));
                }
            } else {
                $this->setWarningMessage(DeniedMessage());
            }
        }

        // Hide export options if export/dashboard report/hide options
        if ($this->isExport() || $DashboardReport || $this->HideOptions) {
            $this->ExportOptions->hideAllOptions();
        }

        // Hide search/filter options if export/drilldown/dashboard report/hide options
        if ($this->isExport() || $this->DrillDown || $DashboardReport || $this->HideOptions) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }

        // Get group records
        if ($this->TotalGroups > 0) {
            $grpSort = UpdateSortFields($this->getSqlOrderByGroup(), $this->Sort, 2); // Get grouping field only
            $sql = $this->buildReportSql($this->getSqlSelectGroup(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderByGroup(), $this->Filter, $grpSort);
            $grpRs = $sql->setFirstResult(max($this->StartGroup - 1, 0))->setMaxResults($this->DisplayGroups)->executeQuery();
            $this->GroupRecords = $grpRs->fetchAll(); // Get records of first grouping field
            $this->loadGroupRowValues();
            $this->GroupCount = 1;
        }

        // Init detail records
        $this->DetailRecords = [];
        $this->setupFieldCount();

        // Set the last group to display if not export all
        if ($this->ExportAll && $this->isExport()) {
            $this->StopGroup = $this->TotalGroups;
        } else {
            $this->StopGroup = $this->StartGroup + $this->DisplayGroups - 1;
        }

        // Stop group <= total number of groups
        if (intval($this->StopGroup) > intval($this->TotalGroups)) {
            $this->StopGroup = $this->TotalGroups;
        }
        $this->RecordCount = 0;
        $this->RecordIndex = 0;

        // Set up pager
        $this->Pager = new PrevNextPager($this, $this->StartGroup, $this->DisplayGroups, $this->TotalGroups, $this->PageSizes, $this->GroupRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);

        // Check if no records
        if ($this->TotalGroups == 0) {
            $this->ReportContainerClass .= " ew-no-record";
        }

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Load group row values
    public function loadGroupRowValues()
    {
        $cnt = count($this->GroupRecords); // Get record count
        if ($this->GroupCount < $cnt) {
            $this->AssignedTo->setGroupValue(reset($this->GroupRecords[$this->GroupCount]));
        } else {
            $this->AssignedTo->setGroupValue("");
        }
    }

    // Load row values
    public function loadRowValues($record)
    {
        $data = [];
        $data["TaskID"] = $record['TaskID'];
        $data["TaskName"] = $record['TaskName'];
        $data["Description"] = $record['Description'];
        $data["AssignedTo"] = $record['AssignedTo'];
        $data["Progress"] = $record['Progress'];
        $data["Target"] = $record['Target'];
        $data["Track"] = $record['Track'];
        $data["PlanStart"] = $record['PlanStart'];
        $data["PlanEnd"] = $record['PlanEnd'];
        $data["StartDate"] = $record['StartDate'];
        $data["EndDate"] = $record['EndDate'];
        $data["Priority"] = $record['Priority'];
        $data["Category"] = $record['Category'];
        $data["_ProjectID"] = $record['ProjectID'];
        $data["Created_Date"] = $record['Created_Date'];
        $data["Created_By"] = $record['Created_By'];
        $data["Last_Updated_Date"] = $record['Last_Updated_Date'];
        $data["Last_Updated_By"] = $record['Last_Updated_By'];
        $data["Complete"] = $record['Complete'];
        $this->Rows[] = $data;
        $this->TaskID->setDbValue($record['TaskID']);
        $this->TaskName->setDbValue($record['TaskName']);
        $this->Description->setDbValue($record['Description']);
        $this->AssignedTo->setDbValue(GroupValue($this->AssignedTo, $record['AssignedTo']));
        $this->Progress->setDbValue($record['Progress']);
        $this->Target->setDbValue($record['Target']);
        $this->Track->setDbValue($record['Track']);
        $this->PlanStart->setDbValue($record['PlanStart']);
        $this->PlanEnd->setDbValue($record['PlanEnd']);
        $this->StartDate->setDbValue($record['StartDate']);
        $this->EndDate->setDbValue($record['EndDate']);
        $this->Priority->setDbValue($record['Priority']);
        $this->Category->setDbValue($record['Category']);
        $this->_ProjectID->setDbValue($record['ProjectID']);
        $this->Created_Date->setDbValue($record['Created_Date']);
        $this->Created_By->setDbValue($record['Created_By']);
        $this->Last_Updated_Date->setDbValue($record['Last_Updated_Date']);
        $this->Last_Updated_By->setDbValue($record['Last_Updated_By']);
        $this->Complete->setDbValue($record['Complete']);
    }

    // Render row
    public function renderRow()
    {
        global $Security, $Language, $Language;
        $conn = $this->getConnection();
        if ($this->RowType == RowType::TOTAL && $this->RowTotalSubType == RowTotal::FOOTER && $this->RowTotalType == RowSummary::PAGE) {
            // Build detail SQL
            $firstGrpFld = &$this->AssignedTo;
            $firstGrpFld->getDistinctValues($this->GroupRecords);
            $where = DetailFilterSql($firstGrpFld, $this->getSqlFirstGroupField(), $firstGrpFld->DistinctValues, $this->Dbid);
            AddFilter($where, $this->Filter);
            $sql = $this->buildReportSql($this->getSqlSelect(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(), $where, $this->Sort);
            $rs = $sql->executeQuery();
            $records = $rs?->fetchAll() ?? [];
            $this->TaskID->getCnt($records, false);
            $this->PageTotalCount = count($records);
        } elseif ($this->RowType == RowType::TOTAL && $this->RowTotalSubType == RowTotal::FOOTER && $this->RowTotalType == RowSummary::GRAND) { // Get Grand total
            $hasCount = false;
            $hasSummary = false;

            // Get total count from SQL directly
            $sql = $this->buildReportSql($this->getSqlSelectCount(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
            $rstot = $conn->executeQuery($sql);
            if ($rstot && $cnt = $rstot->fetchOne()) {
                $hasCount = true;
            } else {
                $cnt = 0;
            }
            $this->TotalCount = $cnt;

            // Get total from SQL directly
            $sql = $this->buildReportSql($this->getSqlSelectAggregate(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
            $sql = $this->getSqlAggregatePrefix() . $sql . $this->getSqlAggregateSuffix();
            $rsagg = $conn->fetchAssociative($sql);
            if ($rsagg) {
                $this->TaskID->Count = $this->TotalCount;
                $this->TaskID->CntValue = $rsagg["cnt_taskid"];
                $this->TaskName->Count = $this->TotalCount;
                $this->Progress->Count = $this->TotalCount;
                $this->Target->Count = $this->TotalCount;
                $this->Track->Count = $this->TotalCount;
                $this->PlanStart->Count = $this->TotalCount;
                $this->PlanEnd->Count = $this->TotalCount;
                $this->StartDate->Count = $this->TotalCount;
                $this->EndDate->Count = $this->TotalCount;
                $this->Priority->Count = $this->TotalCount;
                $this->Category->Count = $this->TotalCount;
                $this->Complete->Count = $this->TotalCount;
                $hasSummary = true;
            }

            // Accumulate grand summary from detail records
            if (!$hasCount || !$hasSummary) {
                $sql = $this->buildReportSql($this->getSqlSelect(), $this->getSqlFrom(), $this->getSqlWhere(), $this->getSqlGroupBy(), $this->getSqlHaving(), "", $this->Filter, "");
                $rs = $sql->executeQuery();
                $this->DetailRecords = $rs?->fetchAll() ?? [];
                $this->TaskID->getCnt($this->DetailRecords, false);
            }
        }

        // Call Row_Rendering event
        $this->rowRendering();

        // AssignedTo
        $this->AssignedTo->CellCssStyle = "white-space: nowrap;";

        // ProjectID
        $this->_ProjectID->CellCssStyle = "white-space: nowrap;";

        // TaskID

        // TaskName
        $this->TaskName->CellCssStyle = "white-space: nowrap;";

        // Progress
        $this->Progress->CellCssStyle = "white-space: nowrap;";

        // Target
        $this->Target->CellCssStyle = "white-space: nowrap;";

        // Track
        $this->Track->CellCssStyle = "white-space: nowrap;";

        // PlanStart
        $this->PlanStart->CellCssStyle = "white-space: nowrap;";

        // PlanEnd
        $this->PlanEnd->CellCssStyle = "white-space: nowrap;";

        // StartDate
        $this->StartDate->CellCssStyle = "white-space: nowrap;";

        // EndDate
        $this->EndDate->CellCssStyle = "white-space: nowrap;";

        // Priority
        $this->Priority->CellCssStyle = "white-space: nowrap;";

        // Category
        $this->Category->CellCssStyle = "white-space: nowrap;";

        // Complete
        if ($this->RowType == RowType::SEARCH) {
            // TaskName
            if ($this->TaskName->UseFilter && !EmptyValue($this->TaskName->AdvancedSearch->SearchValue)) {
                if (is_array($this->TaskName->AdvancedSearch->SearchValue)) {
                    $this->TaskName->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->TaskName->AdvancedSearch->SearchValue);
                }
                $this->TaskName->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->TaskName->AdvancedSearch->SearchValue);
            }

            // AssignedTo
            if ($this->AssignedTo->UseFilter && !EmptyValue($this->AssignedTo->AdvancedSearch->SearchValue)) {
                if (is_array($this->AssignedTo->AdvancedSearch->SearchValue)) {
                    $this->AssignedTo->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->AssignedTo->AdvancedSearch->SearchValue);
                }
                $this->AssignedTo->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->AssignedTo->AdvancedSearch->SearchValue);
            }

            // Progress
            if ($this->Progress->UseFilter && !EmptyValue($this->Progress->AdvancedSearch->SearchValue)) {
                if (is_array($this->Progress->AdvancedSearch->SearchValue)) {
                    $this->Progress->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->Progress->AdvancedSearch->SearchValue);
                }
                $this->Progress->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->Progress->AdvancedSearch->SearchValue);
            }

            // Target
            if ($this->Target->UseFilter && !EmptyValue($this->Target->AdvancedSearch->SearchValue)) {
                if (is_array($this->Target->AdvancedSearch->SearchValue)) {
                    $this->Target->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->Target->AdvancedSearch->SearchValue);
                }
                $this->Target->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->Target->AdvancedSearch->SearchValue);
            }

            // Track
            if ($this->Track->UseFilter && !EmptyValue($this->Track->AdvancedSearch->SearchValue)) {
                if (is_array($this->Track->AdvancedSearch->SearchValue)) {
                    $this->Track->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->Track->AdvancedSearch->SearchValue);
                }
                $this->Track->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->Track->AdvancedSearch->SearchValue);
            }

            // PlanStart
            if ($this->PlanStart->UseFilter && !EmptyValue($this->PlanStart->AdvancedSearch->SearchValue)) {
                if (is_array($this->PlanStart->AdvancedSearch->SearchValue)) {
                    $this->PlanStart->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->PlanStart->AdvancedSearch->SearchValue);
                }
                $this->PlanStart->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->PlanStart->AdvancedSearch->SearchValue);
            }
            $this->PlanStart->setupEditAttributes();
            $this->PlanStart->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->PlanStart->AdvancedSearch->SearchValue2, $this->PlanStart->formatPattern()), $this->PlanStart->formatPattern()));
            $this->PlanStart->PlaceHolder = RemoveHtml($this->PlanStart->caption());

            // PlanEnd
            $this->PlanEnd->setupEditAttributes();
            $this->PlanEnd->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->PlanEnd->AdvancedSearch->SearchValue, $this->PlanEnd->formatPattern()), $this->PlanEnd->formatPattern()));
            $this->PlanEnd->PlaceHolder = RemoveHtml($this->PlanEnd->caption());
            $this->PlanEnd->setupEditAttributes();
            $this->PlanEnd->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->PlanEnd->AdvancedSearch->SearchValue2, $this->PlanEnd->formatPattern()), $this->PlanEnd->formatPattern()));
            $this->PlanEnd->PlaceHolder = RemoveHtml($this->PlanEnd->caption());

            // StartDate
            if ($this->StartDate->UseFilter && !EmptyValue($this->StartDate->AdvancedSearch->SearchValue)) {
                if (is_array($this->StartDate->AdvancedSearch->SearchValue)) {
                    $this->StartDate->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->StartDate->AdvancedSearch->SearchValue);
                }
                $this->StartDate->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->StartDate->AdvancedSearch->SearchValue);
            }
            $this->StartDate->setupEditAttributes();
            $this->StartDate->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->StartDate->AdvancedSearch->SearchValue2, $this->StartDate->formatPattern()), $this->StartDate->formatPattern()));
            $this->StartDate->PlaceHolder = RemoveHtml($this->StartDate->caption());

            // EndDate
            $this->EndDate->setupEditAttributes();
            $this->EndDate->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->EndDate->AdvancedSearch->SearchValue, $this->EndDate->formatPattern()), $this->EndDate->formatPattern()));
            $this->EndDate->PlaceHolder = RemoveHtml($this->EndDate->caption());
            $this->EndDate->setupEditAttributes();
            $this->EndDate->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->EndDate->AdvancedSearch->SearchValue2, $this->EndDate->formatPattern()), $this->EndDate->formatPattern()));
            $this->EndDate->PlaceHolder = RemoveHtml($this->EndDate->caption());

            // Priority
            if ($this->Priority->UseFilter && !EmptyValue($this->Priority->AdvancedSearch->SearchValue)) {
                if (is_array($this->Priority->AdvancedSearch->SearchValue)) {
                    $this->Priority->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->Priority->AdvancedSearch->SearchValue);
                }
                $this->Priority->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->Priority->AdvancedSearch->SearchValue);
            }

            // Category
            if ($this->Category->UseFilter && !EmptyValue($this->Category->AdvancedSearch->SearchValue)) {
                if (is_array($this->Category->AdvancedSearch->SearchValue)) {
                    $this->Category->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->Category->AdvancedSearch->SearchValue);
                }
                $this->Category->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->Category->AdvancedSearch->SearchValue);
            }

            // ProjectID
            if ($this->_ProjectID->UseFilter && !EmptyValue($this->_ProjectID->AdvancedSearch->SearchValue)) {
                if (is_array($this->_ProjectID->AdvancedSearch->SearchValue)) {
                    $this->_ProjectID->AdvancedSearch->SearchValue = implode(Config("FILTER_OPTION_SEPARATOR"), $this->_ProjectID->AdvancedSearch->SearchValue);
                }
                $this->_ProjectID->EditValue = explode(Config("FILTER_OPTION_SEPARATOR"), $this->_ProjectID->AdvancedSearch->SearchValue);
            }
        } elseif ($this->RowType == RowType::TOTAL && !($this->RowTotalType == RowSummary::GROUP && $this->RowTotalSubType == RowTotal::HEADER)) { // Summary row
            $this->RowAttrs->prependClass(($this->RowTotalType == RowSummary::PAGE || $this->RowTotalType == RowSummary::GRAND) ? "ew-rpt-grp-aggregate" : ""); // Set up row class
            if ($this->RowTotalType == RowSummary::GROUP) {
                $this->RowAttrs["data-group"] = $this->AssignedTo->groupValue(); // Set up group attribute
            }
            if ($this->RowTotalType == RowSummary::GROUP && $this->RowGroupLevel >= 2) {
                $this->RowAttrs["data-group-2"] = $this->_ProjectID->groupValue(); // Set up group attribute 2
            }

            // AssignedTo
            $curVal = strval($this->AssignedTo->groupValue());
            if ($curVal != "") {
                $this->AssignedTo->GroupViewValue = $this->AssignedTo->lookupCacheOption($curVal);
                if ($this->AssignedTo->GroupViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->AssignedTo->Lookup->getTable()->Fields["EmployeeID"]->searchExpression(), "=", $curVal, $this->AssignedTo->Lookup->getTable()->Fields["EmployeeID"]->searchDataType(), "");
                    $sqlWrk = $this->AssignedTo->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->AssignedTo->Lookup->renderViewRow($rswrk[0]);
                        $this->AssignedTo->GroupViewValue = $this->AssignedTo->displayValue($arwrk);
                    } else {
                        $this->AssignedTo->GroupViewValue = FormatNumber($this->AssignedTo->groupValue(), $this->AssignedTo->formatPattern());
                    }
                }
            } else {
                $this->AssignedTo->GroupViewValue = null;
            }
            $this->AssignedTo->CellCssClass = ($this->RowGroupLevel == 1 ? "ew-rpt-grp-summary-1" : "ew-rpt-grp-field-1");
            $this->AssignedTo->GroupViewValue = DisplayGroupValue($this->AssignedTo, $this->AssignedTo->GroupViewValue);

            // ProjectID
            $curVal = strval($this->_ProjectID->groupValue());
            if ($curVal != "") {
                $this->_ProjectID->GroupViewValue = $this->_ProjectID->lookupCacheOption($curVal);
                if ($this->_ProjectID->GroupViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchExpression(), "=", $curVal, $this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchDataType(), "");
                    $sqlWrk = $this->_ProjectID->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_ProjectID->Lookup->renderViewRow($rswrk[0]);
                        $this->_ProjectID->GroupViewValue = $this->_ProjectID->displayValue($arwrk);
                    } else {
                        $this->_ProjectID->GroupViewValue = FormatNumber($this->_ProjectID->groupValue(), $this->_ProjectID->formatPattern());
                    }
                }
            } else {
                $this->_ProjectID->GroupViewValue = null;
            }
            $this->_ProjectID->CellCssClass = ($this->RowGroupLevel == 2 ? "ew-rpt-grp-summary-2" : "ew-rpt-grp-field-2");
            $this->_ProjectID->GroupViewValue = DisplayGroupValue($this->_ProjectID, $this->_ProjectID->GroupViewValue);

            // TaskID
            $this->TaskID->CntViewValue = $this->TaskID->CntValue;
            $this->TaskID->CntViewValue = FormatNumber($this->TaskID->CntViewValue, $this->TaskID->formatPattern());
            $this->TaskID->CellAttrs["class"] = ($this->RowTotalType == RowSummary::PAGE || $this->RowTotalType == RowSummary::GRAND) ? "ew-rpt-grp-aggregate" : "ew-rpt-grp-summary-" . $this->RowGroupLevel;

            // AssignedTo
            $this->AssignedTo->HrefValue = "";

            // ProjectID
            $this->_ProjectID->HrefValue = "";

            // TaskID
            $this->TaskID->HrefValue = "";

            // TaskName
            $this->TaskName->HrefValue = "";

            // Progress
            $this->Progress->HrefValue = "";

            // Target
            $this->Target->HrefValue = "";

            // Track
            $this->Track->HrefValue = "";

            // PlanStart
            $this->PlanStart->HrefValue = "";

            // PlanEnd
            $this->PlanEnd->HrefValue = "";

            // StartDate
            $this->StartDate->HrefValue = "";

            // EndDate
            $this->EndDate->HrefValue = "";

            // Priority
            $this->Priority->HrefValue = "";

            // Category
            $this->Category->HrefValue = "";

            // Complete
            $this->Complete->HrefValue = "";
        } else {
            if ($this->RowTotalType == RowSummary::GROUP && $this->RowTotalSubType == RowTotal::HEADER) {
                $this->RowAttrs["data-group"] = $this->AssignedTo->groupValue(); // Set up group attribute
                if ($this->RowGroupLevel >= 2) {
                    $this->RowAttrs["data-group-2"] = $this->_ProjectID->groupValue(); // Set up group attribute 2
                }
            } else {
                $this->RowAttrs["data-group"] = $this->AssignedTo->groupValue(); // Set up group attribute
                $this->RowAttrs["data-group-2"] = $this->_ProjectID->groupValue(); // Set up group attribute 2
            }

            // AssignedTo
            $curVal = strval($this->AssignedTo->groupValue());
            if ($curVal != "") {
                $this->AssignedTo->GroupViewValue = $this->AssignedTo->lookupCacheOption($curVal);
                if ($this->AssignedTo->GroupViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->AssignedTo->Lookup->getTable()->Fields["EmployeeID"]->searchExpression(), "=", $curVal, $this->AssignedTo->Lookup->getTable()->Fields["EmployeeID"]->searchDataType(), "");
                    $sqlWrk = $this->AssignedTo->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->AssignedTo->Lookup->renderViewRow($rswrk[0]);
                        $this->AssignedTo->GroupViewValue = $this->AssignedTo->displayValue($arwrk);
                    } else {
                        $this->AssignedTo->GroupViewValue = FormatNumber($this->AssignedTo->groupValue(), $this->AssignedTo->formatPattern());
                    }
                }
            } else {
                $this->AssignedTo->GroupViewValue = null;
            }
            $this->AssignedTo->CellCssClass = "ew-rpt-grp-field-1";
            $this->AssignedTo->GroupViewValue = DisplayGroupValue($this->AssignedTo, $this->AssignedTo->GroupViewValue);
            if (!$this->AssignedTo->LevelBreak) {
                $this->AssignedTo->GroupViewValue = "";
            } else {
                $this->AssignedTo->LevelBreak = false;
            }

            // ProjectID
            $curVal = strval($this->_ProjectID->groupValue());
            if ($curVal != "") {
                $this->_ProjectID->GroupViewValue = $this->_ProjectID->lookupCacheOption($curVal);
                if ($this->_ProjectID->GroupViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchExpression(), "=", $curVal, $this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchDataType(), "");
                    $sqlWrk = $this->_ProjectID->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_ProjectID->Lookup->renderViewRow($rswrk[0]);
                        $this->_ProjectID->GroupViewValue = $this->_ProjectID->displayValue($arwrk);
                    } else {
                        $this->_ProjectID->GroupViewValue = FormatNumber($this->_ProjectID->groupValue(), $this->_ProjectID->formatPattern());
                    }
                }
            } else {
                $this->_ProjectID->GroupViewValue = null;
            }
            $this->_ProjectID->CellCssClass = "ew-rpt-grp-field-2";
            $this->_ProjectID->GroupViewValue = DisplayGroupValue($this->_ProjectID, $this->_ProjectID->GroupViewValue);
            if (!$this->_ProjectID->LevelBreak) {
                $this->_ProjectID->GroupViewValue = "";
            } else {
                $this->_ProjectID->LevelBreak = false;
            }

            // Increment RowCount
            if ($this->RowType == RowType::DETAIL) {
                $this->RowCount++;
            }

            // TaskID
            $this->TaskID->ViewValue = $this->TaskID->CurrentValue;
            $this->TaskID->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // TaskName
            $this->TaskName->ViewValue = $this->TaskName->CurrentValue;
            $this->TaskName->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // Progress
            $this->Progress->ViewValue = $this->Progress->CurrentValue;
            $this->Progress->ViewValue = FormatPercent($this->Progress->ViewValue, $this->Progress->formatPattern());
            $this->Progress->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");
            $this->Progress->CellCssStyle .= "text-align: right;";

            // Target
            $this->Target->ViewValue = $this->Target->CurrentValue;
            $this->Target->ViewValue = FormatPercent($this->Target->ViewValue, $this->Target->formatPattern());
            $this->Target->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");
            $this->Target->CellCssStyle .= "text-align: right;";

            // Track
            $this->Track->ViewValue = $this->Track->CurrentValue;
            $this->Track->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // PlanStart
            $this->PlanStart->ViewValue = $this->PlanStart->CurrentValue;
            $this->PlanStart->ViewValue = FormatDateTime($this->PlanStart->ViewValue, $this->PlanStart->formatPattern());
            $this->PlanStart->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // PlanEnd
            $this->PlanEnd->ViewValue = $this->PlanEnd->CurrentValue;
            $this->PlanEnd->ViewValue = FormatDateTime($this->PlanEnd->ViewValue, $this->PlanEnd->formatPattern());
            $this->PlanEnd->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // StartDate
            $this->StartDate->ViewValue = $this->StartDate->CurrentValue;
            $this->StartDate->ViewValue = FormatDateTime($this->StartDate->ViewValue, $this->StartDate->formatPattern());
            $this->StartDate->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // EndDate
            $this->EndDate->ViewValue = $this->EndDate->CurrentValue;
            $this->EndDate->ViewValue = FormatDateTime($this->EndDate->ViewValue, $this->EndDate->formatPattern());
            $this->EndDate->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // Priority
            if (strval($this->Priority->CurrentValue) != "") {
                $this->Priority->ViewValue = $this->Priority->optionCaption($this->Priority->CurrentValue);
            } else {
                $this->Priority->ViewValue = null;
            }
            $this->Priority->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // Category
            $curVal = strval($this->Category->CurrentValue);
            if ($curVal != "") {
                $this->Category->ViewValue = $this->Category->lookupCacheOption($curVal);
                if ($this->Category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->Category->Lookup->getTable()->Fields["CategoryName"]->searchExpression(), "=", $curVal, $this->Category->Lookup->getTable()->Fields["CategoryName"]->searchDataType(), "");
                    $lookupFilter = $this->Category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->Category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Category->Lookup->renderViewRow($rswrk[0]);
                        $this->Category->ViewValue = $this->Category->displayValue($arwrk);
                    } else {
                        $this->Category->ViewValue = $this->Category->CurrentValue;
                    }
                }
            } else {
                $this->Category->ViewValue = null;
            }
            $this->Category->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // Complete
            $this->Complete->ViewValue = $this->Complete->CurrentValue;
            $this->Complete->CellCssClass = ($this->RecordCount % 2 != 1 ? "ew-table-alt-row" : "");

            // AssignedTo
            $this->AssignedTo->HrefValue = "";
            $this->AssignedTo->TooltipValue = "";

            // ProjectID
            $this->_ProjectID->HrefValue = "";
            $this->_ProjectID->TooltipValue = "";

            // TaskID
            $this->TaskID->HrefValue = "";
            $this->TaskID->TooltipValue = "";

            // TaskName
            $this->TaskName->HrefValue = "";
            $this->TaskName->TooltipValue = "";

            // Progress
            $this->Progress->HrefValue = "";
            $this->Progress->TooltipValue = "";

            // Target
            $this->Target->HrefValue = "";
            $this->Target->TooltipValue = "";

            // Track
            $this->Track->HrefValue = "";
            $this->Track->TooltipValue = "";

            // PlanStart
            $this->PlanStart->HrefValue = "";
            $this->PlanStart->TooltipValue = "";

            // PlanEnd
            $this->PlanEnd->HrefValue = "";
            $this->PlanEnd->TooltipValue = "";

            // StartDate
            $this->StartDate->HrefValue = "";
            $this->StartDate->TooltipValue = "";

            // EndDate
            $this->EndDate->HrefValue = "";
            $this->EndDate->TooltipValue = "";

            // Priority
            $this->Priority->HrefValue = "";
            $this->Priority->TooltipValue = "";

            // Category
            $this->Category->HrefValue = "";
            $this->Category->TooltipValue = "";

            // Complete
            $this->Complete->HrefValue = "";
            $this->Complete->TooltipValue = "";
        }

        // Call Cell_Rendered event
        if ($this->RowType == RowType::TOTAL) {
            // AssignedTo
            $currentValue = $this->AssignedTo->GroupViewValue;
            $viewValue = &$this->AssignedTo->GroupViewValue;
            $viewAttrs = &$this->AssignedTo->ViewAttrs;
            $cellAttrs = &$this->AssignedTo->CellAttrs;
            $hrefValue = &$this->AssignedTo->HrefValue;
            $linkAttrs = &$this->AssignedTo->LinkAttrs;
            $this->cellRendered($this->AssignedTo, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // ProjectID
            $currentValue = $this->_ProjectID->GroupViewValue;
            $viewValue = &$this->_ProjectID->GroupViewValue;
            $viewAttrs = &$this->_ProjectID->ViewAttrs;
            $cellAttrs = &$this->_ProjectID->CellAttrs;
            $hrefValue = &$this->_ProjectID->HrefValue;
            $linkAttrs = &$this->_ProjectID->LinkAttrs;
            $this->cellRendered($this->_ProjectID, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // TaskID
            $currentValue = $this->TaskID->CntValue;
            $viewValue = &$this->TaskID->CntViewValue;
            $viewAttrs = &$this->TaskID->ViewAttrs;
            $cellAttrs = &$this->TaskID->CellAttrs;
            $hrefValue = &$this->TaskID->HrefValue;
            $linkAttrs = &$this->TaskID->LinkAttrs;
            $this->cellRendered($this->TaskID, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);
        } else {
            // AssignedTo
            $currentValue = $this->AssignedTo->groupValue();
            $viewValue = &$this->AssignedTo->GroupViewValue;
            $viewAttrs = &$this->AssignedTo->ViewAttrs;
            $cellAttrs = &$this->AssignedTo->CellAttrs;
            $hrefValue = &$this->AssignedTo->HrefValue;
            $linkAttrs = &$this->AssignedTo->LinkAttrs;
            $this->cellRendered($this->AssignedTo, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // ProjectID
            $currentValue = $this->_ProjectID->groupValue();
            $viewValue = &$this->_ProjectID->GroupViewValue;
            $viewAttrs = &$this->_ProjectID->ViewAttrs;
            $cellAttrs = &$this->_ProjectID->CellAttrs;
            $hrefValue = &$this->_ProjectID->HrefValue;
            $linkAttrs = &$this->_ProjectID->LinkAttrs;
            $this->cellRendered($this->_ProjectID, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // TaskID
            $currentValue = $this->TaskID->CurrentValue;
            $viewValue = &$this->TaskID->ViewValue;
            $viewAttrs = &$this->TaskID->ViewAttrs;
            $cellAttrs = &$this->TaskID->CellAttrs;
            $hrefValue = &$this->TaskID->HrefValue;
            $linkAttrs = &$this->TaskID->LinkAttrs;
            $this->cellRendered($this->TaskID, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // TaskName
            $currentValue = $this->TaskName->CurrentValue;
            $viewValue = &$this->TaskName->ViewValue;
            $viewAttrs = &$this->TaskName->ViewAttrs;
            $cellAttrs = &$this->TaskName->CellAttrs;
            $hrefValue = &$this->TaskName->HrefValue;
            $linkAttrs = &$this->TaskName->LinkAttrs;
            $this->cellRendered($this->TaskName, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Progress
            $currentValue = $this->Progress->CurrentValue;
            $viewValue = &$this->Progress->ViewValue;
            $viewAttrs = &$this->Progress->ViewAttrs;
            $cellAttrs = &$this->Progress->CellAttrs;
            $hrefValue = &$this->Progress->HrefValue;
            $linkAttrs = &$this->Progress->LinkAttrs;
            $this->cellRendered($this->Progress, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Target
            $currentValue = $this->Target->CurrentValue;
            $viewValue = &$this->Target->ViewValue;
            $viewAttrs = &$this->Target->ViewAttrs;
            $cellAttrs = &$this->Target->CellAttrs;
            $hrefValue = &$this->Target->HrefValue;
            $linkAttrs = &$this->Target->LinkAttrs;
            $this->cellRendered($this->Target, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Track
            $currentValue = $this->Track->CurrentValue;
            $viewValue = &$this->Track->ViewValue;
            $viewAttrs = &$this->Track->ViewAttrs;
            $cellAttrs = &$this->Track->CellAttrs;
            $hrefValue = &$this->Track->HrefValue;
            $linkAttrs = &$this->Track->LinkAttrs;
            $this->cellRendered($this->Track, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // PlanStart
            $currentValue = $this->PlanStart->CurrentValue;
            $viewValue = &$this->PlanStart->ViewValue;
            $viewAttrs = &$this->PlanStart->ViewAttrs;
            $cellAttrs = &$this->PlanStart->CellAttrs;
            $hrefValue = &$this->PlanStart->HrefValue;
            $linkAttrs = &$this->PlanStart->LinkAttrs;
            $this->cellRendered($this->PlanStart, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // PlanEnd
            $currentValue = $this->PlanEnd->CurrentValue;
            $viewValue = &$this->PlanEnd->ViewValue;
            $viewAttrs = &$this->PlanEnd->ViewAttrs;
            $cellAttrs = &$this->PlanEnd->CellAttrs;
            $hrefValue = &$this->PlanEnd->HrefValue;
            $linkAttrs = &$this->PlanEnd->LinkAttrs;
            $this->cellRendered($this->PlanEnd, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // StartDate
            $currentValue = $this->StartDate->CurrentValue;
            $viewValue = &$this->StartDate->ViewValue;
            $viewAttrs = &$this->StartDate->ViewAttrs;
            $cellAttrs = &$this->StartDate->CellAttrs;
            $hrefValue = &$this->StartDate->HrefValue;
            $linkAttrs = &$this->StartDate->LinkAttrs;
            $this->cellRendered($this->StartDate, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // EndDate
            $currentValue = $this->EndDate->CurrentValue;
            $viewValue = &$this->EndDate->ViewValue;
            $viewAttrs = &$this->EndDate->ViewAttrs;
            $cellAttrs = &$this->EndDate->CellAttrs;
            $hrefValue = &$this->EndDate->HrefValue;
            $linkAttrs = &$this->EndDate->LinkAttrs;
            $this->cellRendered($this->EndDate, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Priority
            $currentValue = $this->Priority->CurrentValue;
            $viewValue = &$this->Priority->ViewValue;
            $viewAttrs = &$this->Priority->ViewAttrs;
            $cellAttrs = &$this->Priority->CellAttrs;
            $hrefValue = &$this->Priority->HrefValue;
            $linkAttrs = &$this->Priority->LinkAttrs;
            $this->cellRendered($this->Priority, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Category
            $currentValue = $this->Category->CurrentValue;
            $viewValue = &$this->Category->ViewValue;
            $viewAttrs = &$this->Category->ViewAttrs;
            $cellAttrs = &$this->Category->CellAttrs;
            $hrefValue = &$this->Category->HrefValue;
            $linkAttrs = &$this->Category->LinkAttrs;
            $this->cellRendered($this->Category, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);

            // Complete
            $currentValue = $this->Complete->CurrentValue;
            $viewValue = &$this->Complete->ViewValue;
            $viewAttrs = &$this->Complete->ViewAttrs;
            $cellAttrs = &$this->Complete->CellAttrs;
            $hrefValue = &$this->Complete->HrefValue;
            $linkAttrs = &$this->Complete->LinkAttrs;
            $this->cellRendered($this->Complete, $currentValue, $viewValue, $viewAttrs, $cellAttrs, $hrefValue, $linkAttrs);
        }

        // Call Row_Rendered event
        $this->rowRendered();
        $this->setupFieldCount();
    }
    private $groupCounts = [];

    // Get group count
    public function getGroupCount(...$args)
    {
        $key = "";
        foreach ($args as $arg) {
            if ($key != "") {
                $key .= "_";
            }
            $key .= strval($arg);
        }
        if ($key == "") {
            return -1;
        } elseif ($key == "0") { // Number of first level groups
            $i = 1;
            while (isset($this->groupCounts[strval($i)])) {
                $i++;
            }
            return $i - 1;
        }
        return isset($this->groupCounts[$key]) ? $this->groupCounts[$key] : -1;
    }

    // Set group count
    public function setGroupCount($value, ...$args)
    {
        $key = "";
        foreach ($args as $arg) {
            if ($key != "") {
                $key .= "_";
            }
            $key .= strval($arg);
        }
        if ($key == "") {
            return;
        }
        $this->groupCounts[$key] = $value;
    }

    // Setup field count
    protected function setupFieldCount()
    {
        $this->GroupColumnCount = 0;
        $this->SubGroupColumnCount = 0;
        $this->DetailColumnCount = 0;
        if ($this->AssignedTo->Visible) {
            $this->GroupColumnCount += 1;
        }
        if ($this->_ProjectID->Visible) {
            $this->GroupColumnCount += 1;
            $this->SubGroupColumnCount += 1;
        }
        if ($this->TaskID->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->TaskName->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Progress->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Target->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Track->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->PlanStart->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->PlanEnd->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->StartDate->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->EndDate->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Priority->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Category->Visible) {
            $this->DetailColumnCount += 1;
        }
        if ($this->Complete->Visible) {
            $this->DetailColumnCount += 1;
        }
    }

    // Get export HTML tag
    protected function getExportTag($type, $custom = false)
    {
        global $Language;
        if ($type == "print" || $custom) { // Printer friendly / custom export
            $pageUrl = $this->pageUrl(false);
            $exportUrl = GetUrl($pageUrl . "export=" . $type . ($custom ? "&amp;custom=1" : ""));
        } else { // Export API URL
            $exportUrl = GetApiUrl(Config("API_EXPORT_ACTION") . "/" . $type . "/" . $this->TableVar);
        }
        if (SameText($type, "excel")) {
            return '<button type="button" class="btn btn-default ew-export-link ew-excel" title="' . HtmlEncode($Language->phrase("ExportToExcel", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToExcel", true)) . '" data-ew-action="export" data-export="excel" data-custom="false" data-export-selected="false" data-url="' . $exportUrl . '">' . $Language->phrase("ExportToExcel") . '</button>';
        } elseif (SameText($type, "word")) {
            return '<button type="button" class="btn btn-default ew-export-link ew-word" title="' . HtmlEncode($Language->phrase("ExportToWord", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToWord", true)) . '" data-ew-action="export" data-export="word" data-custom="false" data-export-selected="false" data-url="' . $exportUrl . '">' . $Language->phrase("ExportToWord") . '</button>';
        } elseif (SameText($type, "pdf")) {
            return '<button type="button" class="btn btn-default ew-export-link ew-pdf" title="' . HtmlEncode($Language->phrase("ExportToPdf", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToPdf", true)) . '" data-ew-action="export" data-export="pdf" data-custom="false" data-export-selected="false" data-url="' . $exportUrl . '">' . $Language->phrase("ExportToPdf") . '</button>';
        } elseif (SameText($type, "html")) {
            return '<button type="button" class="btn btn-default ew-export-link ew-html" title="' . HtmlEncode($Language->phrase("ExportToHtml", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToHtml", true)) . '" data-ew-action="export" data-export="html" data-custom="false" data-export-selected="false" data-url="' . $exportUrl . '">' . $Language->phrase("ExportToHtml") . '</button>';
        } elseif (SameText($type, "email")) {
            return '<button type="button" class="btn btn-default ew-export-link ew-email" title="' . HtmlEncode($Language->phrase("ExportToEmail", true)) . '" data-caption="' . HtmlEncode($Language->phrase("ExportToEmail", true)) . '" data-ew-action="email" data-custom="false" data-export-selected="false" data-hdr="' . HtmlEncode($Language->phrase("ExportToEmail", true)) . '" data-url="' . $exportUrl . '">' . $Language->phrase("ExportToEmail") . '</button>';
        } elseif (SameText($type, "print")) {
            return "<a href=\"$exportUrl\" class=\"btn btn-default ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendly", true)) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
        }
    }

    // Set up export options
    protected function setupExportOptions()
    {
        global $Language, $Security;

        // Printer friendly
        $item = &$this->ExportOptions->add("print");
        $item->Body = $this->getExportTag("print");
        $item->Visible = false;

        // Export to Excel
        $item = &$this->ExportOptions->add("excel");
        $item->Body = $this->getExportTag("excel");
        $item->Visible = true;

        // Export to Word
        $item = &$this->ExportOptions->add("word");
        $item->Body = $this->getExportTag("word");
        $item->Visible = false;

        // Export to HTML
        $item = &$this->ExportOptions->add("html");
        $item->Body = $this->getExportTag("html");
        $item->Visible = false;

        // Export to PDF
        $item = &$this->ExportOptions->add("pdf");
        $item->Body = $this->getExportTag("pdf");
        $item->Visible = false;

        // Export to Email
        $item = &$this->ExportOptions->add("email");
        $item->Body = $this->getExportTag("email");
        $item->Visible = false;

        // Drop down button for export
        $this->ExportOptions->UseButtonGroup = true;
        $this->ExportOptions->UseDropDownButton = true;
        if ($this->ExportOptions->UseButtonGroup && IsMobile()) {
            $this->ExportOptions->UseDropDownButton = true;
        }
        $this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

        // Add group option item
        $item = &$this->ExportOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide options for export
        if ($this->isExport()) {
            $this->ExportOptions->hideAllOptions();
        }
        if (!$Security->canExport()) { // Export not allowed
            $this->ExportOptions->hideAllOptions();
        }
    }

    // Set up search options
    protected function setupSearchOptions()
    {
        global $Language, $Security;
        $pageUrl = $this->pageUrl(false);
        $this->SearchOptions = new ListOptions(TagClassName: "ew-search-option");

        // Search button
        $item = &$this->SearchOptions->add("searchtoggle");
        $searchToggleClass = ($this->SearchWhere != "") ? " active" : " active";
        $item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-ew-action=\"search-toggle\" data-form=\"fPerformanceReportsrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
        $item->Visible = true;

        // Show all button
        $item = &$this->SearchOptions->add("showall");
        if ($this->UseCustomTemplate || !$this->UseAjaxActions) {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        } else {
            $item->Body = "<a class=\"btn btn-default ew-show-all\" role=\"button\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" data-ew-action=\"refresh\" data-url=\"" . $pageUrl . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
        }
        $item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

        // Button group for search
        $this->SearchOptions->UseDropDownButton = false;
        $this->SearchOptions->UseButtonGroup = true;
        $this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

        // Add group option item
        $item = &$this->SearchOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;

        // Hide search options
        if ($this->isExport() || $this->CurrentAction && $this->CurrentAction != "search") {
            $this->SearchOptions->hideAllOptions();
        }
        if (!$Security->canSearch()) {
            $this->SearchOptions->hideAllOptions();
            $this->FilterOptions->hideAllOptions();
        }
    }

    // Check if any search fields
    public function hasSearchFields()
    {
        return $this->TaskName->Visible || $this->Description->Visible || $this->AssignedTo->Visible || $this->Progress->Visible || $this->Target->Visible || $this->Track->Visible || $this->PlanStart->Visible || $this->PlanEnd->Visible || $this->StartDate->Visible || $this->EndDate->Visible || $this->Priority->Visible || $this->Category->Visible || $this->_ProjectID->Visible || $this->Created_Date->Visible || $this->Created_By->Visible || $this->Last_Updated_Date->Visible || $this->Last_Updated_By->Visible;
    }

    // Render search options
    protected function renderSearchOptions()
    {
        if (!$this->hasSearchFields() && $this->SearchOptions["searchtoggle"]) {
            $this->SearchOptions["searchtoggle"]->Visible = false;
        }
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("masterprojectlist");
        $url = CurrentUrl();
        $url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset(all)
        $Breadcrumb->add("summary", $this->TableVar, $url, "", $this->TableVar, true);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_AssignedTo":
                    break;
                case "x_Priority":
                    break;
                case "x_Category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x__ProjectID":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Set up other options
    protected function setupOtherOptions()
    {
        global $Language, $Security;

        // Filter button
        $item = &$this->FilterOptions->add("savecurrentfilter");
        $item->Body = "<a class=\"ew-save-filter\" data-form=\"fPerformanceReportsrch\" data-ew-action=\"none\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
        $item->Visible = true;
        $item = &$this->FilterOptions->add("deletefilter");
        $item->Body = "<a class=\"ew-delete-filter\" data-form=\"fPerformanceReportsrch\" data-ew-action=\"none\">" . $Language->phrase("DeleteFilter") . "</a>";
        $item->Visible = true;
        $this->FilterOptions->UseDropDownButton = true;
        $this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
        $this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

        // Add group option item
        $item = &$this->FilterOptions->addGroupOption();
        $item->Body = "";
        $item->Visible = false;
    }

    // Set up starting group
    protected function setupStartGroup()
    {
        // Exit if no groups
        if ($this->DisplayGroups == 0) {
            return;
        }
        $startGrp = Param(Config("TABLE_START_GROUP"));
        $pageNo = Param(Config("TABLE_PAGE_NUMBER"));

        // Check for a 'start' parameter
        if ($startGrp !== null) {
            $this->StartGroup = $startGrp;
            $this->setStartGroup($this->StartGroup);
        } elseif ($pageNo !== null) {
            $pageNo = ParseInteger($pageNo);
            if (is_numeric($pageNo)) {
                $this->StartGroup = ($pageNo - 1) * $this->DisplayGroups + 1;
                if ($this->StartGroup <= 0) {
                    $this->StartGroup = 1;
                } elseif ($this->StartGroup >= intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1) {
                    $this->StartGroup = intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1;
                }
                $this->setStartGroup($this->StartGroup);
            } else {
                $this->StartGroup = $this->getStartGroup();
            }
        } else {
            $this->StartGroup = $this->getStartGroup();
        }

        // Check if correct start group counter
        if (!is_numeric($this->StartGroup) || intval($this->StartGroup) <= 0) { // Avoid invalid start group counter
            $this->StartGroup = 1; // Reset start group counter
            $this->setStartGroup($this->StartGroup);
        } elseif (intval($this->StartGroup) > intval($this->TotalGroups)) { // Avoid starting group > total groups
            $this->StartGroup = intval(($this->TotalGroups - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1; // Point to last page first group
            $this->setStartGroup($this->StartGroup);
        } elseif (($this->StartGroup - 1) % $this->DisplayGroups != 0) {
            $this->StartGroup = intval(($this->StartGroup - 1) / $this->DisplayGroups) * $this->DisplayGroups + 1; // Point to page boundary
            $this->setStartGroup($this->StartGroup);
        }
    }

    // Reset pager
    protected function resetPager()
    {
        // Reset start position (reset command)
        $this->StartGroup = 1;
        $this->setStartGroup($this->StartGroup);
    }

    // Set up number of groups displayed per page
    protected function setupDisplayGroups()
    {
        if (Param(Config("TABLE_GROUP_PER_PAGE")) !== null) {
            $wrk = Param(Config("TABLE_GROUP_PER_PAGE"));
            if (is_numeric($wrk)) {
                $this->DisplayGroups = intval($wrk);
            } else {
                if (SameText($wrk, "ALL")) { // Display all groups
                    $this->DisplayGroups = -1;
                } else {
                    $this->DisplayGroups = 3; // Non-numeric, load default
                }
            }
            $this->setGroupPerPage($this->DisplayGroups); // Save to session

            // Reset start position (reset command)
            $this->StartGroup = 1;
            $this->setStartGroup($this->StartGroup);
        } else {
            if ($this->getGroupPerPage() != "") {
                $this->DisplayGroups = $this->getGroupPerPage(); // Restore from session
            } else {
                $this->DisplayGroups = 3; // Load default
            }
        }
    }

    // Get sort parameters based on sort links clicked
    protected function getSort()
    {
        if ($this->DrillDown) {
            return "";
        }
        $resetSort = Param("cmd") === "resetsort";
        $orderBy = Param("order", "");
        $orderType = Param("ordertype", "");

        // Check for a resetsort command
        if ($resetSort) {
            $this->setOrderBy("");
            $this->setStartGroup(1);
            $this->TaskID->setSort("");
            $this->TaskName->setSort("");
            $this->AssignedTo->setSort("");
            $this->Progress->setSort("");
            $this->Target->setSort("");
            $this->Track->setSort("");
            $this->PlanStart->setSort("");
            $this->PlanEnd->setSort("");
            $this->StartDate->setSort("");
            $this->EndDate->setSort("");
            $this->Priority->setSort("");
            $this->Category->setSort("");
            $this->_ProjectID->setSort("");
            $this->Complete->setSort("");

        // Check for an Order parameter
        } elseif ($orderBy != "") {
            $this->CurrentOrder = $orderBy;
            $this->CurrentOrderType = $orderType;
            $this->updateSort($this->TaskID); // TaskID
            $this->updateSort($this->TaskName); // TaskName
            $this->updateSort($this->AssignedTo); // AssignedTo
            $this->updateSort($this->Progress); // Progress
            $this->updateSort($this->Target); // Target
            $this->updateSort($this->Track); // Track
            $this->updateSort($this->PlanStart); // PlanStart
            $this->updateSort($this->PlanEnd); // PlanEnd
            $this->updateSort($this->StartDate); // StartDate
            $this->updateSort($this->EndDate); // EndDate
            $this->updateSort($this->Priority); // Priority
            $this->updateSort($this->Category); // Category
            $this->updateSort($this->_ProjectID); // ProjectID
            $this->updateSort($this->Complete); // Complete
            $sortSql = $this->sortSql();
            $this->setOrderBy($sortSql);
            $this->setStartGroup(1);
        }
        return $this->getOrderBy();
    }

    // Return extended filter
    protected function getExtendedFilter()
    {
        $filter = "";
        if ($this->DrillDown) {
            return "";
        }
        $restoreSession = false;
        $restoreDefault = false;
        // Reset search command
        if (Get("cmd") == "reset") {
            // Set default values
            $this->TaskName->AdvancedSearch->unsetSession();
            $this->AssignedTo->AdvancedSearch->unsetSession();
            $this->Progress->AdvancedSearch->unsetSession();
            $this->Target->AdvancedSearch->unsetSession();
            $this->Track->AdvancedSearch->unsetSession();
            $this->PlanStart->AdvancedSearch->unsetSession();
            $this->PlanEnd->AdvancedSearch->unsetSession();
            $this->StartDate->AdvancedSearch->unsetSession();
            $this->EndDate->AdvancedSearch->unsetSession();
            $this->Priority->AdvancedSearch->unsetSession();
            $this->Category->AdvancedSearch->unsetSession();
            $this->_ProjectID->AdvancedSearch->unsetSession();
            $restoreDefault = true;
        } else {
            $restoreSession = !$this->SearchCommand;

            // Field TaskName
            $this->getDropDownValue($this->TaskName);

            // Field AssignedTo
            $this->getDropDownValue($this->AssignedTo);

            // Field Progress
            $this->getDropDownValue($this->Progress);

            // Field Target
            $this->getDropDownValue($this->Target);

            // Field Track
            $this->getDropDownValue($this->Track);

            // Field PlanStart
            $this->getDropDownValue($this->PlanStart);

            // Field PlanEnd
            if ($this->PlanEnd->AdvancedSearch->get()) {
            }

            // Field StartDate
            $this->getDropDownValue($this->StartDate);

            // Field EndDate
            if ($this->EndDate->AdvancedSearch->get()) {
            }

            // Field Priority
            $this->getDropDownValue($this->Priority);

            // Field Category
            $this->getDropDownValue($this->Category);

            // Field ProjectID
            $this->getDropDownValue($this->_ProjectID);
            if (!$this->validateForm()) {
                return $filter;
            }
        }

        // Restore session
        if ($restoreSession) {
            $restoreDefault = true;
            if ($this->TaskName->AdvancedSearch->issetSession()) { // Field TaskName
                $this->TaskName->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->AssignedTo->AdvancedSearch->issetSession()) { // Field AssignedTo
                $this->AssignedTo->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->Progress->AdvancedSearch->issetSession()) { // Field Progress
                $this->Progress->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->Target->AdvancedSearch->issetSession()) { // Field Target
                $this->Target->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->Track->AdvancedSearch->issetSession()) { // Field Track
                $this->Track->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->PlanStart->AdvancedSearch->issetSession()) { // Field PlanStart
                $this->PlanStart->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->PlanEnd->AdvancedSearch->issetSession()) { // Field PlanEnd
                $this->PlanEnd->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->StartDate->AdvancedSearch->issetSession()) { // Field StartDate
                $this->StartDate->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->EndDate->AdvancedSearch->issetSession()) { // Field EndDate
                $this->EndDate->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->Priority->AdvancedSearch->issetSession()) { // Field Priority
                $this->Priority->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->Category->AdvancedSearch->issetSession()) { // Field Category
                $this->Category->AdvancedSearch->load();
                $restoreDefault = false;
            }
            if ($this->_ProjectID->AdvancedSearch->issetSession()) { // Field ProjectID
                $this->_ProjectID->AdvancedSearch->load();
                $restoreDefault = false;
            }
        }

        // Restore default
        if ($restoreDefault) {
            $this->loadDefaultFilters();
        }

        // Call page filter validated event
        $this->pageFilterValidated();

        // Build SQL and save to session
        $this->buildDropDownFilter($this->TaskName, $filter, false, true); // Field TaskName
        $this->TaskName->AdvancedSearch->save();
        $this->buildDropDownFilter($this->AssignedTo, $filter, false, true); // Field AssignedTo
        $this->AssignedTo->AdvancedSearch->save();
        $this->buildDropDownFilter($this->Progress, $filter, false, true); // Field Progress
        $this->Progress->AdvancedSearch->save();
        $this->buildDropDownFilter($this->Target, $filter, false, true); // Field Target
        $this->Target->AdvancedSearch->save();
        $this->buildDropDownFilter($this->Track, $filter, false, true); // Field Track
        $this->Track->AdvancedSearch->save();
        $this->buildDropDownFilter($this->PlanStart, $filter, false, true); // Field PlanStart
        $this->PlanStart->AdvancedSearch->save();
        $this->buildExtendedFilter($this->PlanEnd, $filter, false, true); // Field PlanEnd
        $this->PlanEnd->AdvancedSearch->save();
        $this->buildDropDownFilter($this->StartDate, $filter, false, true); // Field StartDate
        $this->StartDate->AdvancedSearch->save();
        $this->buildExtendedFilter($this->EndDate, $filter, false, true); // Field EndDate
        $this->EndDate->AdvancedSearch->save();
        $this->buildDropDownFilter($this->Priority, $filter, false, true); // Field Priority
        $this->Priority->AdvancedSearch->save();
        $this->buildDropDownFilter($this->Category, $filter, false, true); // Field Category
        $this->Category->AdvancedSearch->save();
        $this->buildDropDownFilter($this->_ProjectID, $filter, false, true); // Field ProjectID
        $this->_ProjectID->AdvancedSearch->save();
        return $filter;
    }

    // Build dropdown filter
    protected function buildDropDownFilter(&$fld, &$filterClause, $default = false, $saveFilter = false)
    {
        $fldVal = $default ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
        $fldOpr = $default ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
        $fldVal2 = $default ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
        if (!EmptyValue($fld->DateFilter)) {
            $fldVal2 = "";
        } elseif ($fld->UseFilter) {
            $fldOpr = "";
            $fldVal2 = "";
        }
        $sql = "";
        if (is_array($fldVal)) {
            foreach ($fldVal as $val) {
                $wrk = DropDownFilter($fld, $val, $fldOpr, $this->Dbid);

                // Call Page Filtering event
                if (StartsString("@@", $val)) {
                    $this->pageFiltering($fld, $wrk, "custom", substr($val, 2));
                } else {
                    $this->pageFiltering($fld, $wrk, "dropdown", $fldOpr, $val);
                }
                AddFilter($sql, $wrk, "OR");
            }
        } else {
            $sql = DropDownFilter($fld, $fldVal, $fldOpr, $this->Dbid, $fldVal2);

            // Call Page Filtering event
            if (StartsString("@@", $fldVal)) {
                $this->pageFiltering($fld, $sql, "custom", substr($fldVal, 2));
            } else {
                $this->pageFiltering($fld, $sql, "dropdown", $fldOpr, $fldVal, "", "", $fldVal2);
            }
        }
        if ($sql != "") {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
            AddFilter($filterClause, $sql, $cond);
            if ($saveFilter) {
                $fld->CurrentFilter = $sql;
            }
        }
    }

    // Build extended filter
    protected function buildExtendedFilter(&$fld, &$filterClause, $default = false, $saveFilter = false)
    {
        $wrk = GetReportFilter($fld, $default, $this->Dbid);
        if (!$default) {
            $this->pageFiltering($fld, $wrk, "extended", $fld->AdvancedSearch->SearchOperator, $fld->AdvancedSearch->SearchValue, $fld->AdvancedSearch->SearchCondition, $fld->AdvancedSearch->SearchOperator2, $fld->AdvancedSearch->SearchValue2);
        }
        if ($wrk != "") {
            $cond = SameText($this->SearchOption, "OR") ? "OR" : "AND";
            AddFilter($filterClause, $wrk, $cond);
            if ($saveFilter) {
                $fld->CurrentFilter = $wrk;
            }
        }
    }

    // Get drop down value from querystring
    protected function getDropDownValue(&$fld)
    {
        if (IsPost()) {
            return false; // Skip post back
        }
        $res = false;
        $parm = $fld->Param;
        $opr = Get("z_$parm");
        if ($opr !== null) {
            $fld->AdvancedSearch->SearchOperator = $opr;
        }
        $val = Get("x_$parm");
        if ($val !== null) {
            if (is_array($val)) {
                $val = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $val);
            }
            $fld->AdvancedSearch->setSearchValue($val);
            $res = true;
        }
        $val2 = Get("y_$parm");
        if ($val2 !== null) {
            if (is_array($val2)) {
                $val2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $val2);
            }
            $fld->AdvancedSearch->setSearchValue2($val2);
            $res = true;
        }
        return $res;
    }

    // Dropdown filter exist
    protected function dropDownFilterExist(&$fld)
    {
        $wrk = "";
        $this->buildDropDownFilter($fld, $wrk);
        return ($wrk != "");
    }

    // Extended filter exist
    protected function extendedFilterExist(&$fld)
    {
        $extWrk = "";
        $this->buildExtendedFilter($fld, $extWrk);
        return ($extWrk != "");
    }

    // Validate form
    protected function validateForm()
    {
        global $Language;

        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }

        // Return validate result
        $validateForm = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateForm = $validateForm && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateForm;
    }

    // Load default value for filters
    protected function loadDefaultFilters()
    {
        // Field PlanEnd
        $this->PlanEnd->AdvancedSearch->loadDefault();

        // Field EndDate
        $this->EndDate->AdvancedSearch->loadDefault();
    }

    // Show list of filters
    public function showFilterList()
    {
        global $Language;

        // Initialize
        $filterList = "";
        $captionClass = $this->isExport("email") ? "ew-filter-caption-email" : "ew-filter-caption";
        $captionSuffix = $this->isExport("email") ? ": " : "";

        // Field PlanEnd
        $extWrk = "";
        $this->buildExtendedFilter($this->PlanEnd, $extWrk);
        $filter = "";
        if ($extWrk != "") {
            $filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->PlanEnd->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Field EndDate
        $extWrk = "";
        $this->buildExtendedFilter($this->EndDate, $extWrk);
        $filter = "";
        if ($extWrk != "") {
            $filter .= "<span class=\"ew-filter-value\">$extWrk</span>";
        }
        if ($filter != "") {
            $filterList .= "<div><span class=\"" . $captionClass . "\">" . $this->EndDate->caption() . "</span>" . $captionSuffix . $filter . "</div>";
        }

        // Show Filters
        if ($filterList != "") {
            $message = "<div id=\"ew-filter-list\" class=\"callout callout-info d-table\"><div id=\"ew-current-filters\">" .
                $Language->phrase("CurrentFilters") . "</div>" . $filterList . "</div>";
            $this->messageShowing($message, "");
            Write($message);
        } else { // Output empty tag
            Write("<div id=\"ew-filter-list\"></div>");
        }
    }

    // Get list of filters
    public function getFilterList()
    {
        // Initialize
        $filterList = "";
        $savedFilterList = "";

        // Field PlanEnd
        $wrk = "";
        if ($this->PlanEnd->AdvancedSearch->SearchValue != "" || $this->PlanEnd->AdvancedSearch->SearchValue2 != "") {
            $wrk = "\"x_PlanEnd\":\"" . JsEncode($this->PlanEnd->AdvancedSearch->SearchValue) . "\"," .
                "\"z_PlanEnd\":\"" . JsEncode($this->PlanEnd->AdvancedSearch->SearchOperator) . "\"," .
                "\"v_PlanEnd\":\"" . JsEncode($this->PlanEnd->AdvancedSearch->SearchCondition) . "\"," .
                "\"y_PlanEnd\":\"" . JsEncode($this->PlanEnd->AdvancedSearch->SearchValue2) . "\"," .
                "\"w_PlanEnd\":\"" . JsEncode($this->PlanEnd->AdvancedSearch->SearchOperator2) . "\"";
        }
        if ($wrk != "") {
            if ($filterList != "") {
                $filterList .= ",";
            }
            $filterList .= $wrk;
        }

        // Field EndDate
        $wrk = "";
        if ($this->EndDate->AdvancedSearch->SearchValue != "" || $this->EndDate->AdvancedSearch->SearchValue2 != "") {
            $wrk = "\"x_EndDate\":\"" . JsEncode($this->EndDate->AdvancedSearch->SearchValue) . "\"," .
                "\"z_EndDate\":\"" . JsEncode($this->EndDate->AdvancedSearch->SearchOperator) . "\"," .
                "\"v_EndDate\":\"" . JsEncode($this->EndDate->AdvancedSearch->SearchCondition) . "\"," .
                "\"y_EndDate\":\"" . JsEncode($this->EndDate->AdvancedSearch->SearchValue2) . "\"," .
                "\"w_EndDate\":\"" . JsEncode($this->EndDate->AdvancedSearch->SearchOperator2) . "\"";
        }
        if ($wrk != "") {
            if ($filterList != "") {
                $filterList .= ",";
            }
            $filterList .= $wrk;
        }

        // Return filter list in json
        if ($filterList != "") {
            $filterList = "\"data\":{" . $filterList . "}";
        }
        if ($savedFilterList != "") {
            $filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
        }
        return ($filterList != "") ? "{" . $filterList . "}" : "null";
    }

    // Restore list of filters
    protected function restoreFilterList()
    {
        // Return if not reset filter
        if (Post("cmd", "") != "resetfilter") {
            return false;
        }
        $filter = json_decode(Post("filter", ""), true);
        return $this->setupFilterList($filter);
    }

    // Setup list of filters
    protected function setupFilterList($filter)
    {
        if (!is_array($filter)) {
            return false;
        }

        // Field PlanEnd
        if (!$this->PlanEnd->AdvancedSearch->get($filter)) {
            $this->PlanEnd->AdvancedSearch->loadDefault(); // Clear filter
        }
        $this->PlanEnd->AdvancedSearch->save();

        // Field EndDate
        if (!$this->EndDate->AdvancedSearch->get($filter)) {
            $this->EndDate->AdvancedSearch->loadDefault(); // Clear filter
        }
        $this->EndDate->AdvancedSearch->save();
        return true;
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Page Selecting event
    public function pageSelecting(&$filter)
    {
        // Enter your code here
     if (in_array(CurrentUserLevel(), array("4", "5", "6","7","8","9","10"))) {
            $currentUser = CurrentUserName(); // Ambil nama pengguna saat ini
            // Pastikan untuk meng-escape string nama pengguna untuk keamanan
            $currentUser = addslashes($currentUser);

            // Perbarui filter dengan query yang benar
             $existsClause = "EXISTS (
                    SELECT 1 FROM  masteruser WHERE masteruser.Active=1 AND masteruser.Employee=1
                    AND masteruser.EmployeeID=AssignedTo
                )";
            if (strlen($filter) == 0) {
                $filter = $existsClause;
            } else {
                $filter .= ' AND ' . $existsClause;
            }
        }
    }

    // Load Filters event
    public function pageFilterLoad()
    {
        // Enter your code here
        // Example: Register/Unregister Custom Extended Filter
        //RegisterFilter($this-><Field>, 'StartsWithA', 'Starts With A', 'GetStartsWithAFilter'); // With function, or
        //RegisterFilter($this-><Field>, 'StartsWithA', 'Starts With A'); // No function, use Page_Filtering event
        //UnregisterFilter($this-><Field>, 'StartsWithA');
    }

    // Page Filter Validated event
    public function pageFilterValidated()
    {
        // Example:
        //$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value
    }

    // Page Filtering event
    public function pageFiltering(&$fld, &$filter, $typ, $opr = "", $val = "", $cond = "", $opr2 = "", $val2 = "")
    {
        // Note: ALWAYS CHECK THE FILTER TYPE ($typ)! Example:
        //if ($typ == "dropdown" && $fld->Name == "MyField") // Dropdown filter
        //    $filter = "..."; // Modify the filter
        //if ($typ == "extended" && $fld->Name == "MyField") // Extended filter
        //    $filter = "..."; // Modify the filter
        //if ($typ == "custom" && $opr == "..." && $fld->Name == "MyField") // Custom filter, $opr is the custom filter ID
        //    $filter = "..."; // Modify the filter
    }

    // Cell Rendered event
    public function cellRendered(&$Field, $CurrentValue, &$ViewValue, &$ViewAttrs, &$CellAttrs, &$HrefValue, &$LinkAttrs)
    {
        //$ViewValue = "xxx";
        //$ViewAttrs["class"] = "xxx";
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
