<?php

namespace ProjectManagement\prjProjectManagement;

use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Connection;
use Doctrine\DBAL\Query\QueryBuilder;
use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Container\ContainerInterface;
use Slim\Routing\RouteCollectorProxy;
use Slim\App;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use Closure;

/**
 * Page class
 */
class ProjecttaskSearch extends Projecttask
{
    use MessagesTrait;

    // Page ID
    public $PageID = "search";

    // Project ID
    public $ProjectID = PROJECT_ID;

    // Page object name
    public $PageObjName = "ProjecttaskSearch";

    // View file path
    public $View = null;

    // Title
    public $Title = null; // Title for <title> tag

    // Rendering View
    public $RenderingView = false;

    // CSS class/style
    public $CurrentPageName = "projecttasksearch";

    // Page headings
    public $Heading = "";
    public $Subheading = "";
    public $PageHeader;
    public $PageFooter;

    // Page layout
    public $UseLayout = true;

    // Page terminated
    private $terminated = false;

    // Page heading
    public function pageHeading()
    {
        global $Language;
        if ($this->Heading != "") {
            return $this->Heading;
        }
        if (method_exists($this, "tableCaption")) {
            return $this->tableCaption();
        }
        return "";
    }

    // Page subheading
    public function pageSubheading()
    {
        global $Language;
        if ($this->Subheading != "") {
            return $this->Subheading;
        }
        if ($this->TableName) {
            return $Language->phrase($this->PageID);
        }
        return "";
    }

    // Page name
    public function pageName()
    {
        return CurrentPageName();
    }

    // Page URL
    public function pageUrl($withArgs = true)
    {
        $route = GetRoute();
        $args = RemoveXss($route->getArguments());
        if (!$withArgs) {
            foreach ($args as $key => &$val) {
                $val = "";
            }
            unset($val);
        }
        return rtrim(UrlFor($route->getName(), $args), "/") . "?";
    }

    // Show Page Header
    public function showPageHeader()
    {
        $header = $this->PageHeader;
        $this->pageDataRendering($header);
        if ($header != "") { // Header exists, display
            echo '<div id="ew-page-header">' . $header . '</div>';
        }
    }

    // Show Page Footer
    public function showPageFooter()
    {
        $footer = $this->PageFooter;
        $this->pageDataRendered($footer);
        if ($footer != "") { // Footer exists, display
            echo '<div id="ew-page-footer">' . $footer . '</div>';
        }
    }

    // Set field visibility
    public function setVisibility()
    {
        $this->TaskID->setVisibility();
        $this->TaskName->setVisibility();
        $this->Description->setVisibility();
        $this->AssignedTo->setVisibility();
        $this->Progress->setVisibility();
        $this->Complete->setVisibility();
        $this->Target->setVisibility();
        $this->Track->setVisibility();
        $this->PlanStart->setVisibility();
        $this->PlanEnd->setVisibility();
        $this->StartDate->setVisibility();
        $this->EndDate->setVisibility();
        $this->Priority->setVisibility();
        $this->Category->setVisibility();
        $this->_ProjectID->setVisibility();
        $this->Created_Date->setVisibility();
        $this->Created_By->setVisibility();
        $this->Last_Updated_Date->setVisibility();
        $this->Last_Updated_By->setVisibility();
    }

    // Constructor
    public function __construct()
    {
        parent::__construct();
        global $Language, $DashboardReport, $DebugTimer, $UserTable;
        $this->TableVar = 'projecttask';
        $this->TableName = 'projecttask';

        // Table CSS class
        $this->TableClass = "table table-striped table-bordered table-hover table-sm ew-desktop-table ew-search-table";

        // Initialize
        $GLOBALS["Page"] = &$this;

        // Language object
        $Language = Container("app.language");

        // Table object (projecttask)
        if (!isset($GLOBALS["projecttask"]) || $GLOBALS["projecttask"]::class == PROJECT_NAMESPACE . "projecttask") {
            $GLOBALS["projecttask"] = &$this;
        }

        // Table name (for backward compatibility only)
        if (!defined(PROJECT_NAMESPACE . "TABLE_NAME")) {
            define(PROJECT_NAMESPACE . "TABLE_NAME", 'projecttask');
        }

        // Start timer
        $DebugTimer = Container("debug.timer");

        // Debug message
        LoadDebugMessage();

        // Open connection
        $GLOBALS["Conn"] ??= $this->getConnection();

        // User table object
        $UserTable = Container("usertable");
    }

    // Get content from stream
    public function getContents(): string
    {
        global $Response;
        return $Response?->getBody() ?? ob_get_clean();
    }

    // Is lookup
    public function isLookup()
    {
        return SameText(Route(0), Config("API_LOOKUP_ACTION"));
    }

    // Is AutoFill
    public function isAutoFill()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autofill");
    }

    // Is AutoSuggest
    public function isAutoSuggest()
    {
        return $this->isLookup() && SameText(Post("ajax"), "autosuggest");
    }

    // Is modal lookup
    public function isModalLookup()
    {
        return $this->isLookup() && SameText(Post("ajax"), "modal");
    }

    // Is terminated
    public function isTerminated()
    {
        return $this->terminated;
    }

    /**
     * Terminate page
     *
     * @param string $url URL for direction
     * @return void
     */
    public function terminate($url = "")
    {
        if ($this->terminated) {
            return;
        }
        global $TempImages, $DashboardReport, $Response;

        // Page is terminated
        $this->terminated = true;

        // Page Unload event
        if (method_exists($this, "pageUnload")) {
            $this->pageUnload();
        }
        DispatchEvent(new PageUnloadedEvent($this), PageUnloadedEvent::NAME);
        if (!IsApi() && method_exists($this, "pageRedirecting")) {
            $this->pageRedirecting($url);
        }

        // Close connection
        CloseConnections();

        // Return for API
        if (IsApi()) {
            $res = $url === true;
            if (!$res) { // Show response for API
                $ar = array_merge($this->getMessages(), $url ? ["url" => GetUrl($url)] : []);
                WriteJson($ar);
            }
            $this->clearMessages(); // Clear messages for API request
            return;
        } else { // Check if response is JSON
            if (WithJsonResponse()) { // With JSON response
                $this->clearMessages();
                return;
            }
        }

        // Go to URL if specified
        if ($url != "") {
            if (!Config("DEBUG") && ob_get_length()) {
                ob_end_clean();
            }

            // Handle modal response
            if ($this->IsModal) { // Show as modal
                $pageName = GetPageName($url);
                $result = ["url" => GetUrl($url), "modal" => "1"];  // Assume return to modal for simplicity
                if (!SameString($pageName, GetPageName($this->getListUrl()))) { // Not List page
                    $result["caption"] = $this->getModalCaption($pageName);
                    $result["view"] = SameString($pageName, "projecttaskview"); // If View page, no primary button
                } else { // List page
                    $result["error"] = $this->getFailureMessage(); // List page should not be shown as modal => error
                    $this->clearFailureMessage();
                }
                WriteJson($result);
            } else {
                SaveDebugMessage();
                Redirect(GetUrl($url));
            }
        }
        return; // Return to controller
    }

    // Get records from result set
    protected function getRecordsFromRecordset($rs, $current = false)
    {
        $rows = [];
        if (is_object($rs)) { // Result set
            while ($row = $rs->fetch()) {
                $this->loadRowValues($row); // Set up DbValue/CurrentValue
                $row = $this->getRecordFromArray($row);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        } elseif (is_array($rs)) {
            foreach ($rs as $ar) {
                $row = $this->getRecordFromArray($ar);
                if ($current) {
                    return $row;
                } else {
                    $rows[] = $row;
                }
            }
        }
        return $rows;
    }

    // Get record from array
    protected function getRecordFromArray($ar)
    {
        $row = [];
        if (is_array($ar)) {
            foreach ($ar as $fldname => $val) {
                if (array_key_exists($fldname, $this->Fields) && ($this->Fields[$fldname]->Visible || $this->Fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
                    $fld = &$this->Fields[$fldname];
                    if ($fld->HtmlTag == "FILE") { // Upload field
                        if (EmptyValue($val)) {
                            $row[$fldname] = null;
                        } else {
                            if ($fld->DataType == DataType::BLOB) {
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))));
                                $row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
                            } elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
                                $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                    "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $val)));
                                $row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
                            } else { // Multiple files
                                $files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
                                $ar = [];
                                foreach ($files as $file) {
                                    $url = FullUrl(GetApiUrl(Config("API_FILE_ACTION") .
                                        "/" . $fld->TableVar . "/" . Encrypt($fld->physicalUploadPath() . $file)));
                                    if (!EmptyValue($file)) {
                                        $ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
                                    }
                                }
                                $row[$fldname] = $ar;
                            }
                        }
                    } else {
                        $row[$fldname] = $val;
                    }
                }
            }
        }
        return $row;
    }

    // Get record key value from array
    protected function getRecordKeyValue($ar)
    {
        $key = "";
        if (is_array($ar)) {
            $key .= @$ar['TaskID'];
        }
        return $key;
    }

    /**
     * Hide fields for add/edit
     *
     * @return void
     */
    protected function hideFieldsForAddEdit()
    {
        if ($this->isAdd() || $this->isCopy() || $this->isGridAdd()) {
            $this->TaskID->Visible = false;
        }
    }

    // Lookup data
    public function lookup(array $req = [], bool $response = true)
    {
        global $Language, $Security;

        // Get lookup object
        $fieldName = $req["field"] ?? null;
        if (!$fieldName) {
            return [];
        }
        $fld = $this->Fields[$fieldName];
        $lookup = $fld->Lookup;
        $name = $req["name"] ?? "";
        if (ContainsString($name, "query_builder_rule")) {
            $lookup->FilterFields = []; // Skip parent fields if any
        }

        // Get lookup parameters
        $lookupType = $req["ajax"] ?? "unknown";
        $pageSize = -1;
        $offset = -1;
        $searchValue = "";
        if (SameText($lookupType, "modal") || SameText($lookupType, "filter")) {
            $searchValue = $req["q"] ?? $req["sv"] ?? "";
            $pageSize = $req["n"] ?? $req["recperpage"] ?? 10;
        } elseif (SameText($lookupType, "autosuggest")) {
            $searchValue = $req["q"] ?? "";
            $pageSize = $req["n"] ?? -1;
            $pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
            if ($pageSize <= 0) {
                $pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
            }
        }
        $start = $req["start"] ?? -1;
        $start = is_numeric($start) ? (int)$start : -1;
        $page = $req["page"] ?? -1;
        $page = is_numeric($page) ? (int)$page : -1;
        $offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
        $userSelect = Decrypt($req["s"] ?? "");
        $userFilter = Decrypt($req["f"] ?? "");
        $userOrderBy = Decrypt($req["o"] ?? "");
        $keys = $req["keys"] ?? null;
        $lookup->LookupType = $lookupType; // Lookup type
        $lookup->FilterValues = []; // Clear filter values first
        if ($keys !== null) { // Selected records from modal
            if (is_array($keys)) {
                $keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
            }
            $lookup->FilterFields = []; // Skip parent fields if any
            $lookup->FilterValues[] = $keys; // Lookup values
            $pageSize = -1; // Show all records
        } else { // Lookup values
            $lookup->FilterValues[] = $req["v0"] ?? $req["lookupValue"] ?? "";
        }
        $cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
        for ($i = 1; $i <= $cnt; $i++) {
            $lookup->FilterValues[] = $req["v" . $i] ?? "";
        }
        $lookup->SearchValue = $searchValue;
        $lookup->PageSize = $pageSize;
        $lookup->Offset = $offset;
        if ($userSelect != "") {
            $lookup->UserSelect = $userSelect;
        }
        if ($userFilter != "") {
            $lookup->UserFilter = $userFilter;
        }
        if ($userOrderBy != "") {
            $lookup->UserOrderBy = $userOrderBy;
        }
        return $lookup->toJson($this, $response); // Use settings from current page
    }
    public $FormClassName = "ew-form ew-search-form";
    public $IsModal = false;
    public $IsMobileOrModal = false;

    /**
     * Page run
     *
     * @return void
     */
    public function run()
    {
        global $ExportType, $Language, $Security, $CurrentForm, $SkipHeaderFooter;

        // Is modal
        $this->IsModal = ConvertToBool(Param("modal"));
        $this->UseLayout = $this->UseLayout && !$this->IsModal;

        // Use layout
        $this->UseLayout = $this->UseLayout && ConvertToBool(Param(Config("PAGE_LAYOUT"), true));

        // View
        $this->View = Get(Config("VIEW"));

        // Load user profile
        if (IsLoggedIn()) {
            Profile()->setUserName(CurrentUserName())->loadFromStorage();
        }

        // Create form object
        $CurrentForm = new HttpForm();
        $this->CurrentAction = Param("action"); // Set up current action
        $this->setVisibility();

        // Set lookup cache
        if (!in_array($this->PageID, Config("LOOKUP_CACHE_PAGE_IDS"))) {
            $this->setUseLookupCache(false);
        }

        // Global Page Loading event (in userfn*.php)
        DispatchEvent(new PageLoadingEvent($this), PageLoadingEvent::NAME);

        // Page Load event
        if (method_exists($this, "pageLoad")) {
            $this->pageLoad();
        }

        // Hide fields for add/edit
        if (!$this->UseAjaxActions) {
            $this->hideFieldsForAddEdit();
        }
        // Use inline delete
        if ($this->UseAjaxActions) {
            $this->InlineDelete = true;
        }

        // Set up lookup cache
        $this->setupLookupOptions($this->AssignedTo);
        $this->setupLookupOptions($this->Priority);
        $this->setupLookupOptions($this->Category);
        $this->setupLookupOptions($this->_ProjectID);

        // Set up Breadcrumb
        $this->setupBreadcrumb();

        // Check modal
        if ($this->IsModal) {
            $SkipHeaderFooter = true;
        }
        $this->IsMobileOrModal = IsMobile() || $this->IsModal;

        // Get action
        $this->CurrentAction = Post("action");
        if ($this->isSearch()) {
            // Build search string for advanced search, remove blank field
            $this->loadSearchValues(); // Get search values
            $srchStr = $this->validateSearch() ? $this->buildAdvancedSearch() : "";
            if ($srchStr != "") {
                $srchStr = "projecttasklist" . "?" . $srchStr;
                // Do not return Json for UseAjaxActions
                if ($this->IsModal && $this->UseAjaxActions) {
                    $this->IsModal = false;
                }
                $this->terminate($srchStr); // Go to list page
                return;
            }
        }

        // Restore search settings from Session
        if (!$this->hasInvalidFields()) {
            $this->loadAdvancedSearch();
        }

        // Render row for search
        $this->RowType = RowType::SEARCH;
        $this->resetAttributes();
        $this->renderRow();

        // Set LoginStatus / Page_Rendering / Page_Render
        if (!IsApi() && !$this->isTerminated()) {
            // Setup login status
            SetupLoginStatus();

            // Pass login status to client side
            SetClientVar("login", LoginStatus());

            // Global Page Rendering event (in userfn*.php)
            DispatchEvent(new PageRenderingEvent($this), PageRenderingEvent::NAME);

            // Page Render event
            if (method_exists($this, "pageRender")) {
                $this->pageRender();
            }

            // Render search option
            if (method_exists($this, "renderSearchOptions")) {
                $this->renderSearchOptions();
            }
        }
    }

    // Build advanced search
    protected function buildAdvancedSearch()
    {
        $srchUrl = "";
        $this->buildSearchUrl($srchUrl, $this->TaskID); // TaskID
        $this->buildSearchUrl($srchUrl, $this->TaskName); // TaskName
        $this->buildSearchUrl($srchUrl, $this->Description); // Description
        $this->buildSearchUrl($srchUrl, $this->AssignedTo); // AssignedTo
        $this->buildSearchUrl($srchUrl, $this->Progress); // Progress
        $this->buildSearchUrl($srchUrl, $this->Complete); // Complete
        $this->buildSearchUrl($srchUrl, $this->Target); // Target
        $this->buildSearchUrl($srchUrl, $this->Track); // Track
        $this->buildSearchUrl($srchUrl, $this->PlanStart); // PlanStart
        $this->buildSearchUrl($srchUrl, $this->PlanEnd); // PlanEnd
        $this->buildSearchUrl($srchUrl, $this->StartDate); // StartDate
        $this->buildSearchUrl($srchUrl, $this->EndDate); // EndDate
        $this->buildSearchUrl($srchUrl, $this->Priority); // Priority
        $this->buildSearchUrl($srchUrl, $this->Category); // Category
        $this->buildSearchUrl($srchUrl, $this->_ProjectID); // ProjectID
        $this->buildSearchUrl($srchUrl, $this->Created_Date); // Created_Date
        $this->buildSearchUrl($srchUrl, $this->Created_By); // Created_By
        $this->buildSearchUrl($srchUrl, $this->Last_Updated_Date); // Last_Updated_Date
        $this->buildSearchUrl($srchUrl, $this->Last_Updated_By); // Last_Updated_By
        if ($srchUrl != "") {
            $srchUrl .= "&";
        }
        $srchUrl .= "cmd=search";
        return $srchUrl;
    }

    // Build search URL
    protected function buildSearchUrl(&$url, $fld, $oprOnly = false)
    {
        global $CurrentForm;
        $wrk = "";
        $fldParm = $fld->Param;
        [
            "value" => $fldVal,
            "operator" => $fldOpr,
            "condition" => $fldCond,
            "value2" => $fldVal2,
            "operator2" => $fldOpr2
        ] = $CurrentForm->getSearchValues($fldParm);
        if (is_array($fldVal)) {
            $fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
        }
        if (is_array($fldVal2)) {
            $fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
        }
        $fldDataType = $fld->DataType;
        $value = ConvertSearchValue($fldVal, $fldOpr, $fld); // For testing if numeric only
        $value2 = ConvertSearchValue($fldVal2, $fldOpr2, $fld); // For testing if numeric only
        $fldOpr = ConvertSearchOperator($fldOpr, $fld, $value);
        $fldOpr2 = ConvertSearchOperator($fldOpr2, $fld, $value2);
        if (in_array($fldOpr, ["BETWEEN", "NOT BETWEEN"])) {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld) && IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&y_" . $fldParm . "=" . urlencode($fldVal2) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            }
        } else {
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value, $fldOpr, $fld);
            if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr)) {
                $wrk = "x_" . $fldParm . "=" . urlencode($fldVal) . "&z_" . $fldParm . "=" . urlencode($fldOpr);
            } elseif (in_array($fldOpr, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr))) {
                $wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
            }
            $isValidValue = $fldDataType != DataType::NUMBER || $fld->VirtualSearch || IsNumericSearchValue($value2, $fldOpr2, $fld);
            if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2)) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) . "&w_" . $fldParm . "=" . urlencode($fldOpr2);
            } elseif (in_array($fldOpr2, ["IS NULL", "IS NOT NULL", "IS EMPTY", "IS NOT EMPTY"]) || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2))) {
                if ($wrk != "") {
                    $wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
                }
                $wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
            }
        }
        if ($wrk != "") {
            if ($url != "") {
                $url .= "&";
            }
            $url .= $wrk;
        }
    }

    // Load search values for validation
    protected function loadSearchValues()
    {
        // Load search values
        $hasValue = false;

        // TaskID
        if ($this->TaskID->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // TaskName
        if ($this->TaskName->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Description
        if ($this->Description->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // AssignedTo
        if ($this->AssignedTo->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Progress
        if ($this->Progress->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Complete
        if ($this->Complete->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Target
        if ($this->Target->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Track
        if ($this->Track->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // PlanStart
        if ($this->PlanStart->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // PlanEnd
        if ($this->PlanEnd->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // StartDate
        if ($this->StartDate->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // EndDate
        if ($this->EndDate->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Priority
        if ($this->Priority->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Category
        if ($this->Category->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // ProjectID
        if ($this->_ProjectID->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Created_Date
        if ($this->Created_Date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Created_By
        if ($this->Created_By->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Last_Updated_Date
        if ($this->Last_Updated_Date->AdvancedSearch->get()) {
            $hasValue = true;
        }

        // Last_Updated_By
        if ($this->Last_Updated_By->AdvancedSearch->get()) {
            $hasValue = true;
        }
        return $hasValue;
    }

    // Render row values based on field settings
    public function renderRow()
    {
        global $Security, $Language, $CurrentLanguage;

        // Initialize URLs

        // Call Row_Rendering event
        $this->rowRendering();

        // Common render codes for all row types

        // TaskID
        $this->TaskID->RowCssClass = "row";

        // TaskName
        $this->TaskName->RowCssClass = "row";

        // Description
        $this->Description->RowCssClass = "row";

        // AssignedTo
        $this->AssignedTo->RowCssClass = "row";

        // Progress
        $this->Progress->RowCssClass = "row";

        // Complete
        $this->Complete->RowCssClass = "row";

        // Target
        $this->Target->RowCssClass = "row";

        // Track
        $this->Track->RowCssClass = "row";

        // PlanStart
        $this->PlanStart->RowCssClass = "row";

        // PlanEnd
        $this->PlanEnd->RowCssClass = "row";

        // StartDate
        $this->StartDate->RowCssClass = "row";

        // EndDate
        $this->EndDate->RowCssClass = "row";

        // Priority
        $this->Priority->RowCssClass = "row";

        // Category
        $this->Category->RowCssClass = "row";

        // ProjectID
        $this->_ProjectID->RowCssClass = "row";

        // Created_Date
        $this->Created_Date->RowCssClass = "row";

        // Created_By
        $this->Created_By->RowCssClass = "row";

        // Last_Updated_Date
        $this->Last_Updated_Date->RowCssClass = "row";

        // Last_Updated_By
        $this->Last_Updated_By->RowCssClass = "row";

        // View row
        if ($this->RowType == RowType::VIEW) {
            // TaskID
            $this->TaskID->ViewValue = $this->TaskID->CurrentValue;

            // TaskName
            $this->TaskName->ViewValue = $this->TaskName->CurrentValue;

            // Description
            $this->Description->ViewValue = $this->Description->CurrentValue;

            // AssignedTo
            $curVal = strval($this->AssignedTo->CurrentValue);
            if ($curVal != "") {
                $this->AssignedTo->ViewValue = $this->AssignedTo->lookupCacheOption($curVal);
                if ($this->AssignedTo->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->AssignedTo->Lookup->getTable()->Fields["EmployeeID"]->searchExpression(), "=", $curVal, $this->AssignedTo->Lookup->getTable()->Fields["EmployeeID"]->searchDataType(), "");
                    $sqlWrk = $this->AssignedTo->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->AssignedTo->Lookup->renderViewRow($rswrk[0]);
                        $this->AssignedTo->ViewValue = $this->AssignedTo->displayValue($arwrk);
                    } else {
                        $this->AssignedTo->ViewValue = FormatNumber($this->AssignedTo->CurrentValue, $this->AssignedTo->formatPattern());
                    }
                }
            } else {
                $this->AssignedTo->ViewValue = null;
            }

            // Progress
            $this->Progress->ViewValue = $this->Progress->CurrentValue;
            $this->Progress->ViewValue = FormatPercent($this->Progress->ViewValue, $this->Progress->formatPattern());
            $this->Progress->CellCssStyle .= "text-align: right;";

            // Complete
            $this->Complete->ViewValue = $this->Complete->CurrentValue;

            // Target
            $this->Target->ViewValue = $this->Target->CurrentValue;
            $this->Target->ViewValue = FormatPercent($this->Target->ViewValue, $this->Target->formatPattern());
            $this->Target->CellCssStyle .= "text-align: right;";

            // Track
            $this->Track->ViewValue = $this->Track->CurrentValue;

            // PlanStart
            $this->PlanStart->ViewValue = $this->PlanStart->CurrentValue;
            $this->PlanStart->ViewValue = FormatDateTime($this->PlanStart->ViewValue, $this->PlanStart->formatPattern());

            // PlanEnd
            $this->PlanEnd->ViewValue = $this->PlanEnd->CurrentValue;
            $this->PlanEnd->ViewValue = FormatDateTime($this->PlanEnd->ViewValue, $this->PlanEnd->formatPattern());

            // StartDate
            $this->StartDate->ViewValue = $this->StartDate->CurrentValue;
            $this->StartDate->ViewValue = FormatDateTime($this->StartDate->ViewValue, $this->StartDate->formatPattern());

            // EndDate
            $this->EndDate->ViewValue = $this->EndDate->CurrentValue;
            $this->EndDate->ViewValue = FormatDateTime($this->EndDate->ViewValue, $this->EndDate->formatPattern());

            // Priority
            if (strval($this->Priority->CurrentValue) != "") {
                $this->Priority->ViewValue = $this->Priority->optionCaption($this->Priority->CurrentValue);
            } else {
                $this->Priority->ViewValue = null;
            }

            // Category
            $curVal = strval($this->Category->CurrentValue);
            if ($curVal != "") {
                $this->Category->ViewValue = $this->Category->lookupCacheOption($curVal);
                if ($this->Category->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->Category->Lookup->getTable()->Fields["CategoryName"]->searchExpression(), "=", $curVal, $this->Category->Lookup->getTable()->Fields["CategoryName"]->searchDataType(), "");
                    $lookupFilter = $this->Category->getSelectFilter($this); // PHP
                    $sqlWrk = $this->Category->Lookup->getSql(false, $filterWrk, $lookupFilter, $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->Category->Lookup->renderViewRow($rswrk[0]);
                        $this->Category->ViewValue = $this->Category->displayValue($arwrk);
                    } else {
                        $this->Category->ViewValue = $this->Category->CurrentValue;
                    }
                }
            } else {
                $this->Category->ViewValue = null;
            }

            // ProjectID
            $curVal = strval($this->_ProjectID->CurrentValue);
            if ($curVal != "") {
                $this->_ProjectID->ViewValue = $this->_ProjectID->lookupCacheOption($curVal);
                if ($this->_ProjectID->ViewValue === null) { // Lookup from database
                    $filterWrk = SearchFilter($this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchExpression(), "=", $curVal, $this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchDataType(), "");
                    $sqlWrk = $this->_ProjectID->Lookup->getSql(false, $filterWrk, '', $this, true, true);
                    $conn = Conn();
                    $config = $conn->getConfiguration();
                    $config->setResultCache($this->Cache);
                    $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                    $ari = count($rswrk);
                    if ($ari > 0) { // Lookup values found
                        $arwrk = $this->_ProjectID->Lookup->renderViewRow($rswrk[0]);
                        $this->_ProjectID->ViewValue = $this->_ProjectID->displayValue($arwrk);
                    } else {
                        $this->_ProjectID->ViewValue = FormatNumber($this->_ProjectID->CurrentValue, $this->_ProjectID->formatPattern());
                    }
                }
            } else {
                $this->_ProjectID->ViewValue = null;
            }

            // Created_Date
            $this->Created_Date->ViewValue = $this->Created_Date->CurrentValue;
            $this->Created_Date->ViewValue = FormatDateTime($this->Created_Date->ViewValue, $this->Created_Date->formatPattern());

            // Created_By
            $this->Created_By->ViewValue = $this->Created_By->CurrentValue;

            // Last_Updated_Date
            $this->Last_Updated_Date->ViewValue = $this->Last_Updated_Date->CurrentValue;
            $this->Last_Updated_Date->ViewValue = FormatDateTime($this->Last_Updated_Date->ViewValue, $this->Last_Updated_Date->formatPattern());

            // Last_Updated_By
            $this->Last_Updated_By->ViewValue = $this->Last_Updated_By->CurrentValue;

            // TaskID
            $this->TaskID->HrefValue = "";
            $this->TaskID->TooltipValue = "";

            // TaskName
            $this->TaskName->HrefValue = "";
            $this->TaskName->TooltipValue = "";

            // Description
            $this->Description->HrefValue = "";
            $this->Description->TooltipValue = "";

            // AssignedTo
            $this->AssignedTo->HrefValue = "";
            $this->AssignedTo->TooltipValue = "";

            // Progress
            $this->Progress->HrefValue = "";
            $this->Progress->TooltipValue = "";

            // Complete
            $this->Complete->HrefValue = "";
            $this->Complete->TooltipValue = "";

            // Target
            $this->Target->HrefValue = "";
            $this->Target->TooltipValue = "";

            // Track
            $this->Track->HrefValue = "";
            $this->Track->TooltipValue = "";

            // PlanStart
            $this->PlanStart->HrefValue = "";
            $this->PlanStart->TooltipValue = "";

            // PlanEnd
            $this->PlanEnd->HrefValue = "";
            $this->PlanEnd->TooltipValue = "";

            // StartDate
            $this->StartDate->HrefValue = "";
            $this->StartDate->TooltipValue = "";

            // EndDate
            $this->EndDate->HrefValue = "";
            $this->EndDate->TooltipValue = "";

            // Priority
            $this->Priority->HrefValue = "";
            $this->Priority->TooltipValue = "";

            // Category
            $this->Category->HrefValue = "";
            $this->Category->TooltipValue = "";

            // ProjectID
            $this->_ProjectID->HrefValue = "";
            $this->_ProjectID->TooltipValue = "";

            // Created_Date
            $this->Created_Date->HrefValue = "";
            $this->Created_Date->TooltipValue = "";

            // Created_By
            $this->Created_By->HrefValue = "";
            $this->Created_By->TooltipValue = "";

            // Last_Updated_Date
            $this->Last_Updated_Date->HrefValue = "";
            $this->Last_Updated_Date->TooltipValue = "";

            // Last_Updated_By
            $this->Last_Updated_By->HrefValue = "";
            $this->Last_Updated_By->TooltipValue = "";
        } elseif ($this->RowType == RowType::SEARCH) {
            // TaskID
            $this->TaskID->setupEditAttributes();
            $this->TaskID->EditValue = $this->TaskID->AdvancedSearch->SearchValue;
            $this->TaskID->PlaceHolder = RemoveHtml($this->TaskID->caption());

            // TaskName
            $this->TaskName->setupEditAttributes();
            if (!$this->TaskName->Raw) {
                $this->TaskName->AdvancedSearch->SearchValue = HtmlDecode($this->TaskName->AdvancedSearch->SearchValue);
            }
            $this->TaskName->EditValue = HtmlEncode($this->TaskName->AdvancedSearch->SearchValue);
            $this->TaskName->PlaceHolder = RemoveHtml($this->TaskName->caption());

            // Description
            $this->Description->setupEditAttributes();
            $this->Description->EditValue = HtmlEncode($this->Description->AdvancedSearch->SearchValue);
            $this->Description->PlaceHolder = RemoveHtml($this->Description->caption());

            // AssignedTo
            $this->AssignedTo->setupEditAttributes();
            $curVal = trim(strval($this->AssignedTo->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->AssignedTo->AdvancedSearch->ViewValue = $this->AssignedTo->lookupCacheOption($curVal);
            } else {
                $this->AssignedTo->AdvancedSearch->ViewValue = $this->AssignedTo->Lookup !== null && is_array($this->AssignedTo->lookupOptions()) && count($this->AssignedTo->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->AssignedTo->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->AssignedTo->EditValue = array_values($this->AssignedTo->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->AssignedTo->Lookup->getTable()->Fields["EmployeeID"]->searchExpression(), "=", $this->AssignedTo->AdvancedSearch->SearchValue, $this->AssignedTo->Lookup->getTable()->Fields["EmployeeID"]->searchDataType(), "");
                }
                $sqlWrk = $this->AssignedTo->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->AssignedTo->EditValue = $arwrk;
            }
            $this->AssignedTo->PlaceHolder = RemoveHtml($this->AssignedTo->caption());

            // Progress
            $this->Progress->setupEditAttributes();
            $this->Progress->EditValue = $this->Progress->AdvancedSearch->SearchValue;
            $this->Progress->PlaceHolder = RemoveHtml($this->Progress->caption());

            // Complete
            $this->Complete->setupEditAttributes();
            if (!$this->Complete->Raw) {
                $this->Complete->AdvancedSearch->SearchValue = HtmlDecode($this->Complete->AdvancedSearch->SearchValue);
            }
            $this->Complete->EditValue = HtmlEncode($this->Complete->AdvancedSearch->SearchValue);
            $this->Complete->PlaceHolder = RemoveHtml($this->Complete->caption());

            // Target
            $this->Target->setupEditAttributes();
            $this->Target->EditValue = $this->Target->AdvancedSearch->SearchValue;
            $this->Target->PlaceHolder = RemoveHtml($this->Target->caption());

            // Track
            $this->Track->setupEditAttributes();
            if (!$this->Track->Raw) {
                $this->Track->AdvancedSearch->SearchValue = HtmlDecode($this->Track->AdvancedSearch->SearchValue);
            }
            $this->Track->EditValue = HtmlEncode($this->Track->AdvancedSearch->SearchValue);
            $this->Track->PlaceHolder = RemoveHtml($this->Track->caption());

            // PlanStart
            $this->PlanStart->setupEditAttributes();
            $this->PlanStart->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->PlanStart->AdvancedSearch->SearchValue, $this->PlanStart->formatPattern()), $this->PlanStart->formatPattern()));
            $this->PlanStart->PlaceHolder = RemoveHtml($this->PlanStart->caption());
            $this->PlanStart->setupEditAttributes();
            $this->PlanStart->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->PlanStart->AdvancedSearch->SearchValue2, $this->PlanStart->formatPattern()), $this->PlanStart->formatPattern()));
            $this->PlanStart->PlaceHolder = RemoveHtml($this->PlanStart->caption());

            // PlanEnd
            $this->PlanEnd->setupEditAttributes();
            $this->PlanEnd->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->PlanEnd->AdvancedSearch->SearchValue, $this->PlanEnd->formatPattern()), $this->PlanEnd->formatPattern()));
            $this->PlanEnd->PlaceHolder = RemoveHtml($this->PlanEnd->caption());
            $this->PlanEnd->setupEditAttributes();
            $this->PlanEnd->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->PlanEnd->AdvancedSearch->SearchValue2, $this->PlanEnd->formatPattern()), $this->PlanEnd->formatPattern()));
            $this->PlanEnd->PlaceHolder = RemoveHtml($this->PlanEnd->caption());

            // StartDate
            $this->StartDate->setupEditAttributes();
            $this->StartDate->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->StartDate->AdvancedSearch->SearchValue, $this->StartDate->formatPattern()), $this->StartDate->formatPattern()));
            $this->StartDate->PlaceHolder = RemoveHtml($this->StartDate->caption());
            $this->StartDate->setupEditAttributes();
            $this->StartDate->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->StartDate->AdvancedSearch->SearchValue2, $this->StartDate->formatPattern()), $this->StartDate->formatPattern()));
            $this->StartDate->PlaceHolder = RemoveHtml($this->StartDate->caption());

            // EndDate
            $this->EndDate->setupEditAttributes();
            $this->EndDate->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->EndDate->AdvancedSearch->SearchValue, $this->EndDate->formatPattern()), $this->EndDate->formatPattern()));
            $this->EndDate->PlaceHolder = RemoveHtml($this->EndDate->caption());
            $this->EndDate->setupEditAttributes();
            $this->EndDate->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->EndDate->AdvancedSearch->SearchValue2, $this->EndDate->formatPattern()), $this->EndDate->formatPattern()));
            $this->EndDate->PlaceHolder = RemoveHtml($this->EndDate->caption());

            // Priority
            $this->Priority->setupEditAttributes();
            $this->Priority->EditValue = $this->Priority->options(true);
            $this->Priority->PlaceHolder = RemoveHtml($this->Priority->caption());

            // Category
            $this->Category->setupEditAttributes();
            $curVal = trim(strval($this->Category->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->Category->AdvancedSearch->ViewValue = $this->Category->lookupCacheOption($curVal);
            } else {
                $this->Category->AdvancedSearch->ViewValue = $this->Category->Lookup !== null && is_array($this->Category->lookupOptions()) && count($this->Category->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->Category->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->Category->EditValue = array_values($this->Category->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->Category->Lookup->getTable()->Fields["CategoryName"]->searchExpression(), "=", $this->Category->AdvancedSearch->SearchValue, $this->Category->Lookup->getTable()->Fields["CategoryName"]->searchDataType(), "");
                }
                $lookupFilter = $this->Category->getSelectFilter($this); // PHP
                $sqlWrk = $this->Category->Lookup->getSql(true, $filterWrk, $lookupFilter, $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->Category->EditValue = $arwrk;
            }
            $this->Category->PlaceHolder = RemoveHtml($this->Category->caption());

            // ProjectID
            $this->_ProjectID->setupEditAttributes();
            $curVal = trim(strval($this->_ProjectID->AdvancedSearch->SearchValue));
            if ($curVal != "") {
                $this->_ProjectID->AdvancedSearch->ViewValue = $this->_ProjectID->lookupCacheOption($curVal);
            } else {
                $this->_ProjectID->AdvancedSearch->ViewValue = $this->_ProjectID->Lookup !== null && is_array($this->_ProjectID->lookupOptions()) && count($this->_ProjectID->lookupOptions()) > 0 ? $curVal : null;
            }
            if ($this->_ProjectID->AdvancedSearch->ViewValue !== null) { // Load from cache
                $this->_ProjectID->EditValue = array_values($this->_ProjectID->lookupOptions());
            } else { // Lookup from database
                if ($curVal == "") {
                    $filterWrk = "0=1";
                } else {
                    $filterWrk = SearchFilter($this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchExpression(), "=", $this->_ProjectID->AdvancedSearch->SearchValue, $this->_ProjectID->Lookup->getTable()->Fields["ProjectID"]->searchDataType(), "");
                }
                $sqlWrk = $this->_ProjectID->Lookup->getSql(true, $filterWrk, '', $this, false, true);
                $conn = Conn();
                $config = $conn->getConfiguration();
                $config->setResultCache($this->Cache);
                $rswrk = $conn->executeCacheQuery($sqlWrk, [], [], $this->CacheProfile)->fetchAll();
                $ari = count($rswrk);
                $arwrk = $rswrk;
                $this->_ProjectID->EditValue = $arwrk;
            }
            $this->_ProjectID->PlaceHolder = RemoveHtml($this->_ProjectID->caption());

            // Created_Date
            $this->Created_Date->setupEditAttributes();
            $this->Created_Date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->Created_Date->AdvancedSearch->SearchValue, $this->Created_Date->formatPattern()), $this->Created_Date->formatPattern()));
            $this->Created_Date->PlaceHolder = RemoveHtml($this->Created_Date->caption());
            $this->Created_Date->setupEditAttributes();
            $this->Created_Date->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->Created_Date->AdvancedSearch->SearchValue2, $this->Created_Date->formatPattern()), $this->Created_Date->formatPattern()));
            $this->Created_Date->PlaceHolder = RemoveHtml($this->Created_Date->caption());

            // Created_By
            $this->Created_By->setupEditAttributes();
            if (!$this->Created_By->Raw) {
                $this->Created_By->AdvancedSearch->SearchValue = HtmlDecode($this->Created_By->AdvancedSearch->SearchValue);
            }
            $this->Created_By->EditValue = HtmlEncode($this->Created_By->AdvancedSearch->SearchValue);
            $this->Created_By->PlaceHolder = RemoveHtml($this->Created_By->caption());

            // Last_Updated_Date
            $this->Last_Updated_Date->setupEditAttributes();
            $this->Last_Updated_Date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->Last_Updated_Date->AdvancedSearch->SearchValue, $this->Last_Updated_Date->formatPattern()), $this->Last_Updated_Date->formatPattern()));
            $this->Last_Updated_Date->PlaceHolder = RemoveHtml($this->Last_Updated_Date->caption());
            $this->Last_Updated_Date->setupEditAttributes();
            $this->Last_Updated_Date->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->Last_Updated_Date->AdvancedSearch->SearchValue2, $this->Last_Updated_Date->formatPattern()), $this->Last_Updated_Date->formatPattern()));
            $this->Last_Updated_Date->PlaceHolder = RemoveHtml($this->Last_Updated_Date->caption());

            // Last_Updated_By
            $this->Last_Updated_By->setupEditAttributes();
            if (!$this->Last_Updated_By->Raw) {
                $this->Last_Updated_By->AdvancedSearch->SearchValue = HtmlDecode($this->Last_Updated_By->AdvancedSearch->SearchValue);
            }
            $this->Last_Updated_By->EditValue = HtmlEncode($this->Last_Updated_By->AdvancedSearch->SearchValue);
            $this->Last_Updated_By->PlaceHolder = RemoveHtml($this->Last_Updated_By->caption());
        }
        if ($this->RowType == RowType::ADD || $this->RowType == RowType::EDIT || $this->RowType == RowType::SEARCH) { // Add/Edit/Search row
            $this->setupFieldTitles();
        }

        // Call Row Rendered event
        if ($this->RowType != RowType::AGGREGATEINIT) {
            $this->rowRendered();
        }
    }

    // Validate search
    protected function validateSearch()
    {
        // Check if validation required
        if (!Config("SERVER_VALIDATE")) {
            return true;
        }
        if (!CheckInteger($this->TaskID->AdvancedSearch->SearchValue)) {
            $this->TaskID->addErrorMessage($this->TaskID->getErrorMessage(false));
        }
        if (!CheckNumber($this->Progress->AdvancedSearch->SearchValue)) {
            $this->Progress->addErrorMessage($this->Progress->getErrorMessage(false));
        }
        if (!CheckNumber($this->Target->AdvancedSearch->SearchValue)) {
            $this->Target->addErrorMessage($this->Target->getErrorMessage(false));
        }
        if (!CheckDate($this->PlanStart->AdvancedSearch->SearchValue, $this->PlanStart->formatPattern())) {
            $this->PlanStart->addErrorMessage($this->PlanStart->getErrorMessage(false));
        }
        if (!CheckDate($this->PlanStart->AdvancedSearch->SearchValue2, $this->PlanStart->formatPattern())) {
            $this->PlanStart->addErrorMessage($this->PlanStart->getErrorMessage(false));
        }
        if (!CheckDate($this->PlanEnd->AdvancedSearch->SearchValue, $this->PlanEnd->formatPattern())) {
            $this->PlanEnd->addErrorMessage($this->PlanEnd->getErrorMessage(false));
        }
        if (!CheckDate($this->PlanEnd->AdvancedSearch->SearchValue2, $this->PlanEnd->formatPattern())) {
            $this->PlanEnd->addErrorMessage($this->PlanEnd->getErrorMessage(false));
        }
        if (!CheckDate($this->StartDate->AdvancedSearch->SearchValue, $this->StartDate->formatPattern())) {
            $this->StartDate->addErrorMessage($this->StartDate->getErrorMessage(false));
        }
        if (!CheckDate($this->StartDate->AdvancedSearch->SearchValue2, $this->StartDate->formatPattern())) {
            $this->StartDate->addErrorMessage($this->StartDate->getErrorMessage(false));
        }
        if (!CheckDate($this->EndDate->AdvancedSearch->SearchValue, $this->EndDate->formatPattern())) {
            $this->EndDate->addErrorMessage($this->EndDate->getErrorMessage(false));
        }
        if (!CheckDate($this->EndDate->AdvancedSearch->SearchValue2, $this->EndDate->formatPattern())) {
            $this->EndDate->addErrorMessage($this->EndDate->getErrorMessage(false));
        }

        // Return validate result
        $validateSearch = !$this->hasInvalidFields();

        // Call Form_CustomValidate event
        $formCustomError = "";
        $validateSearch = $validateSearch && $this->formCustomValidate($formCustomError);
        if ($formCustomError != "") {
            $this->setFailureMessage($formCustomError);
        }
        return $validateSearch;
    }

    // Load advanced search
    public function loadAdvancedSearch()
    {
        $this->TaskID->AdvancedSearch->load();
        $this->TaskName->AdvancedSearch->load();
        $this->Description->AdvancedSearch->load();
        $this->AssignedTo->AdvancedSearch->load();
        $this->Progress->AdvancedSearch->load();
        $this->Complete->AdvancedSearch->load();
        $this->Target->AdvancedSearch->load();
        $this->Track->AdvancedSearch->load();
        $this->PlanStart->AdvancedSearch->load();
        $this->PlanEnd->AdvancedSearch->load();
        $this->StartDate->AdvancedSearch->load();
        $this->EndDate->AdvancedSearch->load();
        $this->Priority->AdvancedSearch->load();
        $this->Category->AdvancedSearch->load();
        $this->_ProjectID->AdvancedSearch->load();
        $this->Created_Date->AdvancedSearch->load();
        $this->Created_By->AdvancedSearch->load();
        $this->Last_Updated_Date->AdvancedSearch->load();
        $this->Last_Updated_By->AdvancedSearch->load();
    }

    // Set up Breadcrumb
    protected function setupBreadcrumb()
    {
        global $Breadcrumb, $Language;
        $Breadcrumb = new Breadcrumb("masterprojectlist");
        $url = CurrentUrl();
        $Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("projecttasklist"), "", $this->TableVar, true);
        $pageId = "search";
        $Breadcrumb->add("search", $pageId, $url);
    }

    // Setup lookup options
    public function setupLookupOptions($fld)
    {
        if ($fld->Lookup && $fld->Lookup->Options === null) {
            // Get default connection and filter
            $conn = $this->getConnection();
            $lookupFilter = "";

            // No need to check any more
            $fld->Lookup->Options = [];

            // Set up lookup SQL and connection
            switch ($fld->FieldVar) {
                case "x_AssignedTo":
                    break;
                case "x_Priority":
                    break;
                case "x_Category":
                    $lookupFilter = $fld->getSelectFilter(); // PHP
                    break;
                case "x__ProjectID":
                    break;
                default:
                    $lookupFilter = "";
                    break;
            }

            // Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
            $sql = $fld->Lookup->getSql(false, "", $lookupFilter, $this);

            // Set up lookup cache
            if (!$fld->hasLookupOptions() && $fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0 && count($fld->Lookup->FilterFields) == 0) {
                $totalCnt = $this->getRecordCount($sql, $conn);
                if ($totalCnt > $fld->LookupCacheCount) { // Total count > cache count, do not cache
                    return;
                }
                $rows = $conn->executeQuery($sql)->fetchAll();
                $ar = [];
                foreach ($rows as $row) {
                    $row = $fld->Lookup->renderViewRow($row, Container($fld->Lookup->LinkTable));
                    $key = $row["lf"];
                    if (IsFloatType($fld->Type)) { // Handle float field
                        $key = (float)$key;
                    }
                    $ar[strval($key)] = $row;
                }
                $fld->Lookup->Options = $ar;
            }
        }
    }

    // Page Load event
    public function pageLoad()
    {
        //Log("Page Load");
    }

    // Page Unload event
    public function pageUnload()
    {
        //Log("Page Unload");
    }

    // Page Redirecting event
    public function pageRedirecting(&$url)
    {
        // Example:
        //$url = "your URL";
    }

    // Message Showing event
    // $type = ''|'success'|'failure'|'warning'
    public function messageShowing(&$msg, $type)
    {
        if ($type == "success") {
            //$msg = "your success message";
        } elseif ($type == "failure") {
            //$msg = "your failure message";
        } elseif ($type == "warning") {
            //$msg = "your warning message";
        } else {
            //$msg = "your message";
        }
    }

    // Page Render event
    public function pageRender()
    {
        //Log("Page Render");
    }

    // Page Data Rendering event
    public function pageDataRendering(&$header)
    {
        // Example:
        //$header = "your header";
    }

    // Page Data Rendered event
    public function pageDataRendered(&$footer)
    {
        // Example:
        //$footer = "your footer";
    }

    // Page Breaking event
    public function pageBreaking(&$break, &$content)
    {
        // Example:
        //$break = false; // Skip page break, or
        //$content = "<div style=\"break-after:page;\"></div>"; // Modify page break content
    }

    // Form Custom Validate event
    public function formCustomValidate(&$customError)
    {
        // Return error message in $customError
        return true;
    }
}
