<?php

namespace ProjectManagement\prjProjectManagement\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use ProjectManagement\prjProjectManagement\AbstractEntity;
use ProjectManagement\prjProjectManagement\AdvancedSecurity;
use ProjectManagement\prjProjectManagement\UserProfile;
use function ProjectManagement\prjProjectManagement\Config;
use function ProjectManagement\prjProjectManagement\EntityManager;
use function ProjectManagement\prjProjectManagement\RemoveXss;
use function ProjectManagement\prjProjectManagement\HtmlDecode;
use function ProjectManagement\prjProjectManagement\EncryptPassword;

/**
 * Entity class for "masterprojectcategory" table
 */
#[Entity]
#[Table(name: "masterprojectcategory")]
class Masterprojectcategory extends AbstractEntity
{
    public static array $propertyNames = [
        'CategoryID' => 'categoryId',
        'CategoryName' => 'categoryName',
        'Active' => 'active',
        'Description' => 'description',
        'Created_Date' => 'createdDate',
        'Created_By' => 'createdBy',
        'Last_Updated_Date' => 'lastUpdatedDate',
        'Last_Updated_By' => 'lastUpdatedBy',
    ];

    #[Id]
    #[Column(name: "CategoryID", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $categoryId;

    #[Column(name: "CategoryName", type: "string", nullable: true)]
    private ?string $categoryName;

    #[Column(name: "Active", type: "boolean", nullable: true)]
    private ?bool $active = true;

    #[Column(name: "Description", type: "string", nullable: true)]
    private ?string $description;

    #[Column(name: "Created_Date", type: "datetime", nullable: true)]
    private ?DateTime $createdDate;

    #[Column(name: "Created_By", type: "string", nullable: true)]
    private ?string $createdBy;

    #[Column(name: "Last_Updated_Date", type: "datetime", nullable: true)]
    private ?DateTime $lastUpdatedDate;

    #[Column(name: "Last_Updated_By", type: "string", nullable: true)]
    private ?string $lastUpdatedBy;

    public function getCategoryId(): int
    {
        return $this->categoryId;
    }

    public function setCategoryId(int $value): static
    {
        $this->categoryId = $value;
        return $this;
    }

    public function getCategoryName(): ?string
    {
        return HtmlDecode($this->categoryName);
    }

    public function setCategoryName(?string $value): static
    {
        $this->categoryName = RemoveXss($value);
        return $this;
    }

    public function getActive(): ?bool
    {
        return $this->active;
    }

    public function setActive(?bool $value): static
    {
        $this->active = $value;
        return $this;
    }

    public function getDescription(): ?string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(?string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getCreatedDate(): ?DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(?DateTime $value): static
    {
        $this->createdDate = $value;
        return $this;
    }

    public function getCreatedBy(): ?string
    {
        return HtmlDecode($this->createdBy);
    }

    public function setCreatedBy(?string $value): static
    {
        $this->createdBy = RemoveXss($value);
        return $this;
    }

    public function getLastUpdatedDate(): ?DateTime
    {
        return $this->lastUpdatedDate;
    }

    public function setLastUpdatedDate(?DateTime $value): static
    {
        $this->lastUpdatedDate = $value;
        return $this;
    }

    public function getLastUpdatedBy(): ?string
    {
        return HtmlDecode($this->lastUpdatedBy);
    }

    public function setLastUpdatedBy(?string $value): static
    {
        $this->lastUpdatedBy = RemoveXss($value);
        return $this;
    }
}
