<?php

namespace ProjectManagement\prjProjectManagement\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use ProjectManagement\prjProjectManagement\AbstractEntity;
use ProjectManagement\prjProjectManagement\AdvancedSecurity;
use ProjectManagement\prjProjectManagement\UserProfile;
use function ProjectManagement\prjProjectManagement\Config;
use function ProjectManagement\prjProjectManagement\EntityManager;
use function ProjectManagement\prjProjectManagement\RemoveXss;
use function ProjectManagement\prjProjectManagement\HtmlDecode;
use function ProjectManagement\prjProjectManagement\EncryptPassword;

/**
 * Entity class for "masteruser" table
 */
#[Entity]
#[Table(name: "masteruser")]
class Masteruser extends AbstractEntity
{
    public static array $propertyNames = [
        'EmployeeID' => 'employeeId',
        'FirstName' => 'firstName',
        'LastName' => 'lastName',
        'Username' => 'username',
        'UserPassword' => 'userPassword',
        'Level' => 'level',
        'Email' => 'email',
        'Position' => 'position',
        'Department' => 'department',
        'Employee' => 'employee',
        'WhatsAppNumber' => 'whatsAppNumber',
        'Active' => 'active',
        'Created_Date' => 'createdDate',
        'Created_By' => 'createdBy',
        'Last_Updated_Date' => 'lastUpdatedDate',
        'Last_Updated_By' => 'lastUpdatedBy',
    ];

    #[Id]
    #[Column(name: "EmployeeID", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $employeeId;

    #[Column(name: "FirstName", type: "string", nullable: true)]
    private ?string $firstName;

    #[Column(name: "LastName", type: "string", nullable: true)]
    private ?string $lastName;

    #[Column(name: "Username", type: "string", unique: true)]
    private string $username;

    #[Column(name: "UserPassword", type: "string")]
    private string $userPassword;

    #[Column(name: "Level", type: "integer")]
    private int $level = 4;

    #[Column(name: "Email", type: "string", unique: true, nullable: true)]
    private ?string $email;

    #[Column(name: "Position", type: "string", nullable: true)]
    private ?string $position;

    #[Column(name: "Department", type: "string", nullable: true)]
    private ?string $department;

    #[Column(name: "Employee", type: "boolean", nullable: true)]
    private ?bool $employee = true;

    #[Column(name: "WhatsAppNumber", type: "string", nullable: true)]
    private ?string $whatsAppNumber;

    #[Column(name: "Active", type: "boolean", nullable: true)]
    private ?bool $active = true;

    #[Column(name: "Created_Date", type: "datetime", nullable: true)]
    private ?DateTime $createdDate;

    #[Column(name: "Created_By", type: "string", nullable: true)]
    private ?string $createdBy;

    #[Column(name: "Last_Updated_Date", type: "datetime", nullable: true)]
    private ?DateTime $lastUpdatedDate;

    #[Column(name: "Last_Updated_By", type: "string", nullable: true)]
    private ?string $lastUpdatedBy;

    public function getEmployeeId(): int
    {
        return $this->employeeId;
    }

    public function setEmployeeId(int $value): static
    {
        $this->employeeId = $value;
        return $this;
    }

    public function getFirstName(): ?string
    {
        return HtmlDecode($this->firstName);
    }

    public function setFirstName(?string $value): static
    {
        $this->firstName = RemoveXss($value);
        return $this;
    }

    public function getLastName(): ?string
    {
        return HtmlDecode($this->lastName);
    }

    public function setLastName(?string $value): static
    {
        $this->lastName = RemoveXss($value);
        return $this;
    }

    public function getUsername(): string
    {
        return $this->username;
    }

    public function setUsername(string $value): static
    {
        $this->username = $value;
        return $this;
    }

    public function getUserPassword(): string
    {
        return HtmlDecode($this->userPassword);
    }

    public function setUserPassword(string $value): static
    {
        $this->userPassword = RemoveXss($value);
        return $this;
    }

    public function getLevel(): int
    {
        return $this->level;
    }

    public function setLevel(int $value): static
    {
        $this->level = $value;
        return $this;
    }

    public function getEmail(): ?string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(?string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }

    public function getPosition(): ?string
    {
        return HtmlDecode($this->position);
    }

    public function setPosition(?string $value): static
    {
        $this->position = RemoveXss($value);
        return $this;
    }

    public function getDepartment(): ?string
    {
        return HtmlDecode($this->department);
    }

    public function setDepartment(?string $value): static
    {
        $this->department = RemoveXss($value);
        return $this;
    }

    public function getEmployee(): ?bool
    {
        return $this->employee;
    }

    public function setEmployee(?bool $value): static
    {
        $this->employee = $value;
        return $this;
    }

    public function getWhatsAppNumber(): ?string
    {
        return HtmlDecode($this->whatsAppNumber);
    }

    public function setWhatsAppNumber(?string $value): static
    {
        $this->whatsAppNumber = RemoveXss($value);
        return $this;
    }

    public function getActive(): ?bool
    {
        return $this->active;
    }

    public function setActive(?bool $value): static
    {
        $this->active = $value;
        return $this;
    }

    public function getCreatedDate(): ?DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(?DateTime $value): static
    {
        $this->createdDate = $value;
        return $this;
    }

    public function getCreatedBy(): ?string
    {
        return HtmlDecode($this->createdBy);
    }

    public function setCreatedBy(?string $value): static
    {
        $this->createdBy = RemoveXss($value);
        return $this;
    }

    public function getLastUpdatedDate(): ?DateTime
    {
        return $this->lastUpdatedDate;
    }

    public function setLastUpdatedDate(?DateTime $value): static
    {
        $this->lastUpdatedDate = $value;
        return $this;
    }

    public function getLastUpdatedBy(): ?string
    {
        return HtmlDecode($this->lastUpdatedBy);
    }

    public function setLastUpdatedBy(?string $value): static
    {
        $this->lastUpdatedBy = RemoveXss($value);
        return $this;
    }

    // Get login arguments
    public function getLoginArguments(): array
    {
        return [
            "userName" => $this->get('Username'),
            "userId" => null,
            "parentUserId" => null,
            "userLevel" => $this->get('Level') ?? AdvancedSecurity::ANONYMOUS_USER_LEVEL_ID,
            "userPrimaryKey" => $this->get('EmployeeID'),
        ];
    }

    // Flush
    public function flush()
    {
        EntityManager("DB")->flush();
    }
}
