<?php

namespace ProjectManagement\prjProjectManagement\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use ProjectManagement\prjProjectManagement\AbstractEntity;
use ProjectManagement\prjProjectManagement\AdvancedSecurity;
use ProjectManagement\prjProjectManagement\UserProfile;
use function ProjectManagement\prjProjectManagement\Config;
use function ProjectManagement\prjProjectManagement\EntityManager;
use function ProjectManagement\prjProjectManagement\RemoveXss;
use function ProjectManagement\prjProjectManagement\HtmlDecode;
use function ProjectManagement\prjProjectManagement\EncryptPassword;

/**
 * Entity class for "projectpaymentprocess" table
 */
#[Entity]
#[Table(name: "projectpaymentprocess")]
class Projectpaymentprocess extends AbstractEntity
{
    public static array $propertyNames = [
        'PaymentProcessID' => 'paymentProcessId',
        'DocumentName' => 'documentName',
        'FileName' => 'fileName',
        'Completed' => 'completed',
        'DateDelivered' => 'dateDelivered',
        'PICClient' => 'picClient',
        'Remark' => 'remark',
        'templateid' => 'templateid',
        'ProjectID' => 'projectId',
        'Created_Date' => 'createdDate',
        'Created_By' => 'createdBy',
        'Last_Updated_Date' => 'lastUpdatedDate',
        'Last_Updated_By' => 'lastUpdatedBy',
    ];

    #[Id]
    #[Column(name: "PaymentProcessID", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $paymentProcessId;

    #[Column(name: "DocumentName", type: "string", nullable: true)]
    private ?string $documentName;

    #[Column(name: "FileName", type: "string", nullable: true)]
    private ?string $fileName;

    #[Column(name: "Completed", type: "boolean", nullable: true)]
    private ?bool $completed;

    #[Column(name: "DateDelivered", type: "date", nullable: true)]
    private ?DateTime $dateDelivered;

    #[Column(name: "PICClient", type: "integer", nullable: true)]
    private ?int $picClient;

    #[Column(name: "Remark", type: "string", nullable: true)]
    private ?string $remark;

    #[Column(type: "integer", nullable: true)]
    private ?int $templateid;

    #[Column(name: "ProjectID", type: "integer", nullable: true)]
    private ?int $projectId;

    #[Column(name: "Created_Date", type: "datetime", nullable: true)]
    private ?DateTime $createdDate;

    #[Column(name: "Created_By", type: "string", nullable: true)]
    private ?string $createdBy;

    #[Column(name: "Last_Updated_Date", type: "datetime", nullable: true)]
    private ?DateTime $lastUpdatedDate;

    #[Column(name: "Last_Updated_By", type: "string", nullable: true)]
    private ?string $lastUpdatedBy;

    public function getPaymentProcessId(): int
    {
        return $this->paymentProcessId;
    }

    public function setPaymentProcessId(int $value): static
    {
        $this->paymentProcessId = $value;
        return $this;
    }

    public function getDocumentName(): ?string
    {
        return HtmlDecode($this->documentName);
    }

    public function setDocumentName(?string $value): static
    {
        $this->documentName = RemoveXss($value);
        return $this;
    }

    public function getFileName(): ?string
    {
        return HtmlDecode($this->fileName);
    }

    public function setFileName(?string $value): static
    {
        $this->fileName = RemoveXss($value);
        return $this;
    }

    public function getCompleted(): ?bool
    {
        return $this->completed;
    }

    public function setCompleted(?bool $value): static
    {
        $this->completed = $value;
        return $this;
    }

    public function getDateDelivered(): ?DateTime
    {
        return $this->dateDelivered;
    }

    public function setDateDelivered(?DateTime $value): static
    {
        $this->dateDelivered = $value;
        return $this;
    }

    public function getPicClient(): ?int
    {
        return $this->picClient;
    }

    public function setPicClient(?int $value): static
    {
        $this->picClient = $value;
        return $this;
    }

    public function getRemark(): ?string
    {
        return HtmlDecode($this->remark);
    }

    public function setRemark(?string $value): static
    {
        $this->remark = RemoveXss($value);
        return $this;
    }

    public function getTemplateid(): ?int
    {
        return $this->templateid;
    }

    public function setTemplateid(?int $value): static
    {
        $this->templateid = $value;
        return $this;
    }

    public function getProjectId(): ?int
    {
        return $this->projectId;
    }

    public function setProjectId(?int $value): static
    {
        $this->projectId = $value;
        return $this;
    }

    public function getCreatedDate(): ?DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(?DateTime $value): static
    {
        $this->createdDate = $value;
        return $this;
    }

    public function getCreatedBy(): ?string
    {
        return HtmlDecode($this->createdBy);
    }

    public function setCreatedBy(?string $value): static
    {
        $this->createdBy = RemoveXss($value);
        return $this;
    }

    public function getLastUpdatedDate(): ?DateTime
    {
        return $this->lastUpdatedDate;
    }

    public function setLastUpdatedDate(?DateTime $value): static
    {
        $this->lastUpdatedDate = $value;
        return $this;
    }

    public function getLastUpdatedBy(): ?string
    {
        return HtmlDecode($this->lastUpdatedBy);
    }

    public function setLastUpdatedBy(?string $value): static
    {
        $this->lastUpdatedBy = RemoveXss($value);
        return $this;
    }
}
