<?php

namespace ProjectManagement\prjProjectManagement\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use ProjectManagement\prjProjectManagement\AbstractEntity;
use ProjectManagement\prjProjectManagement\AdvancedSecurity;
use ProjectManagement\prjProjectManagement\UserProfile;
use function ProjectManagement\prjProjectManagement\Config;
use function ProjectManagement\prjProjectManagement\EntityManager;
use function ProjectManagement\prjProjectManagement\RemoveXss;
use function ProjectManagement\prjProjectManagement\HtmlDecode;
use function ProjectManagement\prjProjectManagement\EncryptPassword;

/**
 * Entity class for "projectresult" table
 */
#[Entity]
#[Table(name: "projectresult")]
class Projectresult extends AbstractEntity
{
    public static array $propertyNames = [
        'ResultID' => 'resultId',
        'Activities' => 'activities',
        'DateDelivered' => 'dateDelivered',
        'Progress' => 'progress',
        'Status' => 'status',
        'Category' => 'category',
        'Weight' => 'weight',
        'File' => 'file',
        'Notes' => 'notes',
        'ProjectID' => 'projectId',
        'templateid' => 'templateid',
        'Created_Date' => 'createdDate',
        'Created_By' => 'createdBy',
        'Last_Updated_Date' => 'lastUpdatedDate',
        'Last_Updated_By' => 'lastUpdatedBy',
    ];

    #[Id]
    #[Column(name: "ResultID", type: "integer", unique: true)]
    #[GeneratedValue]
    private int $resultId;

    #[Column(name: "Activities", type: "string")]
    private string $activities;

    #[Column(name: "DateDelivered", type: "date", nullable: true)]
    private ?DateTime $dateDelivered;

    #[Column(name: "Progress", type: "decimal", nullable: true)]
    private ?string $progress;

    #[Column(name: "Status", type: "string", nullable: true)]
    private ?string $status = "Not Started";

    #[Column(name: "Category", type: "string", nullable: true)]
    private ?string $category = "Document";

    #[Column(name: "Weight", type: "integer", nullable: true)]
    private ?int $weight;

    #[Column(name: "File", type: "string", nullable: true)]
    private ?string $file;

    #[Column(name: "Notes", type: "string", nullable: true)]
    private ?string $notes;

    #[Column(name: "ProjectID", type: "integer")]
    private int $projectId;

    #[Column(type: "integer", nullable: true)]
    private ?int $templateid;

    #[Column(name: "Created_Date", type: "datetime", nullable: true)]
    private ?DateTime $createdDate;

    #[Column(name: "Created_By", type: "string", nullable: true)]
    private ?string $createdBy;

    #[Column(name: "Last_Updated_Date", type: "datetime", nullable: true)]
    private ?DateTime $lastUpdatedDate;

    #[Column(name: "Last_Updated_By", type: "string", nullable: true)]
    private ?string $lastUpdatedBy;

    public function getResultId(): int
    {
        return $this->resultId;
    }

    public function setResultId(int $value): static
    {
        $this->resultId = $value;
        return $this;
    }

    public function getActivities(): string
    {
        return HtmlDecode($this->activities);
    }

    public function setActivities(string $value): static
    {
        $this->activities = RemoveXss($value);
        return $this;
    }

    public function getDateDelivered(): ?DateTime
    {
        return $this->dateDelivered;
    }

    public function setDateDelivered(?DateTime $value): static
    {
        $this->dateDelivered = $value;
        return $this;
    }

    public function getProgress(): ?string
    {
        return $this->progress;
    }

    public function setProgress(?string $value): static
    {
        $this->progress = $value;
        return $this;
    }

    public function getStatus(): ?string
    {
        return HtmlDecode($this->status);
    }

    public function setStatus(?string $value): static
    {
        $this->status = RemoveXss($value);
        return $this;
    }

    public function getCategory(): ?string
    {
        return HtmlDecode($this->category);
    }

    public function setCategory(?string $value): static
    {
        $this->category = RemoveXss($value);
        return $this;
    }

    public function getWeight(): ?int
    {
        return $this->weight;
    }

    public function setWeight(?int $value): static
    {
        $this->weight = $value;
        return $this;
    }

    public function getFile(): ?string
    {
        return HtmlDecode($this->file);
    }

    public function setFile(?string $value): static
    {
        $this->file = RemoveXss($value);
        return $this;
    }

    public function getNotes(): ?string
    {
        return HtmlDecode($this->notes);
    }

    public function setNotes(?string $value): static
    {
        $this->notes = RemoveXss($value);
        return $this;
    }

    public function getProjectId(): int
    {
        return $this->projectId;
    }

    public function setProjectId(int $value): static
    {
        $this->projectId = $value;
        return $this;
    }

    public function getTemplateid(): ?int
    {
        return $this->templateid;
    }

    public function setTemplateid(?int $value): static
    {
        $this->templateid = $value;
        return $this;
    }

    public function getCreatedDate(): ?DateTime
    {
        return $this->createdDate;
    }

    public function setCreatedDate(?DateTime $value): static
    {
        $this->createdDate = $value;
        return $this;
    }

    public function getCreatedBy(): ?string
    {
        return HtmlDecode($this->createdBy);
    }

    public function setCreatedBy(?string $value): static
    {
        $this->createdBy = RemoveXss($value);
        return $this;
    }

    public function getLastUpdatedDate(): ?DateTime
    {
        return $this->lastUpdatedDate;
    }

    public function setLastUpdatedDate(?DateTime $value): static
    {
        $this->lastUpdatedDate = $value;
        return $this;
    }

    public function getLastUpdatedBy(): ?string
    {
        return HtmlDecode($this->lastUpdatedBy);
    }

    public function setLastUpdatedBy(?string $value): static
    {
        $this->lastUpdatedBy = RemoveXss($value);
        return $this;
    }
}
