<?php

namespace ProjectManagement\prjProjectManagement\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use ProjectManagement\prjProjectManagement\AbstractEntity;
use ProjectManagement\prjProjectManagement\AdvancedSecurity;
use ProjectManagement\prjProjectManagement\UserProfile;
use function ProjectManagement\prjProjectManagement\Config;
use function ProjectManagement\prjProjectManagement\EntityManager;
use function ProjectManagement\prjProjectManagement\RemoveXss;
use function ProjectManagement\prjProjectManagement\HtmlDecode;
use function ProjectManagement\prjProjectManagement\EncryptPassword;

/**
 * Entity class for "userlevels" table
 */
#[Entity]
#[Table(name: "userlevels")]
class Userlevel extends AbstractEntity
{
    public static array $propertyNames = [
        'userlevelid' => 'userlevelid',
        'userlevelname' => 'userlevelname',
    ];

    #[Id]
    #[Column(type: "integer", unique: true)]
    private int $userlevelid;

    #[Column(type: "string")]
    private string $userlevelname;

    public function getUserlevelid(): int
    {
        return $this->userlevelid;
    }

    public function setUserlevelid(int $value): static
    {
        $this->userlevelid = $value;
        return $this;
    }

    public function getUserlevelname(): string
    {
        return HtmlDecode($this->userlevelname);
    }

    public function setUserlevelname(string $value): static
    {
        $this->userlevelname = RemoveXss($value);
        return $this;
    }
}
