<?php

namespace ProjectManagement\prjProjectManagement\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use ProjectManagement\prjProjectManagement\AbstractEntity;
use ProjectManagement\prjProjectManagement\AdvancedSecurity;
use ProjectManagement\prjProjectManagement\UserProfile;
use function ProjectManagement\prjProjectManagement\Config;
use function ProjectManagement\prjProjectManagement\EntityManager;
use function ProjectManagement\prjProjectManagement\RemoveXss;
use function ProjectManagement\prjProjectManagement\HtmlDecode;
use function ProjectManagement\prjProjectManagement\EncryptPassword;

/**
 * Entity class for "viewwaitingfortask" table
 */
#[Entity]
#[Table(name: "viewwaitingfortask")]
class Viewwaitingfortask extends AbstractEntity
{
    public static array $propertyNames = [
        'EmployeeID' => 'employeeId',
        'FullName' => 'fullName',
        'WhatsAppNumber' => 'whatsAppNumber',
        'Position' => 'position',
        'Department' => 'department',
        'WaitingTask' => 'waitingTask',
        'PlanEnd' => 'planEnd',
        'EndDate' => 'endDate',
    ];

    #[Id]
    #[Column(name: "EmployeeID", type: "integer")]
    private int $employeeId = 0;

    #[Column(name: "FullName", type: "string", nullable: true)]
    private ?string $fullName;

    #[Column(name: "WhatsAppNumber", type: "string", nullable: true)]
    private ?string $whatsAppNumber;

    #[Column(name: "Position", type: "string", nullable: true)]
    private ?string $position;

    #[Column(name: "Department", type: "string", nullable: true)]
    private ?string $department;

    #[Column(name: "WaitingTask", type: "integer", nullable: true)]
    private ?int $waitingTask;

    #[Column(name: "PlanEnd", type: "date", nullable: true)]
    private ?DateTime $planEnd;

    #[Column(name: "EndDate", type: "date", nullable: true)]
    private ?DateTime $endDate;

    public function getEmployeeId(): int
    {
        return $this->employeeId;
    }

    public function setEmployeeId(int $value): static
    {
        $this->employeeId = $value;
        return $this;
    }

    public function getFullName(): ?string
    {
        return HtmlDecode($this->fullName);
    }

    public function setFullName(?string $value): static
    {
        $this->fullName = RemoveXss($value);
        return $this;
    }

    public function getWhatsAppNumber(): ?string
    {
        return HtmlDecode($this->whatsAppNumber);
    }

    public function setWhatsAppNumber(?string $value): static
    {
        $this->whatsAppNumber = RemoveXss($value);
        return $this;
    }

    public function getPosition(): ?string
    {
        return HtmlDecode($this->position);
    }

    public function setPosition(?string $value): static
    {
        $this->position = RemoveXss($value);
        return $this;
    }

    public function getDepartment(): ?string
    {
        return HtmlDecode($this->department);
    }

    public function setDepartment(?string $value): static
    {
        $this->department = RemoveXss($value);
        return $this;
    }

    public function getWaitingTask(): ?int
    {
        return $this->waitingTask;
    }

    public function setWaitingTask(?int $value): static
    {
        $this->waitingTask = $value;
        return $this;
    }

    public function getPlanEnd(): ?DateTime
    {
        return $this->planEnd;
    }

    public function setPlanEnd(?DateTime $value): static
    {
        $this->planEnd = $value;
        return $this;
    }

    public function getEndDate(): ?DateTime
    {
        return $this->endDate;
    }

    public function setEndDate(?DateTime $value): static
    {
        $this->endDate = $value;
        return $this;
    }
}
