<?php
/**
 * PHPMaker 2024 User Level Settings
 */
namespace ProjectManagement\prjProjectManagement;

/**
 * User levels
 *
 * @var array<int, string>
 * [0] int User level ID
 * [1] string User level name
 */
$USER_LEVELS = [["-2","Anonymous"],
    ["0","Default"]];

/**
 * User level permissions
 *
 * @var array<string, int, int>
 * [0] string Project ID + Table name
 * [1] int User level ID
 * [2] int Permissions
 */
$USER_LEVEL_PRIVS = [["{E146A893-31C5-4EA3-AB83-97D09412B27F}masterclient","-2","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}masterclient","0","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}masteruser","-2","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}masteruser","0","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}masterproject","-2","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}masterproject","0","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}masterrole","-2","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}masterrole","0","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}projectmember","-2","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}projectmember","0","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}projectpaymentprocess","-2","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}projectpaymentprocess","0","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}projectresult","-2","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}projectresult","0","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}projecttask","-2","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}projecttask","0","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}userlevelpermissions","-2","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}userlevelpermissions","0","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}userlevels","-2","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}userlevels","0","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}projectmom","-2","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}projectmom","0","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}projectdocuments","-2","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}projectdocuments","0","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}projecttemplate","-2","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}projecttemplate","0","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}projecttemplateresult","-2","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}projecttemplateresult","0","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}masterprogress","-2","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}masterprogress","0","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}vuser","-2","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}vuser","0","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}viewprojectmember","-2","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}viewprojectmember","0","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}masterprojectcategory","-2","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}masterprojectcategory","0","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}projectproblems","-2","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}projectproblems","0","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}projecttemplatepaymentprocess","-2","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}projecttemplatepaymentprocess","0","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}manualdocument","-2","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}manualdocument","0","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}PerformanceReport","-2","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}PerformanceReport","0","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}viewwaitingfortask","-2","0"],
    ["{E146A893-31C5-4EA3-AB83-97D09412B27F}viewwaitingfortask","0","0"]];

/**
 * Tables
 *
 * @var array<string, string, string, bool, string>
 * [0] string Table name
 * [1] string Table variable name
 * [2] string Table caption
 * [3] bool Allowed for update (for userpriv.php)
 * [4] string Project ID
 * [5] string URL (for OthersController::index)
 */
$USER_LEVEL_TABLES = [["masterclient","masterclient","Master Client",true,"{E146A893-31C5-4EA3-AB83-97D09412B27F}","masterclientlist"],
    ["masteruser","masteruser","Master User",true,"{E146A893-31C5-4EA3-AB83-97D09412B27F}","masteruserlist"],
    ["masterproject","masterproject","Master Project",true,"{E146A893-31C5-4EA3-AB83-97D09412B27F}","masterprojectlist"],
    ["masterrole","masterrole","Master Role",true,"{E146A893-31C5-4EA3-AB83-97D09412B27F}","masterrolelist"],
    ["projectmember","projectmember","Project Member",true,"{E146A893-31C5-4EA3-AB83-97D09412B27F}","projectmemberlist"],
    ["projectpaymentprocess","projectpaymentprocess","Payment",true,"{E146A893-31C5-4EA3-AB83-97D09412B27F}","projectpaymentprocesslist"],
    ["projectresult","projectresult","Project Result",true,"{E146A893-31C5-4EA3-AB83-97D09412B27F}","projectresultlist"],
    ["projecttask","projecttask","Project Task",true,"{E146A893-31C5-4EA3-AB83-97D09412B27F}","projecttasklist"],
    ["userlevelpermissions","userlevelpermissions","User Level Permission",true,"{E146A893-31C5-4EA3-AB83-97D09412B27F}","userlevelpermissionslist"],
    ["userlevels","userlevels","User Level",true,"{E146A893-31C5-4EA3-AB83-97D09412B27F}","userlevelslist"],
    ["projectmom","projectmom","MOM",true,"{E146A893-31C5-4EA3-AB83-97D09412B27F}","projectmomlist"],
    ["projectdocuments","projectdocuments","Documents",true,"{E146A893-31C5-4EA3-AB83-97D09412B27F}","projectdocumentslist"],
    ["projecttemplate","projecttemplate","Project Template",true,"{E146A893-31C5-4EA3-AB83-97D09412B27F}","projecttemplatelist"],
    ["projecttemplateresult","projecttemplateresult","Template Result",true,"{E146A893-31C5-4EA3-AB83-97D09412B27F}","projecttemplateresultlist"],
    ["masterprogress","masterprogress","Master Progress",true,"{E146A893-31C5-4EA3-AB83-97D09412B27F}","masterprogresslist"],
    ["vuser","vuser","View User",true,"{E146A893-31C5-4EA3-AB83-97D09412B27F}","vuserlist"],
    ["viewprojectmember","viewprojectmember","View Project Member",true,"{E146A893-31C5-4EA3-AB83-97D09412B27F}","viewprojectmemberlist"],
    ["masterprojectcategory","masterprojectcategory","Project Category",true,"{E146A893-31C5-4EA3-AB83-97D09412B27F}","masterprojectcategorylist"],
    ["projectproblems","projectproblems","Problems",true,"{E146A893-31C5-4EA3-AB83-97D09412B27F}","projectproblemslist"],
    ["projecttemplatepaymentprocess","projecttemplatepaymentprocess","Template Payment",true,"{E146A893-31C5-4EA3-AB83-97D09412B27F}","projecttemplatepaymentprocesslist"],
    ["manualdocument","manualdocument","Manual",true,"{E146A893-31C5-4EA3-AB83-97D09412B27F}","manualdocumentlist"],
    ["PerformanceReport","PerformanceReport","Performance Report",true,"{E146A893-31C5-4EA3-AB83-97D09412B27F}","performancereport"],
    ["viewwaitingfortask","viewwaitingfortask","Waiting For Task",true,"{E146A893-31C5-4EA3-AB83-97D09412B27F}","viewwaitingfortasklist"]];
