<?php

namespace ProjectManagement\prjProjectManagement;

// Page object
$MasterclientSearch = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { masterclient: currentTable } });
var currentPageID = ew.PAGE_ID = "search";
var currentForm;
var fmasterclientsearch, currentSearchForm, currentAdvancedSearchForm;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery,
        fields = currentTable.fields;

    // Form object for search
    let form = new ew.FormBuilder()
        .setId("fmasterclientsearch")
        .setPageId("search")
<?php if ($Page->IsModal && $Page->UseAjaxActions) { ?>
        .setSubmitWithFetch(true)
<?php } ?>

        // Add fields
        .addFields([
            ["ClientID", [ew.Validators.integer], fields.ClientID.isInvalid],
            ["CompanyName", [], fields.CompanyName.isInvalid],
            ["ContactName", [], fields.ContactName.isInvalid],
            ["ContactEmail", [], fields.ContactEmail.isInvalid],
            ["Phone", [], fields.Phone.isInvalid],
            ["NPWP", [], fields.NPWP.isInvalid],
            ["Address", [], fields.Address.isInvalid],
            ["City", [], fields.City.isInvalid],
            ["Active", [], fields.Active.isInvalid],
            ["Created_Date", [], fields.Created_Date.isInvalid],
            ["y_Created_Date", [ew.Validators.between], false],
            ["Created_By", [], fields.Created_By.isInvalid],
            ["Last_Updated_Date", [], fields.Last_Updated_Date.isInvalid],
            ["y_Last_Updated_Date", [ew.Validators.between], false],
            ["Last_Updated_By", [], fields.Last_Updated_By.isInvalid]
        ])
        // Validate form
        .setValidate(
            async function () {
                if (!this.validateRequired)
                    return true; // Ignore validation
                let fobj = this.getForm();

                // Validate fields
                if (!this.validateFields())
                    return false;

                // Call Form_CustomValidate event
                if (!(await this.customValidate?.(fobj) ?? true)) {
                    this.focus();
                    return false;
                }
                return true;
            }
        )

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "Active": <?= $Page->Active->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
<?php if ($Page->IsModal) { ?>
    currentAdvancedSearchForm = form;
<?php } else { ?>
    currentForm = form;
<?php } ?>
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmasterclientsearch" id="fmasterclientsearch" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="masterclient">
<input type="hidden" name="action" id="action" value="search">
<?php if ($Page->IsModal) { ?>
<input type="hidden" name="modal" value="1">
<?php } ?>
<div class="ew-search-div"><!-- page* -->
<?php if ($Page->ClientID->Visible) { // ClientID ?>
    <div id="r_ClientID" class="row"<?= $Page->ClientID->rowAttributes() ?>>
        <label for="x_ClientID" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterclient_ClientID"><?= $Page->ClientID->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_ClientID" id="z_ClientID" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ClientID->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterclient_ClientID" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ClientID->getInputTextType() ?>" name="x_ClientID" id="x_ClientID" data-table="masterclient" data-field="x_ClientID" value="<?= $Page->ClientID->EditValue ?>" placeholder="<?= HtmlEncode($Page->ClientID->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ClientID->formatPattern()) ?>"<?= $Page->ClientID->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ClientID->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->CompanyName->Visible) { // CompanyName ?>
    <div id="r_CompanyName" class="row"<?= $Page->CompanyName->rowAttributes() ?>>
        <label for="x_CompanyName" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterclient_CompanyName"><?= $Page->CompanyName->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_CompanyName" id="z_CompanyName" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->CompanyName->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterclient_CompanyName" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->CompanyName->getInputTextType() ?>" name="x_CompanyName" id="x_CompanyName" data-table="masterclient" data-field="x_CompanyName" value="<?= $Page->CompanyName->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->CompanyName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->CompanyName->formatPattern()) ?>"<?= $Page->CompanyName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->CompanyName->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ContactName->Visible) { // ContactName ?>
    <div id="r_ContactName" class="row"<?= $Page->ContactName->rowAttributes() ?>>
        <label for="x_ContactName" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterclient_ContactName"><?= $Page->ContactName->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ContactName" id="z_ContactName" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ContactName->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterclient_ContactName" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ContactName->getInputTextType() ?>" name="x_ContactName" id="x_ContactName" data-table="masterclient" data-field="x_ContactName" value="<?= $Page->ContactName->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->ContactName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ContactName->formatPattern()) ?>"<?= $Page->ContactName->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ContactName->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ContactEmail->Visible) { // ContactEmail ?>
    <div id="r_ContactEmail" class="row"<?= $Page->ContactEmail->rowAttributes() ?>>
        <label for="x_ContactEmail" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterclient_ContactEmail"><?= $Page->ContactEmail->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ContactEmail" id="z_ContactEmail" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ContactEmail->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterclient_ContactEmail" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->ContactEmail->getInputTextType() ?>" name="x_ContactEmail" id="x_ContactEmail" data-table="masterclient" data-field="x_ContactEmail" value="<?= $Page->ContactEmail->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->ContactEmail->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ContactEmail->formatPattern()) ?>"<?= $Page->ContactEmail->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->ContactEmail->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Phone->Visible) { // Phone ?>
    <div id="r_Phone" class="row"<?= $Page->Phone->rowAttributes() ?>>
        <label for="x_Phone" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterclient_Phone"><?= $Page->Phone->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Phone" id="z_Phone" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Phone->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterclient_Phone" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Phone->getInputTextType() ?>" name="x_Phone" id="x_Phone" data-table="masterclient" data-field="x_Phone" value="<?= $Page->Phone->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->Phone->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Phone->formatPattern()) ?>"<?= $Page->Phone->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Phone->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->NPWP->Visible) { // NPWP ?>
    <div id="r_NPWP" class="row"<?= $Page->NPWP->rowAttributes() ?>>
        <label for="x_NPWP" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterclient_NPWP"><?= $Page->NPWP->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_NPWP" id="z_NPWP" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->NPWP->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterclient_NPWP" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->NPWP->getInputTextType() ?>" name="x_NPWP" id="x_NPWP" data-table="masterclient" data-field="x_NPWP" value="<?= $Page->NPWP->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->NPWP->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NPWP->formatPattern()) ?>"<?= $Page->NPWP->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->NPWP->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Address->Visible) { // Address ?>
    <div id="r_Address" class="row"<?= $Page->Address->rowAttributes() ?>>
        <label for="x_Address" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterclient_Address"><?= $Page->Address->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Address" id="z_Address" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Address->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterclient_Address" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Address->getInputTextType() ?>" name="x_Address" id="x_Address" data-table="masterclient" data-field="x_Address" value="<?= $Page->Address->EditValue ?>" maxlength="255" placeholder="<?= HtmlEncode($Page->Address->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Address->formatPattern()) ?>"<?= $Page->Address->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Address->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->City->Visible) { // City ?>
    <div id="r_City" class="row"<?= $Page->City->rowAttributes() ?>>
        <label for="x_City" class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterclient_City"><?= $Page->City->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("LIKE") ?>
<input type="hidden" name="z_City" id="z_City" value="LIKE">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->City->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterclient_City" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->City->getInputTextType() ?>" name="x_City" id="x_City" data-table="masterclient" data-field="x_City" value="<?= $Page->City->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->City->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->City->formatPattern()) ?>"<?= $Page->City->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->City->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Active->Visible) { // Active ?>
    <div id="r_Active" class="row"<?= $Page->Active->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterclient_Active"><?= $Page->Active->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Active" id="z_Active" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Active->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterclient_Active" class="ew-search-field ew-search-field-single">
<div class="form-check d-inline-block">
    <input type="checkbox" class="form-check-input<?= $Page->Active->isInvalidClass() ?>" data-table="masterclient" data-field="x_Active" data-boolean name="x_Active" id="x_Active" value="1"<?= ConvertToBool($Page->Active->AdvancedSearch->SearchValue) ? " checked" : "" ?><?= $Page->Active->editAttributes() ?>>
    <div class="invalid-feedback"><?= $Page->Active->getErrorMessage(false) ?></div>
</div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Created_Date->Visible) { // Created_Date ?>
    <div id="r_Created_Date" class="row"<?= $Page->Created_Date->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterclient_Created_Date"><?= $Page->Created_Date->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Created_Date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_Created_Date" id="z_Created_Date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->Created_Date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->Created_Date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_masterclient_Created_Date" class="ew-search-field">
<input type="<?= $Page->Created_Date->getInputTextType() ?>" name="x_Created_Date" id="x_Created_Date" data-table="masterclient" data-field="x_Created_Date" value="<?= $Page->Created_Date->EditValue ?>" placeholder="<?= HtmlEncode($Page->Created_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_Date->formatPattern()) ?>"<?= $Page->Created_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Created_Date->ReadOnly && !$Page->Created_Date->Disabled && !isset($Page->Created_Date->EditAttrs["readonly"]) && !isset($Page->Created_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterclientsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterclientsearch", "x_Created_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_masterclient_Created_Date" class="ew-search-field2 d-none">
<input type="<?= $Page->Created_Date->getInputTextType() ?>" name="y_Created_Date" id="y_Created_Date" data-table="masterclient" data-field="x_Created_Date" value="<?= $Page->Created_Date->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->Created_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_Date->formatPattern()) ?>"<?= $Page->Created_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Created_Date->ReadOnly && !$Page->Created_Date->Disabled && !isset($Page->Created_Date->EditAttrs["readonly"]) && !isset($Page->Created_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterclientsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterclientsearch", "y_Created_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Created_By->Visible) { // Created_By ?>
    <div id="r_Created_By" class="row"<?= $Page->Created_By->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterclient_Created_By"><?= $Page->Created_By->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Created_By" id="z_Created_By" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Created_By->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterclient_Created_By" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Created_By->getInputTextType() ?>" name="x_Created_By" id="x_Created_By" data-table="masterclient" data-field="x_Created_By" value="<?= $Page->Created_By->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Created_By->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Created_By->formatPattern()) ?>"<?= $Page->Created_By->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Created_By->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Last_Updated_Date->Visible) { // Last_Updated_Date ?>
    <div id="r_Last_Updated_Date" class="row"<?= $Page->Last_Updated_Date->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterclient_Last_Updated_Date"><?= $Page->Last_Updated_Date->caption() ?></span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Last_Updated_Date->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                    <span class="ew-search-operator">
<select name="z_Last_Updated_Date" id="z_Last_Updated_Date" class="form-select ew-operator-select" data-ew-action="search-operator">
<?php foreach ($Page->Last_Updated_Date->SearchOperators as $opr) { ?>
<option value="<?= HtmlEncode($opr) ?>"<?= $Page->Last_Updated_Date->AdvancedSearch->SearchOperator == $opr ? " selected" : "" ?>><?= $Language->phrase($opr == "=" ? "EQUAL" : $opr) ?></option>
<?php } ?>
</select>
</span>
                <span id="el_masterclient_Last_Updated_Date" class="ew-search-field">
<input type="<?= $Page->Last_Updated_Date->getInputTextType() ?>" name="x_Last_Updated_Date" id="x_Last_Updated_Date" data-table="masterclient" data-field="x_Last_Updated_Date" value="<?= $Page->Last_Updated_Date->EditValue ?>" placeholder="<?= HtmlEncode($Page->Last_Updated_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_Date->formatPattern()) ?>"<?= $Page->Last_Updated_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Last_Updated_Date->ReadOnly && !$Page->Last_Updated_Date->Disabled && !isset($Page->Last_Updated_Date->EditAttrs["readonly"]) && !isset($Page->Last_Updated_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterclientsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterclientsearch", "x_Last_Updated_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                    <span class="ew-search-and d-none"><label><?= $Language->phrase("AND") ?></label></span>
                    <span id="el2_masterclient_Last_Updated_Date" class="ew-search-field2 d-none">
<input type="<?= $Page->Last_Updated_Date->getInputTextType() ?>" name="y_Last_Updated_Date" id="y_Last_Updated_Date" data-table="masterclient" data-field="x_Last_Updated_Date" value="<?= $Page->Last_Updated_Date->EditValue2 ?>" placeholder="<?= HtmlEncode($Page->Last_Updated_Date->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_Date->formatPattern()) ?>"<?= $Page->Last_Updated_Date->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_Date->getErrorMessage(false) ?></div>
<?php if (!$Page->Last_Updated_Date->ReadOnly && !$Page->Last_Updated_Date->Disabled && !isset($Page->Last_Updated_Date->EditAttrs["readonly"]) && !isset($Page->Last_Updated_Date->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fmasterclientsearch", "datetimepicker"], function () {
    let format = "<?= DateFormat(109) ?>",
        options = {
            localization: {
                locale: ew.LANGUAGE_ID + "-u-nu-" + ew.getNumberingSystem(),
                hourCycle: format.match(/H/) ? "h24" : "h12",
                format,
                ...ew.language.phrase("datetimepicker")
            },
            display: {
                icons: {
                    previous: ew.IS_RTL ? "fa-solid fa-chevron-right" : "fa-solid fa-chevron-left",
                    next: ew.IS_RTL ? "fa-solid fa-chevron-left" : "fa-solid fa-chevron-right"
                },
                components: {
                    hours: !!format.match(/h/i),
                    minutes: !!format.match(/m/),
                    seconds: !!format.match(/s/i)
                },
                theme: ew.getPreferredTheme()
            }
        };
    ew.createDateTimePicker("fmasterclientsearch", "y_Last_Updated_Date", ew.deepAssign({"useCurrent":false,"display":{"sideBySide":false}}, options));
});
</script>
<?php } ?>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Last_Updated_By->Visible) { // Last_Updated_By ?>
    <div id="r_Last_Updated_By" class="row"<?= $Page->Last_Updated_By->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>"><span id="elh_masterclient_Last_Updated_By"><?= $Page->Last_Updated_By->caption() ?></span>
        <span class="ew-search-operator">
<?= $Language->phrase("=") ?>
<input type="hidden" name="z_Last_Updated_By" id="z_Last_Updated_By" value="=">
</span>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Last_Updated_By->cellAttributes() ?>>
                <div class="d-flex align-items-start">
                <span id="el_masterclient_Last_Updated_By" class="ew-search-field ew-search-field-single">
<input type="<?= $Page->Last_Updated_By->getInputTextType() ?>" name="x_Last_Updated_By" id="x_Last_Updated_By" data-table="masterclient" data-field="x_Last_Updated_By" value="<?= $Page->Last_Updated_By->EditValue ?>" size="30" maxlength="255" placeholder="<?= HtmlEncode($Page->Last_Updated_By->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Last_Updated_By->formatPattern()) ?>"<?= $Page->Last_Updated_By->editAttributes() ?>>
<div class="invalid-feedback"><?= $Page->Last_Updated_By->getErrorMessage(false) ?></div>
</span>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page* -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
        <button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmasterclientsearch"><?= $Language->phrase("Search") ?></button>
        <?php if ($Page->IsModal) { ?>
        <button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmasterclientsearch"><?= $Language->phrase("Cancel") ?></button>
        <?php } else { ?>
        <button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" form="fmasterclientsearch" data-ew-action="reload"><?= $Language->phrase("Reset") ?></button>
        <?php } ?>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("masterclient");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
