<?php

namespace ProjectManagement\prjProjectManagement;

// Page object
$MasterclientUpdate = &$Page;
?>
<script>
var currentTable = <?= JsonEncode($Page->toClientVar()) ?>;
ew.deepAssign(ew.vars, { tables: { masterclient: currentTable } });
var currentPageID = ew.PAGE_ID = "update";
var currentForm;
var fmasterclientupdate;
loadjs.ready(["wrapper", "head"], function () {
    let $ = jQuery;
    let fields = currentTable.fields;

    // Form object
    let form = new ew.FormBuilder()
        .setId("fmasterclientupdate")
        .setPageId("update")

        // Add fields
        .setFields([
            ["CompanyName", [fields.CompanyName.visible && fields.CompanyName.required ? ew.Validators.required(fields.CompanyName.caption) : null], fields.CompanyName.isInvalid],
            ["ContactName", [fields.ContactName.visible && fields.ContactName.required ? ew.Validators.required(fields.ContactName.caption) : null], fields.ContactName.isInvalid],
            ["ContactEmail", [fields.ContactEmail.visible && fields.ContactEmail.required ? ew.Validators.required(fields.ContactEmail.caption) : null], fields.ContactEmail.isInvalid],
            ["Phone", [fields.Phone.visible && fields.Phone.required ? ew.Validators.required(fields.Phone.caption) : null], fields.Phone.isInvalid],
            ["NPWP", [fields.NPWP.visible && fields.NPWP.required ? ew.Validators.required(fields.NPWP.caption) : null], fields.NPWP.isInvalid],
            ["Address", [fields.Address.visible && fields.Address.required ? ew.Validators.required(fields.Address.caption) : null], fields.Address.isInvalid],
            ["City", [fields.City.visible && fields.City.required ? ew.Validators.required(fields.City.caption) : null], fields.City.isInvalid],
            ["Active", [fields.Active.visible && fields.Active.required ? ew.Validators.required(fields.Active.caption) : null], fields.Active.isInvalid],
            ["Created_Date", [fields.Created_Date.visible && fields.Created_Date.required ? ew.Validators.required(fields.Created_Date.caption) : null], fields.Created_Date.isInvalid],
            ["Created_By", [fields.Created_By.visible && fields.Created_By.required ? ew.Validators.required(fields.Created_By.caption) : null], fields.Created_By.isInvalid],
            ["Last_Updated_Date", [fields.Last_Updated_Date.visible && fields.Last_Updated_Date.required ? ew.Validators.required(fields.Last_Updated_Date.caption) : null], fields.Last_Updated_Date.isInvalid],
            ["Last_Updated_By", [fields.Last_Updated_By.visible && fields.Last_Updated_By.required ? ew.Validators.required(fields.Last_Updated_By.caption) : null], fields.Last_Updated_By.isInvalid]
        ])

        // Form_CustomValidate
        .setCustomValidate(
            function (fobj) { // DO NOT CHANGE THIS LINE! (except for adding "async" keyword)!
                    // Your custom validation code here, return false if invalid.
                    return true;
                }
        )

        // Use JavaScript validation or not
        .setValidateRequired(ew.CLIENT_VALIDATE)

        // Dynamic selection lists
        .setLists({
            "Active": <?= $Page->Active->toClientList($Page) ?>,
        })
        .build();
    window[form.id] = form;
    currentForm = form;
    loadjs.done(form.id);
});
</script>
<script>
loadjs.ready("head", function () {
    // Write your table-specific client script here, no need to add script tags.
});
</script>
<?php $Page->showPageHeader(); ?>
<?php
$Page->showMessage();
?>
<form name="fmasterclientupdate" id="fmasterclientupdate" class="<?= $Page->FormClassName ?>" action="<?= CurrentPageUrl(false) ?>" method="post" autocomplete="off">
<?php if (Config("CHECK_TOKEN")) { ?>
<input type="hidden" name="<?= $TokenNameKey ?>" value="<?= $TokenName ?>"><!-- CSRF token name -->
<input type="hidden" name="<?= $TokenValueKey ?>" value="<?= $TokenValue ?>"><!-- CSRF token value -->
<?php } ?>
<input type="hidden" name="t" value="masterclient">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?= (int)$Page->IsModal ?>">
<?php foreach ($Page->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode(Config("COMPOSITE_KEY_SEPARATOR"), $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?= HtmlEncode($keyvalue) ?>">
<?php } ?>
<div id="tbl_masterclientupdate" class="ew-update-div"><!-- page -->
    <?php if (!$Page->isConfirm()) { // Confirm page ?>
    <div class="form-check">
        <input type="checkbox" class="form-check-input" name="u" id="u" data-ew-action="select-all"><label class="form-check-label" for="u"><?= $Language->phrase("SelectAll") ?></label>
    </div>
    <?php } ?>
<?php if ($Page->CompanyName->Visible && (!$Page->isConfirm() || $Page->CompanyName->multiUpdateSelected())) { // CompanyName ?>
    <div id="r_CompanyName"<?= $Page->CompanyName->rowAttributes() ?>>
        <label for="x_CompanyName" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_CompanyName" id="u_CompanyName" class="form-check-input ew-multi-select" value="1"<?= $Page->CompanyName->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_CompanyName"><?= $Page->CompanyName->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->CompanyName->cellAttributes() ?>>
                <span id="el_masterclient_CompanyName">
                <input type="<?= $Page->CompanyName->getInputTextType() ?>" name="x_CompanyName" id="x_CompanyName" data-table="masterclient" data-field="x_CompanyName" value="<?= $Page->CompanyName->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->CompanyName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->CompanyName->formatPattern()) ?>"<?= $Page->CompanyName->editAttributes() ?> aria-describedby="x_CompanyName_help">
                <?= $Page->CompanyName->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->CompanyName->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ContactName->Visible && (!$Page->isConfirm() || $Page->ContactName->multiUpdateSelected())) { // ContactName ?>
    <div id="r_ContactName"<?= $Page->ContactName->rowAttributes() ?>>
        <label for="x_ContactName" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_ContactName" id="u_ContactName" class="form-check-input ew-multi-select" value="1"<?= $Page->ContactName->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_ContactName"><?= $Page->ContactName->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ContactName->cellAttributes() ?>>
                <span id="el_masterclient_ContactName">
                <input type="<?= $Page->ContactName->getInputTextType() ?>" name="x_ContactName" id="x_ContactName" data-table="masterclient" data-field="x_ContactName" value="<?= $Page->ContactName->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->ContactName->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ContactName->formatPattern()) ?>"<?= $Page->ContactName->editAttributes() ?> aria-describedby="x_ContactName_help">
                <?= $Page->ContactName->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->ContactName->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->ContactEmail->Visible && (!$Page->isConfirm() || $Page->ContactEmail->multiUpdateSelected())) { // ContactEmail ?>
    <div id="r_ContactEmail"<?= $Page->ContactEmail->rowAttributes() ?>>
        <label for="x_ContactEmail" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_ContactEmail" id="u_ContactEmail" class="form-check-input ew-multi-select" value="1"<?= $Page->ContactEmail->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_ContactEmail"><?= $Page->ContactEmail->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->ContactEmail->cellAttributes() ?>>
                <span id="el_masterclient_ContactEmail">
                <input type="<?= $Page->ContactEmail->getInputTextType() ?>" name="x_ContactEmail" id="x_ContactEmail" data-table="masterclient" data-field="x_ContactEmail" value="<?= $Page->ContactEmail->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->ContactEmail->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->ContactEmail->formatPattern()) ?>"<?= $Page->ContactEmail->editAttributes() ?> aria-describedby="x_ContactEmail_help">
                <?= $Page->ContactEmail->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->ContactEmail->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Phone->Visible && (!$Page->isConfirm() || $Page->Phone->multiUpdateSelected())) { // Phone ?>
    <div id="r_Phone"<?= $Page->Phone->rowAttributes() ?>>
        <label for="x_Phone" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_Phone" id="u_Phone" class="form-check-input ew-multi-select" value="1"<?= $Page->Phone->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_Phone"><?= $Page->Phone->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Phone->cellAttributes() ?>>
                <span id="el_masterclient_Phone">
                <input type="<?= $Page->Phone->getInputTextType() ?>" name="x_Phone" id="x_Phone" data-table="masterclient" data-field="x_Phone" value="<?= $Page->Phone->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->Phone->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->Phone->formatPattern()) ?>"<?= $Page->Phone->editAttributes() ?> aria-describedby="x_Phone_help">
                <?= $Page->Phone->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->Phone->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->NPWP->Visible && (!$Page->isConfirm() || $Page->NPWP->multiUpdateSelected())) { // NPWP ?>
    <div id="r_NPWP"<?= $Page->NPWP->rowAttributes() ?>>
        <label for="x_NPWP" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_NPWP" id="u_NPWP" class="form-check-input ew-multi-select" value="1"<?= $Page->NPWP->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_NPWP"><?= $Page->NPWP->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->NPWP->cellAttributes() ?>>
                <span id="el_masterclient_NPWP">
                <input type="<?= $Page->NPWP->getInputTextType() ?>" name="x_NPWP" id="x_NPWP" data-table="masterclient" data-field="x_NPWP" value="<?= $Page->NPWP->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->NPWP->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->NPWP->formatPattern()) ?>"<?= $Page->NPWP->editAttributes() ?> aria-describedby="x_NPWP_help">
                <?= $Page->NPWP->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->NPWP->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Address->Visible && (!$Page->isConfirm() || $Page->Address->multiUpdateSelected())) { // Address ?>
    <div id="r_Address"<?= $Page->Address->rowAttributes() ?>>
        <label for="x_Address" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_Address" id="u_Address" class="form-check-input ew-multi-select" value="1"<?= $Page->Address->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_Address"><?= $Page->Address->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Address->cellAttributes() ?>>
                <span id="el_masterclient_Address">
                <textarea data-table="masterclient" data-field="x_Address" name="x_Address" id="x_Address" cols="35" rows="4" placeholder="<?= HtmlEncode($Page->Address->getPlaceHolder()) ?>"<?= $Page->Address->editAttributes() ?> aria-describedby="x_Address_help"><?= $Page->Address->EditValue ?></textarea>
                <?= $Page->Address->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->Address->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->City->Visible && (!$Page->isConfirm() || $Page->City->multiUpdateSelected())) { // City ?>
    <div id="r_City"<?= $Page->City->rowAttributes() ?>>
        <label for="x_City" class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_City" id="u_City" class="form-check-input ew-multi-select" value="1"<?= $Page->City->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_City"><?= $Page->City->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->City->cellAttributes() ?>>
                <span id="el_masterclient_City">
                <input type="<?= $Page->City->getInputTextType() ?>" name="x_City" id="x_City" data-table="masterclient" data-field="x_City" value="<?= $Page->City->EditValue ?>" size="30" maxlength="100" placeholder="<?= HtmlEncode($Page->City->getPlaceHolder()) ?>" data-format-pattern="<?= HtmlEncode($Page->City->formatPattern()) ?>"<?= $Page->City->editAttributes() ?> aria-describedby="x_City_help">
                <?= $Page->City->getCustomMessage() ?>
                <div class="invalid-feedback"><?= $Page->City->getErrorMessage() ?></div>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($Page->Active->Visible && (!$Page->isConfirm() || $Page->Active->multiUpdateSelected())) { // Active ?>
    <div id="r_Active"<?= $Page->Active->rowAttributes() ?>>
        <label class="<?= $Page->LeftColumnClass ?>">
            <div class="form-check">
                <input type="checkbox" name="u_Active" id="u_Active" class="form-check-input ew-multi-select" value="1"<?= $Page->Active->multiUpdateSelected() ? " checked" : "" ?>>
                <label class="form-check-label" for="u_Active"><?= $Page->Active->caption() ?></label>
            </div>
        </label>
        <div class="<?= $Page->RightColumnClass ?>">
            <div<?= $Page->Active->cellAttributes() ?>>
                <span id="el_masterclient_Active">
                <div class="form-check d-inline-block">
                    <input type="checkbox" class="form-check-input<?= $Page->Active->isInvalidClass() ?>" data-table="masterclient" data-field="x_Active" data-boolean name="x_Active" id="x_Active" value="1"<?= ConvertToBool($Page->Active->CurrentValue) ? " checked" : "" ?><?= $Page->Active->editAttributes() ?> aria-describedby="x_Active_help">
                    <div class="invalid-feedback"><?= $Page->Active->getErrorMessage() ?></div>
                </div>
                <?= $Page->Active->getCustomMessage() ?>
                </span>
            </div>
        </div>
    </div>
<?php } ?>
</div><!-- /page -->
<?= $Page->IsModal ? '<template class="ew-modal-buttons">' : '<div class="row ew-buttons">' ?><!-- buttons .row -->
    <div class="<?= $Page->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit" form="fmasterclientupdate"><?= $Language->phrase("UpdateBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" form="fmasterclientupdate" data-href="<?= HtmlEncode(GetUrl($Page->getReturnUrl())) ?>"><?= $Language->phrase("CancelBtn") ?></button>
    </div><!-- /buttons offset -->
<?= $Page->IsModal ? "</template>" : "</div>" ?><!-- /buttons .row -->
</form>
<?php
$Page->showPageFooter();
echo GetDebugMessage();
?>
<script>
// Field event handlers
loadjs.ready("head", function() {
    ew.addEventHandlers("masterclient");
});
</script>
<script>
loadjs.ready("load", function () {
    // Write your table-specific startup script here, no need to add script tags.
});
</script>
